/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import com.samsarasoftware.license.licenses.SamsaraSoftwareArchitectProductTrialLicense;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;

    public ClassLoaderObjectInputStream(ClassLoader classLoader, InputStream inputStream) throws IOException, StreamCorruptedException {
        super(inputStream);
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class<?> clazz = Class.forName(objectStreamClass.getName(), false, this.classLoader);
        int n = SamsaraSoftwareArchitectProductTrialLicense.c;
        Class<?> clazz2 = clazz;
        if (n != 0) return clazz2;
        if (clazz2 != null) {
            clazz2 = clazz;
            return clazz2;
        }
        clazz2 = super.resolveClass(objectStreamClass);
        if (n == 0) return clazz2;
        return clazz2;
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        Class[] classArray = new Class[stringArray.length];
        int n = SamsaraSoftwareArchitectProductTrialLicense.c;
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Class.forName(stringArray[i], false, this.classLoader);
            if (n == 0) continue;
        }
        try {
            return Proxy.getProxyClass(this.classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.resolveProxyClass(stringArray);
        }
    }
}

