/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import com.samsarasoftware.license.licenses.ProductLicense;
import com.samsarasoftware.license.ui.UIFactory;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianUtils {
    private static final String a;

    public static short swapShort(short s) {
        return (short)(((s >> 0 & 0xFF) << 8) + ((s >> 8 & 0xFF) << 0));
    }

    public static int swapInteger(int n) {
        return ((n >> 0 & 0xFF) << 24) + ((n >> 8 & 0xFF) << 16) + ((n >> 16 & 0xFF) << 8) + ((n >> 24 & 0xFF) << 0);
    }

    public static long swapLong(long l) {
        return ((l >> 0 & 0xFFL) << 56) + ((l >> 8 & 0xFFL) << 48) + ((l >> 16 & 0xFFL) << 40) + ((l >> 24 & 0xFFL) << 32) + ((l >> 32 & 0xFFL) << 24) + ((l >> 40 & 0xFFL) << 16) + ((l >> 48 & 0xFFL) << 8) + ((l >> 56 & 0xFFL) << 0);
    }

    public static float swapFloat(float f) {
        return Float.intBitsToFloat(EndianUtils.swapInteger(Float.floatToIntBits(f)));
    }

    public static double swapDouble(double d) {
        return Double.longBitsToDouble(EndianUtils.swapLong(Double.doubleToLongBits(d)));
    }

    public static void writeSwappedShort(byte[] byArray, int n, short s) {
        byArray[n + 0] = (byte)(s >> 0 & 0xFF);
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
    }

    public static short readSwappedShort(byte[] byArray, int n) {
        return (short)(((byArray[n + 0] & 0xFF) << 0) + ((byArray[n + 1] & 0xFF) << 8));
    }

    public static int readSwappedUnsignedShort(byte[] byArray, int n) {
        return ((byArray[n + 0] & 0xFF) << 0) + ((byArray[n + 1] & 0xFF) << 8);
    }

    public static void writeSwappedInteger(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 >> 0 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    public static int readSwappedInteger(byte[] byArray, int n) {
        return ((byArray[n + 0] & 0xFF) << 0) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
    }

    public static long readSwappedUnsignedInteger(byte[] byArray, int n) {
        long l = ((byArray[n + 0] & 0xFF) << 0) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16);
        long l2 = byArray[n + 3] & 0xFF;
        return (l2 << 24) + (0xFFFFFFFFL & l);
    }

    public static void writeSwappedLong(byte[] byArray, int n, long l) {
        block4: {
            boolean bl;
            block6: {
                block5: {
                    byArray[n + 0] = (byte)(l >> 0 & 0xFFL);
                    byArray[n + 1] = (byte)(l >> 8 & 0xFFL);
                    byArray[n + 2] = (byte)(l >> 16 & 0xFFL);
                    byArray[n + 3] = (byte)(l >> 24 & 0xFFL);
                    byArray[n + 4] = (byte)(l >> 32 & 0xFFL);
                    boolean bl2 = UIFactory.b;
                    byArray[n + 5] = (byte)(l >> 40 & 0xFFL);
                    byArray[n + 6] = (byte)(l >> 48 & 0xFFL);
                    byArray[n + 7] = (byte)(l >> 56 & 0xFFL);
                    if (!bl2) break block4;
                    if (!ProductLicense.b) break block5;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            ProductLicense.b = bl;
        }
    }

    public static long readSwappedLong(byte[] byArray, int n) {
        long l = ((byArray[n + 0] & 0xFF) << 0) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
        long l2 = ((byArray[n + 4] & 0xFF) << 0) + ((byArray[n + 5] & 0xFF) << 8) + ((byArray[n + 6] & 0xFF) << 16) + ((byArray[n + 7] & 0xFF) << 24);
        return (l2 << 32) + (0xFFFFFFFFL & l);
    }

    public static void writeSwappedFloat(byte[] byArray, int n, float f) {
        EndianUtils.writeSwappedInteger(byArray, n, Float.floatToIntBits(f));
    }

    public static float readSwappedFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(byArray, n));
    }

    public static void writeSwappedDouble(byte[] byArray, int n, double d) {
        EndianUtils.writeSwappedLong(byArray, n, Double.doubleToLongBits(d));
    }

    public static double readSwappedDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(byArray, n));
    }

    public static void writeSwappedShort(OutputStream outputStream, short s) throws IOException {
        outputStream.write((byte)(s >> 0 & 0xFF));
        outputStream.write((byte)(s >> 8 & 0xFF));
    }

    public static short readSwappedShort(InputStream inputStream) throws IOException {
        return (short)(((EndianUtils.read(inputStream) & 0xFF) << 0) + ((EndianUtils.read(inputStream) & 0xFF) << 8));
    }

    public static int readSwappedUnsignedShort(InputStream inputStream) throws IOException {
        int n = EndianUtils.read(inputStream);
        int n2 = EndianUtils.read(inputStream);
        return ((n & 0xFF) << 0) + ((n2 & 0xFF) << 8);
    }

    public static void writeSwappedInteger(OutputStream outputStream, int n) throws IOException {
        outputStream.write((byte)(n >> 0 & 0xFF));
        outputStream.write((byte)(n >> 8 & 0xFF));
        outputStream.write((byte)(n >> 16 & 0xFF));
        outputStream.write((byte)(n >> 24 & 0xFF));
    }

    public static int readSwappedInteger(InputStream inputStream) throws IOException {
        int n = EndianUtils.read(inputStream);
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        int n4 = EndianUtils.read(inputStream);
        return ((n & 0xFF) << 0) + ((n2 & 0xFF) << 8) + ((n3 & 0xFF) << 16) + ((n4 & 0xFF) << 24);
    }

    public static long readSwappedUnsignedInteger(InputStream inputStream) throws IOException {
        int n = EndianUtils.read(inputStream);
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        int n4 = EndianUtils.read(inputStream);
        long l = ((n & 0xFF) << 0) + ((n2 & 0xFF) << 8) + ((n3 & 0xFF) << 16);
        long l2 = n4 & 0xFF;
        return (l2 << 24) + (0xFFFFFFFFL & l);
    }

    public static void writeSwappedLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)(l >> 0 & 0xFFL));
        outputStream.write((byte)(l >> 8 & 0xFFL));
        outputStream.write((byte)(l >> 16 & 0xFFL));
        outputStream.write((byte)(l >> 24 & 0xFFL));
        outputStream.write((byte)(l >> 32 & 0xFFL));
        outputStream.write((byte)(l >> 40 & 0xFFL));
        outputStream.write((byte)(l >> 48 & 0xFFL));
        outputStream.write((byte)(l >> 56 & 0xFFL));
    }

    public static long readSwappedLong(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray;
        block4: {
            byte[] byArray2 = new byte[8];
            boolean bl = UIFactory.b;
            int n2 = 0;
            while (n2 < 8) {
                byArray = byArray2;
                n = n2++;
                if (!bl) {
                    byArray[n] = (byte)EndianUtils.read(inputStream);
                    if (!bl) continue;
                    break;
                }
                break block4;
            }
            byArray = byArray2;
            n = 0;
        }
        return EndianUtils.readSwappedLong(byArray, n);
    }

    public static void writeSwappedFloat(OutputStream outputStream, float f) throws IOException {
        EndianUtils.writeSwappedInteger(outputStream, Float.floatToIntBits(f));
    }

    public static float readSwappedFloat(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(inputStream));
    }

    public static void writeSwappedDouble(OutputStream outputStream, double d) throws IOException {
        EndianUtils.writeSwappedLong(outputStream, Double.doubleToLongBits(d));
    }

    public static double readSwappedDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(inputStream));
    }

    private static int read(InputStream inputStream) throws IOException {
        int n;
        block4: {
            int n2;
            block5: {
                n2 = inputStream.read();
                boolean bl = UIFactory.b;
                n = -1;
                if (bl) break block4;
                if (n != n2) break block5;
                throw new EOFException(a);
            }
            n = n2;
        }
        return n;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block11: {
                Object var0 = null;
                char[] cArray3 = "\u001ao@\u0006R3\u001f;dA^g\u0019:os@\u001fA>\u0019+".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 7) {
                        case 0: {
                            n6 = 79;
                            break;
                        }
                        case 1: {
                            n6 = 1;
                            break;
                        }
                        case 2: {
                            n6 = 37;
                            break;
                        }
                        case 3: {
                            n6 = 126;
                            break;
                        }
                        case 4: {
                            n6 = 34;
                            break;
                        }
                        case 5: {
                            n6 = 86;
                            break;
                        }
                        default: {
                            n6 = 124;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        a = new String(cArray).intern();
    }
}

