/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.traceability.tests.unit.text;

import java.util.List;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.tests.unit.AbstractTraceabilityTest;
import org.eclipse.acceleo.traceability.tests.unit.AcceleoTraceabilityListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.junit.Assert;
import org.junit.Test;

public class AcceleoTraceabilityTextTests
extends AbstractTraceabilityTest {
    @Test
    public void testTraceabilityTextSimple() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/text/textSimple.mtl", "main", "data/text/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"textSimple".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"textSimple".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"textSimple", (Object)string.getStringSymbol());
            Assert.assertEquals((long)176L, (long)string.getStartPosition());
            Assert.assertEquals((long)(176 + "textSimple".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/text/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTextSimpleWithSpace() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/text/textSimpleWithSpace.mtl", "main", "data/text/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"textSimple textSimple".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"textSimple textSimple".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"textSimple textSimple", (Object)string.getStringSymbol());
            Assert.assertEquals((long)185L, (long)string.getStartPosition());
            Assert.assertEquals((long)(185 + "textSimple textSimple".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/text/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTextSimpleMultiline() {
        String text = "Lorem ipsum dolor sit amet, consectetur adipiscing elit.\nDonec pellentesque pharetra tellus lacinia tincidunt. Nullam mattis feugiat ligula eget dapibus. Etiam blandit vulputate ornare.\nFusce a justo turpis, id suscipit magna. Curabitur nibh dolor, consequat id blandit ut, tristique sed quam. Ut vitae velit nisl, in lacinia velit.\nPraesent vel.";
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/text/textSimpleMultiline.mtl", "main", "data/text/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\nDonec pellentesque pharetra tellus lacinia tincidunt. Nullam mattis feugiat ligula eget dapibus. Etiam blandit vulputate ornare.\nFusce a justo turpis, id suscipit magna. Curabitur nibh dolor, consequat id blandit ut, tristique sed quam. Ut vitae velit nisl, in lacinia velit.\nPraesent vel.".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\nDonec pellentesque pharetra tellus lacinia tincidunt. Nullam mattis feugiat ligula eget dapibus. Etiam blandit vulputate ornare.\nFusce a justo turpis, id suscipit magna. Curabitur nibh dolor, consequat id blandit ut, tristique sed quam. Ut vitae velit nisl, in lacinia velit.\nPraesent vel.".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\nDonec pellentesque pharetra tellus lacinia tincidunt. Nullam mattis feugiat ligula eget dapibus. Etiam blandit vulputate ornare.\nFusce a justo turpis, id suscipit magna. Curabitur nibh dolor, consequat id blandit ut, tristique sed quam. Ut vitae velit nisl, in lacinia velit.\nPraesent vel.", (Object)string.getStringSymbol());
            Assert.assertEquals((long)185L, (long)string.getStartPosition());
            Assert.assertEquals((long)(185 + "Lorem ipsum dolor sit amet, consectetur adipiscing elit.\nDonec pellentesque pharetra tellus lacinia tincidunt. Nullam mattis feugiat ligula eget dapibus. Etiam blandit vulputate ornare.\nFusce a justo turpis, id suscipit magna. Curabitur nibh dolor, consequat id blandit ut, tristique sed quam. Ut vitae velit nisl, in lacinia velit.\nPraesent vel.".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/text/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }
}

