/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.traceability.tests.unit.query;

import java.util.List;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.tests.unit.AbstractTraceabilityTest;
import org.eclipse.acceleo.traceability.tests.unit.AcceleoTraceabilityListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.junit.Assert;
import org.junit.Test;

public class AcceleoTraceabilityQueryTests
extends AbstractTraceabilityTest {
    @Test
    public void testTraceabilityQuerySimple() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/querySimple.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"querySimple".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"querySimple".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"querySimple", (Object)string.getStringSymbol());
            Assert.assertEquals((long)274L, (long)string.getStartPosition());
            Assert.assertEquals((long)(274 + "'querySimple'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryCache() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryCache.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"queryCachequeryCachequeryCache".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"queryCache".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"queryCache", (Object)string.getStringSymbol());
            Assert.assertEquals((long)315L, (long)string.getStartPosition());
            Assert.assertEquals((long)(315 + "'queryCache'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"queryCache".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"queryCachequeryCache".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"queryCache", (Object)string.getStringSymbol());
            Assert.assertEquals((long)315L, (long)string.getStartPosition());
            Assert.assertEquals((long)(315 + "'queryCache'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"queryCachequeryCache".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"queryCachequeryCachequeryCache".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"queryCache", (Object)string.getStringSymbol());
            Assert.assertEquals((long)315L, (long)string.getStartPosition());
            Assert.assertEquals((long)(315 + "'queryCache'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryMultipleParameters() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryMultipleParameters.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"queryMultipleParameters".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"queryMultipleParameters".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"queryMultipleParameters", (Object)string.getStringSymbol());
            Assert.assertEquals((long)336L, (long)string.getStartPosition());
            Assert.assertEquals((long)(336 + "'queryMultipleParameters'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryMultipleQueries() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryMultipleQueries.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"queryMultipleQueries".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"queryMultipleQueries".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"queryMultipleQueries", (Object)string.getStringSymbol());
            Assert.assertEquals((long)477L, (long)string.getStartPosition());
            Assert.assertEquals((long)(477 + "'queryMultipleQueries'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryImbricated() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryImbricated.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"query1query3".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"query1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"query1", (Object)string.getStringSymbol());
            Assert.assertEquals((long)286L, (long)string.getStartPosition());
            Assert.assertEquals((long)(286 + "'query1'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"query1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("query1".length() + "query3".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"query3", (Object)string.getStringSymbol());
            Assert.assertEquals((long)415L, (long)string.getStartPosition());
            Assert.assertEquals((long)(415 + "'query3'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryCollection() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryCollection.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"query1query2".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"query1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"query1", (Object)string.getStringSymbol());
            Assert.assertEquals((long)295L, (long)string.getStartPosition());
            Assert.assertEquals((long)(295 + "'query1'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"query1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"query1query2".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"query2", (Object)string.getStringSymbol());
            Assert.assertEquals((long)356L, (long)string.getStartPosition());
            Assert.assertEquals((long)(356 + "'query2'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryCollection2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryCollection2.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"query1query2".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"query1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"query1", (Object)string.getStringSymbol());
            Assert.assertEquals((long)304L, (long)string.getStartPosition());
            Assert.assertEquals((long)(304 + "'query1'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"query1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"query1query2".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"query2", (Object)string.getStringSymbol());
            Assert.assertEquals((long)365L, (long)string.getStartPosition());
            Assert.assertEquals((long)(365 + "'query2'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryCollection3() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryCollection3.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)"class1class2class3class4".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)243L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(243 + "name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class1", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1class2".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)243L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(243 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class2", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"class1class2".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1class2class3".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)243L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(243 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class3", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"class1class2class3".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1class2class3class4".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)243L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(243 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class4", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryCollectionCollect() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryCollectionCollect.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)"aaabbbccc".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)198L, (long)string.getStartPosition());
            Assert.assertEquals((long)(198 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"a".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)198L, (long)string.getStartPosition());
            Assert.assertEquals((long)(198 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)198L, (long)string.getStartPosition());
            Assert.assertEquals((long)(198 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaab".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)203L, (long)string.getStartPosition());
            Assert.assertEquals((long)(203 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"aaab".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)203L, (long)string.getStartPosition());
            Assert.assertEquals((long)(203 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"aaabb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)203L, (long)string.getStartPosition());
            Assert.assertEquals((long)(203 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"aaabbb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)208L, (long)string.getStartPosition());
            Assert.assertEquals((long)(208 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"aaabbbc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbcc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)208L, (long)string.getStartPosition());
            Assert.assertEquals((long)(208 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"aaabbbcc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbccc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)208L, (long)string.getStartPosition());
            Assert.assertEquals((long)(208 + "'c'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryCollectionCollect2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryCollectionCollect2.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)"aaabbbccc".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)199L, (long)string.getStartPosition());
            Assert.assertEquals((long)(199 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"a".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)199L, (long)string.getStartPosition());
            Assert.assertEquals((long)(199 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)199L, (long)string.getStartPosition());
            Assert.assertEquals((long)(199 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaab".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)204L, (long)string.getStartPosition());
            Assert.assertEquals((long)(204 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"aaab".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)204L, (long)string.getStartPosition());
            Assert.assertEquals((long)(204 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"aaabb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)204L, (long)string.getStartPosition());
            Assert.assertEquals((long)(204 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"aaabbb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)209L, (long)string.getStartPosition());
            Assert.assertEquals((long)(209 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"aaabbbc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbcc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)209L, (long)string.getStartPosition());
            Assert.assertEquals((long)(209 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"aaabbbcc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbccc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)209L, (long)string.getStartPosition());
            Assert.assertEquals((long)(209 + "'c'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryCollectionSelect() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryCollectionSelect.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"a".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)197L, (long)string.getStartPosition());
            Assert.assertEquals((long)(197 + "'a'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryVariableExp() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryVariableExp.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"aaa".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)195L, (long)string.getStartPosition());
            Assert.assertEquals((long)(195 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"a".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)195L, (long)string.getStartPosition());
            Assert.assertEquals((long)(195 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)195L, (long)string.getStartPosition());
            Assert.assertEquals((long)(195 + "'a'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityQueryComplexUseCase() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/query/queryComplexUseCase.mtl", "main", "data/query/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)6L, (long)generatedRegions.size());
            Assert.assertEquals((long)"bidulechosegnagnachosegnagnamachin".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidule".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"bidule", (Object)string.getStringSymbol());
            Assert.assertEquals((long)203L, (long)string.getStartPosition());
            Assert.assertEquals((long)(203 + "'bidule'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"bidule".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechose".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"chose", (Object)string.getStringSymbol());
            Assert.assertEquals((long)221L, (long)string.getStartPosition());
            Assert.assertEquals((long)(221 + "'chose'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"bidulechose".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechosegnagna".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"gnagna", (Object)string.getStringSymbol());
            Assert.assertEquals((long)277L, (long)string.getStartPosition());
            Assert.assertEquals((long)(277 + "'gnagna'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"bidulechosegnagna".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechosegnagnachose".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"chose", (Object)string.getStringSymbol());
            Assert.assertEquals((long)221L, (long)string.getStartPosition());
            Assert.assertEquals((long)(221 + "'chose'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"bidulechosegnagnachose".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechosegnagnachosegnagna".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"gnagna", (Object)string.getStringSymbol());
            Assert.assertEquals((long)277L, (long)string.getStartPosition());
            Assert.assertEquals((long)(277 + "'gnagna'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"bidulechosegnagnachosegnagna".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechosegnagnachosegnagnamachin".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"machin", (Object)string.getStringSymbol());
            Assert.assertEquals((long)254L, (long)string.getStartPosition());
            Assert.assertEquals((long)(254 + "'machin'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/query/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }
}

