/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.traceability.tests.unit.model;

import java.util.List;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.tests.unit.AbstractTraceabilityTest;
import org.eclipse.acceleo.traceability.tests.unit.AcceleoTraceabilityListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.VisibilityKind;
import org.junit.Assert;
import org.junit.Test;

public class AcceleoTraceabilityModelTests
extends AbstractTraceabilityTest {
    @Test
    public void testTraceabilityModelSimple() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/model/modelSimple.mtl", "main", "data/model/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCall = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCall.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCall.toString());
            Assert.assertEquals((long)178L, (long)propertyCall.getStartPosition());
            Assert.assertEquals((long)(178 + "eClass.name".length()), (long)propertyCall.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/model/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityModelMetamodel() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/model/modelMetamodel.mtl", "main", "data/model/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "EClass").length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCall = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCall.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCall.toString());
            Assert.assertEquals((long)181L, (long)propertyCall.getStartPosition());
            Assert.assertEquals((long)(181 + "eClass.name".length()), (long)propertyCall.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/model/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "EClass").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCall = (PropertyCallExp)element;
            eGenericType = propertyCall.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.eClass().name", (Object)propertyCall.toString());
            Assert.assertEquals((long)195L, (long)propertyCall.getStartPosition());
            Assert.assertEquals((long)(195 + "eClass.eClass().name".length()), (long)propertyCall.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"EClass", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/emf/2002/Ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityModelPropertyOperationSize() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/model/modelPropertyOperationSize.mtl", "main", "data/model/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"6".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"6".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCall = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCall.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCall.toString());
            Assert.assertEquals((long)193L, (long)propertyCall.getStartPosition());
            Assert.assertEquals((long)(193 + "eClass.name".length()), (long)propertyCall.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/model/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityModelEnum() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/model/modelEnum.mtl", "main", "data/model/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)1L, (long)generatedFiles.size());
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"MyEnum".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)1L, (long)sourceElements.size());
            Assert.assertEquals((Object)"MyEnum", (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)"enum.txt", (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"MyEnum".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCall = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCall.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eEnum.name", (Object)propertyCall.toString());
            Assert.assertEquals((long)164L, (long)propertyCall.getStartPosition());
            Assert.assertEquals((long)(164 + "eEnum.name".length()), (long)propertyCall.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EEnum));
            Assert.assertEquals((Object)"MyEnum", (Object)((EEnum)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/model/model.ecore", (Object)modelElement.eResource().getURI().path());
        }
    }

    @Test
    public void testTraceabilityModelEnumToString() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/model/modelEnumToString.mtl", "main", "data/model/model.uml", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)1L, (long)generatedFiles.size());
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"private".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)1L, (long)sourceElements.size());
            Assert.assertEquals((Object)"myoperation", (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)"operation.txt", (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"private".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCall = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCall.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(VisibilityKind.class));
            Assert.assertEquals((Object)"operation.visibility", (Object)propertyCall.toString());
            Assert.assertEquals((long)185L, (long)propertyCall.getStartPosition());
            Assert.assertEquals((long)(185 + "operation.visibility".length()), (long)propertyCall.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof Operation));
            Assert.assertEquals((Object)"myoperation", (Object)((Operation)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/model/model.uml", (Object)modelElement.eResource().getURI().path());
        }
    }

    @Test
    public void testTraceabilityModelEnumString() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/model/modelEnumString.mtl", "main", "data/model/model.uml", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)1L, (long)generatedFiles.size());
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"private".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)1L, (long)sourceElements.size());
            Assert.assertEquals((Object)"myoperation", (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)"operation.txt", (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"private".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCall = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCall.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(VisibilityKind.class));
            Assert.assertEquals((Object)"operation.visibility", (Object)propertyCall.toString());
            Assert.assertEquals((long)183L, (long)propertyCall.getStartPosition());
            Assert.assertEquals((long)(183 + "operation.visibility".length()), (long)propertyCall.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof Operation));
            Assert.assertEquals((Object)"myoperation", (Object)((Operation)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/model/model.uml", (Object)modelElement.eResource().getURI().path());
        }
    }
}

