/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.traceability.tests.unit.library;

import java.util.List;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.tests.unit.AbstractTraceabilityTest;
import org.eclipse.acceleo.traceability.tests.unit.AcceleoTraceabilityListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.junit.Assert;
import org.junit.Test;

public class AcceleoTraceabilityLibraryStringTests
extends AbstractTraceabilityTest {
    @Test
    public void testTraceabilityLibraryStringReplace() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringReplace.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)("clazs" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)180L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(180 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"z", (Object)string.getStringSymbol());
            Assert.assertEquals((long)205L, (long)string.getStartPosition());
            Assert.assertEquals((long)(205 + "'z'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("clazs" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)180L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(180 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringReplaceQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringReplaceQuery.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)("clazs" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)185L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(185 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"z", (Object)string.getStringSymbol());
            Assert.assertEquals((long)301L, (long)string.getStartPosition());
            Assert.assertEquals((long)(301 + "'z'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("clazs" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)185L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(185 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringReplaceTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringReplaceTemplate.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)("clazs" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)188L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(188 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"z", (Object)string.getStringSymbol());
            Assert.assertEquals((long)296L, (long)string.getStartPosition());
            Assert.assertEquals((long)(296 + "z".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("clazs" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)188L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(188 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringReplaceAll() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringReplaceAll.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)("clazz" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)183L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(183 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"z", (Object)string.getStringSymbol());
            Assert.assertEquals((long)211L, (long)string.getStartPosition());
            Assert.assertEquals((long)(211 + "'z'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"clazz".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"z", (Object)string.getStringSymbol());
            Assert.assertEquals((long)211L, (long)string.getStartPosition());
            Assert.assertEquals((long)(211 + "'z'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"clazz".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("clazz" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)183L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(183 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringReplaceAllFirstLast() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringReplaceAllFirstLast.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)"AbrAcAdAbrA".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"A".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"A", (Object)string.getStringSymbol());
            Assert.assertEquals((long)222L, (long)string.getStartPosition());
            Assert.assertEquals((long)(222 + "'A'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)"A".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"Abr".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"abracadabra", (Object)string.getStringSymbol());
            Assert.assertEquals((long)192L, (long)string.getStartPosition());
            Assert.assertEquals((long)(192 + "'abracadabra'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"Abr".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"AbrA".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"A", (Object)string.getStringSymbol());
            Assert.assertEquals((long)222L, (long)string.getStartPosition());
            Assert.assertEquals((long)(222 + "'A'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"AbrA".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"AbrAc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"abracadabra", (Object)string.getStringSymbol());
            Assert.assertEquals((long)192L, (long)string.getStartPosition());
            Assert.assertEquals((long)(192 + "'abracadabra'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"AbrAc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"AbrAcA".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"A", (Object)string.getStringSymbol());
            Assert.assertEquals((long)222L, (long)string.getStartPosition());
            Assert.assertEquals((long)(222 + "'A'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"AbrAcA".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"AbrAcAd".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"abracadabra", (Object)string.getStringSymbol());
            Assert.assertEquals((long)192L, (long)string.getStartPosition());
            Assert.assertEquals((long)(192 + "'abracadabra'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"AbrAcAd".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"AbrAcAda".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"A", (Object)string.getStringSymbol());
            Assert.assertEquals((long)222L, (long)string.getStartPosition());
            Assert.assertEquals((long)(222 + "'A'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"AbrAcAdA".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"AbrAcAdAbr".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"abracadabra", (Object)string.getStringSymbol());
            Assert.assertEquals((long)192L, (long)string.getStartPosition());
            Assert.assertEquals((long)(192 + "'abracadabra'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"AbrAcAdAbr".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"AbrAcAdAbrA".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"A", (Object)string.getStringSymbol());
            Assert.assertEquals((long)222L, (long)string.getStartPosition());
            Assert.assertEquals((long)(222 + "'A'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringReplaceAllTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringReplaceAllTemplate.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)7L, (long)generatedRegions.size());
            Assert.assertEquals((long)"aaanewbbbnewcccnewddd".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaaoldbbboldcccoldddd", (Object)string.getStringSymbol());
            Assert.assertEquals((long)191L, (long)string.getStartPosition());
            Assert.assertEquals((long)(191 + "'aaaoldbbboldcccoldddd'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanew".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"new", (Object)string.getStringSymbol());
            Assert.assertEquals((long)316L, (long)string.getStartPosition());
            Assert.assertEquals((long)(316 + "new".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"aaanew".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaaoldbbboldcccoldddd", (Object)string.getStringSymbol());
            Assert.assertEquals((long)191L, (long)string.getStartPosition());
            Assert.assertEquals((long)(191 + "'aaaoldbbboldcccoldddd'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"aaanewbbb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbbnew".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"new", (Object)string.getStringSymbol());
            Assert.assertEquals((long)316L, (long)string.getStartPosition());
            Assert.assertEquals((long)(316 + "new".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"aaanewbbbnew".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbbnewccc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaaoldbbboldcccoldddd", (Object)string.getStringSymbol());
            Assert.assertEquals((long)191L, (long)string.getStartPosition());
            Assert.assertEquals((long)(191 + "'aaaoldbbboldcccoldddd'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"aaanewbbbnewccc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbbnewcccnew".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"new", (Object)string.getStringSymbol());
            Assert.assertEquals((long)316L, (long)string.getStartPosition());
            Assert.assertEquals((long)(316 + "new".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"aaanewbbbnewcccnew".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbbnewcccnewddd".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaaoldbbboldcccoldddd", (Object)string.getStringSymbol());
            Assert.assertEquals((long)191L, (long)string.getStartPosition());
            Assert.assertEquals((long)(191 + "'aaaoldbbboldcccoldddd'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringReplaceAllQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringReplaceAllQuery.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)7L, (long)generatedRegions.size());
            Assert.assertEquals((long)"aaanewbbbnewcccnewddd".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaaoldbbboldcccoldddd", (Object)string.getStringSymbol());
            Assert.assertEquals((long)188L, (long)string.getStartPosition());
            Assert.assertEquals((long)(188 + "'aaaoldbbboldcccoldddd'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanew".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"new", (Object)string.getStringSymbol());
            Assert.assertEquals((long)321L, (long)string.getStartPosition());
            Assert.assertEquals((long)(321 + "'new'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"aaanew".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaaoldbbboldcccoldddd", (Object)string.getStringSymbol());
            Assert.assertEquals((long)188L, (long)string.getStartPosition());
            Assert.assertEquals((long)(188 + "'aaaoldbbboldcccoldddd'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"aaanewbbb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbbnew".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"new", (Object)string.getStringSymbol());
            Assert.assertEquals((long)321L, (long)string.getStartPosition());
            Assert.assertEquals((long)(321 + "'new'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"aaanewbbbnew".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbbnewccc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaaoldbbboldcccoldddd", (Object)string.getStringSymbol());
            Assert.assertEquals((long)188L, (long)string.getStartPosition());
            Assert.assertEquals((long)(188 + "'aaaoldbbboldcccoldddd'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"aaanewbbbnewccc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbbnewcccnew".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"new", (Object)string.getStringSymbol());
            Assert.assertEquals((long)321L, (long)string.getStartPosition());
            Assert.assertEquals((long)(321 + "'new'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"aaanewbbbnewcccnew".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaanewbbbnewcccnewddd".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaaoldbbboldcccoldddd", (Object)string.getStringSymbol());
            Assert.assertEquals((long)188L, (long)string.getStartPosition());
            Assert.assertEquals((long)(188 + "'aaaoldbbboldcccoldddd'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollection() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollection.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"abc".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)192L, (long)string.getStartPosition());
            Assert.assertEquals((long)(192 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"a".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"ab".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)197L, (long)string.getStartPosition());
            Assert.assertEquals((long)(197 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"ab".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"abc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)202L, (long)string.getStartPosition());
            Assert.assertEquals((long)(202 + "'c'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionReverse() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionReverse.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"cbbaaa".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"c".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)212L, (long)string.getStartPosition());
            Assert.assertEquals((long)(212 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"c".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"cbb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"bb", (Object)string.getStringSymbol());
            Assert.assertEquals((long)206L, (long)string.getStartPosition());
            Assert.assertEquals((long)(206 + "'bb'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)"cbb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"cbbaaa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aaa", (Object)string.getStringSymbol());
            Assert.assertEquals((long)199L, (long)string.getStartPosition());
            Assert.assertEquals((long)(199 + "'aaa'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionReverse2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionReverse2.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)"class4class3class2class1".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class4".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)244L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(244 + "name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class4", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"class4".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class4class3".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)244L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(244 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class3", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"class4class3".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class4class3class2".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)244L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(244 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class2", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)"class4class3class2".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class4class3class2class1".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)244L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(244 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class1", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionSep() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionSep.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)5L, (long)generatedRegions.size());
            Assert.assertEquals((long)"a, b, c".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)195L, (long)string.getStartPosition());
            Assert.assertEquals((long)(195 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"a, ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a, b".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)200L, (long)string.getStartPosition());
            Assert.assertEquals((long)(200 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"a".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a, ".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)", ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)215L, (long)string.getStartPosition());
            Assert.assertEquals((long)(215 + "', '".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"a, b, ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a, b, c".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)205L, (long)string.getStartPosition());
            Assert.assertEquals((long)(205 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"a, b".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a, b, ".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)", ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)215L, (long)string.getStartPosition());
            Assert.assertEquals((long)(215 + "', '".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionSep2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionSep2.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)7L, (long)generatedRegions.size());
            Assert.assertEquals((long)"class1, class2, class3, class4".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)240L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(240 + "name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class1", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1, ".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)", ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)250L, (long)string.getStartPosition());
            Assert.assertEquals((long)(250 + "', '".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"class1, ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1, class2".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)240L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(240 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class2", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"class1, class2".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1, class2, ".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)", ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)250L, (long)string.getStartPosition());
            Assert.assertEquals((long)(250 + "', '".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"class1, class2, ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1, class2, class3".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)240L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(240 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class3", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"class1, class2, class3".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1, class2, class3, ".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)", ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)250L, (long)string.getStartPosition());
            Assert.assertEquals((long)(250 + "', '".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"class1, class2, class3, ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1, class2, class3, class4".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)240L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(240 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class4", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionFirst() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionFirst.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"a".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)197L, (long)string.getStartPosition());
            Assert.assertEquals((long)(197 + "'a'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionFirst2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionFirst2.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)242L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(242 + "name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class1", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionFirst3() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionFirst3.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)189L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(189 + "eClass.eContainer().oclAsType(EPackage).eClassifiers->first().name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class1", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionLast() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionLast.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"c".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"c".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)206L, (long)string.getStartPosition());
            Assert.assertEquals((long)(206 + "'c'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionLast2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionLast2.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class4".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)241L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(241 + "name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class4", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringCollectionLast3() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringCollectionLast3.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class4".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)188L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(188 + "eClass.eContainer().oclAsType(EPackage).eClassifiers->last().name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class4", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringContains() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringContains.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"true".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"true".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"contains operation", (Object)string.getStringSymbol());
            Assert.assertEquals((long)181L, (long)string.getStartPosition());
            Assert.assertEquals((long)(181 + "'contains operation'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringEndsWith() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringEndsWith.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"true".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"true".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"endsWith operation", (Object)string.getStringSymbol());
            Assert.assertEquals((long)181L, (long)string.getStartPosition());
            Assert.assertEquals((long)(181 + "'endsWith operation'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringEqualsIgnoreCase() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringEqualsIgnoreCase.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"true".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"true".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"lowercase", (Object)string.getStringSymbol());
            Assert.assertEquals((long)189L, (long)string.getStartPosition());
            Assert.assertEquals((long)(189 + "'lowercase'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringIsAlpha() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringIsAlpha.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"false".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"false".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)180L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(180 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringIsAlpha2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringIsAlpha2.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"false".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"false".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)" ljdql ", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)181L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(181 + "' ljdql '".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringIsAlphaNum() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringIsAlphaNum.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"clas".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"clas".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)183L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(183 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringIsAlphaNum2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringIsAlphaNum2.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"false".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"false".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)" hsdkhs 545", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)184L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(184 + "' hsdkhs 545'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringFirst() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringFirst.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"clas".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"clas".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)178L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(178 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringLast() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringLast.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"clas".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"clas".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)177L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(177 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringLastIndex() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringLastIndex.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"14".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"14".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"index operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)182L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(182 + "'index operation'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringMatches() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringMatches.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"true".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"true".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"characters and spaces", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)180L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(180 + "'characters and spaces'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringIndex() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringIndex.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"4".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"2".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)178L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(178 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringStartsWith() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringStartsWith.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"true".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"true".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"startsWith operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)183L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(183 + "'startsWith operation'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringStrCmp() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringStrCmp.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"10".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"10".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"strcmp operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)179L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(179 + "'strcmp operation'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringStrStr() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringStrStr.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"true".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"true".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"strstr operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)179L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(179 + "'strstr operation'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringStrTok() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringStrTok.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"strt".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"strt".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"strtok operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)179L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(179 + "'strtok operation'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringSubstitute() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringSubstitute.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)("clazs" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)183L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(183 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"cla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"z", (Object)string.getStringSymbol());
            Assert.assertEquals((long)211L, (long)string.getStartPosition());
            Assert.assertEquals((long)(211 + "'z'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"claz".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("clazs" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)183L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(183 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringSubstituteAll() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringSubstituteAll.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)"subsTiTuTeAll operaTion".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subs".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"substituteAll operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)186L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(186 + "'substituteAll operation'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"subs".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subsT".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"T", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)231L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(231 + "'T'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"subsT".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subsTi".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"substituteAll operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)186L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(186 + "'substituteAll operation'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"subsTi".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subsTiT".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"T", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)231L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(231 + "'T'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"subsTiT".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subsTiTu".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"substituteAll operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)186L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(186 + "'substituteAll operation'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"subsTiTu".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subsTiTuT".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"T", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)231L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(231 + "'T'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"subsTiTuT".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subsTiTuTeAll opera".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"substituteAll operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)186L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(186 + "'substituteAll operation'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"subsTiTuTeAll opera".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subsTiTuTeAll operaT".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"T", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)231L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(231 + "'T'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"subsTiTuTeAll operaT".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"subsTiTuTeAll operaTion".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"substituteAll operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)186L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(186 + "'substituteAll operation'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringSubstring() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringSubstring.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"clas".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"clas".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)182L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(182 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringTokenize() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringTokenize.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)"tokniz opration".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tok".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tokenize operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)181L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(181 + "'tokenize operation'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"tok".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tokniz".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tokenize operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)181L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(181 + "'tokenize operation'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"tokniz".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tokniz op".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tokenize operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)181L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(181 + "'tokenize operation'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"tokniz op".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tokniz opration".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tokenize operation", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)181L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(181 + "'tokenize operation'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringTokenize2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringTokenize2.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)8L, (long)generatedRegions.size());
            Assert.assertEquals((long)"rihrrymlipoupoupidoupou".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"ri".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"aria", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)197L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(197 + "'aria'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"ri".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"rih".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"harry", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)213L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(213 + "'harry'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"rih".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"rihrry".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"harry", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)213L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(213 + "'harry'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"rihrry".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"rihrrym".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"malia", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)223L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(223 + "'malia'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"rihrrym".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"rihrrymli".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"malia", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)223L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(223 + "'malia'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"rihrrymli".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"rihrrymlipou".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"pou", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)240L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(240 + "'pou'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"rihrrymlipou".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"rihrrymlipoupoupidou".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"poupidou", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)248L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(248 + "'poupidou'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"rihrrymlipoupoupidou".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"rihrrymlipoupoupidoupou".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"pou", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)261L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(261 + "'pou'".length()), (long)stringLiteralExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringToLowerFirst() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringToLowerFirst.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)185L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(185 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringToUpperFirst() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringToUpperFirst.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)185L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(185 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityLibraryStringTrim() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/library/string/stringTrim.mtl", "main", "data/library/string/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"trim operation".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"trim operation".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)" trim operation ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)177L, (long)string.getStartPosition());
            Assert.assertEquals((long)(177 + "' trim operation '".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/library/string/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }
}

