/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.traceability.tests.unit.block;

import java.util.List;
import org.eclipse.acceleo.model.mtl.ProtectedAreaBlock;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.tests.unit.AbstractTraceabilityTest;
import org.eclipse.acceleo.traceability.tests.unit.AcceleoTraceabilityListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.IntegerLiteralExp;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class AcceleoTraceabilityBlockTests
extends AbstractTraceabilityTest {
    @Test
    public void testTraceabilityBlockFile() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockFile.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)0L, (long)generatedRegions.size());
            Assert.assertEquals((long)0L, (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)137L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(137 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)151L, (long)string.getStartPosition());
            Assert.assertEquals((long)(151 + "'.txt'".length()), (long)string.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockFileConcat() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockFileConcat.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)0L, (long)generatedRegions.size());
            Assert.assertEquals((long)0L, (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)143L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(143 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)162L, (long)string.getStartPosition());
            Assert.assertEquals((long)(162 + "'.txt'".length()), (long)string.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockFileQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockFileQuery.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)0L, (long)generatedRegions.size());
            Assert.assertEquals((long)0L, (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)259L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(259 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)163L, (long)string.getStartPosition());
            Assert.assertEquals((long)(163 + "'.txt'".length()), (long)string.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockFileTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockFileTemplate.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)0L, (long)generatedRegions.size());
            Assert.assertEquals((long)0L, (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)253L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(253 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)165L, (long)string.getStartPosition());
            Assert.assertEquals((long)(165 + "'.txt'".length()), (long)string.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockIf() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockIf.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"blockIf".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockIf".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockIf", (Object)string.getStringSymbol());
            Assert.assertEquals((long)264L, (long)string.getStartPosition());
            Assert.assertEquals((long)(264 + "blockIf".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockIfQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockIfQuery.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"blockIf".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockIf".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockIf", (Object)string.getStringSymbol());
            Assert.assertEquals((long)283L, (long)string.getStartPosition());
            Assert.assertEquals((long)(283 + "blockIf".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockIfTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockIfTemplate.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"blockIf".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockIf".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockIf", (Object)string.getStringSymbol());
            Assert.assertEquals((long)308L, (long)string.getStartPosition());
            Assert.assertEquals((long)(308 + "blockIf".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockElse() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockElse.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"blockElse".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockElse".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockElse", (Object)string.getStringSymbol());
            Assert.assertEquals((long)277L, (long)string.getStartPosition());
            Assert.assertEquals((long)(277 + "blockElse".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockFor() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockFor.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)("blockFor".length() * 3), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            int gencpt = 0;
            for (GeneratedText generatedText : generatedRegions) {
                Assert.assertEquals((long)(0 + "blockFor".length() * gencpt), (long)generatedText.getStartOffset());
                Assert.assertEquals((long)("blockFor".length() * (gencpt + 1)), (long)generatedText.getEndOffset());
                ModuleElement moduleElement = generatedText.getModuleElement();
                EObject element = moduleElement.getModuleElement();
                Assert.assertTrue((boolean)(element instanceof ASTNode));
                Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
                StringLiteralExp string = (StringLiteralExp)element;
                Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
                Assert.assertEquals((long)281L, (long)string.getStartPosition());
                Assert.assertEquals((long)(281 + "blockFor".length()), (long)string.getEndPosition());
                InputElement sourceElement = generatedText.getSourceElement();
                EObject modelElement = sourceElement.getModelElement();
                Assert.assertTrue((boolean)(modelElement instanceof EClass));
                Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
                Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
                ++gencpt;
            }
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockForQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockForQuery.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"abc".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            int gencpt = 0;
            int expectedStartPosition = 0;
            int expectedEndPosition = 390;
            for (GeneratedText generatedText : generatedRegions) {
                Assert.assertEquals((long)(0 + gencpt), (long)generatedText.getStartOffset());
                Assert.assertEquals((long)(gencpt + 1), (long)generatedText.getEndOffset());
                ModuleElement moduleElement = generatedText.getModuleElement();
                EObject element = moduleElement.getModuleElement();
                Assert.assertTrue((boolean)(element instanceof ASTNode));
                Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
                StringLiteralExp string = (StringLiteralExp)element;
                Assert.assertEquals((Object)String.valueOf((char)(97 + gencpt)), (Object)string.getStringSymbol());
                expectedStartPosition = expectedEndPosition + 2;
                expectedEndPosition = expectedStartPosition + String.valueOf(39 + (char)(97 + gencpt) + 39).length();
                Assert.assertEquals((long)expectedStartPosition, (long)string.getStartPosition());
                Assert.assertEquals((long)expectedEndPosition, (long)string.getEndPosition());
                InputElement sourceElement = generatedText.getSourceElement();
                EObject modelElement = sourceElement.getModelElement();
                Assert.assertTrue((boolean)(modelElement instanceof EClass));
                Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
                Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
                ++gencpt;
            }
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockForQuery2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockForQuery2.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)6L, (long)generatedRegions.size());
            Assert.assertEquals((long)(("begin".length() + 1 + "end".length()) * 2), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"begin".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"begin", (Object)string.getStringSymbol());
            Assert.assertEquals((long)403L, (long)string.getStartPosition());
            Assert.assertEquals((long)(403 + "'begin'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(1);
            Assert.assertEquals((long)"begin".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"begina".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)293L, (long)string.getStartPosition());
            Assert.assertEquals((long)(293 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(2);
            Assert.assertEquals((long)"begina".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaend".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"end", (Object)string.getStringSymbol());
            Assert.assertEquals((long)419L, (long)string.getStartPosition());
            Assert.assertEquals((long)(419 + "'end'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(3);
            Assert.assertEquals((long)"beginaend".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbegin".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"begin", (Object)string.getStringSymbol());
            Assert.assertEquals((long)403L, (long)string.getStartPosition());
            Assert.assertEquals((long)(403 + "'begin'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(4);
            Assert.assertEquals((long)"beginaendbegin".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbeginb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)315L, (long)string.getStartPosition());
            Assert.assertEquals((long)(315 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(5);
            Assert.assertEquals((long)"beginaendbeginb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbeginbend".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"end", (Object)string.getStringSymbol());
            Assert.assertEquals((long)419L, (long)string.getStartPosition());
            Assert.assertEquals((long)(419 + "'end'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockForQuery3() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockForQuery3.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)(("begin".length() + 1 + "end".length()) * 3), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"begin".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"begin", (Object)string.getStringSymbol());
            Assert.assertEquals((long)402L, (long)string.getStartPosition());
            Assert.assertEquals((long)(402 + "'begin'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(1);
            Assert.assertEquals((long)"begin".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"begina".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)277L, (long)string.getStartPosition());
            Assert.assertEquals((long)(277 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(2);
            Assert.assertEquals((long)"begina".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaend".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"end", (Object)string.getStringSymbol());
            Assert.assertEquals((long)418L, (long)string.getStartPosition());
            Assert.assertEquals((long)(418 + "'end'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(3);
            Assert.assertEquals((long)"beginaend".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbegin".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"begin", (Object)string.getStringSymbol());
            Assert.assertEquals((long)402L, (long)string.getStartPosition());
            Assert.assertEquals((long)(402 + "'begin'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(4);
            Assert.assertEquals((long)"beginaendbegin".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbeginb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)282L, (long)string.getStartPosition());
            Assert.assertEquals((long)(282 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(5);
            Assert.assertEquals((long)"beginaendbeginb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbeginbend".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"end", (Object)string.getStringSymbol());
            Assert.assertEquals((long)418L, (long)string.getStartPosition());
            Assert.assertEquals((long)(418 + "'end'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(6);
            Assert.assertEquals((long)"beginaendbeginbend".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbeginbendbegin".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"begin", (Object)string.getStringSymbol());
            Assert.assertEquals((long)402L, (long)string.getStartPosition());
            Assert.assertEquals((long)(402 + "'begin'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(7);
            Assert.assertEquals((long)"beginaendbeginbendbegin".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbeginbendbeginc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)287L, (long)string.getStartPosition());
            Assert.assertEquals((long)(287 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedFile.getGeneratedRegions().get(8);
            Assert.assertEquals((long)"beginaendbeginbendbeginc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"beginaendbeginbendbegincend".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"end", (Object)string.getStringSymbol());
            Assert.assertEquals((long)418L, (long)string.getStartPosition());
            Assert.assertEquals((long)(418 + "'end'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockForTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockForTemplate.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"123".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            int gencpt = 1;
            for (GeneratedText generatedText : generatedRegions) {
                Assert.assertEquals((long)(0 + gencpt - 1), (long)generatedText.getStartOffset());
                Assert.assertEquals((long)gencpt, (long)generatedText.getEndOffset());
                ModuleElement moduleElement = generatedText.getModuleElement();
                EObject element = moduleElement.getModuleElement();
                Assert.assertTrue((boolean)(element instanceof ASTNode));
                Assert.assertTrue((boolean)(element instanceof IntegerLiteralExp));
                IntegerLiteralExp integer = (IntegerLiteralExp)element;
                Assert.assertEquals((Object)gencpt, (Object)integer.getIntegerSymbol());
                Assert.assertEquals((long)(279 + (gencpt - 1) * 3), (long)integer.getStartPosition());
                Assert.assertEquals((long)(279 + (gencpt - 1) * 3 + Integer.valueOf(gencpt).toString().length()), (long)integer.getEndPosition());
                InputElement sourceElement = generatedText.getSourceElement();
                EObject modelElement = sourceElement.getModelElement();
                Assert.assertTrue((boolean)(modelElement instanceof EClass));
                Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
                Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
                ++gencpt;
            }
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockForVariableInitialization() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockForVariableInitialization.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)6L, (long)generatedRegions.size());
            Assert.assertEquals((long)("blockFornewName".length() * 3), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFor".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)338L, (long)string.getStartPosition());
            Assert.assertEquals((long)(338 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"blockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)325L, (long)string.getStartPosition());
            Assert.assertEquals((long)(325 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"blockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameblockFor".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)338L, (long)string.getStartPosition());
            Assert.assertEquals((long)(338 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"blockFornewNameblockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameblockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)325L, (long)string.getStartPosition());
            Assert.assertEquals((long)(325 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"blockFornewNameblockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameblockFornewNameblockFor".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)338L, (long)string.getStartPosition());
            Assert.assertEquals((long)(338 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"blockFornewNameblockFornewNameblockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameblockFornewNameblockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)325L, (long)string.getStartPosition());
            Assert.assertEquals((long)(325 + "'newName'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockForVariableInitializationTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockForVariableInitializationTemplate.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)("blockFornewNameotherName".length() * 3), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFor".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)388L, (long)string.getStartPosition());
            Assert.assertEquals((long)(388 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"blockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)333L, (long)string.getStartPosition());
            Assert.assertEquals((long)(333 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"blockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothername".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"otherName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)481L, (long)string.getStartPosition());
            Assert.assertEquals((long)(481 + "otherName".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"blockFornewNameothername".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFor".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)388L, (long)string.getStartPosition());
            Assert.assertEquals((long)(388 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"blockFornewNameothernameblockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)333L, (long)string.getStartPosition());
            Assert.assertEquals((long)(333 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothername".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"otherName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)481L, (long)string.getStartPosition());
            Assert.assertEquals((long)(481 + "otherName".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothername".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFor".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)388L, (long)string.getStartPosition());
            Assert.assertEquals((long)(388 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)333L, (long)string.getStartPosition());
            Assert.assertEquals((long)(333 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFornewNameothername".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"otherName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)481L, (long)string.getStartPosition());
            Assert.assertEquals((long)(481 + "otherName".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockForVariableInitializationQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockForVariableInitializationQuery.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)("blockFornewNameotherName".length() * 3), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFor".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)385L, (long)string.getStartPosition());
            Assert.assertEquals((long)(385 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"blockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)330L, (long)string.getStartPosition());
            Assert.assertEquals((long)(330 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"blockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothername".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"otherName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)486L, (long)string.getStartPosition());
            Assert.assertEquals((long)(486 + "'otherName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"blockFornewNameothername".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFor".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)385L, (long)string.getStartPosition());
            Assert.assertEquals((long)(385 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"blockFornewNameothernameblockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)330L, (long)string.getStartPosition());
            Assert.assertEquals((long)(330 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothername".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"otherName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)486L, (long)string.getStartPosition());
            Assert.assertEquals((long)(486 + "'otherName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothername".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFor".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)385L, (long)string.getStartPosition());
            Assert.assertEquals((long)(385 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)330L, (long)string.getStartPosition());
            Assert.assertEquals((long)(330 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameothernameblockFornewNameothernameblockFornewNameothername".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"otherName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)486L, (long)string.getStartPosition());
            Assert.assertEquals((long)(486 + "'otherName'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockForVariableInitializationOperation() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockForVariableInitializationOperation.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)12L, (long)generatedRegions.size());
            Assert.assertEquals((long)("blockFornewNameclaYOP".length() * 3), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFor".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)412L, (long)string.getStartPosition());
            Assert.assertEquals((long)(412 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"blockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)334L, (long)string.getStartPosition());
            Assert.assertEquals((long)(334 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"blockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNamecla".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)367L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(367 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"blockFornewNamecla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOP".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"YOP", (Object)string.getStringSymbol());
            Assert.assertEquals((long)402L, (long)string.getStartPosition());
            Assert.assertEquals((long)(402 + "'YOP'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"blockFornewNameclaYOP".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFor".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)412L, (long)string.getStartPosition());
            Assert.assertEquals((long)(412 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)334L, (long)string.getStartPosition());
            Assert.assertEquals((long)(334 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNamecla".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)367L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(367 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNamecla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOP".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"YOP", (Object)string.getStringSymbol());
            Assert.assertEquals((long)402L, (long)string.getStartPosition());
            Assert.assertEquals((long)(402 + "'YOP'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOP".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOPblockFor".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"blockFor", (Object)string.getStringSymbol());
            Assert.assertEquals((long)412L, (long)string.getStartPosition());
            Assert.assertEquals((long)(412 + "blockFor".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(9);
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOPblockFor".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOPblockFornewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)334L, (long)string.getStartPosition());
            Assert.assertEquals((long)(334 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(10);
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOPblockFornewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOPblockFornewNamecla".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)367L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(367 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(11);
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOPblockFornewNamecla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"blockFornewNameclaYOPblockFornewNameclaYOPblockFornewNameclaYOP".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"YOP", (Object)string.getStringSymbol());
            Assert.assertEquals((long)402L, (long)string.getStartPosition());
            Assert.assertEquals((long)(402 + "'YOP'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockLet() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockLet.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof VariableExp));
            VariableExp variableExp = (VariableExp)element;
            Assert.assertEquals((Object)"name", (Object)variableExp.getName());
            Assert.assertEquals((long)291L, (long)variableExp.getStartPosition());
            Assert.assertEquals((long)(291 + "name".length()), (long)variableExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockLetQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockLetQuery.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof VariableExp));
            VariableExp variableExp = (VariableExp)element;
            Assert.assertEquals((Object)"name", (Object)variableExp.getName());
            Assert.assertEquals((long)303L, (long)variableExp.getStartPosition());
            Assert.assertEquals((long)(303 + "name".length()), (long)variableExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockLetTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockLetTemplate.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof VariableExp));
            VariableExp variableExp = (VariableExp)element;
            Assert.assertEquals((Object)"name", (Object)variableExp.getName());
            Assert.assertEquals((long)309L, (long)variableExp.getStartPosition());
            Assert.assertEquals((long)(309 + "name".length()), (long)variableExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockProtected() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockProtected.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)"start of user code protected\nend of user code".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code ".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof ProtectedAreaBlock));
            ProtectedAreaBlock protectedAreaBlock = (ProtectedAreaBlock)element;
            Assert.assertTrue((boolean)(protectedAreaBlock.getMarker() instanceof StringLiteralExp));
            Assert.assertEquals((Object)"protected", (Object)((StringLiteralExp)protectedAreaBlock.getMarker()).getStringSymbol());
            Assert.assertEquals((long)180L, (long)protectedAreaBlock.getStartPosition());
            Assert.assertEquals((long)(180 + "[protected ('protected')]\n[/protected]".length()), (long)protectedAreaBlock.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"start of user code ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code protected".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"protected", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)192L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(192 + "'protected'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"start of user code protected".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code protected\n".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"\n", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)205L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(205 + "\n".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"start of user code protected\n".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code protected\nend of user code".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof ProtectedAreaBlock));
            protectedAreaBlock = (ProtectedAreaBlock)element;
            Assert.assertTrue((boolean)(protectedAreaBlock.getMarker() instanceof StringLiteralExp));
            Assert.assertEquals((Object)"protected", (Object)((StringLiteralExp)protectedAreaBlock.getMarker()).getStringSymbol());
            Assert.assertEquals((long)180L, (long)protectedAreaBlock.getStartPosition());
            Assert.assertEquals((long)(180 + "[protected ('protected')]\n[/protected]".length()), (long)protectedAreaBlock.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Ignore
    @Test
    public void testTraceabilityBlockProtectedMultiple() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockProtectedMultiple.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)20L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)20L, (long)generatedRegions.size());
            Assert.assertEquals((long)"start of user code protected\nend of user code".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code ".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof ProtectedAreaBlock));
            ProtectedAreaBlock protectedAreaBlock = (ProtectedAreaBlock)element;
            Assert.assertTrue((boolean)(protectedAreaBlock.getMarker() instanceof StringLiteralExp));
            Assert.assertEquals((Object)"protected", (Object)((StringLiteralExp)protectedAreaBlock.getMarker()).getStringSymbol());
            Assert.assertEquals((long)180L, (long)protectedAreaBlock.getStartPosition());
            Assert.assertEquals((long)(180 + "[protected ('protected')]\n[/protected]".length()), (long)protectedAreaBlock.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"start of user code ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code protected".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"protected", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)192L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(192 + "'protected'".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"start of user code protected".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code protected\n".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"\n", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)205L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(205 + "\n".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"start of user code protected\n".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code protected\nend of user code".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof ProtectedAreaBlock));
            protectedAreaBlock = (ProtectedAreaBlock)element;
            Assert.assertTrue((boolean)(protectedAreaBlock.getMarker() instanceof StringLiteralExp));
            Assert.assertEquals((Object)"protected", (Object)((StringLiteralExp)protectedAreaBlock.getMarker()).getStringSymbol());
            Assert.assertEquals((long)180L, (long)protectedAreaBlock.getStartPosition());
            Assert.assertEquals((long)(180 + "[protected ('protected')]\n[/protected]".length()), (long)protectedAreaBlock.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockProtectedQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockProtectedQuery.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)("start of user code class" + cpt + "\nend of user code").length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code ".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof ProtectedAreaBlock));
            ProtectedAreaBlock protectedAreaBlock = (ProtectedAreaBlock)element;
            Assert.assertTrue((boolean)(protectedAreaBlock.getMarker() instanceof QueryInvocation));
            Assert.assertEquals((Object)"queryTest", (Object)((QueryInvocation)protectedAreaBlock.getMarker()).getDefinition().getName());
            Assert.assertEquals((long)185L, (long)protectedAreaBlock.getStartPosition());
            Assert.assertEquals((long)(185 + "[protected (eClass.queryTest())]\n[/protected]".length()), (long)protectedAreaBlock.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"start of user code ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("start of user code class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)302L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(302 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("start of user code class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("start of user code class" + cpt + "\n").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"\n", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)217L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(217 + "\n".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)("start of user code class" + cpt + "\n").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("start of user code class" + cpt + "\nend of user code").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof ProtectedAreaBlock));
            protectedAreaBlock = (ProtectedAreaBlock)element;
            Assert.assertTrue((boolean)(protectedAreaBlock.getMarker() instanceof QueryInvocation));
            Assert.assertEquals((Object)"queryTest", (Object)((QueryInvocation)protectedAreaBlock.getMarker()).getDefinition().getName());
            Assert.assertEquals((long)185L, (long)protectedAreaBlock.getStartPosition());
            Assert.assertEquals((long)(185 + "[protected (eClass.queryTest())]\n[/protected]".length()), (long)protectedAreaBlock.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockProtectedTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockProtectedTemplate.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)("start of user code class" + cpt + "\nend of user code").length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"start of user code ".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof ProtectedAreaBlock));
            ProtectedAreaBlock protectedAreaBlock = (ProtectedAreaBlock)element;
            Assert.assertTrue((boolean)(protectedAreaBlock.getMarker() instanceof TemplateInvocation));
            Assert.assertEquals((Object)"templateTest", (Object)((TemplateInvocation)protectedAreaBlock.getMarker()).getDefinition().getName());
            Assert.assertEquals((long)188L, (long)protectedAreaBlock.getStartPosition());
            Assert.assertEquals((long)(188 + "[protected (eClass.templateTest())]\n[/protected]".length()), (long)protectedAreaBlock.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"start of user code ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("start of user code class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)304L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(304 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("start of user code class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("start of user code class" + cpt + "\n").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"\n", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)223L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(223 + "\n".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)("start of user code class" + cpt + "\n").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("start of user code class" + cpt + "\nend of user code").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof ProtectedAreaBlock));
            protectedAreaBlock = (ProtectedAreaBlock)element;
            Assert.assertTrue((boolean)(protectedAreaBlock.getMarker() instanceof TemplateInvocation));
            Assert.assertEquals((Object)"templateTest", (Object)((TemplateInvocation)protectedAreaBlock.getMarker()).getDefinition().getName());
            Assert.assertEquals((long)188L, (long)protectedAreaBlock.getStartPosition());
            Assert.assertEquals((long)(188 + "[protected (eClass.templateTest())]\n[/protected]".length()), (long)protectedAreaBlock.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateFile() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateFile.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"Hello World".length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)219L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(219 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)233L, (long)string.getStartPosition());
            Assert.assertEquals((long)(233 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"Hello World".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"Hello World", (Object)string.getStringSymbol());
            Assert.assertEquals((long)257L, (long)string.getStartPosition());
            Assert.assertEquals((long)(257 + "Hello World".length()), (long)string.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFile() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFile.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)283L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(283 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)297L, (long)string.getStartPosition());
            Assert.assertEquals((long)(297 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)322L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(322 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFile2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFile2.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)284L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(284 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)298L, (long)string.getStartPosition());
            Assert.assertEquals((long)(298 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)418L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(418 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFile3() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFile3.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)284L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(284 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)298L, (long)string.getStartPosition());
            Assert.assertEquals((long)(298 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)418L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(418 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)431L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(431 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)438L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(438 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFile4() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFile4.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)284L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(284 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)298L, (long)string.getStartPosition());
            Assert.assertEquals((long)(298 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)449L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(449 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)347L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(347 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)449L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(449 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFile5() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFile5.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)284L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(284 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)298L, (long)string.getStartPosition());
            Assert.assertEquals((long)(298 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)621L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(621 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)347L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(347 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)621L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(621 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFile6() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFile6.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)7L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)284L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(284 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)298L, (long)string.getStartPosition());
            Assert.assertEquals((long)(298 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)683L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(683 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)347L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(347 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)683L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(683 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)378L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(378 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)683L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(683 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)409L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(409 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)683L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(683 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFile7() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFile7.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)7L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)284L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(284 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)298L, (long)string.getStartPosition());
            Assert.assertEquals((long)(298 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)893L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(893 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)347L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(347 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)893L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(893 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)378L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(378 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)893L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(893 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)409L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(409 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)893L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(893 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFileFor() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFileFor.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)7L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)286L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(286 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)300L, (long)string.getStartPosition());
            Assert.assertEquals((long)(300 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)937L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(937 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)385L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(385 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)937L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(937 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)416L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(416 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)937L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(937 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)447L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(447 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)937L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(937 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFileIf() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFileIf.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)7L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)285L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(285 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)299L, (long)string.getStartPosition());
            Assert.assertEquals((long)(299 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)910L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(910 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)359L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(359 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)910L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(910 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)390L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(390 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)910L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(910 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)421L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(421 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)910L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(910 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFileIf2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFileIf2.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)7L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)2L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)286L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(286 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)nameRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + ".txt").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)".txt", (Object)string.getStringSymbol());
            Assert.assertEquals((long)300L, (long)string.getStartPosition());
            Assert.assertEquals((long)(300 + "'.txt'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)927L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(927 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)371L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(371 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)927L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(927 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)402L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(402 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)927L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(927 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"yopyop", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)433L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(433 + "yopyop".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt + "yopyop" + "class" + cpt).length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"eClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)927L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(927 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateCollectFileIfTrim() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateCollectFileIfTrim.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((String)("Error with the file " + generatedFile.getPath()), (long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"/**\n * stuff".length(), (long)generatedFile.getLength());
            EList nameRegions = generatedFile.getNameRegions();
            Assert.assertEquals((long)1L, (long)nameRegions.size());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getName());
            GeneratedText generatedText = (GeneratedText)nameRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            EGenericType eGenericType = propertyCallExp.getEGenericType();
            Assert.assertTrue((boolean)eGenericType.getERawType().getInstanceClass().equals(String.class));
            Assert.assertEquals((Object)"aClass.name", (Object)propertyCallExp.toString());
            Assert.assertEquals((long)289L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(289 + "aClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"/**\n * ".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"/**\n * ", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)418L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(418 + "/**\n * ".length()), (long)stringLiteralExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"/**\n * ".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"/**\n * stuff".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            stringLiteralExp = (StringLiteralExp)element;
            Assert.assertEquals((Object)"stuff\n", (Object)stringLiteralExp.getStringSymbol());
            Assert.assertEquals((long)539L, (long)stringLiteralExp.getStartPosition());
            Assert.assertEquals((long)(539 + "stuff\n".length()), (long)stringLiteralExp.getEndPosition());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)1L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)generatedFile.getPath());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateFor() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateFor.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"tictac".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tictac".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tictac", (Object)string.getStringSymbol());
            Assert.assertEquals((long)195L, (long)string.getStartPosition());
            Assert.assertEquals((long)(195 + "'tictac'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateForIf() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateForIf.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"tictac".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tictac".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tictac", (Object)string.getStringSymbol());
            Assert.assertEquals((long)197L, (long)string.getStartPosition());
            Assert.assertEquals((long)(197 + "'tictac'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateForFor() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateForFor.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"tictac".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tictac".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tictac", (Object)string.getStringSymbol());
            Assert.assertEquals((long)198L, (long)string.getStartPosition());
            Assert.assertEquals((long)(198 + "'tictac'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateForIfLet() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateForIfLet.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"tictac".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tictac".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tictac", (Object)string.getStringSymbol());
            Assert.assertEquals((long)200L, (long)string.getStartPosition());
            Assert.assertEquals((long)(200 + "'tictac'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityBlockTemplateForForTemplateForForTemplateForForTemplateForFor() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/block/blockTemplateForForTemplateForForTemplateForForTemplateForFor.mtl", "main", "data/block/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"tictac".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"tictac".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"tictac", (Object)string.getStringSymbol());
            Assert.assertEquals((long)240L, (long)string.getStartPosition());
            Assert.assertEquals((long)(240 + "'tictac'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/block/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }
}

