/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.traceability.tests.unit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.AssertionFailedError;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.PreviewStrategy;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.util.MtlResourceImpl;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoParserInfos;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoParserWarnings;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.traceability.tests.unit.AcceleoTraceabilityListener;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.junit.After;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public abstract class AbstractTraceabilityTest {
    protected static final String PLUGIN_ID = "org.eclipse.acceleo.traceability.tests";
    protected final Bundle bundle = Platform.getBundle((String)"org.eclipse.acceleo.traceability.tests");
    protected EObject inputModel;
    protected Module module;
    protected final ResourceSet resourceSet = new ResourceSetImpl();
    protected URI moduleURI;

    protected AcceleoTraceabilityListener parseAndGenerate(String mtlPath, StringBuffer moduleBuffer, String templateName, String modelPath, boolean listenGenerationEnd) {
        Resource modelResource = this.parse(mtlPath, moduleBuffer);
        EObject rootTemplate = (EObject)modelResource.getContents().get(0);
        if (rootTemplate instanceof Module) {
            this.module = (Module)rootTemplate;
        } else {
            junit.framework.Assert.fail((String)"Couldn't load the input template.");
        }
        AcceleoTraceabilityListener traceabilityListener = new AcceleoTraceabilityListener(listenGenerationEnd);
        AcceleoPreferences.switchTraceability((boolean)true);
        AcceleoService.addStaticListener((IAcceleoTextGenerationListener)traceabilityListener);
        try {
            URI inputModelURI = URI.createPlatformPluginURI((String)("/org.eclipse.acceleo.traceability.tests/" + modelPath), (boolean)true);
            this.inputModel = ModelUtils.load((URI)inputModelURI, (ResourceSet)this.resourceSet);
        }
        catch (IOException e) {
            Assert.fail((String)"Error loading the input model.");
        }
        new AcceleoService((IAcceleoGenerationStrategy)new PreviewStrategy()).doGenerate(this.module, templateName, this.inputModel, null, (Monitor)new BasicMonitor());
        AcceleoPreferences.switchTraceability((boolean)false);
        AcceleoService.removeStaticListener((IAcceleoTextGenerationListener)traceabilityListener);
        return traceabilityListener;
    }

    protected Resource parse(String mtlPath, StringBuffer mtlBuffer) {
        File file = this.createFile(mtlPath);
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(mtlBuffer);
        this.moduleURI = URI.createPlatformPluginURI((String)("/org.eclipse.acceleo.traceability.tests/" + new Path(mtlPath).removeFileExtension().addFileExtension("emtl")), (boolean)true);
        MtlResourceImpl modelResource = new MtlResourceImpl(URI.createURI((String)"org.eclipse.acceleo/src/module/myModule.emtl"));
        AcceleoParser parser = new AcceleoParser();
        parser.parse(source, (Resource)modelResource, new ArrayList());
        AcceleoParserProblems problems = parser.getProblems(file);
        AcceleoParserWarnings warnings = parser.getWarnings(file);
        AcceleoParserInfos infos = parser.getInfos(file);
        String emptyList = "[]";
        if (problems != null) {
            junit.framework.Assert.assertEquals((String)"[]", (String)problems.getList().toString());
        }
        if (warnings != null) {
            junit.framework.Assert.assertEquals((String)"[]", (String)warnings.getList().toString());
        }
        if (infos != null) {
            junit.framework.Assert.assertEquals((String)"[]", (String)infos.getList().toString());
        }
        return modelResource;
    }

    protected AcceleoTraceabilityListener parseAndGenerate(String modulePath, String templateName, String modelPath, boolean listenGenerationEnd) {
        Resource moduleResource = this.parse(modulePath);
        EObject rootTemplate = (EObject)moduleResource.getContents().get(0);
        ResourceSetImpl moduleResourceSet = new ResourceSetImpl();
        moduleResourceSet.getResources().add((Object)moduleResource);
        if (rootTemplate instanceof Module) {
            this.module = (Module)rootTemplate;
        } else {
            junit.framework.Assert.fail((String)"Couldn't load the input template.");
        }
        AcceleoTraceabilityListener traceabilityListener = new AcceleoTraceabilityListener(listenGenerationEnd);
        AcceleoPreferences.switchTraceability((boolean)true);
        AcceleoService.addStaticListener((IAcceleoTextGenerationListener)traceabilityListener);
        try {
            URI inputModelURI = URI.createPlatformPluginURI((String)("/org.eclipse.acceleo.traceability.tests/" + modelPath), (boolean)true);
            this.inputModel = ModelUtils.load((URI)inputModelURI, (ResourceSet)this.resourceSet);
        }
        catch (IOException e) {
            Assert.fail((String)"Error loading the input model.");
        }
        new AcceleoService((IAcceleoGenerationStrategy)new PreviewStrategy()).doGenerate(this.module, templateName, this.inputModel, null, (Monitor)new BasicMonitor());
        AcceleoPreferences.switchTraceability((boolean)false);
        AcceleoService.removeStaticListener((IAcceleoTextGenerationListener)traceabilityListener);
        return traceabilityListener;
    }

    protected Resource parse(String mtlPath) {
        File file = this.createFile(mtlPath);
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(file);
        this.moduleURI = URI.createPlatformPluginURI((String)("/org.eclipse.acceleo.traceability.tests/" + new Path(mtlPath).removeFileExtension().addFileExtension("emtl")), (boolean)true);
        MtlResourceImpl modelResource = new MtlResourceImpl(URI.createURI((String)"org.eclipse.acceleo/src/module/myModule.emtl"));
        AcceleoParser parser = new AcceleoParser();
        parser.parse(source, (Resource)modelResource, new ArrayList());
        AcceleoParserProblems problems = parser.getProblems(file);
        AcceleoParserWarnings warnings = parser.getWarnings(file);
        AcceleoParserInfos infos = parser.getInfos(file);
        String emptyList = "[]";
        if (problems != null) {
            junit.framework.Assert.assertEquals((String)"[]", (String)problems.getList().toString());
        }
        if (warnings != null) {
            junit.framework.Assert.assertEquals((String)"[]", (String)warnings.getList().toString());
        }
        if (infos != null) {
            junit.framework.Assert.assertEquals((String)"[]", (String)infos.getList().toString());
        }
        return modelResource;
    }

    protected File createFile(String pathName) {
        try {
            String fileLocation = FileLocator.resolve((URL)this.bundle.getEntry(pathName)).getPath();
            return new File(fileLocation);
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.getMessage());
        }
    }

    protected Object getObjectFromVariable(VariableExp variableExp) {
        Object object = null;
        OCLExpression initExpression = variableExp.getReferredVariable().getInitExpression();
        try {
            Field[] declaredFields;
            Field ref = null;
            Field[] fieldArray = declaredFields = initExpression.getClass().getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if ("referredExpression".equals(field.getName())) {
                    ref = field;
                    break;
                }
                ++n2;
            }
            if (ref != null) {
                ref.setAccessible(true);
                object = ref.get(initExpression);
            } else {
                Assert.fail();
            }
        }
        catch (SecurityException e) {
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
        catch (IllegalAccessException e) {
            Assert.fail();
        }
        return object;
    }

    @After
    public void tearDown() {
        for (Resource resource : this.resourceSet.getResources()) {
            if (resource == this.inputModel.eResource()) continue;
            resource.unload();
        }
    }
}

