/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.traceability.tests.unit.template;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.PreviewStrategy;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.traceability.GeneratedFile;
import org.eclipse.acceleo.traceability.GeneratedText;
import org.eclipse.acceleo.traceability.InputElement;
import org.eclipse.acceleo.traceability.ModuleElement;
import org.eclipse.acceleo.traceability.tests.unit.AbstractTraceabilityTest;
import org.eclipse.acceleo.traceability.tests.unit.AcceleoTraceabilityListener;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.text.Region;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.utilities.ASTNode;
import org.junit.Assert;
import org.junit.Test;

public class AcceleoTraceabilityTemplateTests
extends AbstractTraceabilityTest {
    @Test
    public void testTraceabilityTemplateSimple() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateSimple.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templateSimple".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateSimple".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateSimple", (Object)string.getStringSymbol());
            Assert.assertEquals((long)275L, (long)string.getStartPosition());
            Assert.assertEquals((long)(275 + "templateSimple".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateGuard() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateGuard.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)1L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templateGuard".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateGuard".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateGuard", (Object)string.getStringSymbol());
            Assert.assertEquals((long)332L, (long)string.getStartPosition());
            Assert.assertEquals((long)(332 + "templateGuard".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateMultipleParameters() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateMultipleParameters.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templateMultipleParameters".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateMultipleParameters".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateMultipleParameters", (Object)string.getStringSymbol());
            Assert.assertEquals((long)313L, (long)string.getStartPosition());
            Assert.assertEquals((long)(313 + "templateMultipleParameters".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateMultipleTemplates() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateMultipleTemplates.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templateMultipleTemplates".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateMultipleTemplates".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateMultipleTemplates", (Object)string.getStringSymbol());
            Assert.assertEquals((long)510L, (long)string.getStartPosition());
            Assert.assertEquals((long)(510 + "templateMultipleTemplates".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateTabulations() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateTabulations.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"\ttemplateTabulations".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"\t".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"\t", (Object)string.getStringSymbol());
            Assert.assertEquals((long)185L, (long)string.getStartPosition());
            Assert.assertEquals((long)(185 + "\t".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"\t".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("\t".length() + "templateTabulations".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateTabulations", (Object)string.getStringSymbol());
            Assert.assertEquals((long)292L, (long)string.getStartPosition());
            Assert.assertEquals((long)(292 + "templateTabulations".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateImbricated() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateImbricated.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"template1template3".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"template1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"template1", (Object)string.getStringSymbol());
            Assert.assertEquals((long)290L, (long)string.getStartPosition());
            Assert.assertEquals((long)(290 + "template1".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"template1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("template1".length() + "template3".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"template3", (Object)string.getStringSymbol());
            Assert.assertEquals((long)434L, (long)string.getStartPosition());
            Assert.assertEquals((long)(434 + "template3".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateIndentation() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateIndentation.mtl", "main", "data/template/model.uml", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)1L, (long)generatedFiles.size());
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedText = generatedFile.getGeneratedRegions();
            ArrayList<Region> regions = new ArrayList<Region>();
            for (GeneratedText text : generatedText) {
                Region region = new Region(text.getStartOffset(), text.getEndOffset() - text.getStartOffset());
                boolean collision = false;
                for (Region otherRegion : regions) {
                    if (otherRegion.getOffset() <= region.getOffset() && region.getOffset() < otherRegion.getOffset() + otherRegion.getLength()) {
                        collision = true;
                        continue;
                    }
                    if (otherRegion.getOffset() >= region.getOffset() + region.getLength() || region.getOffset() + region.getLength() >= otherRegion.getOffset() + otherRegion.getLength()) continue;
                    collision = true;
                }
                regions.add(region);
                Assert.assertFalse((String)("The region [" + region.getOffset() + "," + (region.getLength() + region.getOffset()) + "] has entered in collision with another traceability region."), (boolean)collision);
            }
        }
    }

    @Test
    public void testTraceabilityTemplateCollectIf() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollectIf.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)444L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(444 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollectIf2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollectIf2.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)461L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(461 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollectIf3() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollectIf3.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)480L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(480 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollection() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollection.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"template1template2".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"template1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"template1", (Object)string.getStringSymbol());
            Assert.assertEquals((long)299L, (long)string.getStartPosition());
            Assert.assertEquals((long)(299 + "template1".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"template1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("template1".length() + "template2".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"template2", (Object)string.getStringSymbol());
            Assert.assertEquals((long)365L, (long)string.getStartPosition());
            Assert.assertEquals((long)(365 + "template2".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollection2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollection2.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"template1template2".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"template1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"template1", (Object)string.getStringSymbol());
            Assert.assertEquals((long)311L, (long)string.getStartPosition());
            Assert.assertEquals((long)(311 + "template1".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"template1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("template1".length() + "template2".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"template2", (Object)string.getStringSymbol());
            Assert.assertEquals((long)377L, (long)string.getStartPosition());
            Assert.assertEquals((long)(377 + "template2".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollection3() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollection3.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)"class1class2class3class4".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)239L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(239 + "name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class1", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class1".length() + "class2".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)239L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(239 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class2", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"class1class2".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class1class2".length() + "class3".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)239L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(239 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class3", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"class1class2class3".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class1class2class3".length() + "class4".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)239L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(239 + "name".length()), (long)propertyCallExp.getEndPosition());
            sourceElement = generatedText.getSourceElement();
            modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class4", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollection4() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollection4.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)"class1class2class3class4".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)249L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(249 + "name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"class1".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class1".length() + "class2".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)249L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(249 + "name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"class1class2".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class1class2".length() + "class3".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)249L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(249 + "name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"class1class2class3".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class1class2class3".length() + "class4".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)249L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(249 + "name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)"class4", (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollectionCollect() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollectionCollect.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)"aaabbbccc".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)201L, (long)string.getStartPosition());
            Assert.assertEquals((long)(201 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"a".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)201L, (long)string.getStartPosition());
            Assert.assertEquals((long)(201 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)201L, (long)string.getStartPosition());
            Assert.assertEquals((long)(201 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaab".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)206L, (long)string.getStartPosition());
            Assert.assertEquals((long)(206 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"aaab".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)206L, (long)string.getStartPosition());
            Assert.assertEquals((long)(206 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"aaabb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)206L, (long)string.getStartPosition());
            Assert.assertEquals((long)(206 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"aaabbb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)211L, (long)string.getStartPosition());
            Assert.assertEquals((long)(211 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"aaabbbc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbcc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)211L, (long)string.getStartPosition());
            Assert.assertEquals((long)(211 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"aaabbbcc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbccc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)211L, (long)string.getStartPosition());
            Assert.assertEquals((long)(211 + "'c'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollectionCollect2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollectionCollect2.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)9L, (long)generatedRegions.size());
            Assert.assertEquals((long)"aaabbbccc".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)202L, (long)string.getStartPosition());
            Assert.assertEquals((long)(202 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"a".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)202L, (long)string.getStartPosition());
            Assert.assertEquals((long)(202 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)202L, (long)string.getStartPosition());
            Assert.assertEquals((long)(202 + "'a'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaab".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)207L, (long)string.getStartPosition());
            Assert.assertEquals((long)(207 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"aaab".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)207L, (long)string.getStartPosition());
            Assert.assertEquals((long)(207 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"aaabb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbb".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)207L, (long)string.getStartPosition());
            Assert.assertEquals((long)(207 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(6);
            Assert.assertEquals((long)"aaabbb".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)212L, (long)string.getStartPosition());
            Assert.assertEquals((long)(212 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(7);
            Assert.assertEquals((long)"aaabbbc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbcc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)212L, (long)string.getStartPosition());
            Assert.assertEquals((long)(212 + "'c'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(8);
            Assert.assertEquals((long)"aaabbbcc".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaabbbccc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)212L, (long)string.getStartPosition());
            Assert.assertEquals((long)(212 + "'c'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollectionCollect3() {
        Resource moduleResource = this.parse("data/template/templateCollectionCollect3.mtl");
        EObject rootTemplate = (EObject)moduleResource.getContents().get(0);
        ResourceSetImpl moduleResourceSet = new ResourceSetImpl();
        moduleResourceSet.getResources().add((Object)moduleResource);
        if (rootTemplate instanceof Module) {
            this.module = (Module)rootTemplate;
        } else {
            junit.framework.Assert.fail((String)"Couldn't load the input template.");
        }
        AcceleoTraceabilityListener traceabilityListener = new AcceleoTraceabilityListener(true);
        AcceleoPreferences.switchTraceability((boolean)true);
        AcceleoService.addStaticListener((IAcceleoTextGenerationListener)traceabilityListener);
        try {
            URI inputModelURI = URI.createPlatformPluginURI((String)"/org.eclipse.acceleo.traceability.tests/data/template/NonRegressionModel.uml", (boolean)true);
            this.inputModel = ModelUtils.load((URI)inputModelURI, (ResourceSet)this.resourceSet);
        }
        catch (IOException e) {
            Assert.fail((String)"Error loading the input model.");
        }
        Map map = new AcceleoService((IAcceleoGenerationStrategy)new PreviewStrategy()).doGenerate(this.module, "main", this.inputModel, null, (Monitor)new BasicMonitor());
        AcceleoPreferences.switchTraceability((boolean)false);
        AcceleoService.removeStaticListener((IAcceleoTextGenerationListener)traceabilityListener);
        String generatedFile = (String)map.get("result.txt");
        Assert.assertTrue((generatedFile.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTraceabilityTemplateCollectionSelect() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollectionSelect.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"a".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)string.getStringSymbol());
            Assert.assertEquals((long)200L, (long)string.getStartPosition());
            Assert.assertEquals((long)(200 + "'a'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateCollectionReject() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateCollectionReject.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"bc".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"b".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"b", (Object)string.getStringSymbol());
            Assert.assertEquals((long)205L, (long)string.getStartPosition());
            Assert.assertEquals((long)(205 + "'b'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"b".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bc".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"c", (Object)string.getStringSymbol());
            Assert.assertEquals((long)210L, (long)string.getStartPosition());
            Assert.assertEquals((long)(210 + "'c'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostSubstring() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostSubstring.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"mp".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"mp".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)" templatePostTrim ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)306L, (long)string.getStartPosition());
            Assert.assertEquals((long)(306 + " templatePostTrim ".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templatePostTrim".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templatePostTrim".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)" templatePostTrim ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)292L, (long)string.getStartPosition());
            Assert.assertEquals((long)(292 + " templatePostTrim ".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim2() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim2.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)391L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(391 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim3() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim3.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)423L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(423 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim4() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim4.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)544L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(544 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim5() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim5.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)541L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(541 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim6() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim6.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt + "coucou").length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)521L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(521 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "coucou").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"coucou\n\n\n\n", (Object)string.getStringSymbol());
            Assert.assertEquals((long)360L, (long)string.getStartPosition());
            Assert.assertEquals((long)(360 + "coucou\n\n\n\n".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim7() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim7.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)(("class" + cpt).length() * 2), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)547L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(547 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)(("class" + cpt).length() * 2), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)547L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(547 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim8() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim8.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)(("class" + cpt).length() * 2 + "coucou".length()), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)553L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(553 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt + "coucou").length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"coucou", (Object)string.getStringSymbol());
            Assert.assertEquals((long)360L, (long)string.getStartPosition());
            Assert.assertEquals((long)(360 + "coucou".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)("class" + cpt + "coucou").length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)(("class" + cpt).length() * 2 + "coucou".length()), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)553L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(553 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim9() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim9.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)("class" + cpt).length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)318L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(318 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplatePostTrim10() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templatePostTrim10.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)1L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templatePostTrim".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templatePostTrim".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)" templatePostTrim ", (Object)string.getStringSymbol());
            Assert.assertEquals((long)305L, (long)string.getStartPosition());
            Assert.assertEquals((long)(305 + " templatePostTrim ".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateVariableInitialization() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateVariableInitialization.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)2L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templateVariableInitnewName".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInit".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateVariableInit", (Object)string.getStringSymbol());
            Assert.assertEquals((long)335L, (long)string.getStartPosition());
            Assert.assertEquals((long)(335 + "templateVariableInit".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"templateVariableInit".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInitnewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)323L, (long)string.getStartPosition());
            Assert.assertEquals((long)(323 + "'newName'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateVariableInitializationOperation() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateVariableInitializationOperation.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)4L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templateVariableInitnewNameclaYOP".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInit".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateVariableInit", (Object)string.getStringSymbol());
            Assert.assertEquals((long)416L, (long)string.getStartPosition());
            Assert.assertEquals((long)(416 + "templateVariableInit".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"templateVariableInit".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInitnewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)335L, (long)string.getStartPosition());
            Assert.assertEquals((long)(335 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"templateVariableInitnewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInitnewNamecla".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof PropertyCallExp));
            PropertyCallExp propertyCallExp = (PropertyCallExp)element;
            Assert.assertEquals((Object)"name", (Object)((EStructuralFeature)propertyCallExp.getReferredProperty()).getName());
            Assert.assertEquals((long)369L, (long)propertyCallExp.getStartPosition());
            Assert.assertEquals((long)(369 + "eClass.name".length()), (long)propertyCallExp.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"templateVariableInitnewNamecla".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInitnewNameclaYOP".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"YOP", (Object)string.getStringSymbol());
            Assert.assertEquals((long)404L, (long)string.getStartPosition());
            Assert.assertEquals((long)(404 + "'YOP'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateVariableInitializationTemplate() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateVariableInitializationTemplate.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templateVariableInitnewNameclassName".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInit".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateVariableInit", (Object)string.getStringSymbol());
            Assert.assertEquals((long)392L, (long)string.getStartPosition());
            Assert.assertEquals((long)(392 + "templateVariableInit".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"templateVariableInit".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInitnewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)334L, (long)string.getStartPosition());
            Assert.assertEquals((long)(334 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"templateVariableInitnewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInitnewNameclassName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"className", (Object)string.getStringSymbol());
            Assert.assertEquals((long)491L, (long)string.getStartPosition());
            Assert.assertEquals((long)(491 + "className".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateVariableInitializationQuery() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateVariableInitializationQuery.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"templateVariableInitnewNameclassName".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInit".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"templateVariableInit", (Object)string.getStringSymbol());
            Assert.assertEquals((long)389L, (long)string.getStartPosition());
            Assert.assertEquals((long)(389 + "templateVariableInit".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"templateVariableInit".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInitnewName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"newName", (Object)string.getStringSymbol());
            Assert.assertEquals((long)331L, (long)string.getStartPosition());
            Assert.assertEquals((long)(331 + "'newName'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"templateVariableInitnewName".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"templateVariableInitnewNameclassName".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"className", (Object)string.getStringSymbol());
            Assert.assertEquals((long)496L, (long)string.getStartPosition());
            Assert.assertEquals((long)(496 + "'className'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateVariableExp() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateVariableExp.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)3L, (long)generatedRegions.size());
            Assert.assertEquals((long)"aaa".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"a".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp str = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)str.getStringSymbol());
            Assert.assertEquals((long)201L, (long)str.getStartPosition());
            Assert.assertEquals((long)(201 + "'a'".length()), (long)str.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"a".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            str = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)str.getStringSymbol());
            Assert.assertEquals((long)201L, (long)str.getStartPosition());
            Assert.assertEquals((long)(201 + "'a'".length()), (long)str.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"aa".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"aaa".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            str = (StringLiteralExp)element;
            Assert.assertEquals((Object)"a", (Object)str.getStringSymbol());
            Assert.assertEquals((long)201L, (long)str.getStartPosition());
            Assert.assertEquals((long)(201 + "'a'".length()), (long)str.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }

    @Test
    public void testTraceabilityTemplateComplexUseCase() {
        AcceleoTraceabilityListener traceabilityListener = this.parseAndGenerate("data/template/templateComplexUseCase.mtl", "main", "data/template/model.ecore", true);
        List<GeneratedFile> generatedFiles = traceabilityListener.getGeneratedFiles();
        Assert.assertEquals((long)4L, (long)generatedFiles.size());
        int cpt = 1;
        for (GeneratedFile generatedFile : generatedFiles) {
            EList generatedRegions = generatedFile.getGeneratedRegions();
            Assert.assertEquals((long)6L, (long)generatedRegions.size());
            Assert.assertEquals((long)"bidulechosegnagnachosegnagnamachin".length(), (long)generatedFile.getLength());
            EList sourceElements = generatedFile.getSourceElements();
            Assert.assertEquals((long)2L, (long)sourceElements.size());
            Assert.assertEquals((Object)("class" + cpt + ", feature='name'"), (Object)((InputElement)sourceElements.get(0)).toString());
            Assert.assertEquals((Object)("class" + cpt), (Object)((InputElement)sourceElements.get(1)).toString());
            Assert.assertEquals((Object)("class" + cpt + ".txt"), (Object)generatedFile.getPath());
            GeneratedText generatedText = (GeneratedText)generatedRegions.get(0);
            Assert.assertEquals((long)0L, (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidule".length(), (long)generatedText.getEndOffset());
            ModuleElement moduleElement = generatedText.getModuleElement();
            EObject element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            StringLiteralExp string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"bidule", (Object)string.getStringSymbol());
            Assert.assertEquals((long)206L, (long)string.getStartPosition());
            Assert.assertEquals((long)(206 + "'bidule'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(1);
            Assert.assertEquals((long)"bidule".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechose".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"chose", (Object)string.getStringSymbol());
            Assert.assertEquals((long)224L, (long)string.getStartPosition());
            Assert.assertEquals((long)(224 + "'chose'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(4);
            Assert.assertEquals((long)"bidulechose".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechosegnagna".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"gnagna", (Object)string.getStringSymbol());
            Assert.assertEquals((long)280L, (long)string.getStartPosition());
            Assert.assertEquals((long)(280 + "'gnagna'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(2);
            Assert.assertEquals((long)"bidulechosegnagna".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechosegnagnachose".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"chose", (Object)string.getStringSymbol());
            Assert.assertEquals((long)240L, (long)string.getStartPosition());
            Assert.assertEquals((long)(240 + "'chose'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(5);
            Assert.assertEquals((long)"bidulechosegnagnachose".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechosegnagnachosegnagna".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"gnagna", (Object)string.getStringSymbol());
            Assert.assertEquals((long)280L, (long)string.getStartPosition());
            Assert.assertEquals((long)(280 + "'gnagna'".length()), (long)string.getEndPosition());
            generatedText = (GeneratedText)generatedRegions.get(3);
            Assert.assertEquals((long)"bidulechosegnagnachosegnagna".length(), (long)generatedText.getStartOffset());
            Assert.assertEquals((long)"bidulechosegnagnachosegnagnamachin".length(), (long)generatedText.getEndOffset());
            moduleElement = generatedText.getModuleElement();
            element = moduleElement.getModuleElement();
            Assert.assertTrue((boolean)(element instanceof ASTNode));
            Assert.assertTrue((boolean)(element instanceof StringLiteralExp));
            string = (StringLiteralExp)element;
            Assert.assertEquals((Object)"machin", (Object)string.getStringSymbol());
            Assert.assertEquals((long)257L, (long)string.getStartPosition());
            Assert.assertEquals((long)(257 + "'machin'".length()), (long)string.getEndPosition());
            InputElement sourceElement = generatedText.getSourceElement();
            EObject modelElement = sourceElement.getModelElement();
            Assert.assertTrue((boolean)(modelElement instanceof EClass));
            Assert.assertEquals((Object)("class" + cpt), (Object)((EClass)modelElement).getName());
            Assert.assertEquals((Object)"/plugin/org.eclipse.acceleo.traceability.tests/data/template/model.ecore", (Object)modelElement.eResource().getURI().path());
            ++cpt;
        }
    }
}

