/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.traceability.tests.unit.random;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.experimental.theories.Theory;
import org.junit.experimental.theories.internal.Assignments;
import org.junit.experimental.theories.internal.ParameterizedAssertionError;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RandomStatement
extends Statement {
    private int successes = 0;
    private FrameworkMethod fTestMethod;
    private List<AssumptionViolatedException> fInvalidParameters = new ArrayList<AssumptionViolatedException>();
    private TestClass clazz;

    public RandomStatement(FrameworkMethod method, TestClass clazz) {
        this.fTestMethod = method;
        this.clazz = clazz;
    }

    public void evaluate() throws Throwable {
        this.runWithAssignment(Assignments.allUnassigned((Method)this.fTestMethod.getMethod(), (TestClass)this.clazz));
        if (this.successes == 0) {
            Assert.fail((String)("Never found parameters that satisfied method assumptions.  Violated assumptions: " + this.fInvalidParameters));
        }
    }

    protected void runWithAssignment(Assignments parameterAssignment) throws Throwable {
        if (!parameterAssignment.isComplete()) {
            this.runWithIncompleteAssignment(parameterAssignment);
        } else {
            this.runWithCompleteAssignment(parameterAssignment);
        }
    }

    protected void runWithIncompleteAssignment(Assignments incomplete) throws InstantiationException, IllegalAccessException, Throwable {
        for (PotentialAssignment source : incomplete.potentialsForNextUnassigned()) {
            this.runWithAssignment(incomplete.assignNext(source));
        }
    }

    protected void runWithCompleteAssignment(final Assignments complete) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, Throwable {
        new BlockJUnit4ClassRunner(this.clazz.getJavaClass()){

            protected void collectInitializationErrors(List<Throwable> errors) {
            }

            public Statement methodBlock(FrameworkMethod method) {
                final Statement statement = super.methodBlock(method);
                return new Statement(){

                    public void evaluate() throws Throwable {
                        try {
                            statement.evaluate();
                            RandomStatement.this.handleDataPointSuccess();
                        }
                        catch (AssumptionViolatedException e) {
                            RandomStatement.this.handleAssumptionViolation(e);
                        }
                        catch (Throwable e) {
                            RandomStatement.this.reportParameterizedError(e, complete.getArgumentStrings(RandomStatement.this.nullsOk()));
                        }
                    }
                };
            }

            protected Statement methodInvoker(FrameworkMethod method, Object test) {
                return RandomStatement.this.methodCompletesWithParameters(method, complete, test);
            }

            public Object createTest() throws Exception {
                return this.getTestClass().getOnlyConstructor().newInstance(complete.getConstructorArguments());
            }
        }.methodBlock(this.fTestMethod).evaluate();
    }

    private Statement methodCompletesWithParameters(final FrameworkMethod method, final Assignments complete, final Object freshInstance) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    Object[] values = complete.getMethodArguments();
                    method.invokeExplosively(freshInstance, values);
                }
                catch (PotentialAssignment.CouldNotGenerateValueException couldNotGenerateValueException) {
                    // empty catch block
                }
            }
        };
    }

    protected void handleAssumptionViolation(AssumptionViolatedException e) {
        this.fInvalidParameters.add(e);
    }

    protected void reportParameterizedError(Throwable e, Object ... params) throws Throwable {
        if (params.length == 0) {
            throw e;
        }
        throw new ParameterizedAssertionError(e, this.fTestMethod.getName(), params);
    }

    private boolean nullsOk() {
        Theory annotation = this.fTestMethod.getMethod().getAnnotation(Theory.class);
        if (annotation == null) {
            return false;
        }
        return annotation.nullsAccepted();
    }

    protected void handleDataPointSuccess() {
        ++this.successes;
    }
}

