/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.runtime.lookup.basic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.ILookupEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.acceleo.query.runtime.lookup.basic.CacheLookupEngine;
import org.eclipse.acceleo.query.runtime.lookup.basic.ServiceStore;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.ComparableServices;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.services.XPathServices;
import org.eclipse.acceleo.query.tests.runtime.lookup.basic.MethodHolder;
import org.eclipse.acceleo.query.tests.runtime.lookup.basic.TestServiceProvider;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LookupEngineTest {
    private final Class<ITestLookupEngine> cls;

    public LookupEngineTest(Class<ITestLookupEngine> cls) {
        this.cls = cls;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> classes() {
        return Arrays.asList({TestBasicLookupEngine.class}, {TestCacheLookupEngine.class});
    }

    ITestLookupEngine instanciate(CrossReferenceProvider provider) {
        try {
            Constructor<ITestLookupEngine> constructor = this.cls.getConstructor(CrossReferenceProvider.class);
            return constructor.newInstance(provider);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Test
    public void simpleRegistration() throws NoSuchMethodException, SecurityException {
        IService service2;
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServices1(provider))) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)engine.getRegisteredServices().size());
        service2 = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)service2.getMethod());
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void staticRegistration() throws NoSuchMethodException, SecurityException {
        IService service2;
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), TestStaticServices.class)) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)engine.getRegisteredServices().size());
        service2 = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestStaticServices.class.getMethod("service1", EClassifier.class), (Object)service2.getMethod());
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestStaticServices.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void extendedRegistration() throws NoSuchMethodException, SecurityException {
        IService service2;
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new ExtendedTestServices1(provider))) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        service2 = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)ExtendedTestServices1.class.getMethod("service1", EClassifier.class), (Object)service2.getMethod());
        service2 = (JavaMethodService)engine.lookup("service2", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)ExtendedTestServices1.class.getMethod("service2", EClassifier.class), (Object)service2.getMethod());
        Assert.assertEquals((long)2L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)ExtendedTestServices1.class.getMethod("service2", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        Assert.assertEquals((Object)ExtendedTestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(1)).getMethod());
    }

    @Test
    public void doubleRegistration() throws NoSuchMethodException, SecurityException {
        IService service2;
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServices1(provider))) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServices1(provider))) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)1L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)engine.getRegisteredServices().size());
        service2 = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)service2.getMethod());
        Assert.assertEquals((long)0L, (long)result.getRegistered().size());
    }

    @Test
    public void duplicateRegistration() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServices1(provider))) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), TestDuplicateServices1.class)) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)result.getDuplicated().size());
        Method expectedDuplicatedMethod = TestServices1.class.getMethod("service1", EClassifier.class);
        Map.Entry entry = result.getDuplicated().entrySet().iterator().next();
        Assert.assertEquals((Object)TestDuplicateServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)entry.getKey()).getMethod());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Method actualDuplicatedMethod = ((JavaMethodService)((List)entry.getValue()).get(0)).getMethod();
        Assert.assertEquals((Object)expectedDuplicatedMethod, (Object)actualDuplicatedMethod);
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        JavaMethodService service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestDuplicateServices1.class.getMethod("service1", EClassifier.class), (Object)service.getMethod());
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestDuplicateServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void maskRegistration() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServices1(provider))) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), TestMaskServices1.class)) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)1L, (long)result.getMasked().size());
        Method expectedMaskMethod = TestServices1.class.getMethod("service1", EClassifier.class);
        Assert.assertEquals((long)1L, (long)result.getMasked().entrySet().size());
        Map.Entry entry = result.getMasked().entrySet().iterator().next();
        Assert.assertEquals((Object)TestMaskServices1.class.getMethod("service1", EClass.class), (Object)((JavaMethodService)entry.getKey()).getMethod());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Method actualMaskMethod = ((JavaMethodService)((List)entry.getValue()).get(0)).getMethod();
        Assert.assertEquals((Object)expectedMaskMethod, (Object)actualMaskMethod);
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        JavaMethodService service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)service.getMethod());
        service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals((Object)TestMaskServices1.class.getMethod("service1", EClass.class), (Object)service.getMethod());
        Assert.assertEquals((long)2L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        Assert.assertEquals((Object)TestMaskServices1.class.getMethod("service1", EClass.class), (Object)((JavaMethodService)result.getRegistered().get(1)).getMethod());
    }

    @Test
    public void maskedByRegistration() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), TestMaskServices1.class)) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestMaskServices1.class.getMethod("service1", EClass.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServices1(provider))) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)1L, (long)result.getIsMaskedBy().size());
        Method expectedIsMaskedByMethod = TestMaskServices1.class.getMethod("service1", EClass.class);
        Map.Entry entry = result.getIsMaskedBy().entrySet().iterator().next();
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)entry.getKey()).getMethod());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Method actualIsMaskedByMethod = ((JavaMethodService)((List)entry.getValue()).get(0)).getMethod();
        Assert.assertEquals((Object)expectedIsMaskedByMethod, (Object)actualIsMaskedByMethod);
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        JavaMethodService service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)service.getMethod());
        service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals((Object)TestMaskServices1.class.getMethod("service1", EClass.class), (Object)service.getMethod());
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void withCrossReferencerRegistration() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServices1(provider))) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)engine.getRegisteredServices().size());
        Iterator iterator = engine.getRegisteredServices().iterator();
        JavaMethodService javaMethodService = (JavaMethodService)iterator.next();
        Assert.assertTrue((boolean)(javaMethodService.getInstance() instanceof TestServices1));
        TestServices1 instance = (TestServices1)javaMethodService.getInstance();
        Assert.assertEquals((Object)provider, (Object)instance.crossReferencer);
        JavaMethodService service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)service.getMethod());
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServices1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void simpleRegistrationServiceProvider() throws NoSuchMethodException, SecurityException {
        IService service2;
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)((Object)new TestServicesProvider1(provider)))) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)engine.getRegisteredServices().size());
        service2 = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)((TestServicesProvider1)((Object)service2.getInstance())).service1, (Object)service2);
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void extendedRegistrationServiceProvider() throws NoSuchMethodException, SecurityException {
        IService service2;
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)((Object)new ExtendedTestServicesProvider1(provider)))) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        service2 = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)ExtendedTestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)service2.getMethod());
        Assert.assertEquals((Object)((TestServicesProvider1)((Object)service2.getInstance())).service1, (Object)service2);
        service2 = (JavaMethodService)engine.lookup("service2", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)ExtendedTestServicesProvider1.class.getMethod("service2", EClassifier.class), (Object)service2.getMethod());
        Assert.assertEquals((Object)((ExtendedTestServicesProvider1)((Object)service2.getInstance())).service2, (Object)service2);
        Assert.assertEquals((long)2L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)ExtendedTestServicesProvider1.class.getMethod("service2", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        Assert.assertEquals((Object)ExtendedTestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(1)).getMethod());
    }

    @Test
    public void doubleRegistrationServiceProvider() throws NoSuchMethodException, SecurityException {
        IService service2;
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)((Object)new TestServicesProvider1(provider)))) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        result = new ServiceRegistrationResult();
        for (IService service2 : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)((Object)new TestServicesProvider1(provider)))) {
            result.merge(engine.registerService(service2));
        }
        Assert.assertEquals((long)1L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)engine.getRegisteredServices().size());
        service2 = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)service2.getMethod());
        Assert.assertEquals((Object)((TestServicesProvider1)((Object)service2.getInstance())).service1, (Object)service2);
        Assert.assertEquals((long)0L, (long)result.getRegistered().size());
    }

    @Test
    public void duplicateRegistrationServiceProvider() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)((Object)new TestServicesProvider1(provider)))) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), TestDuplicateServicesProvider1.class)) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)result.getDuplicated().size());
        Method expectedDuplicatedMethod = TestServicesProvider1.class.getMethod("service1", EClassifier.class);
        Map.Entry entry = result.getDuplicated().entrySet().iterator().next();
        Assert.assertEquals((Object)TestDuplicateServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)entry.getKey()).getMethod());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Method actualDuplicatedMethod = ((JavaMethodService)((List)entry.getValue()).get(0)).getMethod();
        Assert.assertEquals((Object)expectedDuplicatedMethod, (Object)actualDuplicatedMethod);
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        JavaMethodService service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestDuplicateServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)service.getMethod());
        Assert.assertEquals((Object)((TestDuplicateServicesProvider1)((Object)service.getInstance())).service1, (Object)service);
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestDuplicateServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void maskRegistrationServiceProvider() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)((Object)new TestServicesProvider1(provider)))) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), TestMaskServicesProvider1.class)) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)1L, (long)result.getMasked().size());
        Method expectedMaskMethod = TestServicesProvider1.class.getMethod("service1", EClassifier.class);
        Map.Entry entry = result.getMasked().entrySet().iterator().next();
        Assert.assertEquals((Object)TestMaskServicesProvider1.class.getMethod("service1", EClass.class), (Object)((JavaMethodService)entry.getKey()).getMethod());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Method actualMaskMethod = ((JavaMethodService)((List)entry.getValue()).get(0)).getMethod();
        Assert.assertEquals((Object)expectedMaskMethod, (Object)actualMaskMethod);
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        JavaMethodService service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)service.getMethod());
        Assert.assertEquals((Object)((TestServicesProvider1)((Object)service.getInstance())).service1, (Object)service);
        service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals((Object)TestMaskServicesProvider1.class.getMethod("service1", EClass.class), (Object)service.getMethod());
        Assert.assertEquals((Object)((TestMaskServicesProvider1)((Object)service.getInstance())).service1, (Object)service);
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestMaskServicesProvider1.class.getMethod("service1", EClass.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void maskedByRegistrationServiceProvider() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), TestMaskServicesProvider1.class)) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestMaskServicesProvider1.class.getMethod("service1", EClass.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
        result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)((Object)new TestServicesProvider1(provider)))) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)1L, (long)result.getIsMaskedBy().size());
        Method expectedIsMaskedByMethod = TestMaskServicesProvider1.class.getMethod("service1", EClass.class);
        Map.Entry entry = result.getIsMaskedBy().entrySet().iterator().next();
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)entry.getKey()).getMethod());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Method actualIsMaskedByMethod = ((JavaMethodService)((List)entry.getValue()).get(0)).getMethod();
        Assert.assertEquals((Object)expectedIsMaskedByMethod, (Object)actualIsMaskedByMethod);
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        JavaMethodService service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)service.getMethod());
        Assert.assertEquals((Object)((TestServicesProvider1)((Object)service.getInstance())).service1, (Object)service);
        service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals((Object)TestMaskServicesProvider1.class.getMethod("service1", EClass.class), (Object)service.getMethod());
        Assert.assertEquals((Object)((TestMaskServicesProvider1)((Object)service.getInstance())).service1, (Object)service);
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void withCrossReferencerRegistrationServiceProvider() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)((Object)new TestServicesProvider1(provider)))) {
            result.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)result.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)result.getMasked().size());
        Assert.assertEquals((long)0L, (long)result.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)engine.getRegisteredServices().size());
        Iterator iterator = engine.getRegisteredServices().iterator();
        JavaMethodService javaMethodService = (JavaMethodService)iterator.next();
        Assert.assertTrue((boolean)(javaMethodService.getInstance() instanceof TestServicesProvider1));
        TestServicesProvider1 instance = (TestServicesProvider1)((Object)javaMethodService.getInstance());
        Assert.assertEquals((Object)provider, (Object)instance.crossReferencer);
        JavaMethodService service = (JavaMethodService)engine.lookup("service1", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)service.getMethod());
        Assert.assertEquals((Object)((TestServicesProvider1)((Object)service.getInstance())).service1, (Object)service);
        Assert.assertEquals((long)1L, (long)result.getRegistered().size());
        Assert.assertEquals((Object)TestServicesProvider1.class.getMethod("service1", EClassifier.class), (Object)((JavaMethodService)result.getRegistered().get(0)).getMethod());
    }

    @Test
    public void isServiceMethodFromObject() throws NoSuchMethodException, SecurityException {
        Method method = Object.class.getMethod("equals", Object.class);
        Assert.assertNotNull((Object)method);
        Assert.assertFalse((boolean)ServiceUtils.isServiceMethod((Object)this, (Method)method));
    }

    @Test
    public void isServiceMethodNoParameter() throws NoSuchMethodException, SecurityException {
        Method method = MethodHolder.class.getMethod("testNotServiceMethodNoParameter", new Class[0]);
        Assert.assertNotNull((Object)method);
        Assert.assertFalse((boolean)ServiceUtils.isServiceMethod((Object)this, (Method)method));
    }

    @Test
    public void isServiceMethodNotStaticNoInstance() throws NoSuchMethodException, SecurityException {
        Method method = MethodHolder.class.getMethod("testServiceMethod", Object.class);
        Assert.assertNotNull((Object)method);
        Assert.assertFalse((boolean)ServiceUtils.isServiceMethod(null, (Method)method));
    }

    @Test
    public void isServiceMethodNotStaticInstance() throws NoSuchMethodException, SecurityException {
        Method method = MethodHolder.class.getMethod("testServiceMethod", Object.class);
        Assert.assertNotNull((Object)method);
        Assert.assertTrue((boolean)ServiceUtils.isServiceMethod((Object)this, (Method)method));
    }

    @Test
    public void isServiceMethodStaticNoInstance() throws NoSuchMethodException, SecurityException {
        Method method = MethodHolder.class.getMethod("testStaticServiceMethod", Object.class);
        Assert.assertNotNull((Object)method);
        Assert.assertTrue((boolean)ServiceUtils.isServiceMethod(null, (Method)method));
    }

    @Test
    public void isServiceMethodStaticInstance() throws NoSuchMethodException, SecurityException {
        Method method = MethodHolder.class.getMethod("testStaticServiceMethod", Object.class);
        Assert.assertNotNull((Object)method);
        Assert.assertTrue((boolean)ServiceUtils.isServiceMethod((Object)this, (Method)method));
    }

    @Test
    public void isRegisteredService() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), TestServices1.class);
        for (IService service : services) {
            engine.removeService(service);
        }
        for (IService service : services) {
            Assert.assertFalse((boolean)engine.isRegisteredService(service));
        }
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : services) {
            result.merge(engine.registerService(service));
        }
        for (IService service : services) {
            Assert.assertTrue((boolean)engine.isRegisteredService(service));
        }
    }

    @Test
    public void removeServiceEmpty() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServices1(provider))) {
            engine.removeService(service);
        }
        Assert.assertEquals((long)0L, (long)engine.getRegisteredServices().size());
        Assert.assertEquals((long)0L, (long)engine.getServices().size());
    }

    @Test
    public void removeService() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new ExtendedTestServices1(provider));
        for (IService service : services) {
            engine.registerService(service);
        }
        Assert.assertEquals((long)2L, (long)engine.getRegisteredServices().size());
        Assert.assertEquals((long)2L, (long)engine.getServices().size());
        for (IService service : services) {
            engine.removeService(service);
        }
        Assert.assertEquals((long)0L, (long)engine.getRegisteredServices().size());
        Assert.assertEquals((long)0L, (long)engine.getServices().size());
    }

    @Test
    public void getServicesEmpty() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        LinkedHashSet<ClassType> types = new LinkedHashSet<ClassType>();
        types.add(new ClassType(engine.getQueryEnvironment(), EClassifier.class));
        Assert.assertEquals((long)0L, (long)engine.getServices(types).size());
    }

    @Test
    public void getServices() throws NoSuchMethodException, SecurityException {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        LinkedHashSet<ClassType> types = new LinkedHashSet<ClassType>();
        types.add(new ClassType(engine.getQueryEnvironment(), EClassifier.class));
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new ExtendedTestServices1(provider))) {
            engine.registerService(service);
        }
        Set services = engine.getServices(types);
        Assert.assertEquals((long)2L, (long)services.size());
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        for (IService service : services) {
            methods.add(((JavaMethodService)service).getMethod());
        }
        Assert.assertTrue((boolean)methods.contains(ExtendedTestServices1.class.getMethod("service1", EClassifier.class)));
        Assert.assertTrue((boolean)methods.contains(ExtendedTestServices1.class.getMethod("service2", EClassifier.class)));
    }

    @Test
    public void lookupEmpty() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        Assert.assertEquals(null, (Object)engine.lookup("service", new IType[0]));
    }

    @Test
    public void lookupLowerPriorityLowerType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(0, EClass.class, 1, EClassifier.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)registrationResult.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)registrationResult.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)registrationResult.getMasked().size());
        Map.Entry entry = registrationResult.getMasked().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
    }

    @Test
    public void lookupLowerPriorityEqualType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(0, EClassifier.class, 1, EClassifier.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)registrationResult.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)registrationResult.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)registrationResult.getMasked().size());
        Map.Entry entry = registrationResult.getMasked().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
    }

    @Test
    public void lookupLowerPriorityGreaterType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(0, EClassifier.class, 1, EClass.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)registrationResult.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)registrationResult.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)registrationResult.getMasked().size());
        Map.Entry entry = registrationResult.getMasked().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service1.class, service.getClass());
    }

    @Test
    public void lookupEqualPriorityLowerType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(0, EClass.class, 0, EClassifier.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)registrationResult.getDuplicated().size());
        Assert.assertEquals((long)1L, (long)registrationResult.getIsMaskedBy().size());
        Map.Entry entry = registrationResult.getIsMaskedBy().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)0L, (long)registrationResult.getMasked().size());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service1.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
    }

    @Test
    public void lookupEqualPriorityEqualType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(0, EClassifier.class, 0, EClassifier.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)1L, (long)registrationResult.getDuplicated().size());
        Map.Entry entry = registrationResult.getDuplicated().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)0L, (long)registrationResult.getIsMaskedBy().size());
        Assert.assertEquals((long)0L, (long)registrationResult.getMasked().size());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
    }

    @Test
    public void lookupEqualPriorityGreaterType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(0, EClassifier.class, 0, EClass.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)registrationResult.getDuplicated().size());
        Assert.assertEquals((long)0L, (long)registrationResult.getIsMaskedBy().size());
        Assert.assertEquals((long)1L, (long)registrationResult.getMasked().size());
        Map.Entry entry = registrationResult.getMasked().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service1.class, service.getClass());
    }

    @Test
    public void lookupGreaterPriorityLowerType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(1, EClass.class, 0, EClassifier.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)registrationResult.getDuplicated().size());
        Assert.assertEquals((long)1L, (long)registrationResult.getIsMaskedBy().size());
        Map.Entry entry = registrationResult.getIsMaskedBy().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)0L, (long)registrationResult.getMasked().size());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service1.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service2.class, service.getClass());
    }

    @Test
    public void lookupGreaterPriorityEqualType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(1, EClassifier.class, 0, EClassifier.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)registrationResult.getDuplicated().size());
        Assert.assertEquals((long)1L, (long)registrationResult.getIsMaskedBy().size());
        Map.Entry entry = registrationResult.getIsMaskedBy().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)0L, (long)registrationResult.getMasked().size());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service1.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service1.class, service.getClass());
    }

    @Test
    public void lookupGreaterPriorityGreaterType() {
        ITestLookupEngine engine = this.instanciate(null);
        ServiceRegistrationResult registrationResult = new ServiceRegistrationResult();
        for (IService service : ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new TestServiceProvider(1, EClassifier.class, 0, EClass.class))) {
            registrationResult.merge(engine.registerService(service));
        }
        Assert.assertEquals((long)0L, (long)registrationResult.getDuplicated().size());
        Assert.assertEquals((long)1L, (long)registrationResult.getIsMaskedBy().size());
        Map.Entry entry = registrationResult.getIsMaskedBy().entrySet().iterator().next();
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)entry.getKey()).getClass());
        Assert.assertEquals((long)1L, (long)((List)entry.getValue()).size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)((List)entry.getValue()).get(0)).getClass());
        Assert.assertEquals((long)0L, (long)registrationResult.getMasked().size());
        Assert.assertEquals((long)2L, (long)registrationResult.getRegistered().size());
        Assert.assertEquals(TestServiceProvider.Service1.class, ((IService)registrationResult.getRegistered().get(0)).getClass());
        Assert.assertEquals(TestServiceProvider.Service2.class, ((IService)registrationResult.getRegistered().get(1)).getClass());
        IService service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertEquals(TestServiceProvider.Service1.class, service.getClass());
        service = engine.lookup("service", new IType[]{new ClassType(engine.getQueryEnvironment(), EClassifier.class)});
        Assert.assertEquals(TestServiceProvider.Service1.class, service.getClass());
    }

    @Test
    public void lookupPerf() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        LinkedHashMap<String, IType[]> services = new LinkedHashMap<String, IType[]>();
        this.registerServices(engine);
        for (IService service : engine.getRegisteredServices()) {
            services.put(service.getName(), service.getParameterTypes(engine.getQueryEnvironment()).toArray(new IType[service.getNumberOfParameters()]));
        }
        int i = 0;
        while (i < 10000) {
            for (Map.Entry entry : services.entrySet()) {
                Assert.assertNotNull((Object)engine.lookup((String)entry.getKey(), (IType[])entry.getValue()));
            }
            ++i;
        }
    }

    @Test
    public void lookup_492250_twoParameters() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        this.registerServices(engine);
        IService service = engine.lookup("eAllContents", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class), new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertNotNull((Object)service);
    }

    @Test
    public void lookup_492250_oneParameter() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        this.registerServices(engine);
        IService service = engine.lookup("eAllContents", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertNotNull((Object)service);
    }

    @Test
    public void lookup_492250_twoThenOneParameters() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        this.registerServices(engine);
        IService service = engine.lookup("eAllContents", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class), new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertNotNull((Object)service);
        service = engine.lookup("eAllContents", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertNotNull((Object)service);
    }

    @Test
    public void lookup_492250_oneThenTwoParameters() {
        TestCrossReferenceProvider provider = new TestCrossReferenceProvider();
        ITestLookupEngine engine = this.instanciate(provider);
        this.registerServices(engine);
        IService service = engine.lookup("eAllContents", new IType[]{new EClassifierType(engine.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEClass())});
        Assert.assertNotNull((Object)service);
        service = engine.lookup("eAllContents", new IType[]{new ClassType(engine.getQueryEnvironment(), EClass.class), new ClassType(engine.getQueryEnvironment(), EClass.class)});
        Assert.assertNotNull((Object)service);
    }

    private void registerServices(ITestLookupEngine engine) {
        LinkedHashSet services = new LinkedHashSet();
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new AnyServices(engine.getQueryEnvironment())));
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new EObjectServices(engine.getQueryEnvironment(), null, null)));
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), (Object)new XPathServices(engine.getQueryEnvironment())));
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), ComparableServices.class));
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), NumberServices.class));
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), StringServices.class));
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), BooleanServices.class));
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), CollectionServices.class));
        services.addAll(ServiceUtils.getServices((IReadOnlyQueryEnvironment)engine.getQueryEnvironment(), ResourceServices.class));
        for (IService service : services) {
            engine.registerService(service);
        }
    }

    public static class ExtendedTestServices1
    extends TestServices1 {
        public ExtendedTestServices1(CrossReferenceProvider crossReferencer) {
            super(crossReferencer);
        }

        public Boolean service2(EClassifier eObj) {
            return Boolean.FALSE;
        }
    }

    public static class ExtendedTestServicesProvider1
    extends TestServicesProvider1 {
        private IService service2;

        public ExtendedTestServicesProvider1(CrossReferenceProvider crossReferencer) {
            super(crossReferencer);
        }

        public Boolean service2(EClassifier eObj) {
            return Boolean.FALSE;
        }

        @Override
        protected IService getService(Method method) {
            IService result;
            if ("service2".equals(method.getName())) {
                this.service2 = result = new JavaMethodService(method, (Object)this);
            } else {
                result = super.getService(method);
            }
            return result;
        }
    }

    private static interface ITestLookupEngine
    extends ILookupEngine {
        public ServiceRegistrationResult registerService(IService var1);

        public IService removeService(IService var1);

        public ServiceStore getServices();

        public IReadOnlyQueryEnvironment getQueryEnvironment();
    }

    private static class TestBasicLookupEngine
    extends BasicLookupEngine
    implements ITestLookupEngine {
        public TestBasicLookupEngine(CrossReferenceProvider crossReferencer) {
            super((IReadOnlyQueryEnvironment)Query.newEnvironmentWithDefaultServices((CrossReferenceProvider)crossReferencer));
        }

        @Override
        public ServiceStore getServices() {
            return super.getServices();
        }

        @Override
        public IReadOnlyQueryEnvironment getQueryEnvironment() {
            return this.queryEnvironment;
        }
    }

    private static class TestCacheLookupEngine
    extends CacheLookupEngine
    implements ITestLookupEngine {
        public TestCacheLookupEngine(CrossReferenceProvider crossReferencer) {
            super((IReadOnlyQueryEnvironment)Query.newEnvironmentWithDefaultServices((CrossReferenceProvider)crossReferencer));
        }

        @Override
        public ServiceStore getServices() {
            return super.getServices();
        }

        @Override
        public IReadOnlyQueryEnvironment getQueryEnvironment() {
            return this.queryEnvironment;
        }
    }

    public static final class TestCrossReferenceProvider
    implements CrossReferenceProvider {
        public Collection<EStructuralFeature.Setting> getInverseReferences(EObject self) {
            return null;
        }
    }

    public static class TestDuplicateServices1 {
        public Boolean service1(EClassifier eObj) {
            return Boolean.FALSE;
        }
    }

    public static class TestDuplicateServicesProvider1
    extends AbstractServiceProvider {
        private IService service1;

        public Boolean service1(EClassifier eObj) {
            return Boolean.FALSE;
        }

        protected IService getService(Method method) {
            JavaMethodService result = new JavaMethodService(method, (Object)this);
            this.service1 = result;
            return result;
        }
    }

    public static class TestMaskServices1 {
        public Boolean service1(EClass eCls) {
            return Boolean.FALSE;
        }
    }

    public static class TestMaskServicesProvider1
    extends AbstractServiceProvider {
        private IService service1;

        public Boolean service1(EClass eCls) {
            return Boolean.FALSE;
        }

        protected IService getService(Method method) {
            JavaMethodService result = new JavaMethodService(method, (Object)this);
            this.service1 = result;
            return result;
        }
    }

    public static class TestServices1 {
        public final CrossReferenceProvider crossReferencer;

        public TestServices1(CrossReferenceProvider crossReferencer) {
            this.crossReferencer = crossReferencer;
        }

        public Boolean service1(EClassifier eObj) {
            return Boolean.FALSE;
        }

        private Boolean notAService(EClassifier eObj) {
            return Boolean.FALSE;
        }
    }

    public static class TestServicesProvider1
    extends AbstractServiceProvider {
        private IService service1;
        public final CrossReferenceProvider crossReferencer;

        public TestServicesProvider1(CrossReferenceProvider crossReferencer) {
            this.crossReferencer = crossReferencer;
        }

        public Boolean service1(EClassifier eObj) {
            return Boolean.FALSE;
        }

        private Boolean notAService(EClassifier eObj) {
            return Boolean.FALSE;
        }

        protected IService getService(Method method) {
            JavaMethodService result = new JavaMethodService(method, (Object)this);
            this.service1 = result;
            return result;
        }
    }

    public static final class TestStaticServices {
        private TestStaticServices() {
        }

        public static Boolean service1(EClassifier eObj) {
            return Boolean.FALSE;
        }

        private Boolean notAService(EClassifier eObj) {
            return Boolean.FALSE;
        }
    }
}

