/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.runtime.impl.completion;

import com.google.common.base.Strings;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.Throw;

public class StringServicesClone {
    @Documentation(value="Returns a string that is the result of a concatenation of a string \"b\" at the end of a self string \"self\".", params={@Param(name="self", value="The \"self\" string from which we concatenate the string \"b\"."), @Param(name="b", value="The string that will be concatenated to the string \"self\".")}, result="The concatenated String.")
    public String concat(String self, String b) {
        return String.valueOf(Strings.nullToEmpty((String)self)) + Strings.nullToEmpty((String)b);
    }

    @Documentation(value="Concatenates a string b at the end of a self string \"a\".")
    public String add(String a, String b) {
        return String.valueOf(Strings.nullToEmpty((String)a)) + Strings.nullToEmpty((String)b);
    }

    public String replace(String self, String subStringRegex, String replacementRegex) {
        return self.replaceFirst(subStringRegex, replacementRegex);
    }

    @Documentation(value="Returns the resulting string of a substitution of all occurrence of substring<code>subStringRegex</code> in self by substring <code>replacementRegex</code>.<code>subStringRegex</code> and <code>replacementRegex</code> are treated as regular expressions.", params={@Param(name="self", value="The \"self\" string from which we concatenate the string \"b\".")})
    public String replaceAll(String self, String subStringRegex, String replacementRegex) {
        return self.replaceAll(subStringRegex, replacementRegex);
    }

    @Documentation(value="Returns true if a \"self\" string contains the string \"b\".", result="true if the self string \"self\" contains the string \"b\". False otherwise. ThrowsNullPointerException if \"self\" or \"b\" is null.")
    public String prefix(String self, String prefix) {
        return String.valueOf(Strings.nullToEmpty((String)prefix)) + Strings.nullToEmpty((String)self);
    }

    @Documentation(value="Returns true if a \"self\" string contains the string \"b\".", exceptions={@Throw(type=NullPointerException.class, value="If one of the parameter is null."), @Throw(type=IllegalAccessException.class, value="If things go wrong.")})
    public Boolean contains(String self, String b) throws NullPointerException, IllegalAccessException {
        return self.contains(b);
    }
}

