/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.runtime.impl.completion;

import java.lang.reflect.Method;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.completion.JavaMethodServiceCompletionProposal;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.tests.runtime.impl.completion.StringServicesClone;
import org.junit.Assert;
import org.junit.Test;

public class JavaMethodServiceCompletionProposalTests {
    private static final String LS = System.getProperty("line.separator");

    private void assertJavadocEquals(Class<?> clazz, String methodName, String expectedJavadoc) {
        Method[] methods;
        Method serviceMethod = null;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                serviceMethod = method;
            }
            ++n2;
        }
        if (serviceMethod != null) {
            try {
                JavaMethodService service = new JavaMethodService(serviceMethod, clazz.newInstance());
                JavaMethodServiceCompletionProposal proposal = new JavaMethodServiceCompletionProposal(service);
                String description = proposal.getDescription();
                Assert.assertEquals((Object)expectedJavadoc, (Object)description);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Assert.fail();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Assert.fail();
            }
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testConcatJavadoc() {
        String javadoc = "concat(self: java.lang.String, b: java.lang.String) = String" + LS + LS + "Returns a string that is the result of a concatenation of a string \"b\" at the end of a self string \"self\"." + LS + LS + "  @param self" + LS + "        The \"self\" string from which we concatenate the string \"b\"." + LS + "  @param b" + LS + "        The string that will be concatenated to the string \"self\"." + LS + LS + "  @return" + LS + "        The concatenated String." + LS + LS;
        this.assertJavadocEquals(StringServicesClone.class, "concat", javadoc);
    }

    @Test
    public void testAddJavadoc() {
        String javadoc = "add(java.lang.String, java.lang.String) = String" + LS + LS + "Concatenates a string b at the end of a self string \"a\"." + LS + LS;
        this.assertJavadocEquals(StringServicesClone.class, "add", javadoc);
    }

    @Test
    public void testReplaceJavadoc() {
        String javadoc = "replace(java.lang.String, java.lang.String, java.lang.String) = String" + LS;
        this.assertJavadocEquals(StringServicesClone.class, "replace", javadoc);
    }

    @Test
    public void testReplaceAllJavadoc() {
        String javadoc = "replaceAll(self: java.lang.String, java.lang.String, java.lang.String) = String" + LS + LS + "Returns the resulting string of a substitution of all occurrence of substring" + "<code>subStringRegex</code> in self by substring <code>replacementRegex</code>." + "<code>subStringRegex</code> and <code>replacementRegex</code> are treated as regular expressions." + LS + LS + "  @param self" + LS + "        The \"self\" string from which we concatenate the string \"b\"." + LS + LS;
        this.assertJavadocEquals(StringServicesClone.class, "replaceAll", javadoc);
    }

    @Test
    public void testPrefixJavadoc() {
        String javadoc = "prefix(java.lang.String, java.lang.String) = String" + LS + LS + "Returns true if a \"self\" string contains the string \"b\"." + LS + LS + "  @return" + LS + "        true if the self string \"self\" contains the string \"b\". False otherwise. Throws" + "NullPointerException if \"self\" or \"b\" is null." + LS + LS;
        this.assertJavadocEquals(StringServicesClone.class, "prefix", javadoc);
    }

    @Test
    public void testContainsJavadoc() {
        String javadoc = "contains(java.lang.String, java.lang.String) = Boolean" + LS + LS + "Returns true if a \"self\" string contains the string \"b\"." + LS + LS + "  @throw java.lang.NullPointerException" + LS + "        If one of the parameter is null." + LS + "  @throw java.lang.IllegalAccessException" + LS + "        If things go wrong." + LS + LS;
        this.assertJavadocEquals(StringServicesClone.class, "contains", javadoc);
    }

    @Test
    public void getCursorOffsetOneParameter() throws NoSuchMethodException, SecurityException {
        Method serviceMethod = AnyServices.class.getMethod("toString", Object.class);
        JavaMethodService service = new JavaMethodService(serviceMethod, (Object)new AnyServices(null));
        JavaMethodServiceCompletionProposal proposal = new JavaMethodServiceCompletionProposal(service);
        Assert.assertEquals((long)10L, (long)proposal.getCursorOffset());
    }

    @Test
    public void getCursorOffsetMoreThanOneParameter() throws NoSuchMethodException, SecurityException {
        Method serviceMethod = AnyServices.class.getMethod("equals", Object.class, Object.class);
        JavaMethodService service = new JavaMethodService(serviceMethod, (Object)new AnyServices(null));
        JavaMethodServiceCompletionProposal proposal = new JavaMethodServiceCompletionProposal(service);
        Assert.assertEquals((long)7L, (long)proposal.getCursorOffset());
    }

    @Test
    public void testToString() throws NoSuchMethodException, SecurityException {
        Method serviceMethod = AnyServices.class.getMethod("equals", Object.class, Object.class);
        JavaMethodService service = new JavaMethodService(serviceMethod, (Object)new AnyServices(null));
        JavaMethodServiceCompletionProposal proposal = new JavaMethodServiceCompletionProposal(service);
        Assert.assertEquals((Object)"equals()", (Object)proposal.toString());
    }
}

