/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.runtime.impl;

import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEnvironmentListener;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.QueryEnvironment;
import org.eclipse.acceleo.query.tests.runtime.lookup.basic.MethodHolder;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryEnvironmentTests {
    private TestQueryEnvironment queryEnvironment;
    private TestQueryEnvironmentListener listener;

    @Before
    public void before() {
        this.queryEnvironment = new TestQueryEnvironment();
        this.listener = new TestQueryEnvironmentListener();
        this.queryEnvironment.addQueryEnvironmentListener(this.listener);
    }

    @Test
    public void isRegisteredServiceNull() {
        Assert.assertFalse((boolean)this.queryEnvironment.isRegisteredService(null));
    }

    @Test
    public void isRegisteredService() {
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, MethodHolder.class);
        for (IService service : services) {
            Assert.assertFalse((boolean)this.queryEnvironment.isRegisteredService(service));
        }
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        for (IService service : services) {
            Assert.assertTrue((boolean)this.queryEnvironment.isRegisteredService(service));
        }
        QueryEnvironmentTests.assertListener(this.listener, 2, 0, 0, 0, 0);
    }

    @Test(expected=NullPointerException.class)
    public void registerServiceNull() {
        this.queryEnvironment.registerService(null);
    }

    @Test
    public void registerServiceNotRegistered() {
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, MethodHolder.class);
        ServiceRegistrationResult result = ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        for (IService service : services) {
            Assert.assertTrue((boolean)this.queryEnvironment.getLookupEngine().isRegisteredService(service));
        }
        Assert.assertFalse((boolean)result.getRegistered().isEmpty());
        QueryEnvironmentTests.assertListener(this.listener, 2, 0, 0, 0, 0);
    }

    @Test
    public void registerServiceRegistered() {
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, MethodHolder.class);
        ServiceRegistrationResult result = ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        Assert.assertFalse((boolean)result.getRegistered().isEmpty());
        result = ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        for (IService service : services) {
            Assert.assertTrue((boolean)this.queryEnvironment.getLookupEngine().isRegisteredService(service));
        }
        Assert.assertTrue((boolean)result.getRegistered().isEmpty());
        QueryEnvironmentTests.assertListener(this.listener, 2, 0, 0, 0, 0);
    }

    @Test
    public void removeServiceNull() {
        this.queryEnvironment.removeService(null);
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 0, 0, 0);
    }

    @Test
    public void removeServiceNotRegistered() {
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, MethodHolder.class);
        for (IService service : services) {
            Assert.assertFalse((boolean)this.queryEnvironment.getLookupEngine().isRegisteredService(service));
        }
        for (IService service : services) {
            this.queryEnvironment.getLookupEngine().removeService(service);
        }
        for (IService service : services) {
            Assert.assertFalse((boolean)this.queryEnvironment.getLookupEngine().isRegisteredService(service));
        }
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 0, 0, 0);
    }

    @Test
    public void removeServiceRegistered() {
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, MethodHolder.class);
        for (IService service : services) {
            Assert.assertFalse((boolean)this.queryEnvironment.getLookupEngine().isRegisteredService(service));
        }
        ServiceRegistrationResult result = ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        Assert.assertEquals((long)2L, (long)result.getRegistered().size());
        for (IService service : services) {
            Assert.assertTrue((boolean)this.queryEnvironment.isRegisteredService(service));
        }
        QueryEnvironmentTests.assertListener(this.listener, 2, 0, 0, 0, 0);
        ServiceUtils.removeServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        for (IService service : services) {
            Assert.assertFalse((boolean)this.queryEnvironment.isRegisteredService(service));
        }
        QueryEnvironmentTests.assertListener(this.listener, 2, 2, 0, 0, 0);
    }

    @Test(expected=NullPointerException.class)
    public void registerEPackageNull() {
        this.queryEnvironment.registerEPackage(null);
    }

    @Test
    public void registerEPackageNotRegistered() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("test");
        ePkg.setNsURI("test");
        ePkg.setNsPrefix("test");
        this.queryEnvironment.registerEPackage(ePkg);
        Assert.assertTrue((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 1, 0, 0);
    }

    @Test
    public void registerEPackageRegistered() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("test");
        ePkg.setNsURI("test");
        ePkg.setNsPrefix("test");
        this.queryEnvironment.registerEPackage(ePkg);
        Assert.assertTrue((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 1, 0, 0);
        this.queryEnvironment.registerEPackage(ePkg);
        Assert.assertTrue((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 1, 0, 0);
    }

    @Test(expected=NullPointerException.class)
    public void removeEPackageNull() {
        this.queryEnvironment.removeEPackage(null);
    }

    @Test
    public void removeEPackageNullName() {
        this.queryEnvironment.removeEPackage(null);
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 0, 0, 0);
    }

    @Test
    public void removeEPackageNotRegistered() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("test");
        ePkg.setNsURI("test");
        ePkg.setNsPrefix("test");
        this.queryEnvironment.removeEPackage(ePkg);
        Assert.assertFalse((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 0, 0, 0);
    }

    @Test
    public void removeEPackageNotRegisteredName() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("test");
        ePkg.setNsURI("test");
        ePkg.setNsPrefix("test");
        this.queryEnvironment.removeEPackage(ePkg.getName());
        Assert.assertFalse((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 0, 0, 0);
    }

    @Test
    public void removeEPackageRegistered() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("test");
        ePkg.setNsURI("test");
        ePkg.setNsPrefix("test");
        this.queryEnvironment.registerEPackage(ePkg);
        Assert.assertTrue((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 1, 0, 0);
        this.queryEnvironment.removeEPackage(ePkg);
        Assert.assertFalse((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 1, 1, 0);
    }

    @Test
    public void removeEPackageRegisteredName() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("test");
        ePkg.setNsURI("test");
        ePkg.setNsPrefix("test");
        this.queryEnvironment.registerEPackage(ePkg);
        Assert.assertTrue((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 1, 0, 0);
        this.queryEnvironment.removeEPackage(ePkg.getName());
        Assert.assertFalse((boolean)this.queryEnvironment.getEPackageProvider().getRegisteredEPackages().contains(ePkg));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 1, 1, 0);
    }

    @Test
    public void registerCustomClassMapping() {
        this.queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEAttribute(), this.getClass());
        Assert.assertEquals(this.getClass(), (Object)this.queryEnvironment.getEPackageProvider().getClass((EClassifier)EcorePackage.eINSTANCE.getEAttribute()));
        QueryEnvironmentTests.assertListener(this.listener, 0, 0, 0, 0, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void addQueryEnvironmentListenerNull() {
        this.queryEnvironment.addQueryEnvironmentListener(null);
    }

    @Test
    public void addQueryEnvironmentListener() {
        TestQueryEnvironmentListener listener = new TestQueryEnvironmentListener();
        this.queryEnvironment.addQueryEnvironmentListener(listener);
        Assert.assertEquals((long)2L, (long)this.queryEnvironment.getListeners().size());
        Assert.assertEquals((Object)listener, (Object)this.queryEnvironment.getListeners().get(1));
    }

    @Test
    public void removeQueryEnvironmentListenerNull() {
        this.queryEnvironment.removeQueryEnvironmentListener(null);
        Assert.assertFalse((boolean)this.queryEnvironment.getListeners().contains(null));
        Assert.assertEquals((long)1L, (long)this.queryEnvironment.getListeners().size());
    }

    @Test
    public void removeQueryEnvironmentListenerNotAdded() {
        TestQueryEnvironmentListener listener = new TestQueryEnvironmentListener();
        this.queryEnvironment.removeQueryEnvironmentListener(listener);
        Assert.assertEquals((long)1L, (long)this.queryEnvironment.getListeners().size());
    }

    @Test
    public void removeQueryEnvironmentListenerAdded() {
        TestQueryEnvironmentListener listener = new TestQueryEnvironmentListener();
        this.queryEnvironment.addQueryEnvironmentListener(listener);
        Assert.assertEquals((long)2L, (long)this.queryEnvironment.getListeners().size());
        Assert.assertEquals((Object)listener, (Object)this.queryEnvironment.getListeners().get(1));
        this.queryEnvironment.removeQueryEnvironmentListener(listener);
        Assert.assertEquals((long)1L, (long)this.queryEnvironment.getListeners().size());
    }

    public static void assertListener(TestQueryEnvironmentListener listener, int servicePackageRegistered, int servicePackageRemoved, int ePackageRegistered, int ePackageRemoved, int customClassMappingRegistered) {
        Assert.assertEquals((long)servicePackageRegistered, (long)listener.servicePackageRegistered);
        Assert.assertEquals((long)servicePackageRemoved, (long)listener.servicePackageRemoved);
        Assert.assertEquals((long)ePackageRegistered, (long)listener.ePackageRegistered);
        Assert.assertEquals((long)ePackageRemoved, (long)listener.ePackageRemoved);
        Assert.assertEquals((long)customClassMappingRegistered, (long)listener.customClassMappingRegistered);
    }

    public static class TestQueryEnvironment
    extends QueryEnvironment {
        public List<IQueryEnvironmentListener> getListeners() {
            return super.getListeners();
        }
    }

    public static class TestQueryEnvironmentListener
    implements IQueryEnvironmentListener {
        public int servicePackageRegistered;
        public int servicePackageRemoved;
        public int ePackageRegistered;
        public int ePackageRemoved;
        public int customClassMappingRegistered;

        public void serviceRegistered(ServiceRegistrationResult result, IService service) {
            ++this.servicePackageRegistered;
        }

        public void serviceRemoved(IService services) {
            ++this.servicePackageRemoved;
        }

        public void ePackageRegistered(EPackage ePackage) {
            ++this.ePackageRegistered;
        }

        public void ePackageRemoved(EPackage ePackage) {
            ++this.ePackageRemoved;
        }

        public void customClassMappingRegistered(EClassifier eClassifier, Class<?> cls) {
            ++this.customClassMappingRegistered;
        }
    }
}

