/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests.runtime.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IEPackageProvider;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EPackageProviderTests {
    private final Class<ITestEPackageProvider> cls;
    private ITestEPackageProvider provider;

    public EPackageProviderTests(Class<ITestEPackageProvider> cls) {
        this.cls = cls;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> classes() {
        return Arrays.asList(new Object[][]{{TestEPackageProvider.class}});
    }

    @Before
    public void before() throws InstantiationException, IllegalAccessException {
        this.provider = this.cls.newInstance();
    }

    @Test
    public void getEPackageNull() {
        Assert.assertEquals((long)0L, (long)this.provider.getEPackage(null).size());
    }

    @Test
    public void getEPackageNotRegistered() {
        Assert.assertEquals((long)0L, (long)this.provider.getEPackage("ecore").size());
    }

    @Test
    public void getEPackageRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        EPackage ePkg = (EPackage)this.provider.getEPackage("ecore").iterator().next();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, (Object)ePkg);
    }

    @Test
    public void getTypeNull() {
        Collection eClassifier = this.provider.getTypes(null, null);
        Assert.assertEquals((long)0L, (long)eClassifier.size());
    }

    @Test
    public void getTypeNotRegistered() {
        Assert.assertEquals((long)0L, (long)this.provider.getTypes("ecore", "EOperation").size());
    }

    @Test
    public void getTypeRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        EClassifier eClassifier = (EClassifier)this.provider.getTypes("ecore", "EOperation").iterator().next();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), (Object)eClassifier);
    }

    @Test
    public void getEnumLiteralNull() {
        Assert.assertEquals((long)0L, (long)this.provider.getEnumLiterals(null, null, null).size());
    }

    @Test
    public void getEnumLiteralNotRegistered() {
        Assert.assertEquals((long)0L, (long)this.provider.getEnumLiterals("anydsl", "Color", "red").size());
    }

    @Test
    public void getEnumLiteralRegistered() {
        this.provider.registerPackage((EPackage)AnydslPackage.eINSTANCE);
        EEnumLiteral eNum = (EEnumLiteral)this.provider.getEnumLiterals("anydsl", "Color", "red").iterator().next();
        Assert.assertEquals((Object)AnydslPackage.eINSTANCE.getColor().getEEnumLiteral("red"), (Object)eNum);
    }

    @Test
    public void getEClassNull() {
        Set eClasses = this.provider.getEClassifiers(null);
        Assert.assertEquals(null, (Object)eClasses);
    }

    @Test
    public void getEClassNotRegistered() {
        Set eClasses = this.provider.getEClassifiers(EObject.class);
        Assert.assertEquals(null, (Object)eClasses);
    }

    @Test
    public void getEClassRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getEClassifiers(EObject.class);
        Assert.assertEquals((long)1L, (long)eClasses.size());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), eClasses.iterator().next());
    }

    @Test
    public void getClassNull() {
        Class cls = this.provider.getClass(null);
        Assert.assertEquals(null, (Object)cls);
    }

    @Test
    public void getClassNotRegistered() {
        Class cls = this.provider.getClass((EClassifier)EcorePackage.eINSTANCE.getEClass());
        Assert.assertEquals(null, (Object)cls);
    }

    @Test
    public void getClassRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Class cls = this.provider.getClass((EClassifier)EcorePackage.eINSTANCE.getEClass());
        Assert.assertEquals(EClass.class, (Object)cls);
    }

    @Test
    public void isRegisteredNull() {
        Assert.assertFalse((boolean)this.provider.isRegistered(null));
    }

    @Test
    public void isRegisteredNotRegistered() {
        Assert.assertFalse((boolean)this.provider.isRegistered((EClassifier)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void isRegisteredRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Assert.assertTrue((boolean)this.provider.isRegistered((EClassifier)EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void getRegisteredEPackagesNothingRegistered() {
        Set ePkgs = this.provider.getRegisteredEPackages();
        Assert.assertEquals((long)0L, (long)ePkgs.size());
    }

    @Test
    public void getRegisteredEPackages() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set ePkgs = this.provider.getRegisteredEPackages();
        Assert.assertEquals((long)1L, (long)ePkgs.size());
        Iterator it = ePkgs.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, it.next());
    }

    @Test(expected=NullPointerException.class)
    public void getEStructuralFeaturesNull() {
        this.provider.getEStructuralFeatures(null);
    }

    @Test
    public void getEStructuralFeaturesNotRegistered() {
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        eClasses.add(EcorePackage.eINSTANCE.getEClass());
        Set features = this.provider.getEStructuralFeatures(eClasses);
        Assert.assertEquals((long)0L, (long)features.size());
    }

    @Test
    public void getEStructuralFeaturesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        eClasses.add(EcorePackage.eINSTANCE.getEClass());
        Set features = this.provider.getEStructuralFeatures(eClasses);
        Assert.assertEquals((long)24L, (long)features.size());
    }

    @Test
    public void getEClassifiersNothingRegistered() {
        Set eClassifiers = this.provider.getEClassifiers();
        Assert.assertEquals((long)0L, (long)eClassifiers.size());
    }

    @Test
    public void getEClassifiers() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClassifiers = this.provider.getEClassifiers();
        Assert.assertEquals((long)53L, (long)eClassifiers.size());
    }

    @Test
    public void getEEnumLiteralsNothingRegistered() {
        Set eEnumLiterals = this.provider.getEEnumLiterals();
        Assert.assertEquals((long)0L, (long)eEnumLiterals.size());
    }

    @Test
    public void getEEnumLiterals() {
        this.provider.registerPackage((EPackage)AnydslPackage.eINSTANCE);
        Set eEnumLiterals = this.provider.getEEnumLiterals();
        Assert.assertEquals((long)42L, (long)eEnumLiterals.size());
    }

    @Test(expected=NullPointerException.class)
    public void getAllContainingEClassesNull() {
        this.provider.getAllContainingEClasses(null);
    }

    @Test
    public void getAllContainingEClassesNotRegistered() {
        Set eClasses = this.provider.getAllContainingEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getAllContainingEClassesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getAllContainingEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)7L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEModelElement(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnum(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), it.next());
    }

    @Test
    public void getAllSubTypesNull() {
        Set eClasses = this.provider.getAllSubTypes(null);
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getAllSubTypesNotRegistered() {
        Set eClasses = this.provider.getAllSubTypes(EcorePackage.eINSTANCE.getEClassifier());
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getAllSubTypesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getAllSubTypes(EcorePackage.eINSTANCE.getEClassifier());
        Assert.assertEquals((long)3L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEDataType(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnum(), it.next());
    }

    @Test
    public void getContainedEClassesNull() {
        Set eClasses = this.provider.getContainedEClasses(null);
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getContainedEClassesNotRegistered() {
        Set eClasses = this.provider.getContainedEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getContainedEClassesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getContainedEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)3L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
    }

    @Test
    public void getAllContainedEClassesNull() {
        Set eClasses = this.provider.getAllContainedEClasses(null);
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getAllContainedEClassesNotRegistered() {
        Set eClasses = this.provider.getAllContainedEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getAllContainedEClassesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getAllContainedEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)11L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypeParameter(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnumLiteral(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEParameter(), it.next());
    }

    @Test(expected=NullPointerException.class)
    public void getInverseEClassesNull() {
        this.provider.getInverseEClasses(null);
    }

    @Test
    public void getInverseEClassesNotRegistered() {
        Set eClasses = this.provider.getInverseEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getInverseEClassesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getInverseEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)4L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEFactory(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), it.next());
    }

    @Test
    public void getInverseEClassesRegisteredWithSubClasses() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getInverseEClasses(EcorePackage.eINSTANCE.getEClassifier());
        Assert.assertEquals((long)10L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypedElement(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnumLiteral(), it.next());
    }

    @Test(expected=NullPointerException.class)
    public void getFollowingSiblingsEClassesNull() {
        this.provider.getFollowingSiblingsEClasses(null);
    }

    @Test
    public void getFollowingSiblingsEClassesNotRegistered() {
        Set eClasses = this.provider.getFollowingSiblingsEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getFollowingSiblingsEClassesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getFollowingSiblingsEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)2L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), it.next());
    }

    @Test
    public void getFollowingSiblingsEClassesRegisteredWithSubClasses() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getFollowingSiblingsEClasses(EcorePackage.eINSTANCE.getENamedElement());
        Assert.assertEquals((long)9L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnumLiteral(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEParameter(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypeParameter(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), it.next());
    }

    @Test(expected=NullPointerException.class)
    public void getPrecedingSiblingsEClassesNull() {
        this.provider.getPrecedingSiblingsEClasses(null);
    }

    @Test
    public void getPrecedingSiblingsEClassesNotRegistered() {
        Set eClasses = this.provider.getPrecedingSiblingsEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getPrecedingSiblingsEClassesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getPrecedingSiblingsEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)5L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), it.next());
    }

    @Test(expected=NullPointerException.class)
    public void getSiblingsEClassesNull() {
        this.provider.getSiblingsEClasses(null);
    }

    @Test
    public void getSiblingsEClassesNotRegistered() {
        Set eClasses = this.provider.getSiblingsEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)eClasses.size());
    }

    @Test
    public void getSiblingsEClassesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set eClasses = this.provider.getSiblingsEClasses(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)5L, (long)eClasses.size());
        Iterator it = eClasses.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), it.next());
    }

    @Test(expected=NullPointerException.class)
    public void getContainingEStructuralFeaturesNull() {
        this.provider.getContainingEStructuralFeatures(null);
    }

    @Test
    public void getContainingEStructuralFeaturesNotRegistered() {
        Set features = this.provider.getContainingEStructuralFeatures(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)features.size());
    }

    @Test
    public void getContainingEStructuralFeaturesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set features = this.provider.getContainingEStructuralFeatures(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)2L, (long)features.size());
        Iterator it = features.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage_ESubpackages(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation_Contents(), it.next());
    }

    @Test(expected=NullPointerException.class)
    public void getAllContainingEStructuralFeaturesNull() {
        this.provider.getAllContainingEStructuralFeatures(null);
    }

    @Test
    public void getAllContainingEStructuralFeaturesNotRegistered() {
        Set features = this.provider.getAllContainingEStructuralFeatures(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)0L, (long)features.size());
    }

    @Test
    public void getAllContainingEStructuralFeaturesRegistered() {
        this.provider.registerPackage((EPackage)EcorePackage.eINSTANCE);
        Set features = this.provider.getAllContainingEStructuralFeatures(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)10L, (long)features.size());
        Iterator it = features.iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage_ESubpackages(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation_Contents(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEModelElement_EAnnotations(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnum_ELiterals(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass_EOperations(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation_EParameters(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass_EStructuralFeatures(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier_ETypeParameters(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation_ETypeParameters(), it.next());
    }

    public static interface ITestEPackageProvider
    extends IEPackageProvider {
        public void registerCustomClassMapping(EClassifier var1, Class<?> var2);

        public EPackage registerPackage(EPackage var1);

        public Collection<EPackage> removePackage(String var1);
    }

    public static class TestEPackageProvider
    extends EPackageProvider
    implements ITestEPackageProvider {
    }
}

