/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.acceleo.query.tests.AcceleoQueryInterpreter;
import org.eclipse.acceleo.query.tests.InterpreterUnderTest;
import org.eclipse.acceleo.query.tests.QueryResultAssert;
import org.eclipse.acceleo.query.tests.qmodel.Query;
import org.eclipse.acceleo.query.tests.qmodel.QueryValidationResult;
import org.eclipse.acceleo.query.tests.qmodel.QueryValidationResultExpectation;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestValidationQModel {
    private QueryValidationResultExpectation expectation;
    protected InterpreterUnderTest underTest;

    public TestValidationQModel(QueryValidationResultExpectation expect, String name) {
        this.expectation = expect;
    }

    @Test
    public void test() {
        if (this.expectation instanceof QueryValidationResultExpectation) {
            QueryValidationResultExpectation qExpect = this.expectation;
            Query q = (Query)qExpect.eContainer();
            this.underTest = new AcceleoQueryInterpreter(q);
            this.underTest.compileQuery(q);
            QueryValidationResult actualResult = this.underTest.validateQuery(q);
            QueryResultAssert.assertEquivalentValidation(qExpect.getExpectedResult(), actualResult);
        }
    }

    protected static Collection<Object[]> expectationsFrom(Resource reverse) throws URISyntaxException, IOException {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        UnmodifiableIterator it = Iterators.filter((Iterator)reverse.getAllContents(), QueryValidationResultExpectation.class);
        int i = 0;
        while (it.hasNext()) {
            QueryValidationResultExpectation cur = (QueryValidationResultExpectation)it.next();
            if (cur.getExpectedResult() == null) continue;
            parameters.add(new Object[]{cur, String.valueOf(++i) + " " + ((Query)cur.eContainer()).getExpression()});
        }
        return parameters;
    }
}

