/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.acceleo.query.tests.InterpreterUnderTest;
import org.eclipse.acceleo.query.tests.QueryResultAssert;
import org.eclipse.acceleo.query.tests.qmodel.Query;
import org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResult;
import org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResultExpectation;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestEvaluationPerfQModel {
    private static final int LOOP = 10000;
    private QueryEvaluationResultExpectation expectation;
    protected InterpreterUnderTest underTest;
    private static OutputStreamWriter out;

    public TestEvaluationPerfQModel(QueryEvaluationResultExpectation expect, String name) {
        this.expectation = expect;
    }

    @BeforeClass
    public static void beforeClass() {
        try {
            File tmpLogFile = File.createTempFile("log.txt", "");
            out = new OutputStreamWriter(new FileOutputStream(tmpLogFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void afterClass() {
        try {
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void test() {
        if (this.expectation instanceof QueryEvaluationResultExpectation) {
            QueryEvaluationResultExpectation qExpect = this.expectation;
            Query q = (Query)qExpect.eContainer();
            this.underTest = this.getInterpreter(q);
            QueryEvaluationResult actualResult = null;
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < 10000) {
                this.underTest.compileQuery(q);
                ++i;
            }
            try {
                out.write(String.valueOf(q.getExpression()) + " " + (System.currentTimeMillis() - start) + "]");
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            start = System.currentTimeMillis();
            i = 0;
            while (i < 10000) {
                actualResult = this.underTest.computeQuery(q);
                ++i;
            }
            try {
                out.write(String.valueOf(System.currentTimeMillis() - start) + "\n");
                out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            QueryResultAssert.assertEquivalentEvaluation(qExpect.getExpectedResult(), actualResult);
        }
    }

    protected abstract InterpreterUnderTest getInterpreter(Query var1);

    protected static Collection<Object[]> expectationsFrom(Resource reverse) throws URISyntaxException, IOException {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        UnmodifiableIterator it = Iterators.filter((Iterator)reverse.getAllContents(), QueryEvaluationResultExpectation.class);
        int i = 0;
        while (it.hasNext()) {
            QueryEvaluationResultExpectation cur = (QueryEvaluationResultExpectation)it.next();
            if (cur.getExpectedResult() == null) continue;
            parameters.add(new Object[]{cur, String.valueOf(++i) + " " + ((Query)cur.eContainer()).getExpression()});
        }
        return parameters;
    }
}

