/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.acceleo.query.tests.qmodel.BooleanResult;
import org.eclipse.acceleo.query.tests.qmodel.EObjectResult;
import org.eclipse.acceleo.query.tests.qmodel.EObjectVariable;
import org.eclipse.acceleo.query.tests.qmodel.EmptyResult;
import org.eclipse.acceleo.query.tests.qmodel.EnumeratorResult;
import org.eclipse.acceleo.query.tests.qmodel.ErrorResult;
import org.eclipse.acceleo.query.tests.qmodel.IntegerResult;
import org.eclipse.acceleo.query.tests.qmodel.InvalidResult;
import org.eclipse.acceleo.query.tests.qmodel.ListResult;
import org.eclipse.acceleo.query.tests.qmodel.Query;
import org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResult;
import org.eclipse.acceleo.query.tests.qmodel.QueryValidationResult;
import org.eclipse.acceleo.query.tests.qmodel.SerializableResult;
import org.eclipse.acceleo.query.tests.qmodel.SetResult;
import org.eclipse.acceleo.query.tests.qmodel.StringResult;
import org.eclipse.acceleo.query.tests.qmodel.ValidationMessage;
import org.eclipse.acceleo.query.tests.qmodel.Variable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;

public class QueryResultAssert {
    public static void assertEquivalentEvaluation(QueryEvaluationResult expectedResult, QueryEvaluationResult actualResult) {
        junit.framework.Assert.assertSame((Object)expectedResult.eClass().getName(), (Object)actualResult.eClass().getName());
        if (expectedResult instanceof ListResult) {
            junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof ListResult));
            junit.framework.Assert.assertEquals((int)((ListResult)expectedResult).getValues().size(), (int)((ListResult)actualResult).getValues().size());
            Iterator expectedIt = ((ListResult)expectedResult).getValues().iterator();
            Iterator actualIt = ((ListResult)actualResult).getValues().iterator();
            while (expectedIt.hasNext()) {
                QueryResultAssert.assertEquivalentEvaluation((QueryEvaluationResult)expectedIt.next(), (QueryEvaluationResult)actualIt.next());
            }
        } else if (expectedResult instanceof SetResult) {
            junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof SetResult));
            junit.framework.Assert.assertEquals((int)((SetResult)expectedResult).getValues().size(), (int)((SetResult)actualResult).getValues().size());
            Iterator expectedIt = ((SetResult)expectedResult).getValues().iterator();
            Iterator actualIt = ((SetResult)actualResult).getValues().iterator();
            while (expectedIt.hasNext()) {
                QueryResultAssert.assertEquivalentEvaluation((QueryEvaluationResult)expectedIt.next(), (QueryEvaluationResult)actualIt.next());
            }
        } else if (expectedResult instanceof EObjectResult) {
            junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof EObjectResult));
            EObject expectedValue = ((EObjectResult)expectedResult).getValue();
            EObject actualValue = ((EObjectResult)actualResult).getValue();
            junit.framework.Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (expectedResult instanceof StringResult) {
            junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof StringResult));
            String expectedValue = ((StringResult)expectedResult).getValue();
            String actualValue = ((StringResult)actualResult).getValue();
            junit.framework.Assert.assertEquals((String)expectedValue, (String)actualValue);
        } else if (expectedResult instanceof BooleanResult) {
            junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof BooleanResult));
            Boolean expectedValue = ((BooleanResult)expectedResult).isValue();
            Boolean actualValue = ((BooleanResult)actualResult).isValue();
            junit.framework.Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        } else if (expectedResult instanceof InvalidResult) {
            junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof InvalidResult));
        } else if (!(expectedResult instanceof ErrorResult)) {
            if (expectedResult instanceof EmptyResult) {
                junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof EmptyResult));
            } else if (expectedResult instanceof EnumeratorResult) {
                junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof EnumeratorResult));
                String expectedValue = ((EnumeratorResult)expectedResult).getValue();
                String actualValue = ((EnumeratorResult)actualResult).getValue();
                junit.framework.Assert.assertEquals((String)expectedValue, (String)actualValue);
            } else if (expectedResult instanceof SerializableResult) {
                junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof SerializableResult));
                Serializable expectedValue = ((SerializableResult)expectedResult).getValue();
                Serializable actualValue = ((SerializableResult)actualResult).getValue();
                junit.framework.Assert.assertEquals((Object)expectedValue, (Object)actualValue);
            } else if (expectedResult instanceof IntegerResult) {
                junit.framework.Assert.assertEquals((boolean)true, (boolean)(actualResult instanceof IntegerResult));
                Integer expectedValue = ((IntegerResult)expectedResult).getValue();
                Integer actualValue = ((IntegerResult)actualResult).getValue();
                junit.framework.Assert.assertEquals((Object)expectedValue, (Object)actualValue);
            } else {
                Assert.fail((String)("not supported yet in the test framework:" + expectedResult.eClass().getName()));
            }
        }
    }

    private static Collection<URI> toURIs(Collection<EObject> expectedValues) {
        ArrayList<URI> uris = new ArrayList<URI>(expectedValues.size());
        for (EObject val : expectedValues) {
            uris.add(EcoreUtil.getURI((EObject)val));
        }
        return uris;
    }

    public static void assertEquivalentValidation(QueryValidationResult expectedResult, QueryValidationResult actualResult) {
        junit.framework.Assert.assertEquals((Object)expectedResult.getPossibleTypes(), (Object)actualResult.getPossibleTypes());
        junit.framework.Assert.assertEquals((int)expectedResult.getValidationMessages().size(), (int)actualResult.getValidationMessages().size());
        int i = 0;
        while (i < expectedResult.getValidationMessages().size()) {
            ValidationMessage expectedMessage = (ValidationMessage)expectedResult.getValidationMessages().get(i);
            ValidationMessage actualMessage = (ValidationMessage)actualResult.getValidationMessages().get(i);
            junit.framework.Assert.assertEquals((Object)expectedMessage.getSeverity(), (Object)actualMessage.getSeverity());
            junit.framework.Assert.assertEquals((int)expectedMessage.getStartPosition(), (int)actualMessage.getStartPosition());
            junit.framework.Assert.assertEquals((int)expectedMessage.getEndPosition(), (int)actualMessage.getEndPosition());
            junit.framework.Assert.assertEquals((String)expectedMessage.getMessage(), (String)actualMessage.getMessage());
            ++i;
        }
    }

    public static void printValidation(Query query, QueryValidationResult result) {
        System.out.println("Interpreter: " + result.getInterpreter());
        QueryResultAssert.printQuery(query);
        System.out.println("Possible types:");
        for (String possibleType : result.getPossibleTypes()) {
            System.out.println("\t" + possibleType);
        }
        System.out.println("Validation messages:");
        for (ValidationMessage message : result.getValidationMessages()) {
            System.out.println("\t" + message.getSeverity() + " " + message.getMessage());
        }
        System.out.flush();
    }

    private static void printQuery(Query query) {
        System.out.println("Expression: " + query.getExpression());
        System.out.println("Self: " + query.getStartingPoint().getName() + " - " + query.getStartingPoint().getTarget());
        for (Variable variable : query.getVariables()) {
            if (!(variable instanceof EObjectVariable)) continue;
            System.out.println(String.valueOf(variable.getName()) + ": " + ((EObjectVariable)variable).getValue().getTarget());
        }
    }
}

