/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesTest;
import org.junit.Assert;
import org.junit.Test;

public class StringServicesTest
extends AbstractServicesTest {
    private StringServices stringServices;

    @Override
    public void before() throws Exception {
        super.before();
        this.stringServices = new StringServices();
    }

    @Test
    public void addNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.add(null, null));
    }

    @Test
    public void addNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.add(null, ""));
    }

    @Test
    public void addEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.add("", null));
    }

    @Test
    public void addEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.add("", ""));
    }

    @Test
    public void addEmptyString() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.add("", "string"));
    }

    @Test
    public void addStringEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.add("string", ""));
    }

    @Test
    public void addNullString() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.add(null, "string"));
    }

    @Test
    public void addStringNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.add("string", null));
    }

    @Test
    public void addStringString() {
        Assert.assertEquals((Object)"stringstring", (Object)this.stringServices.add("string", "string"));
    }

    @Test
    public void concatNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.concat(null, null));
    }

    @Test
    public void concatNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.concat(null, ""));
    }

    @Test
    public void concatEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.concat("", null));
    }

    @Test
    public void concatEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.concat("", ""));
    }

    @Test
    public void concatEmptyString() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.concat("", "string"));
    }

    @Test
    public void concatStringEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.concat("string", ""));
    }

    @Test
    public void concatNullString() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.concat(null, "string"));
    }

    @Test
    public void concatStringNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.concat("string", null));
    }

    @Test
    public void concatStringString() {
        Assert.assertEquals((Object)"stringstring", (Object)this.stringServices.concat("string", "string"));
    }

    @Test
    public void containsNullNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.contains(null, null));
    }

    @Test
    public void containsNullEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.contains(null, ""));
    }

    @Test
    public void containsEmptyNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.contains("", null));
    }

    @Test
    public void containsEmptyEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.contains("", ""));
    }

    @Test
    public void containsEmptyString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.contains("", "string"));
    }

    @Test
    public void containsStringEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.contains("string", ""));
    }

    @Test
    public void containsNullString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.contains(null, "string"));
    }

    @Test
    public void containsStringNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.contains("string", null));
    }

    @Test
    public void containsAllString() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.contains("string", "string"));
    }

    @Test
    public void containsSubString() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.contains("string", "in"));
    }

    @Test
    public void containsFlase() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.contains("string", "fr"));
    }

    @Test
    public void endsWithNullNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.endsWith(null, null));
    }

    @Test
    public void endsWithNullEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.endsWith(null, ""));
    }

    @Test
    public void endsWithEmptyNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.endsWith("", null));
    }

    @Test
    public void endsWithEmptyEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.endsWith("", ""));
    }

    @Test
    public void endsWithEmptyString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.endsWith("", "string"));
    }

    @Test
    public void endsWithStringEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.endsWith("string", ""));
    }

    @Test
    public void endsWithNullString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.endsWith(null, "string"));
    }

    @Test
    public void endsWithStringNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.endsWith("string", null));
    }

    @Test
    public void endsWithStringString() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.endsWith("string", "string"));
    }

    @Test
    public void endsWithFalse() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.endsWith("stringa", "string"));
    }

    @Test
    public void equalsIgnoreCaseNullNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.equalsIgnoreCase(null, null));
    }

    @Test
    public void equalsIgnoreCaseNullEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.equalsIgnoreCase(null, ""));
    }

    @Test
    public void equalsIgnoreCaseEmptyNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.equalsIgnoreCase("", null));
    }

    @Test
    public void equalsIgnoreCaseEmptyEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.equalsIgnoreCase("", ""));
    }

    @Test
    public void equalsIgnoreCaseEmptyString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.equalsIgnoreCase("", "string"));
    }

    @Test
    public void equalsIgnoreCaseStringEmpty() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.equalsIgnoreCase("string", ""));
    }

    @Test
    public void equalsIgnoreCaseNullString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.equalsIgnoreCase(null, "string"));
    }

    @Test
    public void equalsIgnoreCaseStringNull() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.equalsIgnoreCase("string", null));
    }

    @Test
    public void equalsIgnoreCaseStringString() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.equalsIgnoreCase("strIng", "strinG"));
    }

    @Test
    public void firstNullNull() {
        Assert.assertEquals(null, (Object)this.stringServices.first(null, null));
    }

    @Test(expected=NullPointerException.class)
    public void firstEmptyNull() {
        this.stringServices.first("", null);
    }

    @Test(expected=NullPointerException.class)
    public void firstStringNull() {
        this.stringServices.first("string", null);
    }

    @Test(expected=StringIndexOutOfBoundsException.class)
    public void firstStringNegative() {
        this.stringServices.first("string", Integer.valueOf(-10));
    }

    @Test
    public void firstStringInRange() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.first("string", Integer.valueOf(3)));
    }

    @Test
    public void firstStringOverRange() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.first("string", Integer.valueOf(300)));
    }

    @Test
    public void indexNullNull() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.index(null, null));
    }

    @Test
    public void indexNullEmpty() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.index(null, ""));
    }

    @Test
    public void indexEmptyNull() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.index("", null));
    }

    @Test
    public void indexEmptyEmpty() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.index("", ""));
    }

    @Test
    public void indexEmptyString() {
        Assert.assertEquals((Object)-1, (Object)this.stringServices.index("", "string"));
    }

    @Test
    public void indexStringEmpty() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.index("string", ""));
    }

    @Test
    public void indexNullString() {
        Assert.assertEquals((Object)-1, (Object)this.stringServices.index(null, "string"));
    }

    @Test
    public void indexStringNull() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.index("string", null));
    }

    @Test
    public void indexStringString() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.index("string", "string"));
    }

    @Test
    public void index() {
        Assert.assertEquals((Object)4, (Object)this.stringServices.index("string", "ing"));
    }

    @Test(expected=NullPointerException.class)
    public void indexNullNullNull() {
        this.stringServices.index(null, null, null);
    }

    @Test(expected=NullPointerException.class)
    public void indexNullEmptyNull() {
        this.stringServices.index(null, "", null);
    }

    @Test(expected=NullPointerException.class)
    public void indexEmptyNullNull() {
        this.stringServices.index("", null, null);
    }

    @Test(expected=NullPointerException.class)
    public void indexEmptyEmptyNull() {
        this.stringServices.index("", "", null);
    }

    @Test(expected=NullPointerException.class)
    public void indexEmptyStringNull() {
        this.stringServices.index("", "string", null);
    }

    @Test(expected=NullPointerException.class)
    public void indexStringEmptyNull() {
        this.stringServices.index("string", "", null);
    }

    @Test(expected=NullPointerException.class)
    public void indexNullStringNull() {
        this.stringServices.index(null, "string", null);
    }

    @Test(expected=NullPointerException.class)
    public void indexStringNullNull() {
        this.stringServices.index("string", null, null);
    }

    @Test(expected=NullPointerException.class)
    public void indexStringStringNull() {
        this.stringServices.index("string", "string", null);
    }

    @Test(expected=NullPointerException.class)
    public void indexNull() {
        this.stringServices.index("string", "ing", null);
    }

    @Test
    public void indexNegativeStartPosition() {
        Assert.assertEquals((Object)4, (Object)this.stringServices.index("string", "ing", Integer.valueOf(-10)));
    }

    @Test
    public void indexOutOfRangeStartPosition() {
        Assert.assertEquals((Object)-1, (Object)this.stringServices.index("string", "ing", Integer.valueOf(100)));
    }

    @Test
    public void indexStartPosition() {
        Assert.assertEquals((Object)10, (Object)this.stringServices.index("stringstring", "ing", Integer.valueOf(4)));
    }

    @Test
    public void isAlphaNull() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.isAlpha(null));
    }

    @Test
    public void isAlphaEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.isAlpha(""));
    }

    @Test
    public void isAlphaTrue() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.isAlpha("abcD"));
    }

    @Test
    public void isAlphaFalse() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.isAlpha("abcD1"));
    }

    @Test
    public void isAlphaNumNull() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.isAlphaNum(null));
    }

    @Test
    public void isAlphaNumEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.isAlphaNum(""));
    }

    @Test
    public void isAlphaNumTrue() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.isAlphaNum("abcD1"));
    }

    @Test
    public void isAlphaNumFalse() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.isAlphaNum("abcD1_"));
    }

    @Test
    public void lastNullNull() {
        Assert.assertEquals(null, (Object)this.stringServices.last(null, null));
    }

    @Test(expected=NullPointerException.class)
    public void lastEmptyNull() {
        this.stringServices.last("", null);
    }

    @Test(expected=NullPointerException.class)
    public void lastStringNull() {
        this.stringServices.last("string", null);
    }

    @Test(expected=StringIndexOutOfBoundsException.class)
    public void lastStringNegative() {
        this.stringServices.last("string", Integer.valueOf(-10));
    }

    @Test
    public void lastStringInRange() {
        Assert.assertEquals((Object)"ng", (Object)this.stringServices.last("string", Integer.valueOf(2)));
    }

    @Test
    public void lastStringOverRange() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.last("string", Integer.valueOf(300)));
    }

    @Test
    public void lastIndexNullNull() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.lastIndex(null, null));
    }

    @Test
    public void lastIndexNullEmpty() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.lastIndex(null, ""));
    }

    @Test
    public void lastIndexEmptyNull() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.lastIndex("", null));
    }

    @Test
    public void lastIndexEmptyEmpty() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.lastIndex("", ""));
    }

    @Test
    public void lastIndexEmptyString() {
        Assert.assertEquals((Object)-1, (Object)this.stringServices.lastIndex("", "string"));
    }

    @Test
    public void lastIndexStringEmpty() {
        Assert.assertEquals((Object)7, (Object)this.stringServices.lastIndex("string", ""));
    }

    @Test
    public void lastIndexNullString() {
        Assert.assertEquals((Object)-1, (Object)this.stringServices.lastIndex(null, "string"));
    }

    @Test
    public void lastIndexStringNull() {
        Assert.assertEquals((Object)7, (Object)this.stringServices.lastIndex("string", null));
    }

    @Test
    public void lastIndexStringString() {
        Assert.assertEquals((Object)1, (Object)this.stringServices.lastIndex("string", "string"));
    }

    @Test
    public void lastIndex() {
        Assert.assertEquals((Object)4, (Object)this.stringServices.lastIndex("string", "ing"));
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexNullNullNull() {
        this.stringServices.lastIndex(null, null, null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexNullEmptyNull() {
        this.stringServices.lastIndex(null, "", null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexEmptyNullNull() {
        this.stringServices.lastIndex("", null, null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexEmptyEmptyNull() {
        this.stringServices.lastIndex("", "", null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexEmptyStringNull() {
        this.stringServices.lastIndex("", "string", null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexStringEmptyNull() {
        this.stringServices.lastIndex("string", "", null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexNullStringNull() {
        this.stringServices.lastIndex(null, "string", null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexStringNullNull() {
        this.stringServices.lastIndex("string", null, null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexStringStringNull() {
        this.stringServices.lastIndex("string", "string", null);
    }

    @Test(expected=NullPointerException.class)
    public void lastIndexNull() {
        this.stringServices.lastIndex("string", "ing", null);
    }

    @Test
    public void lastIndexNegativeStartPosition() {
        Assert.assertEquals((Object)-1, (Object)this.stringServices.lastIndex("string", "ing", Integer.valueOf(-10)));
    }

    @Test
    public void lastIndexOutOfRangeStartPosition() {
        Assert.assertEquals((Object)4, (Object)this.stringServices.lastIndex("string", "ing", Integer.valueOf(100)));
    }

    @Test
    public void lastIndexStartPosition() {
        Assert.assertEquals((Object)4, (Object)this.stringServices.lastIndex("stringstring", "ing", Integer.valueOf(4)));
    }

    @Test
    public void matchesNullNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.matches(null, null));
    }

    @Test
    public void matchesNullEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.matches(null, ""));
    }

    @Test
    public void matchesEmptyNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.matches("", null));
    }

    @Test
    public void matchesEmptyEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.matches("", ""));
    }

    @Test
    public void matchesEmptyString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.matches("", "string"));
    }

    @Test
    public void matchesStringEmpty() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.matches("string", ""));
    }

    @Test
    public void matchesNullString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.matches(null, "string"));
    }

    @Test
    public void matchesStringNull() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.matches("string", null));
    }

    @Test
    public void matchesStringString() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.matches("string", "string"));
    }

    @Test
    public void matchesTrue() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.matches("string", "s.ri(n|g)+"));
    }

    @Test
    public void matchesFalse() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.matches("string", "s.ri(t|g)+"));
    }

    @Test
    public void prefixNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.prefix(null, null));
    }

    @Test
    public void prefixNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.prefix(null, ""));
    }

    @Test
    public void prefixEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.prefix("", null));
    }

    @Test
    public void prefixEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.prefix("", ""));
    }

    @Test
    public void prefixEmptyString() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.prefix("", "string"));
    }

    @Test
    public void prefixStringEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.prefix("string", ""));
    }

    @Test
    public void prefixNullString() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.prefix(null, "string"));
    }

    @Test
    public void prefixStringNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.prefix("string", null));
    }

    @Test
    public void prefixStringString() {
        Assert.assertEquals((Object)"bbbaaa", (Object)this.stringServices.prefix("aaa", "bbb"));
    }

    @Test
    public void replaceNullNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace(null, null, null));
    }

    @Test
    public void replaceNullEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace(null, "", null));
    }

    @Test
    public void replaceEmptyNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace("", null, null));
    }

    @Test
    public void replaceEmptyEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace("", "", null));
    }

    @Test
    public void replaceEmptyStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace("", "string", null));
    }

    @Test
    public void replaceStringEmptyNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.replace("string", "", null));
    }

    @Test
    public void replaceNullStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace(null, "string", null));
    }

    @Test
    public void replaceStringNullNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.replace("string", null, null));
    }

    @Test
    public void replaceStringStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace("string", "string", null));
    }

    @Test
    public void replaceNull() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.replace("string", "ing", null));
    }

    @Test
    public void replaceNullNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace(null, null, ""));
    }

    @Test
    public void replaceNullEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace(null, "", ""));
    }

    @Test
    public void replaceEmptyNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace("", null, ""));
    }

    @Test
    public void replaceEmptyEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace("", "", ""));
    }

    @Test
    public void replaceEmptyStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace("", "string", ""));
    }

    @Test
    public void replaceStringEmptyEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.replace("string", "", ""));
    }

    @Test
    public void replaceNullStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace(null, "string", ""));
    }

    @Test
    public void replaceStringNullEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.replace("string", null, ""));
    }

    @Test
    public void replaceStringStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replace("string", "string", ""));
    }

    @Test
    public void replaceEmpty() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.replace("string", "ing", ""));
    }

    @Test
    public void replace() {
        Assert.assertEquals((Object)"strremplacement and string", (Object)this.stringServices.replace("string and string", "i[nz]g", "remplacement"));
    }

    @Test
    public void replaceAllNullNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll(null, null, null));
    }

    @Test
    public void replaceAllNullEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll(null, "", null));
    }

    @Test
    public void replaceAllEmptyNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll("", null, null));
    }

    @Test
    public void replaceAllEmptyEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll("", "", null));
    }

    @Test
    public void replaceAllEmptyStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll("", "string", null));
    }

    @Test
    public void replaceAllStringEmptyNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.replaceAll("string", "", null));
    }

    @Test
    public void replaceAllNullStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll(null, "string", null));
    }

    @Test
    public void replaceAllStringNullNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.replaceAll("string", null, null));
    }

    @Test
    public void replaceAllStringStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll("string", "string", null));
    }

    @Test
    public void replaceAllNull() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.replaceAll("string", "ing", null));
    }

    @Test
    public void replaceAllNullNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll(null, null, ""));
    }

    @Test
    public void replaceAllNullEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll(null, "", ""));
    }

    @Test
    public void replaceAllEmptyNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll("", null, ""));
    }

    @Test
    public void replaceAllEmptyEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll("", "", ""));
    }

    @Test
    public void replaceAllEmptyStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll("", "string", ""));
    }

    @Test
    public void replaceAllStringEmptyEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.replaceAll("string", "", ""));
    }

    @Test
    public void replaceAllNullStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll(null, "string", ""));
    }

    @Test
    public void replaceAllStringNullEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.replaceAll("string", null, ""));
    }

    @Test
    public void replaceAllStringStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.replaceAll("string", "string", ""));
    }

    @Test
    public void replaceAllEmpty() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.replaceAll("string", "ing", ""));
    }

    @Test
    public void replaceAll() {
        Assert.assertEquals((Object)"strremplacement and strremplacement", (Object)this.stringServices.replaceAll("string and string", "i[nz]g", "remplacement"));
    }

    @Test
    public void sizeNull() {
        Assert.assertEquals((Object)0, (Object)this.stringServices.size(null));
    }

    @Test
    public void sizeEmpty() {
        Assert.assertEquals((Object)0, (Object)this.stringServices.size(""));
    }

    @Test
    public void size() {
        Assert.assertEquals((Object)5, (Object)this.stringServices.size("acbde"));
    }

    @Test
    public void startsWithNullNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.startsWith(null, null));
    }

    @Test
    public void startsWithNullEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.startsWith(null, ""));
    }

    @Test
    public void startsWithEmptyNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.startsWith("", null));
    }

    @Test
    public void startsWithEmptyEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.startsWith("", ""));
    }

    @Test
    public void startsWithEmptyString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.startsWith("", "string"));
    }

    @Test
    public void startsWithStringEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.startsWith("string", ""));
    }

    @Test
    public void startsWithNullString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.startsWith(null, "string"));
    }

    @Test
    public void startsWithStringNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.startsWith("string", null));
    }

    @Test
    public void startsWithStringString() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.startsWith("string", "string"));
    }

    @Test
    public void startsWithFalse() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.startsWith("astring", "string"));
    }

    @Test
    public void strcmpNullNull() {
        Assert.assertEquals((Object)0, (Object)this.stringServices.strcmp(null, null));
    }

    @Test
    public void strcmpNullEmpty() {
        Assert.assertEquals((Object)0, (Object)this.stringServices.strcmp(null, ""));
    }

    @Test
    public void strcmpEmptyNull() {
        Assert.assertEquals((Object)0, (Object)this.stringServices.strcmp("", null));
    }

    @Test
    public void strcmpEmptyEmpty() {
        Assert.assertEquals((Object)0, (Object)this.stringServices.strcmp("", ""));
    }

    @Test
    public void strcmpEmptyString() {
        Assert.assertEquals((Object)-6, (Object)this.stringServices.strcmp("", "string"));
    }

    @Test
    public void strcmpStringEmpty() {
        Assert.assertEquals((Object)6, (Object)this.stringServices.strcmp("string", ""));
    }

    @Test
    public void strcmpNullString() {
        Assert.assertEquals((Object)-6, (Object)this.stringServices.strcmp(null, "string"));
    }

    @Test
    public void strcmpStringNull() {
        Assert.assertEquals((Object)6, (Object)this.stringServices.strcmp("string", null));
    }

    @Test
    public void strcmpZero() {
        Assert.assertEquals((Object)0, (Object)this.stringServices.strcmp("string", "string"));
    }

    @Test
    public void strcmp() {
        Assert.assertEquals((Object)-18, (Object)this.stringServices.strcmp("astring", "string"));
    }

    @Test
    public void strstrNullNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.strstr(null, null));
    }

    @Test
    public void strstrNullEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.strstr(null, ""));
    }

    @Test
    public void strstrEmptyNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.strstr("", null));
    }

    @Test
    public void strstrEmptyEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.strstr("", ""));
    }

    @Test
    public void strstrEmptyString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.strstr("", "string"));
    }

    @Test
    public void strstrStringEmpty() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.strstr("string", ""));
    }

    @Test
    public void strstrNullString() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.strstr(null, "string"));
    }

    @Test
    public void strstrStringNull() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.strstr("string", null));
    }

    @Test
    public void strstrStringString() {
        Assert.assertEquals((Object)true, (Object)this.stringServices.strstr("string", "string"));
    }

    @Test
    public void strstrFalse() {
        Assert.assertEquals((Object)false, (Object)this.stringServices.strstr("astrrng", "string"));
    }

    @Test
    public void substituteNullNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute(null, null, null));
    }

    @Test
    public void substituteNullEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute(null, "", null));
    }

    @Test
    public void substituteEmptyNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute("", null, null));
    }

    @Test
    public void substituteEmptyEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute("", "", null));
    }

    @Test
    public void substituteEmptyStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute("", "string", null));
    }

    @Test
    public void substituteStringEmptyNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.substitute("string", "", null));
    }

    @Test
    public void substituteNullStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute(null, "string", null));
    }

    @Test
    public void substituteStringNullNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.substitute("string", null, null));
    }

    @Test
    public void substituteStringStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute("string", "string", null));
    }

    @Test
    public void substituteNull() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.substitute("string", "ing", null));
    }

    @Test
    public void substituteNullNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute(null, null, ""));
    }

    @Test
    public void substituteNullEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute(null, "", ""));
    }

    @Test
    public void substituteEmptyNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute("", null, ""));
    }

    @Test
    public void substituteEmptyEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute("", "", ""));
    }

    @Test
    public void substituteEmptyStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute("", "string", ""));
    }

    @Test
    public void substituteStringEmptyEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.substitute("string", "", ""));
    }

    @Test
    public void substituteNullStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute(null, "string", ""));
    }

    @Test
    public void substituteStringNullEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.substitute("string", null, ""));
    }

    @Test
    public void substituteStringStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substitute("string", "string", ""));
    }

    @Test
    public void substituteEmpty() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.substitute("string", "ing", ""));
    }

    @Test
    public void substitute() {
        Assert.assertEquals((Object)"strremplacement and string", (Object)this.stringServices.substitute("string and string", "ing", "remplacement"));
    }

    @Test
    public void substituteAllNullNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll(null, null, null));
    }

    @Test
    public void substituteAllNullEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll(null, "", null));
    }

    @Test
    public void substituteAllEmptyNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll("", null, null));
    }

    @Test
    public void substituteAllEmptyEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll("", "", null));
    }

    @Test
    public void substituteAllEmptyStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll("", "string", null));
    }

    @Test
    public void substituteAllStringEmptyNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.substituteAll("string", "", null));
    }

    @Test
    public void substituteAllNullStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll(null, "string", null));
    }

    @Test
    public void substituteAllStringNullNull() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.substituteAll("string", null, null));
    }

    @Test
    public void substituteAllStringStringNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll("string", "string", null));
    }

    @Test
    public void substituteAllNull() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.substituteAll("string", "ing", null));
    }

    @Test
    public void substituteAllNullNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll(null, null, ""));
    }

    @Test
    public void substituteAllNullEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll(null, "", ""));
    }

    @Test
    public void substituteAllEmptyNullEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll("", null, ""));
    }

    @Test
    public void substituteAllEmptyEmptyEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll("", "", ""));
    }

    @Test
    public void substituteAllEmptyStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll("", "string", ""));
    }

    @Test
    public void substituteAllStringEmptyEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.substituteAll("string", "", ""));
    }

    @Test
    public void substituteAllNullStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll(null, "string", ""));
    }

    @Test
    public void substituteAllStringNullEmpty() {
        Assert.assertEquals((Object)"string", (Object)this.stringServices.substituteAll("string", null, ""));
    }

    @Test
    public void substituteAllStringStringEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substituteAll("string", "string", ""));
    }

    @Test
    public void substituteAllEmpty() {
        Assert.assertEquals((Object)"str", (Object)this.stringServices.substituteAll("string", "ing", ""));
    }

    @Test
    public void substituteAll() {
        Assert.assertEquals((Object)"strremplacement and strremplacement", (Object)this.stringServices.substituteAll("string and string", "ing", "remplacement"));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void substringLowerOutOfRange() {
        this.stringServices.substring("some string", Integer.valueOf(0), Integer.valueOf(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void substringUpperOutOfRange() {
        this.stringServices.substring("some string", Integer.valueOf(1), Integer.valueOf(100));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void substringInversedBounds() {
        this.stringServices.substring("some string", Integer.valueOf(7), Integer.valueOf(4));
    }

    @Test
    public void substringNullNull() {
        Assert.assertEquals(null, (Object)this.stringServices.substring(null, null));
    }

    @Test(expected=NullPointerException.class)
    public void substringEmptyNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substring("", null));
    }

    @Test
    public void substringNullNullNull() {
        Assert.assertEquals(null, (Object)this.stringServices.substring(null, null, null));
    }

    @Test(expected=NullPointerException.class)
    public void substringEmptyNullNull() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substring("", null, null));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void substringNegative() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substring("", Integer.valueOf(-100), Integer.valueOf(-10)));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void substringOverRange() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.substring("", Integer.valueOf(10), Integer.valueOf(100)));
    }

    @Test
    public void substring() {
        String result = this.stringServices.substring("some string", Integer.valueOf(4), Integer.valueOf(7));
        Assert.assertEquals((Object)"some string".substring(3, 7), (Object)result);
        result = this.stringServices.substring("some string", Integer.valueOf(4));
        Assert.assertEquals((Object)"some string".substring(3), (Object)result);
    }

    @Test
    public void substringUpperBound() {
        String result = this.stringServices.substring("substring operation", Integer.valueOf(11), Integer.valueOf(19));
        Assert.assertEquals((Object)"operation", (Object)result);
    }

    @Test
    public void substringLowerBound() {
        String result = this.stringServices.substring("substring operation", Integer.valueOf(1), Integer.valueOf(1));
        Assert.assertEquals((Object)"s", (Object)result);
    }

    @Test(expected=NumberFormatException.class)
    public void toIntegerNull() {
        this.stringServices.toInteger(null);
    }

    @Test(expected=NumberFormatException.class)
    public void toIntegerRoundedReal() {
        this.stringServices.toInteger("3.0");
    }

    @Test(expected=NumberFormatException.class)
    public void toIntegerReal() {
        this.stringServices.toInteger("3.14");
    }

    @Test(expected=NumberFormatException.class)
    public void toIntegerInvalid() {
        this.stringServices.toInteger("toInteger");
    }

    @Test
    public void toInteger() {
        Integer result = this.stringServices.toInteger("4");
        Assert.assertEquals((Object)4, (Object)result);
    }

    @Test
    public void tokenizeSpaceNull() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.stringServices.tokenize(null).toArray());
    }

    @Test
    public void tokenizeSpaceEmpty() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.stringServices.tokenize("").toArray());
    }

    @Test
    public void tokenizeSpace() {
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])this.stringServices.tokenize("a b c d").toArray());
    }

    @Test
    public void tokenizeNullNull() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.stringServices.tokenize(null, null).toArray());
    }

    @Test
    public void tokenizeNullEmpty() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.stringServices.tokenize(null, "").toArray());
    }

    @Test
    public void tokenizeEmptyNull() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.stringServices.tokenize("", null).toArray());
    }

    @Test
    public void tokenizeEmptyEmpty() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.stringServices.tokenize("", "").toArray());
    }

    @Test
    public void tokenizeEmptyString() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.stringServices.tokenize("", "string").toArray());
    }

    @Test
    public void tokenizeStringEmpty() {
        Assert.assertArrayEquals((Object[])new String[]{"string"}, (Object[])this.stringServices.tokenize("string", "").toArray());
    }

    @Test
    public void tokenizeNullString() {
        Assert.assertArrayEquals((Object[])new String[0], (Object[])this.stringServices.tokenize(null, "string").toArray());
    }

    @Test
    public void tokenizeStringNull() {
        Assert.assertArrayEquals((Object[])new String[]{"string"}, (Object[])this.stringServices.tokenize("string", null).toArray());
    }

    @Test
    public void tokenizeStringString() {
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])this.stringServices.tokenize("a|b|c|d", "|").toArray());
    }

    @Test
    public void toLowerNull() {
        Assert.assertEquals(null, (Object)this.stringServices.toLower(null));
    }

    @Test
    public void toLowerEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.toLower(""));
    }

    @Test
    public void toLower() {
        Assert.assertEquals((Object)"abcd", (Object)this.stringServices.toLower("ABCD"));
    }

    @Test
    public void toLowerNullFirst() {
        Assert.assertEquals(null, (Object)this.stringServices.toLowerFirst(null));
    }

    @Test
    public void toLowerEmptyFirst() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.toLowerFirst(""));
    }

    @Test
    public void toLowerFirst() {
        Assert.assertEquals((Object)"aBCD", (Object)this.stringServices.toLowerFirst("ABCD"));
    }

    @Test(expected=NumberFormatException.class)
    public void toRealNull() {
        this.stringServices.toReal(null);
    }

    @Test(expected=NumberFormatException.class)
    public void toRealEmpty() {
        this.stringServices.toReal("");
    }

    @Test
    public void toRealRoundedReal() {
        Double result = this.stringServices.toReal("3.0");
        Assert.assertEquals((Object)3.0, (Object)result);
    }

    @Test(expected=NumberFormatException.class)
    public void toRealInvalid() {
        this.stringServices.toReal("toInteger");
    }

    @Test
    public void toReal() {
        Double result = this.stringServices.toReal("3.14");
        Assert.assertEquals((Object)3.14, (Object)result);
    }

    @Test
    public void toUpperNull() {
        Assert.assertEquals(null, (Object)this.stringServices.toUpper(null));
    }

    @Test
    public void toUpperEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.toUpper(""));
    }

    @Test
    public void toUpper() {
        Assert.assertEquals((Object)"ABCD", (Object)this.stringServices.toUpper("abcd"));
    }

    @Test
    public void toUpperNullFirst() {
        Assert.assertEquals(null, (Object)this.stringServices.toUpperFirst(null));
    }

    @Test
    public void toUpperEmptyFirst() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.toUpperFirst(""));
    }

    @Test
    public void toUpperFirst() {
        Assert.assertEquals((Object)"Abcd", (Object)this.stringServices.toUpperFirst("abcd"));
    }

    @Test
    public void trimNull() {
        Assert.assertEquals(null, (Object)this.stringServices.trim(null));
    }

    @Test
    public void trimEmpty() {
        Assert.assertEquals((Object)"", (Object)this.stringServices.trim(""));
    }

    @Test
    public void trim() {
        Assert.assertEquals((Object)"azerty", (Object)this.stringServices.trim("\n\t    \razerty \t\t"));
    }
}

