/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesTest;
import org.junit.Assert;
import org.junit.Test;

public class NumberServicesTest
extends AbstractServicesTest {
    private NumberServices numServices;

    @Override
    public void before() throws Exception {
        super.before();
        Set servicesToRegister = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), NumberServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)servicesToRegister);
        this.numServices = new NumberServices();
    }

    @Test(expected=NullPointerException.class)
    public void testUnaryMinIntegerNull() {
        this.numServices.unaryMin(null);
    }

    @Test
    public void testUnaryMinInteger() {
        Integer integer1 = new Integer(1);
        Integer integer2 = new Integer(5);
        Assert.assertEquals((Object)"-1", (Object)this.numServices.unaryMin(integer1).toString());
        Assert.assertEquals((Object)"-5", (Object)this.numServices.unaryMin(integer2).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testUnaryMinDoubleNull() {
        this.numServices.unaryMin(null);
    }

    @Test
    public void testUnaryMinDouble() {
        Double double1 = new Double(1.0);
        Double double2 = new Double(5.0);
        Assert.assertEquals((Object)"-1.0", (Object)this.numServices.unaryMin(double1).toString());
        Assert.assertEquals((Object)"-5.0", (Object)this.numServices.unaryMin(double2).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testAddIntegerNullNull() {
        this.numServices.add(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddIntegerIntegerNull() {
        Integer integer0 = new Integer(0);
        this.numServices.add(integer0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddIntegerNullInteger() {
        Integer integer0 = new Integer(0);
        this.numServices.add(null, integer0);
    }

    @Test
    public void testAddInteger() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Integer integer0 = new Integer(0);
        Integer integer1 = new Integer(1);
        Assert.assertEquals((Object)"2", (Object)this.numServices.add(integer1, integer1).toString());
        Assert.assertEquals((Object)"1", (Object)this.numServices.add(integer1, integer0).toString());
        Assert.assertEquals((Object)"1", (Object)this.numServices.add(integer0, integer1).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testSubIntegerNullNull() {
        this.numServices.sub(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubIntegerIntegerNull() {
        Integer integer0 = new Integer(0);
        this.numServices.sub(integer0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubIntegerNullInteger() {
        Integer integer0 = new Integer(0);
        this.numServices.sub(null, integer0);
    }

    @Test
    public void testSubInteger() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Integer integer0 = new Integer(0);
        Integer integer1 = new Integer(1);
        Integer integer3 = new Integer(3);
        Assert.assertEquals((Object)"-1", (Object)this.numServices.sub(integer0, integer1).toString());
        Assert.assertEquals((Object)"2", (Object)this.numServices.sub(integer3, integer1).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testDivIntegerNullNull() {
        this.numServices.div(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testDivIntegerIntegerNull() {
        Integer integer0 = new Integer(0);
        this.numServices.div(integer0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivIntegerNullInteger() {
        Integer integer0 = new Integer(0);
        this.numServices.div(null, integer0);
    }

    @Test
    public void testDivInteger() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Integer integer1 = new Integer(1);
        Integer integer2 = new Integer(2);
        Integer integer4 = new Integer(4);
        Assert.assertEquals((Object)"2", (Object)this.numServices.divOp(integer4, integer2).toString());
        Assert.assertEquals((Object)"0", (Object)this.numServices.divOp(integer1, integer2).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testMultIntegerNullNull() {
        this.numServices.mult(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testMultIntegerIntegerNull() {
        Integer integer0 = new Integer(0);
        this.numServices.mult(integer0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testMultIntegerNullInteger() {
        Integer integer0 = new Integer(0);
        this.numServices.mult(null, integer0);
    }

    @Test
    public void testMultInteger() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Integer integer0 = new Integer(0);
        Integer integer1 = new Integer(1);
        Integer integer2 = new Integer(2);
        Integer integer4 = new Integer(4);
        Assert.assertEquals((Object)"8", (Object)this.numServices.mult(integer4, integer2).toString());
        Assert.assertEquals((Object)"2", (Object)this.numServices.mult(integer1, integer2).toString());
        Assert.assertEquals((Object)"0", (Object)this.numServices.mult(integer0, integer2).toString());
        Assert.assertEquals((Object)"0", (Object)this.numServices.mult(integer2, integer0).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testAddDoubleNullNull() {
        this.numServices.add(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddDoubleDoubleNull() {
        Double integer0 = new Double(0.0);
        this.numServices.add(integer0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddDoubleNullDouble() {
        Double integer0 = new Double(0.0);
        this.numServices.add(null, integer0);
    }

    @Test
    public void testAddDouble() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Double double0 = new Double(0.0);
        Double double1 = new Double(1.0);
        Assert.assertEquals((Object)"2.0", (Object)this.numServices.add(double1, double1).toString());
        Assert.assertEquals((Object)"1.0", (Object)this.numServices.add(double1, double0).toString());
        Assert.assertEquals((Object)"1.0", (Object)this.numServices.add(double0, double1).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testSubDoubleNullNull() {
        this.numServices.sub(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubDoubleDoubleNull() {
        Double integer0 = new Double(0.0);
        this.numServices.sub(integer0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubDoubleNullDouble() {
        Double integer0 = new Double(0.0);
        this.numServices.sub(null, integer0);
    }

    @Test
    public void testSubDouble() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Double double0 = new Double(0.0);
        Double double1 = new Double(1.0);
        Double double3 = new Double(3.0);
        Assert.assertEquals((Object)"-1.0", (Object)this.numServices.sub(double0, double1).toString());
        Assert.assertEquals((Object)"2.0", (Object)this.numServices.sub(double3, double1).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testDivDoubleNullNull() {
        this.numServices.div(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testDivDoubleDoubleNull() {
        Double integer0 = new Double(0.0);
        this.numServices.div(integer0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivDoubleNullDouble() {
        Double integer0 = new Double(0.0);
        this.numServices.div(null, integer0);
    }

    @Test
    public void testDivDouble() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Double double1 = new Double(1.0);
        Double double2 = new Double(2.0);
        Double double4 = new Double(4.0);
        Assert.assertEquals((Object)"2.0", (Object)this.numServices.divOp(double4, double2).toString());
        Assert.assertEquals((Object)"0.5", (Object)this.numServices.divOp(double1, double2).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testMultDoubleNullNull() {
        this.numServices.mult(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testMultDoubleDoubleNull() {
        Double integer0 = new Double(0.0);
        this.numServices.mult(integer0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testMultDoubleNullDouble() {
        Double integer0 = new Double(0.0);
        this.numServices.mult(null, integer0);
    }

    @Test
    public void testMultDouble() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Double double0 = new Double(0.0);
        Double double1 = new Double(1.0);
        Double double2 = new Double(2.0);
        Double double4 = new Double(4.0);
        Assert.assertEquals((Object)"8.0", (Object)this.numServices.mult(double4, double2).toString());
        Assert.assertEquals((Object)"2.0", (Object)this.numServices.mult(double1, double2).toString());
        Assert.assertEquals((Object)"0.0", (Object)this.numServices.mult(double0, double2).toString());
        Assert.assertEquals((Object)"0.0", (Object)this.numServices.mult(double2, double0).toString());
    }

    @Test(expected=NullPointerException.class)
    public void absDoubleNull() {
        this.numServices.abs(null);
    }

    @Test
    public void absDoublePositive() {
        Double result = this.numServices.abs(Double.valueOf(3.14));
        Assert.assertEquals((Object)3.14, (Object)result);
    }

    @Test
    public void absDoubleNegative() {
        Double result = this.numServices.abs(Double.valueOf(-3.14));
        Assert.assertEquals((Object)3.14, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void absIntegerNull() {
        this.numServices.abs(null);
    }

    @Test
    public void absIntegerPositive() {
        Integer result = this.numServices.abs(Integer.valueOf(3));
        Assert.assertEquals((Object)3, (Object)result);
    }

    @Test
    public void absIntegerNegative() {
        Integer result = this.numServices.abs(Integer.valueOf(-3));
        Assert.assertEquals((Object)3, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void floorDoubleNull() {
        this.numServices.floor(null);
    }

    @Test
    public void floorDouble() {
        Integer result = this.numServices.floor(Double.valueOf(3.14));
        Assert.assertEquals((Object)3, (Object)result);
    }

    @Test
    public void floorIntegerNull() {
        Integer result = this.numServices.floor(null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void floorInteger() {
        Integer result = this.numServices.floor(Integer.valueOf(3));
        Assert.assertEquals((Object)3, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void maxDoubleNullNull() {
        this.numServices.max(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void maxDoubleDoubleNull() {
        this.numServices.max(Double.valueOf(3.14), null);
    }

    @Test(expected=NullPointerException.class)
    public void maxDoubleNullDouble() {
        this.numServices.max(null, Double.valueOf(3.14));
    }

    @Test
    public void maxDouble() {
        Double result = this.numServices.max(Double.valueOf(6.28), Double.valueOf(3.14));
        Assert.assertEquals((Object)6.28, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void maxIntegerNullNull() {
        this.numServices.max(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void maxIntegerIntegerNull() {
        this.numServices.max(Integer.valueOf(3), null);
    }

    @Test(expected=NullPointerException.class)
    public void maxIntegerNullInteger() {
        this.numServices.max(null, Integer.valueOf(3));
    }

    @Test
    public void maxInteger() {
        Integer result = this.numServices.max(Integer.valueOf(6), Integer.valueOf(3));
        Assert.assertEquals((Object)6, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void minDoubleNullNull() {
        this.numServices.min(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void minDoubleDoubleNull() {
        this.numServices.min(Double.valueOf(3.14), null);
    }

    @Test(expected=NullPointerException.class)
    public void minDoubleNullDouble() {
        this.numServices.min(null, Double.valueOf(3.14));
    }

    @Test
    public void minDouble() {
        Double result = this.numServices.min(Double.valueOf(6.28), Double.valueOf(3.14));
        Assert.assertEquals((Object)3.14, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void minIntegerNullNull() {
        this.numServices.min(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void minIntegerIntegerNull() {
        this.numServices.min(Integer.valueOf(3), null);
    }

    @Test(expected=NullPointerException.class)
    public void minIntegerNullInteger() {
        this.numServices.min(null, Integer.valueOf(3));
    }

    @Test
    public void minInteger() {
        Integer result = this.numServices.min(Integer.valueOf(6), Integer.valueOf(3));
        Assert.assertEquals((Object)3, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void roundDoubleNull() {
        this.numServices.round(null);
    }

    @Test
    public void roundDouble() {
        Integer result = this.numServices.round(Double.valueOf(3.64));
        Assert.assertEquals((Object)4, (Object)result);
    }

    @Test
    public void roundIntegerNull() {
        Integer result = this.numServices.round(null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void roundInteger() {
        Integer result = this.numServices.round(Integer.valueOf(3));
        Assert.assertEquals((Object)3, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void divDoubleNullNull() {
        this.numServices.div(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void divDoubleDoubleNull() {
        this.numServices.div(Double.valueOf(3.14), null);
    }

    @Test(expected=NullPointerException.class)
    public void divDoubleNullDouble() {
        this.numServices.div(null, Double.valueOf(3.14));
    }

    @Test(expected=IllegalArgumentException.class)
    public void divDoubleByZero() {
        Integer result = this.numServices.div(Double.valueOf(3.14), Double.valueOf(0.0));
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void divDouble() {
        Integer result = this.numServices.div(Double.valueOf(22.98), Double.valueOf(3.14));
        Assert.assertEquals((Object)7, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void divIntegerNullNull() {
        this.numServices.div(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void divIntegerIntegerNull() {
        this.numServices.div(Integer.valueOf(3), null);
    }

    @Test(expected=NullPointerException.class)
    public void divIntegerNullInteger() {
        this.numServices.div(null, Integer.valueOf(3));
    }

    @Test(expected=IllegalArgumentException.class)
    public void divIntegerByZero() {
        Integer result = this.numServices.div(Integer.valueOf(3), Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void divInteger() {
        Integer result = this.numServices.div(Integer.valueOf(22), Integer.valueOf(3));
        Assert.assertEquals((Object)7, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void modDoubleNullNull() {
        this.numServices.mod(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void modDoubleDoubleNull() {
        this.numServices.mod(Double.valueOf(3.14), null);
    }

    @Test(expected=NullPointerException.class)
    public void modDoubleNullDouble() {
        this.numServices.mod(null, Double.valueOf(3.14));
    }

    @Test(expected=IllegalArgumentException.class)
    public void modDoubleByZero() {
        Integer result = this.numServices.mod(Double.valueOf(3.14), Double.valueOf(0.0));
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void modDouble() {
        Integer result = this.numServices.mod(Double.valueOf(22.98), Double.valueOf(3.14));
        Assert.assertEquals((Object)1, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void modIntegerNullNull() {
        this.numServices.mod(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void modIntegerIntegerNull() {
        this.numServices.mod(Integer.valueOf(3), null);
    }

    @Test(expected=NullPointerException.class)
    public void modIntegerNullInteger() {
        this.numServices.mod(null, Integer.valueOf(3));
    }

    @Test(expected=IllegalArgumentException.class)
    public void modIntegerByZero() {
        Integer result = this.numServices.mod(Integer.valueOf(3), Integer.valueOf(0));
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void modInteger() {
        Integer result = this.numServices.mod(Integer.valueOf(22), Integer.valueOf(3));
        Assert.assertEquals((Object)1, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testUnaryMinLongNull() {
        this.numServices.unaryMin(null);
    }

    @Test
    public void testUnaryMinLong() {
        Long long1 = new Long(1L);
        Long long2 = new Long(5L);
        Assert.assertEquals((Object)"-1", (Object)this.numServices.unaryMin(long1).toString());
        Assert.assertEquals((Object)"-5", (Object)this.numServices.unaryMin(long2).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testUnaryMinFloatNull() {
        this.numServices.unaryMin(null);
    }

    @Test
    public void testUnaryMinFloat() {
        Float float1 = new Float(1.0f);
        Float float2 = new Float(5.0f);
        Assert.assertEquals((Object)"-1.0", (Object)this.numServices.unaryMin(float1).toString());
        Assert.assertEquals((Object)"-5.0", (Object)this.numServices.unaryMin(float2).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testAddLongNullNull() {
        this.numServices.add(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddLongLongNull() {
        Long long0 = new Long(0L);
        this.numServices.add(long0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddLongNullLong() {
        Long long0 = new Long(0L);
        this.numServices.add(null, long0);
    }

    @Test
    public void testAddLong() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Long long0 = new Long(0L);
        Long long1 = new Long(1L);
        Assert.assertEquals((Object)"2", (Object)this.numServices.add(long1, long1).toString());
        Assert.assertEquals((Object)"1", (Object)this.numServices.add(long1, long0).toString());
        Assert.assertEquals((Object)"1", (Object)this.numServices.add(long0, long1).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testSubLongNullNull() {
        this.numServices.sub(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubLongLongNull() {
        Long long0 = new Long(0L);
        this.numServices.sub(long0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubLongNullLong() {
        Long long0 = new Long(0L);
        this.numServices.sub(null, long0);
    }

    @Test
    public void testSubLong() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Long long0 = new Long(0L);
        Long long1 = new Long(1L);
        Long long3 = new Long(3L);
        Assert.assertEquals((Object)"-1", (Object)this.numServices.sub(long0, long1).toString());
        Assert.assertEquals((Object)"2", (Object)this.numServices.sub(long3, long1).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testDivLongNullNull() {
        this.numServices.div(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testDivLongLongNull() {
        Long long0 = new Long(0L);
        this.numServices.div(long0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivLongNullLong() {
        Long long0 = new Long(0L);
        this.numServices.div(null, long0);
    }

    @Test
    public void testDivLong() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Long long1 = new Long(1L);
        Long long2 = new Long(2L);
        Long long4 = new Long(4L);
        Assert.assertEquals((Object)"2", (Object)this.numServices.divOp(long4, long2).toString());
        Assert.assertEquals((Object)"0", (Object)this.numServices.divOp(long1, long2).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testMultLongNullNull() {
        this.numServices.mult(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testMultLongLongNull() {
        Long long0 = new Long(0L);
        this.numServices.mult(long0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testMultLongNullLong() {
        Long long0 = new Long(0L);
        this.numServices.mult(null, long0);
    }

    @Test
    public void testMultLong() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Long long0 = new Long(0L);
        Long long1 = new Long(1L);
        Long long2 = new Long(2L);
        Long long4 = new Long(4L);
        Assert.assertEquals((Object)"8", (Object)this.numServices.mult(long4, long2).toString());
        Assert.assertEquals((Object)"2", (Object)this.numServices.mult(long1, long2).toString());
        Assert.assertEquals((Object)"0", (Object)this.numServices.mult(long0, long2).toString());
        Assert.assertEquals((Object)"0", (Object)this.numServices.mult(long2, long0).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testAddFloatNullNull() {
        this.numServices.add(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddFloatFloatNull() {
        Float long0 = new Float(0.0f);
        this.numServices.add(long0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddFloatNullFloat() {
        Float long0 = new Float(0.0f);
        this.numServices.add(null, long0);
    }

    @Test
    public void testAddFloat() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Float float0 = new Float(0.0f);
        Float float1 = new Float(1.0f);
        Assert.assertEquals((Object)"2.0", (Object)this.numServices.add(float1, float1).toString());
        Assert.assertEquals((Object)"1.0", (Object)this.numServices.add(float1, float0).toString());
        Assert.assertEquals((Object)"1.0", (Object)this.numServices.add(float0, float1).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testSubFloatNullNull() {
        this.numServices.sub(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubFloatFloatNull() {
        Float long0 = new Float(0.0f);
        this.numServices.sub(long0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubFloatNullFloat() {
        Float long0 = new Float(0.0f);
        this.numServices.sub(null, long0);
    }

    @Test
    public void testSubFloat() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Float float0 = new Float(0.0f);
        Float float1 = new Float(1.0f);
        Float float3 = new Float(3.0f);
        Assert.assertEquals((Object)"-1.0", (Object)this.numServices.sub(float0, float1).toString());
        Assert.assertEquals((Object)"2.0", (Object)this.numServices.sub(float3, float1).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testDivFloatNullNull() {
        this.numServices.div(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testDivFloatFloatNull() {
        Float long0 = new Float(0.0f);
        this.numServices.div(long0, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDivFloatNullFloat() {
        Float long0 = new Float(0.0f);
        this.numServices.div(null, long0);
    }

    @Test
    public void testDivFloat() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Float float1 = new Float(1.0f);
        Float float2 = new Float(2.0f);
        Float float4 = new Float(4.0f);
        Assert.assertEquals((Object)"2.0", (Object)this.numServices.divOp(float4, float2).toString());
        Assert.assertEquals((Object)"0.5", (Object)this.numServices.divOp(float1, float2).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testMultFloatNullNull() {
        this.numServices.mult(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testMultFloatFloatNull() {
        Float long0 = new Float(0.0f);
        this.numServices.mult(long0, null);
    }

    @Test(expected=NullPointerException.class)
    public void testMultFloatNullFloat() {
        Float long0 = new Float(0.0f);
        this.numServices.mult(null, long0);
    }

    @Test
    public void testMultFloat() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Float float0 = new Float(0.0f);
        Float float1 = new Float(1.0f);
        Float float2 = new Float(2.0f);
        Float float4 = new Float(4.0f);
        Assert.assertEquals((Object)"8.0", (Object)this.numServices.mult(float4, float2).toString());
        Assert.assertEquals((Object)"2.0", (Object)this.numServices.mult(float1, float2).toString());
        Assert.assertEquals((Object)"0.0", (Object)this.numServices.mult(float0, float2).toString());
        Assert.assertEquals((Object)"0.0", (Object)this.numServices.mult(float2, float0).toString());
    }

    @Test(expected=NullPointerException.class)
    public void absFloatNull() {
        this.numServices.abs(null);
    }

    @Test
    public void absFloatPositive() {
        Float result = this.numServices.abs(Float.valueOf(3.14f));
        Assert.assertEquals((Object)Float.valueOf(3.14f), (Object)result);
    }

    @Test
    public void absFloatNegative() {
        Float result = this.numServices.abs(Float.valueOf(-3.14f));
        Assert.assertEquals((Object)Float.valueOf(3.14f), (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void absLongNull() {
        this.numServices.abs(null);
    }

    @Test
    public void absLongPositive() {
        Long result = this.numServices.abs(Long.valueOf(3L));
        Assert.assertEquals((Object)3L, (Object)result);
    }

    @Test
    public void absLongNegative() {
        Long result = this.numServices.abs(Long.valueOf(-3L));
        Assert.assertEquals((Object)3L, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void floorFloatNull() {
        this.numServices.floor(null);
    }

    @Test
    public void floorFloat() {
        Integer result = this.numServices.floor(Float.valueOf(3.14f));
        Assert.assertEquals((Object)3, (Object)result);
    }

    @Test
    public void floorLongNull() {
        Long result = this.numServices.floor(null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void floorLong() {
        Long result = this.numServices.floor(Long.valueOf(3L));
        Assert.assertEquals((Object)3L, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void maxFloatNullNull() {
        this.numServices.max(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void maxFloatFloatNull() {
        this.numServices.max(Float.valueOf(3.14f), null);
    }

    @Test(expected=NullPointerException.class)
    public void maxFloatNullFloat() {
        this.numServices.max(null, Float.valueOf(3.14f));
    }

    @Test
    public void maxFloat() {
        Float result = this.numServices.max(Float.valueOf(6.28f), Float.valueOf(3.14f));
        Assert.assertEquals((Object)Float.valueOf(6.28f), (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void maxLongNullNull() {
        this.numServices.max(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void maxLongLongNull() {
        this.numServices.max(Long.valueOf(3L), null);
    }

    @Test(expected=NullPointerException.class)
    public void maxLongNullLong() {
        this.numServices.max(null, Long.valueOf(3L));
    }

    @Test
    public void maxLong() {
        Long result = this.numServices.max(Long.valueOf(6L), Long.valueOf(3L));
        Assert.assertEquals((Object)6L, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void minFloatNullNull() {
        this.numServices.min(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void minFloatFloatNull() {
        this.numServices.min(Float.valueOf(3.14f), null);
    }

    @Test(expected=NullPointerException.class)
    public void minFloatNullFloat() {
        this.numServices.min(null, Float.valueOf(3.14f));
    }

    @Test
    public void minFloat() {
        Float result = this.numServices.min(Float.valueOf(6.28f), Float.valueOf(3.14f));
        Assert.assertEquals((Object)Float.valueOf(3.14f), (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void minLongNullNull() {
        this.numServices.min(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void minLongLongNull() {
        this.numServices.min(Long.valueOf(3L), null);
    }

    @Test(expected=NullPointerException.class)
    public void minLongNullLong() {
        this.numServices.min(null, Long.valueOf(3L));
    }

    @Test
    public void minLong() {
        Long result = this.numServices.min(Long.valueOf(6L), Long.valueOf(3L));
        Assert.assertEquals((Object)3L, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void roundFloatNull() {
        this.numServices.round(null);
    }

    @Test
    public void roundFloat() {
        Integer result = this.numServices.round(Float.valueOf(3.64f));
        Assert.assertEquals((Object)4, (Object)result);
    }

    @Test
    public void roundLongNull() {
        Long result = this.numServices.round(null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void roundLong() {
        Long result = this.numServices.round(Long.valueOf(3L));
        Assert.assertEquals((Object)3L, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void divFloatNullNull() {
        this.numServices.div(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void divFloatFloatNull() {
        this.numServices.div(Float.valueOf(3.14f), null);
    }

    @Test(expected=NullPointerException.class)
    public void divFloatNullFloat() {
        this.numServices.div(null, Float.valueOf(3.14f));
    }

    @Test(expected=IllegalArgumentException.class)
    public void divFloatByZero() {
        Integer result = this.numServices.div(Float.valueOf(3.14f), Float.valueOf(0.0f));
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void divFloat() {
        Integer result = this.numServices.div(Float.valueOf(22.980001f), Float.valueOf(3.14f));
        Assert.assertEquals((Object)7, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void divLongNullNull() {
        this.numServices.div(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void divLongLongNull() {
        this.numServices.div(Long.valueOf(3L), null);
    }

    @Test(expected=NullPointerException.class)
    public void divLongNullLong() {
        this.numServices.div(null, Long.valueOf(3L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void divLongByZero() {
        Long result = this.numServices.div(Long.valueOf(3L), Long.valueOf(0L));
        Assert.assertEquals((Object)0L, (Object)result);
    }

    @Test
    public void divLong() {
        Long result = this.numServices.div(Long.valueOf(22L), Long.valueOf(3L));
        Assert.assertEquals((Object)7L, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void modFloatNullNull() {
        this.numServices.mod(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void modFloatFloatNull() {
        this.numServices.mod(Float.valueOf(3.14f), null);
    }

    @Test(expected=NullPointerException.class)
    public void modFloatNullFloat() {
        this.numServices.mod(null, Float.valueOf(3.14f));
    }

    @Test(expected=IllegalArgumentException.class)
    public void modFloatByZero() {
        Integer result = this.numServices.mod(Float.valueOf(3.14f), Float.valueOf(0.0f));
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void modFloat() {
        Integer result = this.numServices.mod(Float.valueOf(22.91f), Float.valueOf(3.13f));
        Assert.assertEquals((Object)1, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void modLongNullNull() {
        this.numServices.mod(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void modLongLongNull() {
        this.numServices.mod(Long.valueOf(3L), null);
    }

    @Test(expected=NullPointerException.class)
    public void modLongNullLong() {
        this.numServices.mod(null, Long.valueOf(3L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void modLongByZero() {
        Long result = this.numServices.mod(Long.valueOf(3L), Long.valueOf(0L));
        Assert.assertEquals((Object)0L, (Object)result);
    }

    @Test
    public void modLong() {
        Long result = this.numServices.mod(Long.valueOf(22L), Long.valueOf(3L));
        Assert.assertEquals((Object)1L, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void toDoubleIntegerNull() {
        this.numServices.toDouble(null);
    }

    @Test
    public void toDoubleInteger() {
        Double result = this.numServices.toDouble(Integer.valueOf(3));
        Assert.assertEquals((Object)3.0, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void toDoubleFloatNull() {
        this.numServices.toDouble(null);
    }

    @Test
    public void toDoubleFloat() {
        Double result = this.numServices.toDouble(Float.valueOf(3.14f));
        Assert.assertTrue((result - 3.14 < 0.001 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void toLongNull() {
        this.numServices.toLong(null);
    }

    @Test
    public void toLong() {
        Long result = this.numServices.toLong(Integer.valueOf(3));
        Assert.assertEquals((Object)3L, (Object)result);
    }
}

