/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.RootEObjectProvider;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.junit.Assert;
import org.junit.Test;

public class EObjectServicesValidationTest
extends AbstractServicesValidationTest {
    @Override
    public void before() throws Exception {
        super.before();
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), EObjectServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)services);
    }

    @Test
    public void testEAllContentsNoContainingEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifier=eCls1 doesn't contain any other EClass"))};
            IType[] expectedReturnAllTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling eAllContents:\nEClassifier=eCls1 doesn't contain any other EClass"))};
            this.assertValidation(expectedReturnTypes, expectedReturnAllTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEAllContentsFilteredSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContentsFilteredSetOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContents() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getETypeParameter())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStructuralFeature())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEGenericType())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnumLiteral())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEParameter()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContentsOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContentsFilteredNoContainingEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifier=eCls1 can't contain EClassifierLiteral=eCls2 direclty or indirectly"))};
            IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling eAllContents:\nEClassifier=eCls1 can't contain EClassifierLiteral=eCls2 direclty or indirectly"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEAllContentsFilteredEClassifierLiteral() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContentsFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContentsFilteredEClassifier() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getETypeParameter())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStructuralFeature())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEGenericType())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnumLiteral())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEParameter()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContentsFilteredLoweredByTypes() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getETypeParameter())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStructuralFeature())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnumLiteral())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEParameter()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContentsFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEAllContentsFilteredNoType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        EReference ref1 = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        ref1.setName("ref1");
        ref1.setContainment(true);
        ref1.setEType((EClassifier)eCls1);
        eCls1.getEStructuralFeatures().add((Object)ref1);
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifier=eCls1 can't contain EClassifierLiteral=eCls2 direclty or indirectly"))};
            IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling eAllContents:\nEClassifier=eCls1 can't contain EClassifierLiteral=eCls2 direclty or indirectly"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eAllContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEClass() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
            IType[] expectedReturnTypes = new IType[]{this.classType(EClass.class)};
            this.assertValidation(expectedReturnTypes, "eClass", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.nothingType("EClassifier=eCls1 can't be contained")};
            IType[] expectedAllReturnTypes = new IType[]{this.nothingType("Nothing will be left after calling eContainer:\nEClassifier=eCls1 can't be contained")};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEContainer() {
        IService service = this.serviceLookUp("eContainer", new Object[]{EcorePackage.eINSTANCE.eClass()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())};
            this.assertValidation(expectedReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerOnEStringToStringMapEntryBasicMapping() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())};
            this.assertNoService("eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerOnEStringToStringMapEntryCustomMapping() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            this.getQueryEnvironment().registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
            IType[] parameterTypes = new IType[]{new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())};
            this.assertValidation(expectedReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            this.assertValidation(expectedReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerFilteredNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls2), this.eClassifierLiteralType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.nothingType("EClassifierLiteral=eCls1 can't contain directly or indirectly EClassifier=eCls2")};
            IType[] expectedAllReturnTypes = new IType[]{this.nothingType("Nothing will be left after calling eContainer:\nEClassifierLiteral=eCls1 can't contain directly or indirectly EClassifier=eCls2")};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEContainerFiltered() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            this.assertValidation(expectedReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            this.assertValidation(expectedReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerFilteredLoweredByTypes() {
        IService service = this.serviceLookUp("eContainer", new Object[]{EcorePackage.eINSTANCE, EcorePackage.eINSTANCE.getEModelElement()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<Object> argTypes = new ArrayList<Object>();
        argTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        argTypes.add(new EClassifierLiteralType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getETypedElement()));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getETypedElement())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getETypedElement()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())};
            this.assertValidation(expectedReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            this.assertValidation(expectedReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerFilteredNoType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        EReference ref1 = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        ref1.setName("ref1");
        ref1.setContainment(true);
        ref1.setEType((EClassifier)eCls1);
        eCls1.getEStructuralFeatures().add((Object)ref1);
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.nothingType("EClassifierLiteral=eCls2 can't contain directly or indirectly EClassifier=eCls1")};
            IType[] expectedAllReturnTypes = new IType[]{this.nothingType("Nothing will be left after calling eContainer:\nEClassifierLiteral=eCls2 can't contain directly or indirectly EClassifier=eCls1")};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eContainer", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEContainerOrSelfFilteredNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls2), this.eClassifierLiteralType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.nothingType("EClassifierLiteral=eCls1 can't contain directly or indirectly EClassifier=eCls2")};
            IType[] expectedAllReturnTypes = new IType[]{this.nothingType("Nothing will be left after calling eContainerOrSelf:\nEClassifierLiteral=eCls1 can't contain directly or indirectly EClassifier=eCls2")};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eContainerOrSelf", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEContainerOrSelfFiltered() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            this.assertValidation(expectedReturnTypes, "eContainerOrSelf", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerOrSelfFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            this.assertValidation(expectedReturnTypes, "eContainerOrSelf", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerOrSelfFilteredLoweredByTypes() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getETypedElement())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getETypedElement()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())};
            this.assertValidation(expectedReturnTypes, "eContainerOrSelf", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerOrSelfFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            this.assertValidation(expectedReturnTypes, "eContainerOrSelf", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContainerOrSelfFilteredNoType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        EReference ref1 = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        ref1.setName("ref1");
        ref1.setContainment(true);
        ref1.setEType((EClassifier)eCls1);
        eCls1.getEStructuralFeatures().add((Object)ref1);
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.nothingType("EClassifierLiteral=eCls2 can't contain directly or indirectly EClassifier=eCls1")};
            IType[] expectedAllReturnTypes = new IType[]{this.nothingType("Nothing will be left after calling eContainerOrSelf:\nEClassifierLiteral=eCls2 can't contain directly or indirectly EClassifier=eCls1")};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eContainerOrSelf", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEContentsNoContainingEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifier=eCls1 doesn't contain any other EClass"))};
            IType[] expectedReturnAllTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling eContents:\nEClassifier=eCls1 doesn't contain any other EClass"))};
            this.assertValidation(expectedReturnTypes, expectedReturnAllTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEContents() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilteredNoContainingEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifier=eCls1 can't contain EClassifierLiteral=eCls2 direclty"))};
            IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling eContents:\nEClassifier=eCls1 can't contain EClassifierLiteral=eCls2 direclty"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEContentsFiltered() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilteredSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilterEClass() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilterSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilteredSetOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilteredLoweredByTypes() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEContentsFilteredNoType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        EReference ref1 = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        ref1.setName("ref1");
        ref1.setContainment(true);
        ref1.setEType((EClassifier)eCls1);
        eCls1.getEStructuralFeatures().add((Object)ref1);
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifier=eCls1 can't contain EClassifierLiteral=eCls2 direclty"))};
            IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling eContents:\nEClassifier=eCls1 can't contain EClassifierLiteral=eCls2 direclty"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eContents", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEInverseFeatureNameEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.classType(String.class)};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "eInverse", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEInverseFiltered() {
        IService service = this.serviceLookUp("eInverse", new Object[]{EcorePackage.eINSTANCE, EcorePackage.eINSTANCE.eClass()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<Object> argTypes = new ArrayList<Object>();
        argTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        argTypes.add(new EClassifierLiteralType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
            this.assertValidation(expectedReturnTypes, "eInverse", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEInverseFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEEnum())};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnum()))};
            this.assertValidation(expectedReturnTypes, "eInverse", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEInverseFilteredLoweredByTypes() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEFactory())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation()))};
            this.assertValidation(expectedReturnTypes, "eInverse", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEInverseOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "eInverse", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEInverseFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEEnum())};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnum()))};
            this.assertValidation(expectedReturnTypes, "eInverse", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testEInverseFilteredNoType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEOperation())};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.nothingType("EClassifier=EPackage don't have inverse to EClassifierLiteral=EOperation"))};
            IType[] expectedAllReturnTypes = new IType[]{this.setType((IType)this.nothingType("Nothing will be left after calling eInverse:\nEClassifier=EPackage don't have inverse to EClassifierLiteral=EOperation"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "eInverse", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAllInstancesNoRootProviderEClassLiteral() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEAttribute())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("No IRootEObjectProvider registered"))};
            IType[] expectedReturnAllTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling allInstances:\nNo IRootEObjectProvider registered"))};
            this.assertValidation(expectedReturnTypes, expectedReturnAllTypes, "allInstances", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAllInstancesNoRootProviderEClass() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("No IRootEObjectProvider registered"))};
            IType[] expectedReturnAllTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling allInstances:\nNo IRootEObjectProvider registered"))};
            this.assertValidation(expectedReturnTypes, expectedReturnAllTypes, "allInstances", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAllInstancesNoRootProviderEClassSetLiteral() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEAttribute(), EcorePackage.eINSTANCE.getEReference()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("No IRootEObjectProvider registered"))};
            IType[] expectedReturnAllTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling allInstances:\nNo IRootEObjectProvider registered"))};
            this.assertValidation(expectedReturnTypes, expectedReturnAllTypes, "allInstances", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAllInstancesNoRootProviderSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("No IRootEObjectProvider registered"))};
            IType[] expectedReturnAllTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling allInstances:\nNo IRootEObjectProvider registered"))};
            this.assertValidation(expectedReturnTypes, expectedReturnAllTypes, "allInstances", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAllInstancesEClassLiteral() {
        try {
            this.setQueryEnvironment(Query.newEnvironmentWithDefaultServices(null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE})));
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEAttribute())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAttribute()))};
            this.assertValidation(expectedReturnTypes, "allInstances", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAllInstancesEClass() {
        try {
            this.setQueryEnvironment(Query.newEnvironmentWithDefaultServices(null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE})));
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(EObject.class))};
            this.assertValidation(expectedReturnTypes, "allInstances", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAllInstancesEClassSetLiteral() {
        try {
            this.setQueryEnvironment(Query.newEnvironmentWithDefaultServices(null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE})));
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEAttribute(), EcorePackage.eINSTANCE.getEReference()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAttribute())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEReference()))};
            this.assertValidation(expectedReturnTypes, "allInstances", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAllInstancesSet() {
        try {
            this.setQueryEnvironment(Query.newEnvironmentWithDefaultServices(null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE})));
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(EObject.class))};
            this.assertValidation(expectedReturnTypes, "allInstances", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }
}

