/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.acceleo.query.parser.tests.ValidationTest;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.IType;
import org.junit.Assert;
import org.junit.Test;

public class ComparableServicesAstValidationTest
extends AbstractServicesValidationTest {
    @Test
    public void testGreaterThanNullNull() {
        IValidationResult validationResult = this.validate("null > null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing > null", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testGreaterThanNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null > nothing", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testGreaterThanNullComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("null > comparable", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanComparableNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable > null", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanComparableComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable > comparable", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanEqualNullNull() {
        IValidationResult validationResult = this.validate("null >= null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanEqualNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing >= null", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testGreaterThanEqualNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null >= nothing", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testGreaterThanEqualNullComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("null >= comparable", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanEqualComparableNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable >= null", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanEqualComparableComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable >= comparable", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanNullNull() {
        IValidationResult validationResult = this.validate("null < null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing < null", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testLessThanNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null < nothing", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testLessThanNullComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("null < comparable", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanComparableNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable < null", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanComparableComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable < comparable", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanEqualNullNull() {
        IValidationResult validationResult = this.validate("null <= null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanEqualNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing <= null", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testLessThanEqualNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null <= nothing", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testLessThanEqualNullComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("null <= comparable", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanEqualComparableNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable <= null", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanEqualComparableComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable <= comparable", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }
}

