/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.parser.AstEvaluator;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.LambdaValue;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.impl.QueryEvaluationEngine;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.tests.ComparableServicesTest;
import org.eclipse.acceleo.query.tests.Setup;
import org.eclipse.acceleo.query.tests.UnitTestModels;
import org.eclipse.acceleo.query.tests.anydsl.AnydslFactory;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.tests.anydsl.Food;
import org.eclipse.acceleo.query.tests.anydsl.ProductionCompany;
import org.eclipse.acceleo.query.tests.anydsl.Restaurant;
import org.eclipse.acceleo.query.tests.anydsl.World;
import org.eclipse.acceleo.query.tests.qmodel.Query;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollectionServicesTest {
    CollectionServices collectionServices;

    @Before
    public void setup() {
        this.collectionServices = new CollectionServices();
    }

    @Test
    public void testConcatListList() {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.concat((List)list1, (Collection)list2).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        list1.add(obj1);
        list1.add(obj2);
        list2.add(obj3);
        List list3 = this.collectionServices.concat((List)list1, (Collection)list2);
        Assert.assertEquals((long)3L, (long)list3.size());
        Assert.assertEquals((Object)obj1, list3.get(0));
        Assert.assertEquals((Object)obj2, list3.get(1));
        Assert.assertEquals((Object)obj3, list3.get(2));
    }

    @Test
    public void testConcatListSet() {
        ArrayList list = Lists.newArrayList();
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.concat((List)list, (Collection)set).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        list.add(obj1);
        list.add(obj2);
        set.add(obj3);
        List list3 = this.collectionServices.concat((List)list, (Collection)set);
        Assert.assertEquals((long)3L, (long)list3.size());
        Assert.assertEquals((Object)obj1, list3.get(0));
        Assert.assertEquals((Object)obj2, list3.get(1));
        Assert.assertEquals((Object)obj3, list3.get(2));
    }

    @Test
    public void testConcatListListDifferentTypes() {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.concat((List)list1, (Collection)list2).size());
        list1.add("a");
        list1.add("b");
        list2.add(1);
        List list3 = this.collectionServices.concat((List)list1, (Collection)list2);
        Assert.assertEquals((long)3L, (long)list3.size());
        Assert.assertEquals((Object)"a", list3.get(0));
        Assert.assertEquals((Object)"b", list3.get(1));
        Assert.assertEquals((Object)1, list3.get(2));
    }

    @Test
    public void testConcatListSetDifferentTypes() {
        ArrayList list = Lists.newArrayList();
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.concat((List)list, (Collection)set).size());
        list.add("a");
        list.add("b");
        set.add(1);
        List list3 = this.collectionServices.concat((List)list, (Collection)set);
        Assert.assertEquals((long)3L, (long)list3.size());
        Assert.assertEquals((Object)"a", list3.get(0));
        Assert.assertEquals((Object)"b", list3.get(1));
        Assert.assertEquals((Object)1, list3.get(2));
    }

    @Test(expected=NullPointerException.class)
    public void testConcatListNull() {
        ArrayList list = Lists.newArrayList();
        this.collectionServices.concat((List)list, null);
    }

    @Test(expected=NullPointerException.class)
    public void testConcatNullList() {
        ArrayList list = Lists.newArrayList();
        this.collectionServices.concat((List)list, null);
    }

    @Test
    public void testConcatListsWithDuplicates() {
        ArrayList list1 = Lists.newArrayList();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        list1.add("c");
        list1.add("c");
        ArrayList list2 = Lists.newArrayList();
        list2.add("c");
        list2.add("b");
        list2.add("a");
        List result = this.collectionServices.concat((List)list1, (Collection)list2);
        Assert.assertEquals((long)8L, (long)result.size());
        Assert.assertEquals((Object)"a", result.get(0));
        Assert.assertEquals((Object)"b", result.get(1));
        Assert.assertEquals((Object)"c", result.get(2));
        Assert.assertEquals((Object)"c", result.get(3));
        Assert.assertEquals((Object)"c", result.get(4));
        Assert.assertEquals((Object)"c", result.get(5));
        Assert.assertEquals((Object)"b", result.get(6));
        Assert.assertEquals((Object)"a", result.get(7));
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add("c");
        set1.add("b");
        set1.add("a");
        List result2 = this.collectionServices.concat((List)list1, (Collection)set1);
        Assert.assertEquals((long)8L, (long)result2.size());
        Assert.assertEquals((Object)"a", result2.get(0));
        Assert.assertEquals((Object)"b", result2.get(1));
        Assert.assertEquals((Object)"c", result2.get(2));
        Assert.assertEquals((Object)"c", result2.get(3));
        Assert.assertEquals((Object)"c", result2.get(4));
        Assert.assertEquals((Object)"c", result2.get(5));
        Assert.assertEquals((Object)"b", result2.get(6));
        Assert.assertEquals((Object)"a", result2.get(7));
    }

    @Test
    public void testConcatSetList() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.concat((Set)set, (Collection)list).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        set.add(obj1);
        set.add(obj2);
        list.add(obj3);
        Set res = this.collectionServices.concat((Set)set, (Collection)list);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
        Assert.assertEquals((Object)obj2, itr.next());
        Assert.assertEquals((Object)obj3, itr.next());
    }

    @Test
    public void testConcatSetSet() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.concat((Set)set1, (Collection)set2).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        set1.add(obj1);
        set1.add(obj2);
        set2.add(obj3);
        Set res = this.collectionServices.concat((Set)set1, (Collection)set2);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
        Assert.assertEquals((Object)obj2, itr.next());
        Assert.assertEquals((Object)obj3, itr.next());
    }

    @Test
    public void testConcatSetListDifferentTypes() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.concat((Set)set, (Collection)list).size());
        set.add("a");
        set.add("b");
        list.add(1);
        Set res = this.collectionServices.concat((Set)set, (Collection)list);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)"a", itr.next());
        Assert.assertEquals((Object)"b", itr.next());
        Assert.assertEquals((Object)1, itr.next());
    }

    @Test
    public void testConcatSetSetDifferentTypes() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.concat((Set)set1, (Collection)set2).size());
        set1.add("a");
        set1.add("b");
        set2.add(1);
        Set res = this.collectionServices.concat((Set)set1, (Collection)set2);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)"a", itr.next());
        Assert.assertEquals((Object)"b", itr.next());
        Assert.assertEquals((Object)1, itr.next());
    }

    @Test(expected=NullPointerException.class)
    public void testConcatSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        this.collectionServices.concat((Set)set, null);
    }

    @Test(expected=NullPointerException.class)
    public void testConcatNullSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        this.collectionServices.concat((Set)set, null);
    }

    @Test
    public void testConcatSetsWithDuplicates() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add("a");
        set1.add("b");
        set1.add("c");
        set1.add("d");
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        set2.add("e");
        set2.add("d");
        set2.add("c");
        set2.add("b");
        Set result = this.collectionServices.concat((Set)set1, (Collection)set2);
        Assert.assertEquals((long)5L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)"a", itr.next());
        Assert.assertEquals((Object)"b", itr.next());
        Assert.assertEquals((Object)"c", itr.next());
        Assert.assertEquals((Object)"d", itr.next());
        Assert.assertEquals((Object)"e", itr.next());
        ArrayList list1 = Lists.newArrayList();
        list1.add("e");
        list1.add("d");
        list1.add("c");
        list1.add("b");
        Set result2 = this.collectionServices.concat((Set)set1, (Collection)list1);
        Assert.assertEquals((long)5L, (long)result2.size());
        Iterator itr2 = result2.iterator();
        Assert.assertEquals((Object)"a", itr2.next());
        Assert.assertEquals((Object)"b", itr2.next());
        Assert.assertEquals((Object)"c", itr2.next());
        Assert.assertEquals((Object)"d", itr2.next());
        Assert.assertEquals((Object)"e", itr2.next());
    }

    @Test
    public void testUnionListList() {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.union((List)list1, (List)list2).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        list1.add(obj1);
        list1.add(obj2);
        list2.add(obj3);
        List list3 = this.collectionServices.concat((List)list1, (Collection)list2);
        Assert.assertEquals((long)3L, (long)list3.size());
        Assert.assertEquals((Object)obj1, list3.get(0));
        Assert.assertEquals((Object)obj2, list3.get(1));
        Assert.assertEquals((Object)obj3, list3.get(2));
    }

    @Test
    public void testUnionListListDifferentTypes() {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.union((List)list1, (List)list2).size());
        list1.add("a");
        list1.add("b");
        list2.add(1);
        List list3 = this.collectionServices.union((List)list1, (List)list2);
        Assert.assertEquals((long)3L, (long)list3.size());
        Assert.assertEquals((Object)"a", list3.get(0));
        Assert.assertEquals((Object)"b", list3.get(1));
        Assert.assertEquals((Object)1, list3.get(2));
    }

    @Test(expected=NullPointerException.class)
    public void testUnionListNull() {
        ArrayList list = Lists.newArrayList();
        this.collectionServices.union((List)list, null);
    }

    @Test(expected=NullPointerException.class)
    public void testUnionNullList() {
        ArrayList list = Lists.newArrayList();
        this.collectionServices.union((List)list, null);
    }

    @Test
    public void testUnionListsWithDuplicates() {
        ArrayList list1 = Lists.newArrayList();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        list1.add("c");
        list1.add("c");
        ArrayList list2 = Lists.newArrayList();
        list2.add("c");
        list2.add("b");
        list2.add("a");
        List result = this.collectionServices.union((List)list1, (List)list2);
        Assert.assertEquals((long)8L, (long)result.size());
        Assert.assertEquals((Object)"a", result.get(0));
        Assert.assertEquals((Object)"b", result.get(1));
        Assert.assertEquals((Object)"c", result.get(2));
        Assert.assertEquals((Object)"c", result.get(3));
        Assert.assertEquals((Object)"c", result.get(4));
        Assert.assertEquals((Object)"c", result.get(5));
        Assert.assertEquals((Object)"b", result.get(6));
        Assert.assertEquals((Object)"a", result.get(7));
    }

    @Test
    public void testUnionSetSet() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.union((Set)set1, (Set)set2).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        set1.add(obj1);
        set1.add(obj2);
        set2.add(obj3);
        Set res = this.collectionServices.union((Set)set1, (Set)set2);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
        Assert.assertEquals((Object)obj2, itr.next());
        Assert.assertEquals((Object)obj3, itr.next());
    }

    @Test
    public void testUnionSetSetDifferentTypes() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.union((Set)set1, (Set)set2).size());
        set1.add("a");
        set1.add("b");
        set2.add(1);
        Set res = this.collectionServices.union((Set)set1, (Set)set2);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)"a", itr.next());
        Assert.assertEquals((Object)"b", itr.next());
        Assert.assertEquals((Object)1, itr.next());
    }

    @Test(expected=NullPointerException.class)
    public void testUnionSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        this.collectionServices.union((Set)set, null);
    }

    @Test(expected=NullPointerException.class)
    public void testUnionNullSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        this.collectionServices.union((Set)set, null);
    }

    @Test
    public void testUnionSetsWithDuplicates() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add("a");
        set1.add("b");
        set1.add("c");
        set1.add("d");
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        set2.add("e");
        set2.add("d");
        set2.add("c");
        set2.add("b");
        Set result = this.collectionServices.union((Set)set1, (Set)set2);
        Assert.assertEquals((long)5L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)"a", itr.next());
        Assert.assertEquals((Object)"b", itr.next());
        Assert.assertEquals((Object)"c", itr.next());
        Assert.assertEquals((Object)"d", itr.next());
        Assert.assertEquals((Object)"e", itr.next());
    }

    @Test
    public void testAddListList() {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.add((List)list1, (Collection)list2).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        list1.add(obj1);
        list1.add(obj2);
        list2.add(obj3);
        List res = this.collectionServices.add((List)list1, (Collection)list2);
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertEquals((Object)obj1, res.get(0));
        Assert.assertEquals((Object)obj2, res.get(1));
        Assert.assertEquals((Object)obj3, res.get(2));
    }

    @Test
    public void testAddListSet() {
        ArrayList list = Lists.newArrayList();
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.add((List)list, (Collection)set).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        list.add(obj1);
        list.add(obj2);
        set.add(obj3);
        List res = this.collectionServices.add((List)list, (Collection)set);
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertEquals((Object)obj1, res.get(0));
        Assert.assertEquals((Object)obj2, res.get(1));
        Assert.assertEquals((Object)obj3, res.get(2));
    }

    @Test
    public void testAddListListDifferentTypes() {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.add((List)list1, (Collection)list2).size());
        list1.add("a");
        list1.add("b");
        list2.add(1);
        List res = this.collectionServices.add((List)list1, (Collection)list2);
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertEquals((Object)"a", res.get(0));
        Assert.assertEquals((Object)"b", res.get(1));
        Assert.assertEquals((Object)1, res.get(2));
    }

    @Test
    public void testAddListSetDifferentTypes() {
        ArrayList list = Lists.newArrayList();
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.add((List)list, (Collection)set).size());
        list.add("a");
        list.add("b");
        set.add(1);
        List res = this.collectionServices.add((List)list, (Collection)set);
        Assert.assertEquals((long)3L, (long)res.size());
        Assert.assertEquals((Object)"a", res.get(0));
        Assert.assertEquals((Object)"b", res.get(1));
        Assert.assertEquals((Object)1, res.get(2));
    }

    @Test(expected=NullPointerException.class)
    public void testAddListNull() {
        ArrayList list = Lists.newArrayList();
        this.collectionServices.add((List)list, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddNullList() {
        ArrayList list = Lists.newArrayList();
        this.collectionServices.add(null, (Collection)list);
    }

    @Test
    public void testAddListWithDuplicates() {
        ArrayList list1 = Lists.newArrayList();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        list1.add("c");
        list1.add("c");
        ArrayList list2 = Lists.newArrayList();
        list2.add("c");
        list2.add("b");
        list2.add("a");
        List result = this.collectionServices.add((List)list1, (Collection)list2);
        Assert.assertEquals((long)8L, (long)result.size());
        Assert.assertEquals((Object)"a", result.get(0));
        Assert.assertEquals((Object)"b", result.get(1));
        Assert.assertEquals((Object)"c", result.get(2));
        Assert.assertEquals((Object)"c", result.get(3));
        Assert.assertEquals((Object)"c", result.get(4));
        Assert.assertEquals((Object)"c", result.get(5));
        Assert.assertEquals((Object)"b", result.get(6));
        Assert.assertEquals((Object)"a", result.get(7));
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add("c");
        set1.add("b");
        set1.add("a");
        List result2 = this.collectionServices.add((List)list1, (Collection)set1);
        Assert.assertEquals((long)8L, (long)result2.size());
        Assert.assertEquals((Object)"a", result2.get(0));
        Assert.assertEquals((Object)"b", result2.get(1));
        Assert.assertEquals((Object)"c", result2.get(2));
        Assert.assertEquals((Object)"c", result2.get(3));
        Assert.assertEquals((Object)"c", result2.get(4));
        Assert.assertEquals((Object)"c", result2.get(5));
        Assert.assertEquals((Object)"b", result2.get(6));
        Assert.assertEquals((Object)"a", result2.get(7));
    }

    @Test
    public void testAddSetList() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.add((Set)set, (Collection)list).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        set.add(obj1);
        set.add(obj2);
        list.add(obj3);
        Set res = this.collectionServices.add((Set)set, (Collection)list);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
        Assert.assertEquals((Object)obj2, itr.next());
        Assert.assertEquals((Object)obj3, itr.next());
    }

    @Test
    public void testAddSetSet() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.add((Set)set1, (Collection)set2).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        set1.add(obj1);
        set1.add(obj2);
        set2.add(obj3);
        Set res = this.collectionServices.add((Set)set1, (Collection)set2);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
        Assert.assertEquals((Object)obj2, itr.next());
        Assert.assertEquals((Object)obj3, itr.next());
    }

    @Test
    public void testAddSetListDifferentTypes() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.add((Set)set, (Collection)list).size());
        set.add("a");
        set.add("b");
        list.add(1);
        Set res = this.collectionServices.add((Set)set, (Collection)list);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)"a", itr.next());
        Assert.assertEquals((Object)"b", itr.next());
        Assert.assertEquals((Object)1, itr.next());
    }

    @Test
    public void testAddSetSetDifferentTypes() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.add((Set)set1, (Collection)set2).size());
        set1.add("a");
        set1.add("b");
        set2.add(1);
        Set res = this.collectionServices.add((Set)set1, (Collection)set2);
        Assert.assertEquals((long)3L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)"a", itr.next());
        Assert.assertEquals((Object)"b", itr.next());
        Assert.assertEquals((Object)1, itr.next());
    }

    @Test(expected=NullPointerException.class)
    public void testAddSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        this.collectionServices.add((Set)set, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAddNullSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        this.collectionServices.add(null, (Collection)set);
    }

    @Test
    public void testAddSetWithDuplicates() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add("a");
        set1.add("b");
        set1.add("c");
        set1.add("d");
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        set2.add("e");
        set2.add("d");
        set2.add("c");
        set2.add("b");
        Set result = this.collectionServices.concat((Set)set1, (Collection)set2);
        Assert.assertEquals((long)5L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)"a", itr.next());
        Assert.assertEquals((Object)"b", itr.next());
        Assert.assertEquals((Object)"c", itr.next());
        Assert.assertEquals((Object)"d", itr.next());
        Assert.assertEquals((Object)"e", itr.next());
        ArrayList list1 = Lists.newArrayList();
        list1.add("e");
        list1.add("d");
        list1.add("c");
        list1.add("b");
        Set result2 = this.collectionServices.concat((Set)set1, (Collection)list1);
        Assert.assertEquals((long)5L, (long)result2.size());
        Iterator itr2 = result2.iterator();
        Assert.assertEquals((Object)"a", itr2.next());
        Assert.assertEquals((Object)"b", itr2.next());
        Assert.assertEquals((Object)"c", itr2.next());
        Assert.assertEquals((Object)"d", itr2.next());
        Assert.assertEquals((Object)"e", itr2.next());
    }

    @Test
    public void testSubListList() {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.sub((List)list1, (Collection)list2).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        list1.add(obj1);
        list1.add(obj2);
        List list3 = this.collectionServices.sub((List)list1, (Collection)list2);
        Assert.assertEquals((long)2L, (long)list3.size());
        Assert.assertEquals((Object)obj1, list3.get(0));
        Assert.assertEquals((Object)obj2, list3.get(1));
        list2.add(obj2);
        list2.add(obj3);
        list3 = this.collectionServices.sub((List)list1, (Collection)list2);
        Assert.assertEquals((long)1L, (long)list3.size());
        Assert.assertEquals((Object)obj1, list3.get(0));
    }

    @Test
    public void testSubListSet() {
        ArrayList list = Lists.newArrayList();
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.sub((List)list, (Collection)set).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        list.add(obj1);
        list.add(obj2);
        List list3 = this.collectionServices.sub((List)list, (Collection)set);
        Assert.assertEquals((long)2L, (long)list3.size());
        Assert.assertEquals((Object)obj1, list3.get(0));
        Assert.assertEquals((Object)obj2, list3.get(1));
        set.add(obj2);
        set.add(obj3);
        list3 = this.collectionServices.sub((List)list, (Collection)set);
        Assert.assertEquals((long)1L, (long)list3.size());
        Assert.assertEquals((Object)obj1, list3.get(0));
    }

    @Test
    public void testSubListListDifferentTypes() {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.sub((List)list1, (Collection)list2).size());
        list1.add(1);
        list1.add(2.0);
        List list3 = this.collectionServices.sub((List)list1, (Collection)list2);
        Assert.assertEquals((long)2L, (long)list3.size());
        Assert.assertEquals((Object)1, list3.get(0));
        Assert.assertEquals((Object)2.0, list3.get(1));
        list2.add(1);
        list2.add(2);
        list3 = this.collectionServices.sub((List)list1, (Collection)list2);
        Assert.assertEquals((long)1L, (long)list3.size());
        Assert.assertEquals((Object)2.0, list3.get(0));
    }

    @Test
    public void testSubListSetDifferentTypes() {
        ArrayList list = Lists.newArrayList();
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.sub((List)list, (Collection)set).size());
        list.add(1);
        list.add(2.0);
        List list3 = this.collectionServices.sub((List)list, (Collection)set);
        Assert.assertEquals((long)2L, (long)list3.size());
        Assert.assertEquals((Object)1, list3.get(0));
        Assert.assertEquals((Object)2.0, list3.get(1));
        set.add(1);
        set.add(2);
        list3 = this.collectionServices.sub((List)list, (Collection)set);
        Assert.assertEquals((long)1L, (long)list3.size());
        Assert.assertEquals((Object)2.0, list3.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void testSubListNull() {
        ArrayList list = Lists.newArrayList();
        list.add(new Object());
        this.collectionServices.sub((List)list, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubNullList() {
        ArrayList list = Lists.newArrayList();
        list.add(new Object());
        this.collectionServices.sub(null, (Collection)list);
    }

    @Test(expected=NullPointerException.class)
    public void testSubListNullEmptyList() {
        ArrayList list = Lists.newArrayList();
        this.collectionServices.sub((List)list, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubNullListEmptyList() {
        ArrayList list = Lists.newArrayList();
        this.collectionServices.sub(null, (Collection)list);
    }

    @Test
    public void testSubListWithDuplicates() {
        ArrayList list1 = Lists.newArrayList();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        list1.add("c");
        list1.add("c");
        ArrayList list2 = Lists.newArrayList();
        list2.add("c");
        List result = this.collectionServices.sub((List)list1, (Collection)list2);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"a", result.get(0));
        Assert.assertEquals((Object)"b", result.get(1));
    }

    @Test
    public void testSubSetList() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.sub((Set)set, (Collection)list).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        set.add(obj1);
        set.add(obj2);
        Set res = this.collectionServices.sub((Set)set, (Collection)list);
        Assert.assertEquals((long)2L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
        Assert.assertEquals((Object)obj2, itr.next());
        list.add(obj2);
        list.add(obj3);
        res = this.collectionServices.sub((Set)set, (Collection)list);
        Assert.assertEquals((long)1L, (long)res.size());
        itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
    }

    @Test
    public void testSubSetSet() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.sub((Set)set1, (Collection)set2).size());
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object obj3 = new Object();
        set1.add(obj1);
        set1.add(obj2);
        Set res = this.collectionServices.sub((Set)set1, (Collection)set2);
        Assert.assertEquals((long)2L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
        Assert.assertEquals((Object)obj2, itr.next());
        set2.add(obj2);
        set2.add(obj3);
        res = this.collectionServices.sub((Set)set1, (Collection)set2);
        Assert.assertEquals((long)1L, (long)res.size());
        itr = res.iterator();
        Assert.assertEquals((Object)obj1, itr.next());
    }

    @Test
    public void testSubSetListDifferentTypes() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.sub((Set)set, (Collection)list).size());
        set.add(1);
        set.add(2.0);
        Set res = this.collectionServices.sub((Set)set, (Collection)list);
        Assert.assertEquals((long)2L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals((Object)2.0, itr.next());
        list.add(1);
        list.add(2);
        res = this.collectionServices.sub((Set)set, (Collection)list);
        Assert.assertEquals((long)1L, (long)res.size());
        itr = res.iterator();
        Assert.assertEquals((Object)2.0, itr.next());
    }

    @Test
    public void testSubSetSetDifferentTypes() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.sub((Set)set1, (Collection)set2).size());
        set1.add(1);
        set1.add(2.0);
        Set res = this.collectionServices.sub((Set)set1, (Collection)set2);
        Assert.assertEquals((long)2L, (long)res.size());
        Iterator itr = res.iterator();
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals((Object)2.0, itr.next());
        set2.add(1);
        set2.add(2);
        res = this.collectionServices.sub((Set)set1, (Collection)set2);
        Assert.assertEquals((long)1L, (long)res.size());
        itr = res.iterator();
        Assert.assertEquals((Object)2.0, itr.next());
    }

    @Test(expected=NullPointerException.class)
    public void testSubSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        this.collectionServices.sub((Set)set, null);
    }

    @Test(expected=NullPointerException.class)
    public void testSubNullSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        this.collectionServices.sub(null, (Collection)set);
    }

    @Test
    public void testIncludingList() {
        ArrayList list = Lists.newArrayList();
        Object elt = new Object();
        list.add(elt);
        Object elt2 = new Object();
        List result = this.collectionServices.including((List)list, elt2);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals(result.get(0), (Object)elt);
        Assert.assertEquals(result.get(1), (Object)elt2);
        result = this.collectionServices.including((List)list, elt);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals(result.get(0), (Object)elt);
        Assert.assertEquals(result.get(1), (Object)elt);
    }

    @Test
    public void testIncludingListNull() {
        ArrayList list = Lists.newArrayList();
        Object elt = new Object();
        list.add(elt);
        List result = this.collectionServices.including((List)list, null);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals(result.get(0), (Object)elt);
        Assert.assertEquals(result.get(1), null);
    }

    @Test
    public void testIncludingSet() {
        HashSet<Object> set = new HashSet<Object>();
        Object elt = new Object();
        set.add(elt);
        Object elt2 = new Object();
        Set result = this.collectionServices.including(set, elt2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)elt, itr.next());
        Assert.assertEquals((Object)elt2, itr.next());
        result = this.collectionServices.including(set, elt);
        Assert.assertEquals(set, (Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(elt));
    }

    @Test
    public void testIncludingSetNull() {
        HashSet<Object> set = new HashSet<Object>();
        Object elt = new Object();
        set.add(elt);
        Set result = this.collectionServices.including(set, null);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)elt, itr.next());
        Assert.assertEquals(null, itr.next());
    }

    @Test
    public void testExcludingList() {
        ArrayList list = Lists.newArrayList();
        Object elt = new Object();
        Object elt2 = new Object();
        list.add(elt);
        list.add(elt2);
        List result = this.collectionServices.excluding((List)list, elt2);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertFalse((boolean)result.contains(elt2));
        Assert.assertEquals((Object)elt, result.get(0));
        list = Lists.newArrayList();
        list.add(elt);
        result = this.collectionServices.excluding((List)list, elt2);
        Assert.assertEquals((Object)list, (Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)elt, result.get(0));
    }

    @Test
    public void testExcludingListNull() {
        ArrayList list = Lists.newArrayList();
        Object elt = new Object();
        list.add(elt);
        list.add(null);
        List result = this.collectionServices.excluding((List)list, null);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertFalse((boolean)result.contains(null));
        Assert.assertEquals((Object)elt, result.get(0));
        list = Lists.newArrayList();
        list.add(elt);
        result = this.collectionServices.excluding((List)list, null);
        Assert.assertEquals((Object)list, (Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)elt, result.get(0));
    }

    @Test
    public void testExcludingWithDuplicates() {
        ArrayList<String> list = new ArrayList<String>();
        String a = "a";
        String b = "b";
        String c = "c";
        list.add(a);
        list.add(b);
        list.add(c);
        list.add(b);
        List result = this.collectionServices.excluding(list, (Object)b);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertFalse((boolean)result.contains(b));
        Assert.assertEquals((Object)a, result.get(0));
        Assert.assertEquals((Object)c, result.get(1));
    }

    @Test
    public void testExcludingSet() {
        HashSet<Object> set = new HashSet<Object>();
        Object elt = new Object();
        Object elt2 = new Object();
        set.add(elt);
        set.add(elt2);
        Set result = this.collectionServices.excluding(set, elt2);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertFalse((boolean)result.contains(elt2));
        Assert.assertTrue((boolean)result.contains(elt));
        set = new HashSet();
        set.add(elt);
        result = this.collectionServices.excluding(set, elt2);
        Assert.assertEquals(set, (Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(elt));
        set = new HashSet();
        Assert.assertEquals((long)0L, (long)this.collectionServices.excluding(set, null).size());
    }

    @Test
    public void testExcludingSetNull() {
        HashSet<Object> set = new HashSet<Object>();
        Object elt = new Object();
        set.add(elt);
        set.add(null);
        Set result = this.collectionServices.excluding(set, null);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertFalse((boolean)result.contains(null));
        Assert.assertTrue((boolean)result.contains(elt));
        set = new HashSet();
        set.add(elt);
        result = this.collectionServices.excluding(set, null);
        Assert.assertEquals(set, (Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(elt));
    }

    @Test
    public void testReverseList() {
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.reverse((List)list).size());
        Object elt = new Object();
        Object elt2 = new Object();
        list.add(elt);
        list.add(elt);
        list.add(elt2);
        list.add(elt);
        Assert.assertEquals((long)4L, (long)this.collectionServices.reverse((List)list).size());
        List result = this.collectionServices.reverse((List)list);
        Assert.assertSame((Object)elt, result.get(0));
        Assert.assertSame((Object)elt2, result.get(1));
        Assert.assertSame((Object)elt, result.get(2));
        Assert.assertSame((Object)elt, result.get(3));
        Object elt3 = new Object();
        list.add(elt3);
        result = this.collectionServices.reverse((List)list);
        Assert.assertSame((Object)elt3, result.get(0));
        Assert.assertSame((Object)elt, result.get(1));
        Assert.assertSame((Object)elt2, result.get(2));
        Assert.assertSame((Object)elt, result.get(3));
        Assert.assertSame((Object)elt, result.get(4));
    }

    @Test
    public void testReverseListCopy() {
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((long)0L, (long)this.collectionServices.reverse((List)list).size());
        Object elt = new Object();
        Object elt2 = new Object();
        list.add(elt);
        list.add(elt);
        list.add(elt2);
        list.add(elt);
        List result = this.collectionServices.reverse((List)list);
        list.remove(elt2);
        Assert.assertTrue((boolean)result.contains(elt2));
    }

    @Test
    public void testReverseSet() {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        Assert.assertEquals((long)0L, (long)this.collectionServices.reverse(set).size());
        Object elt = new Object();
        Object elt2 = new Object();
        set.add(elt);
        set.add(elt2);
        Assert.assertEquals((long)2L, (long)this.collectionServices.reverse(set).size());
        Iterator iterator = this.collectionServices.reverse(set).iterator();
        Assert.assertSame((Object)elt2, iterator.next());
        Assert.assertSame((Object)elt, iterator.next());
        Object elt3 = new Object();
        set.add(elt3);
        iterator = this.collectionServices.reverse(set).iterator();
        Assert.assertSame((Object)elt3, iterator.next());
        Assert.assertSame((Object)elt2, iterator.next());
        Assert.assertSame((Object)elt, iterator.next());
    }

    @Test
    public void testIsEmptyList() {
        Assert.assertTrue((boolean)this.collectionServices.isEmpty((Collection)Lists.newArrayList()));
        Assert.assertFalse((boolean)this.collectionServices.isEmpty((Collection)ImmutableList.of((Object)new Object())));
    }

    @Test
    public void testIsEmptySet() {
        Assert.assertTrue((boolean)this.collectionServices.isEmpty((Collection)Sets.newLinkedHashSet()));
        Assert.assertFalse((boolean)this.collectionServices.isEmpty((Collection)ImmutableSet.of((Object)new Object())));
    }

    @Test
    public void testNotEmptyList() {
        ArrayList list = Lists.newArrayList();
        Assert.assertFalse((boolean)this.collectionServices.notEmpty((Collection)list));
        list.add(new Object());
        Assert.assertTrue((boolean)this.collectionServices.notEmpty((Collection)list));
    }

    @Test
    public void testNotEmptySet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertFalse((boolean)this.collectionServices.notEmpty((Collection)set));
        set.add(new Object());
        Assert.assertTrue((boolean)this.collectionServices.notEmpty((Collection)set));
    }

    @Test
    public void testFirstList() {
        ArrayList list = Lists.newArrayList();
        Object elt = new Object();
        list.add(elt);
        list.add(new Object());
        Assert.assertEquals((Object)elt, (Object)this.collectionServices.first((Collection)list));
    }

    @Test
    public void testFirstEmptyList() {
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals(null, (Object)this.collectionServices.first((Collection)list));
    }

    @Test
    public void testFirstSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Object elt = new Object();
        set.add(elt);
        set.add(new Object());
        Assert.assertEquals((Object)elt, (Object)this.collectionServices.first((Collection)set));
    }

    @Test
    public void testFirstEmptySet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertEquals(null, (Object)this.collectionServices.first((Collection)set));
    }

    @Test(expected=NullPointerException.class)
    public void testFirstNullCollection() {
        this.collectionServices.first(null);
    }

    @Test
    public void testAt() {
        ArrayList list = Lists.newArrayList();
        Object elt = new Object();
        Object elt2 = new Object();
        Object elt3 = new Object();
        Object elt4 = new Object();
        list.add(elt);
        list.add(elt2);
        list.add(elt3);
        list.add(elt3);
        list.add(elt4);
        Assert.assertEquals((Object)elt, (Object)this.collectionServices.at((List)list, Integer.valueOf(1)));
        Assert.assertEquals((Object)elt2, (Object)this.collectionServices.at((List)list, Integer.valueOf(2)));
        Assert.assertEquals((Object)elt4, (Object)this.collectionServices.at((List)list, Integer.valueOf(5)));
        list.add(0, elt4);
        Assert.assertEquals((Object)elt4, (Object)this.collectionServices.at((List)list, Integer.valueOf(1)));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAtOutOfBounds() {
        ArrayList list = Lists.newArrayList();
        list.add(new Object());
        this.collectionServices.at((List)list, Integer.valueOf(2));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAtZero() {
        ArrayList list = Lists.newArrayList();
        list.add(new Object());
        this.collectionServices.at((List)list, Integer.valueOf(0));
    }

    @Test(expected=NullPointerException.class)
    public void testAtNullList() {
        this.collectionServices.at(null, Integer.valueOf(1));
    }

    @Test
    public void testSizeList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        Assert.assertEquals((Object)1, (Object)this.collectionServices.size((Collection)list));
        list.add(2);
        list.add(3);
        Assert.assertEquals((Object)3, (Object)this.collectionServices.size((Collection)list));
        list.remove(1);
        Assert.assertEquals((Object)2, (Object)this.collectionServices.size((Collection)list));
    }

    @Test
    public void testSizeSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        Assert.assertEquals((Object)new Integer(1), (Object)this.collectionServices.size((Collection)set));
        set.add(2);
        set.add(3);
        Assert.assertEquals((Object)3, (Object)this.collectionServices.size((Collection)set));
        set.remove(1);
        Assert.assertEquals((Object)2, (Object)this.collectionServices.size((Collection)set));
    }

    @Test(expected=NullPointerException.class)
    public void testAsSetNull() {
        this.collectionServices.asSet(null);
    }

    @Test
    public void testAsSetList() {
        ArrayList list = Lists.newArrayList();
        Object elt = new Object();
        Object elt2 = new Object();
        list.add(elt);
        list.add(elt);
        list.add(elt2);
        Set asSet = this.collectionServices.asSet((Collection)list);
        Assert.assertNotNull((Object)asSet);
        Iterator itr = asSet.iterator();
        Assert.assertEquals((Object)elt, itr.next());
        Assert.assertEquals((Object)elt2, itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
        Object elt3 = new Object();
        list.add(elt3);
        Assert.assertFalse((boolean)asSet.contains(elt3));
    }

    @Test
    public void testAsSetSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Object elt = new Object();
        Object elt2 = new Object();
        set.add(elt);
        set.add(elt2);
        Set asSet = this.collectionServices.asSet((Collection)set);
        Assert.assertNotNull((Object)asSet);
        Iterator itr = asSet.iterator();
        Assert.assertEquals((Object)elt, itr.next());
        Assert.assertEquals((Object)elt2, itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
        Object elt3 = new Object();
        set.add(elt3);
        Assert.assertTrue((boolean)asSet.contains(elt3));
    }

    @Test(expected=NullPointerException.class)
    public void testAsOrderedSetNull() {
        this.collectionServices.asOrderedSet(null);
    }

    @Test
    public void testAsOrderedSetList() {
        ArrayList list = Lists.newArrayList();
        Object elt = new Object();
        Object elt2 = new Object();
        list.add(elt);
        list.add(elt);
        list.add(elt2);
        Set asSet = this.collectionServices.asOrderedSet((Collection)list);
        Assert.assertNotNull((Object)asSet);
        Iterator itr = asSet.iterator();
        Assert.assertEquals((Object)elt, itr.next());
        Assert.assertEquals((Object)elt2, itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
        Object elt3 = new Object();
        list.add(elt3);
        Assert.assertFalse((boolean)asSet.contains(elt3));
    }

    @Test
    public void testAsOrderedSetSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Object elt = new Object();
        Object elt2 = new Object();
        set.add(elt);
        set.add(elt2);
        Set asSet = this.collectionServices.asOrderedSet((Collection)set);
        Assert.assertNotNull((Object)asSet);
        Iterator itr = asSet.iterator();
        Assert.assertEquals((Object)elt, itr.next());
        Assert.assertEquals((Object)elt2, itr.next());
        Assert.assertFalse((boolean)itr.hasNext());
        Object elt3 = new Object();
        set.add(elt3);
        Assert.assertTrue((boolean)asSet.contains(elt3));
    }

    @Test(expected=NullPointerException.class)
    public void testAsSequenceNull() {
        this.collectionServices.asSequence(null);
    }

    @Test
    public void testAsSequenceList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        List asSequence = this.collectionServices.asSequence((Collection)list);
        Assert.assertNotNull((Object)asSequence);
        Assert.assertEquals((Object)1, asSequence.get(0));
        Assert.assertEquals((Object)2, asSequence.get(1));
        Assert.assertEquals((Object)3, asSequence.get(2));
        list.add(4);
        Assert.assertTrue((boolean)asSequence.contains(4));
    }

    @Test
    public void testAsSequenceSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        List asSequence = this.collectionServices.asSequence((Collection)set);
        Assert.assertNotNull((Object)asSequence);
        Assert.assertEquals((Object)1, asSequence.get(0));
        Assert.assertEquals((Object)2, asSequence.get(1));
        Assert.assertEquals((Object)3, asSequence.get(2));
        set.add(4);
        Assert.assertFalse((boolean)asSequence.contains(4));
    }

    private LambdaValue createStringLengthLambda() {
        return new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                if (args[0] instanceof String) {
                    return ((String)args[0]).length();
                }
                return 0;
            }
        };
    }

    @Test
    public void testSortedByNullSet() {
        Set sortedBySet = this.collectionServices.sortedBy(null, this.createStringLengthLambda());
        Assert.assertEquals(null, (Object)sortedBySet);
    }

    @Test
    public void testSortedByNullList() {
        List sortedByList = this.collectionServices.sortedBy(null, this.createStringLengthLambda());
        Assert.assertEquals(null, (Object)sortedByList);
    }

    @Test
    public void testSortedBySetNullLambda() {
        LinkedHashSet<ComparableServicesTest.TestComparable> set = new LinkedHashSet<ComparableServicesTest.TestComparable>();
        ComparableServicesTest.TestComparable comp1 = new ComparableServicesTest.TestComparable(1);
        ComparableServicesTest.TestComparable comp2 = new ComparableServicesTest.TestComparable(2);
        ComparableServicesTest.TestComparable comp3 = new ComparableServicesTest.TestComparable(3);
        ComparableServicesTest.TestComparable comp4 = new ComparableServicesTest.TestComparable(4);
        ComparableServicesTest.TestComparable comp5 = new ComparableServicesTest.TestComparable(5);
        set.add(comp2);
        set.add(comp4);
        set.add(comp1);
        set.add(comp3);
        set.add(comp5);
        Set sortedBySet = this.collectionServices.sortedBy(set, null);
        Assert.assertSame(set, (Object)sortedBySet);
        Assert.assertEquals((long)5L, (long)sortedBySet.size());
    }

    @Test
    public void testSortedByListNullLambda() {
        ArrayList<ComparableServicesTest.TestComparable> list = new ArrayList<ComparableServicesTest.TestComparable>();
        ComparableServicesTest.TestComparable comp1 = new ComparableServicesTest.TestComparable(1);
        ComparableServicesTest.TestComparable comp2 = new ComparableServicesTest.TestComparable(2);
        ComparableServicesTest.TestComparable comp3 = new ComparableServicesTest.TestComparable(3);
        ComparableServicesTest.TestComparable comp4 = new ComparableServicesTest.TestComparable(4);
        ComparableServicesTest.TestComparable comp5 = new ComparableServicesTest.TestComparable(5);
        list.add(comp2);
        list.add(comp4);
        list.add(comp1);
        list.add(comp3);
        list.add(comp5);
        List sortedByList = this.collectionServices.sortedBy(list, null);
        Assert.assertSame(list, (Object)sortedByList);
        Assert.assertEquals((long)5L, (long)sortedByList.size());
    }

    private LambdaValue createSelfLambda() {
        return new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                if (args.length >= 1) {
                    return args[0];
                }
                return null;
            }
        };
    }

    private LambdaValue createExceptionLambda(Diagnostic diagnostic) {
        return new LambdaValue(null, null, null, diagnostic){

            public Object eval(Object[] args) {
                throw new RuntimeException("Test runtime exception lambda.");
            }
        };
    }

    @Test
    public void testSortedBySetWithNull() {
        LinkedHashSet<ComparableServicesTest.TestComparable> set = new LinkedHashSet<ComparableServicesTest.TestComparable>();
        ComparableServicesTest.TestComparable comp1 = new ComparableServicesTest.TestComparable(1);
        ComparableServicesTest.TestComparable comp2 = new ComparableServicesTest.TestComparable(2);
        ComparableServicesTest.TestComparable comp3 = new ComparableServicesTest.TestComparable(3);
        ComparableServicesTest.TestComparable comp4 = new ComparableServicesTest.TestComparable(4);
        ComparableServicesTest.TestComparable comp5 = new ComparableServicesTest.TestComparable(5);
        set.add(comp2);
        set.add(comp4);
        set.add(comp1);
        set.add(null);
        set.add(comp3);
        set.add(comp5);
        Set sortedBySet = this.collectionServices.sortedBy(set, this.createSelfLambda());
        Assert.assertEquals((long)6L, (long)sortedBySet.size());
        Iterator itr = sortedBySet.iterator();
        Assert.assertEquals(null, itr.next());
        Assert.assertEquals((Object)comp1, itr.next());
        Assert.assertEquals((Object)comp2, itr.next());
        Assert.assertEquals((Object)comp3, itr.next());
        Assert.assertEquals((Object)comp4, itr.next());
        Assert.assertEquals((Object)comp5, itr.next());
    }

    @Test
    public void testSortedByListWithNull() {
        ArrayList<ComparableServicesTest.TestComparable> list = new ArrayList<ComparableServicesTest.TestComparable>();
        ComparableServicesTest.TestComparable comp1 = new ComparableServicesTest.TestComparable(1);
        ComparableServicesTest.TestComparable comp2 = new ComparableServicesTest.TestComparable(2);
        ComparableServicesTest.TestComparable comp3 = new ComparableServicesTest.TestComparable(3);
        ComparableServicesTest.TestComparable comp4 = new ComparableServicesTest.TestComparable(4);
        ComparableServicesTest.TestComparable comp5 = new ComparableServicesTest.TestComparable(5);
        list.add(comp2);
        list.add(comp4);
        list.add(comp1);
        list.add(null);
        list.add(comp3);
        list.add(comp5);
        List sortedByList = this.collectionServices.sortedBy(list, this.createSelfLambda());
        Assert.assertEquals((long)6L, (long)sortedByList.size());
        Assert.assertEquals(null, sortedByList.get(0));
        Assert.assertEquals((Object)comp1, sortedByList.get(1));
        Assert.assertEquals((Object)comp2, sortedByList.get(2));
        Assert.assertEquals((Object)comp3, sortedByList.get(3));
        Assert.assertEquals((Object)comp4, sortedByList.get(4));
        Assert.assertEquals((Object)comp5, sortedByList.get(5));
    }

    @Test
    public void testSortedBySet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("aa");
        set.add("bbb");
        set.add("c");
        Set sortedBySet = this.collectionServices.sortedBy(set, this.createStringLengthLambda());
        Assert.assertEquals((long)3L, (long)sortedBySet.size());
        Iterator itr = sortedBySet.iterator();
        Assert.assertEquals((Object)"c", itr.next());
        Assert.assertEquals((Object)"aa", itr.next());
        Assert.assertEquals((Object)"bbb", itr.next());
    }

    @Test
    public void testSortedByList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aa");
        list.add("bbb");
        list.add("c");
        List sortedByList = this.collectionServices.sortedBy(list, this.createStringLengthLambda());
        Assert.assertEquals((long)3L, (long)sortedByList.size());
        Assert.assertEquals((Object)"c", sortedByList.get(0));
        Assert.assertEquals((Object)"aa", sortedByList.get(1));
        Assert.assertEquals((Object)"bbb", sortedByList.get(2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSortedBySetDifferentTypes() {
        LinkedHashSet<Number> set = new LinkedHashSet<Number>();
        set.add(1);
        set.add(1.5);
        this.collectionServices.sortedBy(set, this.createSelfLambda());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSortedByListDifferentTypes() {
        ArrayList<Number> list = new ArrayList<Number>();
        list.add(1);
        list.add(1.5);
        this.collectionServices.sortedBy(list, this.createSelfLambda());
    }

    @Test
    public void testSortedByListExceptionLambda() {
        ArrayList<Number> list = new ArrayList<Number>();
        list.add(1);
        list.add(1.5);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertEquals(list, (Object)this.collectionServices.sortedBy(list, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)2L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
    }

    @Test
    public void testSortedBySetExceptionLambda() {
        LinkedHashSet<Number> set = new LinkedHashSet<Number>();
        set.add(1);
        set.add(1.5);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertEquals(set, (Object)this.collectionServices.sortedBy(set, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)2L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
    }

    private LambdaValue createEObjectNameLambda() {
        return new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                if (args[0] instanceof ENamedElement) {
                    return ((ENamedElement)args[0]).getName();
                }
                return 0;
            }
        };
    }

    @Test
    public void testSortedByEObjectName() {
        ArrayList<EClass> list = new ArrayList<EClass>();
        list.add(EcorePackage.eINSTANCE.getEStructuralFeature());
        list.add(EcorePackage.eINSTANCE.getEAttribute());
        list.add(EcorePackage.eINSTANCE.getEClassifier());
        list.add(EcorePackage.eINSTANCE.getEAnnotation());
        list.add(EcorePackage.eINSTANCE.getENamedElement());
        List sortedByList = this.collectionServices.sortedBy(list, this.createEObjectNameLambda());
        Assert.assertEquals((long)5L, (long)sortedByList.size());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), sortedByList.get(0));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), sortedByList.get(1));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), sortedByList.get(2));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getENamedElement(), sortedByList.get(3));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), sortedByList.get(4));
    }

    private LambdaValue createInstanceOfLambda(final Class<?> clazz) {
        return new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                return clazz.isInstance(args[0]);
            }
        };
    }

    @Test
    public void sortByPerf() {
        int size = 1000000;
        ArrayList<Integer> list = new ArrayList<Integer>(1000000);
        SortedByCounter nameLambda = new SortedByCounter(null, null, null);
        int i = 0;
        while (i < 1000000) {
            list.add(1000000 - i - 1);
            ++i;
        }
        List sortedByList = this.collectionServices.sortedBy(list, (LambdaValue)nameLambda);
        Assert.assertEquals((long)1000000L, (long)nameLambda.counter);
        int i2 = 0;
        while (i2 < 1000000) {
            Assert.assertEquals((Object)i2, sortedByList.get(i2));
            ++i2;
        }
    }

    @Test
    public void testSelectList() throws URISyntaxException, IOException {
        Resource reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        EObject queries = (EObject)reverseModel.getContents().get(0);
        TreeIterator iterator = queries.eAllContents();
        ArrayList list = Lists.newArrayList();
        EObject queryWithExpression = (EObject)iterator.next();
        list.add(queryWithExpression);
        list.add((EObject)iterator.next());
        list.add((EObject)iterator.next());
        List filtered = this.collectionServices.select((List)list, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
        filtered = this.collectionServices.select((List)list, this.createInstanceOfLambda(Query.class));
        Assert.assertEquals((long)1L, (long)filtered.size());
        Assert.assertEquals((Object)queryWithExpression, filtered.get(0));
    }

    @Test(expected=NullPointerException.class)
    public void testSelectNullList() {
        List nullList = null;
        this.collectionServices.select(nullList, this.createInstanceOfLambda(Query.class));
    }

    @Test
    public void testSelectListNullLambda() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        list.add("c");
        List filtered = this.collectionServices.select((List)list, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
    }

    @Test
    public void testSelectListNotBooleanLambda() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        list.add("c");
        List result = this.collectionServices.select((List)list, this.createSelfLambda());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testSelectListExceptionLambda() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        list.add("c");
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.collectionServices.reject((List)list, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)3L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(2)).getMessage());
    }

    @Test
    public void testSelectSet() throws URISyntaxException, IOException {
        Resource reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        EObject queries = (EObject)reverseModel.getContents().get(0);
        TreeIterator iterator = queries.eAllContents();
        LinkedHashSet set = Sets.newLinkedHashSet();
        EObject queryWithExpression = (EObject)iterator.next();
        set.add(queryWithExpression);
        set.add((EObject)iterator.next());
        set.add((EObject)iterator.next());
        Set filtered = this.collectionServices.select((Set)set, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
        filtered = this.collectionServices.select((Set)set, this.createInstanceOfLambda(Query.class));
        Assert.assertEquals((long)1L, (long)filtered.size());
        Assert.assertEquals((Object)queryWithExpression, filtered.iterator().next());
    }

    @Test(expected=NullPointerException.class)
    public void testSelectNullSet() {
        Set nullSet = null;
        this.collectionServices.select(nullSet, this.createInstanceOfLambda(Query.class));
    }

    @Test
    public void testSelectSetNullLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("a");
        set.add("b");
        set.add("c");
        Set filtered = this.collectionServices.select((Set)set, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
    }

    @Test
    public void testSelectSetNotBooleanLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("a");
        set.add("b");
        set.add("c");
        Set result = this.collectionServices.select((Set)set, this.createSelfLambda());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testRejectList() throws URISyntaxException, IOException {
        Resource reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        EObject queries = (EObject)reverseModel.getContents().get(0);
        TreeIterator iterator = queries.eAllContents();
        ArrayList list = Lists.newArrayList();
        EObject queryWithExpression = (EObject)iterator.next();
        EObject eObj2 = (EObject)iterator.next();
        EObject eObj3 = (EObject)iterator.next();
        list.add(queryWithExpression);
        list.add(eObj2);
        list.add(eObj3);
        List filtered = this.collectionServices.reject((List)list, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
        filtered = this.collectionServices.reject((List)list, this.createInstanceOfLambda(Query.class));
        Assert.assertEquals((long)2L, (long)filtered.size());
        Assert.assertEquals((Object)eObj2, filtered.get(0));
        Assert.assertEquals((Object)eObj3, filtered.get(1));
    }

    @Test(expected=NullPointerException.class)
    public void testRejectNullList() {
        List nullList = null;
        this.collectionServices.reject(nullList, this.createInstanceOfLambda(Query.class));
    }

    @Test
    public void testRejectListNullLambda() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        list.add("c");
        List filtered = this.collectionServices.reject((List)list, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
    }

    @Test
    public void testRejectListNotBooleanLambda() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        list.add("c");
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.collectionServices.reject((List)list, this.createSelfLambda()));
    }

    @Test
    public void testRejectListExceptionLambda() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        list.add("c");
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.collectionServices.reject((List)list, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)3L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(2)).getMessage());
    }

    @Test
    public void testRejectSet() throws URISyntaxException, IOException {
        Resource reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        EObject queries = (EObject)reverseModel.getContents().get(0);
        TreeIterator iterator = queries.eAllContents();
        LinkedHashSet set = Sets.newLinkedHashSet();
        EObject queryWithExpression = (EObject)iterator.next();
        EObject eObj2 = (EObject)iterator.next();
        EObject eObj3 = (EObject)iterator.next();
        set.add(queryWithExpression);
        set.add(eObj2);
        set.add(eObj3);
        Set filtered = this.collectionServices.reject((Set)set, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
        filtered = this.collectionServices.reject((Set)set, this.createInstanceOfLambda(Query.class));
        Assert.assertEquals((long)2L, (long)filtered.size());
        Iterator itr = filtered.iterator();
        Assert.assertEquals((Object)eObj2, itr.next());
        Assert.assertEquals((Object)eObj3, itr.next());
    }

    @Test(expected=NullPointerException.class)
    public void testRejectNullSet() {
        Set nullSet = null;
        this.collectionServices.reject(nullSet, this.createInstanceOfLambda(Query.class));
    }

    @Test
    public void testRejectSetNullLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("a");
        set.add("b");
        set.add("c");
        Set filtered = this.collectionServices.reject((Set)set, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
    }

    @Test
    public void testRejectSetNotBooleanLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("a");
        set.add("b");
        set.add("c");
        Set result = this.collectionServices.reject((Set)set, this.createSelfLambda());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testRejectSetExceptionLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("a");
        set.add("b");
        set.add("c");
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)this.collectionServices.reject((Set)set, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)3L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(2)).getMessage());
    }

    @Test
    public void testCollectList() throws URISyntaxException, IOException {
        Resource reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        EObject queries = (EObject)reverseModel.getContents().get(0);
        TreeIterator iterator = queries.eAllContents();
        ArrayList list = Lists.newArrayList();
        list.add(iterator.next());
        list.add(iterator.next());
        list.add(iterator.next());
        List filtered = this.collectionServices.collect((List)list, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
        filtered = this.collectionServices.collect((List)list, this.createInstanceOfLambda(Query.class));
        Assert.assertEquals((long)3L, (long)filtered.size());
        Assert.assertEquals((Object)Boolean.TRUE, filtered.get(0));
        Assert.assertEquals((Object)Boolean.FALSE, filtered.get(1));
        Assert.assertEquals((Object)Boolean.FALSE, filtered.get(2));
    }

    @Test(expected=NullPointerException.class)
    public void testCollectNullList() {
        List nullList = null;
        this.collectionServices.collect(nullList, this.createInstanceOfLambda(Query.class));
    }

    @Test
    public void testCollectNothingNullList() throws URISyntaxException, IOException {
        Resource reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        EObject queries = (EObject)reverseModel.getContents().get(0);
        TreeIterator iterator = queries.eAllContents();
        ArrayList list = Lists.newArrayList();
        Object queryWithExpression = iterator.next();
        Assert.assertTrue((boolean)(queryWithExpression instanceof Query));
        list.add(queryWithExpression);
        list.add(iterator.next());
        list.add(iterator.next());
        List filtered = this.collectionServices.collect((List)list, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
        filtered = this.collectionServices.collect((List)list, this.createQueryExpressionLambda());
        Assert.assertEquals((long)1L, (long)filtered.size());
        Iterator itr = filtered.iterator();
        Assert.assertEquals((Object)((Query)queryWithExpression).getExpression(), itr.next());
    }

    @Test
    public void testCollectListNullLambda() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        list.add("c");
        List filtered = this.collectionServices.collect((List)list, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
    }

    @Test
    public void testCollectImplicitFlattenList() {
        LambdaValue lambdaValue = new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                return EcorePackage.eINSTANCE.getEClassifiers();
            }
        };
        ArrayList<EcorePackage> list = new ArrayList<EcorePackage>();
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE);
        List result = this.collectionServices.collect(list, lambdaValue);
        Assert.assertEquals((long)(EcorePackage.eINSTANCE.getEClassifiers().size() * 2), (long)result.size());
    }

    @Test
    public void testCollectSet() throws URISyntaxException, IOException {
        Resource reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        EObject queries = (EObject)reverseModel.getContents().get(0);
        TreeIterator iterator = queries.eAllContents();
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(iterator.next());
        set.add(iterator.next());
        set.add(iterator.next());
        Set filtered = this.collectionServices.collect((Set)set, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
        filtered = this.collectionServices.collect((Set)set, this.createInstanceOfLambda(Query.class));
        Assert.assertEquals((long)2L, (long)filtered.size());
        Iterator itr = filtered.iterator();
        Assert.assertEquals((Object)Boolean.TRUE, itr.next());
        Assert.assertEquals((Object)Boolean.FALSE, itr.next());
    }

    @Test(expected=NullPointerException.class)
    public void testCollectNullSet() {
        Set nullSet = null;
        this.collectionServices.collect(nullSet, this.createInstanceOfLambda(Query.class));
    }

    @Test
    public void testCollectNothingNullSet() throws URISyntaxException, IOException {
        Resource reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
        EObject queries = (EObject)reverseModel.getContents().get(0);
        TreeIterator iterator = queries.eAllContents();
        LinkedHashSet set = Sets.newLinkedHashSet();
        Object queryWithExpression = iterator.next();
        Assert.assertTrue((boolean)(queryWithExpression instanceof Query));
        set.add(queryWithExpression);
        set.add(iterator.next());
        set.add(iterator.next());
        Set filtered = this.collectionServices.collect((Set)set, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
        filtered = this.collectionServices.collect((Set)set, this.createQueryExpressionLambda());
        Assert.assertEquals((long)1L, (long)filtered.size());
        Iterator itr = filtered.iterator();
        Assert.assertEquals((Object)((Query)queryWithExpression).getExpression(), itr.next());
    }

    @Test
    public void testCollectSetNullLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("a");
        set.add("b");
        set.add("c");
        Set filtered = this.collectionServices.collect((Set)set, null);
        Assert.assertTrue((boolean)filtered.isEmpty());
    }

    @Test
    public void testCollectImplicitFlattenSet() {
        LambdaValue lambdaValue = new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                return EcorePackage.eINSTANCE.getEClassifiers();
            }
        };
        LinkedHashSet<EcorePackage> set = new LinkedHashSet<EcorePackage>();
        set.add(EcorePackage.eINSTANCE);
        set.add(EcorePackage.eINSTANCE);
        Set result = this.collectionServices.collect(set, lambdaValue);
        Assert.assertEquals((long)EcorePackage.eINSTANCE.getEClassifiers().size(), (long)result.size());
    }

    private LambdaValue createQueryExpressionLambda() {
        return new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                if (args[0] instanceof Query) {
                    return ((Query)args[0]).getExpression();
                }
                return null;
            }
        };
    }

    @Test
    public void testClosure() {
        LambdaValue lambdaValue = new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                List<Object> result = args[0] instanceof TestClosure ? ((TestClosure)args[0]).getRefs() : null;
                return result;
            }
        };
        TestClosure a = new TestClosure();
        TestClosure b = new TestClosure();
        TestClosure c = new TestClosure();
        TestClosure d = new TestClosure();
        TestClosure e = new TestClosure();
        TestClosure f = new TestClosure();
        a.getRefs().add(b);
        b.getRefs().add(d);
        b.getRefs().add(c);
        c.getRefs().add(e);
        c.getRefs().add(f);
        LinkedHashSet<TestClosure> set = new LinkedHashSet<TestClosure>();
        set.add(a);
        Set result = this.collectionServices.closure(set, lambdaValue);
        Assert.assertEquals((long)6L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)a, it.next());
        Assert.assertEquals((Object)b, it.next());
        Assert.assertEquals((Object)d, it.next());
        Assert.assertEquals((Object)c, it.next());
        Assert.assertEquals((Object)e, it.next());
        Assert.assertEquals((Object)f, it.next());
    }

    @Test
    public void testClosureRecursive() {
        LambdaValue lambdaValue = new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                List<Object> result = args[0] instanceof TestClosure ? ((TestClosure)args[0]).getRefs() : null;
                return result;
            }
        };
        TestClosure a = new TestClosure();
        TestClosure b = new TestClosure();
        TestClosure c = new TestClosure();
        TestClosure d = new TestClosure();
        TestClosure e = new TestClosure();
        TestClosure f = new TestClosure();
        a.getRefs().add(b);
        b.getRefs().add(d);
        b.getRefs().add(c);
        c.getRefs().add(e);
        c.getRefs().add(f);
        f.getRefs().add(b);
        LinkedHashSet<TestClosure> set = new LinkedHashSet<TestClosure>();
        set.add(a);
        Set result = this.collectionServices.closure(set, lambdaValue);
        Assert.assertEquals((long)6L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)a, it.next());
        Assert.assertEquals((Object)b, it.next());
        Assert.assertEquals((Object)d, it.next());
        Assert.assertEquals((Object)c, it.next());
        Assert.assertEquals((Object)e, it.next());
        Assert.assertEquals((Object)f, it.next());
    }

    @Test
    public void testClosureNothingNull() {
        LambdaValue nullLambdaValue = new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                return null;
            }
        };
        LinkedHashSet<EcorePackage> set = new LinkedHashSet<EcorePackage>();
        set.add(EcorePackage.eINSTANCE);
        Set result = this.collectionServices.closure(set, nullLambdaValue);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.iterator().next());
        LambdaValue nothingLambdaValue = new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                return new Nothing("");
            }
        };
        set = new LinkedHashSet();
        set.add(EcorePackage.eINSTANCE);
        result = this.collectionServices.closure(set, nothingLambdaValue);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.iterator().next());
    }

    @Test
    public void testClosureSubPackages() {
        EPackage pkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        pkg.setName("package1");
        EPackage package11 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        package11.setName("package11");
        EPackage package12 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        package12.setName("package12");
        EPackage package111 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        package111.setName("package111");
        EPackage package121 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        package121.setName("package121");
        EPackage package1111 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        package1111.setName("package1111");
        EPackage package1112 = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        package1112.setName("package1112");
        pkg.getESubpackages().add((Object)package11);
        pkg.getESubpackages().add((Object)package12);
        package11.getESubpackages().add((Object)package111);
        package12.getESubpackages().add((Object)package121);
        package111.getESubpackages().add((Object)package1111);
        package111.getESubpackages().add((Object)package1112);
        LambdaValue subPackagesLambdaValue = new LambdaValue(null, null, null, null){

            public Object eval(Object[] args) {
                if (args[0] instanceof EPackage) {
                    return ((EPackage)args[0]).getESubpackages();
                }
                return null;
            }
        };
        Set result = this.collectionServices.closure((Collection)ImmutableSet.of((Object)pkg), subPackagesLambdaValue);
        Assert.assertEquals((long)7L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)pkg, it.next());
        Assert.assertEquals((Object)package11, it.next());
        Assert.assertEquals((Object)package12, it.next());
        Assert.assertEquals((Object)package111, it.next());
        Assert.assertEquals((Object)package121, it.next());
        Assert.assertEquals((Object)package1111, it.next());
        Assert.assertEquals((Object)package1112, it.next());
    }

    @Test
    public void testFilterSetNullSetAndNullType() {
        Set result = this.collectionServices.filter(null, null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testFilterSetNullSet() {
        Set result = this.collectionServices.filter(null, (EClassifier)EcorePackage.eINSTANCE.getEClass());
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testFilterSetNullType() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(this);
        set.add("");
        set.add(EcorePackage.eINSTANCE);
        set.add(EcorePackage.eINSTANCE.getEClass());
        Set result = this.collectionServices.filter((Set)set, null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testFilterSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(this);
        set.add("");
        set.add(EcorePackage.eINSTANCE);
        set.add(EcorePackage.eINSTANCE.getEClass());
        Set result = this.collectionServices.filter((Set)set, (EClassifier)EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(EcorePackage.eINSTANCE));
    }

    @Test
    public void testFilterListNullListAndNullType() {
        List result = this.collectionServices.filter(null, null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testFilterListNullList() {
        List result = this.collectionServices.filter(null, (EClassifier)EcorePackage.eINSTANCE.getEClass());
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testFilterListNullType() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.collectionServices.filter((List)list, null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testFilterList() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.collectionServices.filter((List)list, (EClassifier)EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(EcorePackage.eINSTANCE));
    }

    @Test
    public void testFilterSetNullSetAndNullTypeEClassifierSet() {
        Set result = this.collectionServices.filter(null, null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testFilterSetNullSetEClassifierSet() {
        LinkedHashSet<EClass> eClassifiers = new LinkedHashSet<EClass>();
        eClassifiers.add(EcorePackage.eINSTANCE.getEClass());
        Set result = this.collectionServices.filter(null, eClassifiers);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testFilterSetNullTypeEClassifierSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(this);
        set.add("");
        set.add(EcorePackage.eINSTANCE);
        set.add(EcorePackage.eINSTANCE.getEClass());
        Set result = this.collectionServices.filter((Set)set, null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testFilterSetEmptyEClassifierSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(this);
        set.add("");
        set.add(EcorePackage.eINSTANCE);
        set.add(EcorePackage.eINSTANCE.getEClass());
        Set result = this.collectionServices.filter((Set)set, (Set)Sets.newLinkedHashSet());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testFilterSetEClassifierSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(this);
        set.add("");
        set.add(EcorePackage.eINSTANCE);
        set.add(EcorePackage.eINSTANCE.getEClass());
        LinkedHashSet<EClass> eClassifiers = new LinkedHashSet<EClass>();
        eClassifiers.add(EcorePackage.eINSTANCE.getEPackage());
        eClassifiers.add(EcorePackage.eINSTANCE.getEClass());
        Set result = this.collectionServices.filter((Set)set, eClassifiers);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(EcorePackage.eINSTANCE));
        Assert.assertTrue((boolean)result.contains(EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void testFilterListNullListAndNullTypeEClassifierSet() {
        List result = this.collectionServices.filter(null, null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testFilterListNullListEClassifierSet() {
        LinkedHashSet<EClass> eClassifiers = new LinkedHashSet<EClass>();
        eClassifiers.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.collectionServices.filter(null, eClassifiers);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testFilterListNullTypeEClassifierSet() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.collectionServices.filter((List)list, null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testFilterListEmptyEClassifierSet() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.collectionServices.filter((List)list, (Set)Sets.newLinkedHashSet());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testFilterListEClassifierSet() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        LinkedHashSet<EClass> eClassifiers = new LinkedHashSet<EClass>();
        eClassifiers.add(EcorePackage.eINSTANCE.getEPackage());
        eClassifiers.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.collectionServices.filter((List)list, eClassifiers);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((boolean)result.contains(EcorePackage.eINSTANCE));
        Assert.assertTrue((boolean)result.contains(EcorePackage.eINSTANCE.getEClass()));
    }

    @Test
    public void testFilterOnEContents_ecore_477217() {
        EPackage rootPackage = EcoreFactory.eINSTANCE.createEPackage();
        EPackage subPackage = EcoreFactory.eINSTANCE.createEPackage();
        EClass nestedClass = EcoreFactory.eINSTANCE.createEClass();
        rootPackage.getEClassifiers().add((Object)nestedClass);
        rootPackage.getESubpackages().add((Object)subPackage);
        IQueryEnvironment queryEnvironment = org.eclipse.acceleo.query.runtime.Query.newEnvironmentWithDefaultServices(null);
        queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        QueryBuilderEngine queryBuilder = new QueryBuilderEngine((IReadOnlyQueryEnvironment)queryEnvironment);
        IQueryBuilderEngine.AstResult query = queryBuilder.build("self.eContents()->filter(ecore::EClass)");
        QueryEvaluationEngine evaluationEngine = new QueryEvaluationEngine(queryEnvironment);
        HashMap<String, EPackage> variables = new HashMap<String, EPackage>();
        variables.put("self", rootPackage);
        EvaluationResult result = evaluationEngine.eval(query, variables);
        Assert.assertTrue((boolean)(result.getResult() instanceof List));
        Assert.assertEquals((long)1L, (long)((List)result.getResult()).size());
        Assert.assertTrue((boolean)((List)result.getResult()).contains(nestedClass));
    }

    @Test
    public void testFilterOnEContents_anydsl_477217() {
        World world = AnydslFactory.eINSTANCE.createWorld();
        Restaurant comp1 = AnydslFactory.eINSTANCE.createRestaurant();
        ProductionCompany comp2 = AnydslFactory.eINSTANCE.createProductionCompany();
        Food food = AnydslFactory.eINSTANCE.createFood();
        world.getCompanies().add((Object)comp1);
        world.getCompanies().add((Object)comp2);
        world.getFoods().add((Object)food);
        IQueryEnvironment queryEnvironment = org.eclipse.acceleo.query.runtime.Query.newEnvironmentWithDefaultServices(null);
        queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        QueryBuilderEngine queryBuilder = new QueryBuilderEngine((IReadOnlyQueryEnvironment)queryEnvironment);
        IQueryBuilderEngine.AstResult query = queryBuilder.build("self.eContents()->filter(anydsl::Company)");
        QueryEvaluationEngine evaluationEngine = new QueryEvaluationEngine(queryEnvironment);
        HashMap<String, World> variables = new HashMap<String, World>();
        variables.put("self", world);
        EvaluationResult result = evaluationEngine.eval(query, variables);
        Assert.assertTrue((boolean)(result.getResult() instanceof List));
        Assert.assertEquals((long)2L, (long)((List)result.getResult()).size());
        Assert.assertTrue((boolean)((List)result.getResult()).contains(comp1));
        Assert.assertTrue((boolean)((List)result.getResult()).contains(comp2));
    }

    @Test
    public void testSepNullListNullSeparator() {
        List result = this.collectionServices.sep(null, null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testSepNullList() {
        Object separator = new Object();
        List result = this.collectionServices.sep(null, separator);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testSepEmptyList() {
        Object separator = new Object();
        List result = this.collectionServices.sep((Collection)Lists.newArrayList(), separator);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testSepListNullSeparator() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        list.add("c");
        List result = this.collectionServices.sep((Collection)list, null);
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals((Object)"a", result.get(0));
        Assert.assertEquals(null, result.get(1));
        Assert.assertEquals((Object)"b", result.get(2));
        Assert.assertEquals(null, result.get(3));
        Assert.assertEquals((Object)"c", result.get(4));
    }

    @Test
    public void testSepList() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object separator = new Object();
        List result = this.collectionServices.sep((Collection)list, separator);
        Assert.assertEquals((long)7L, (long)result.size());
        Assert.assertEquals((Object)this, result.get(0));
        Assert.assertEquals((Object)separator, result.get(1));
        Assert.assertEquals((Object)"", result.get(2));
        Assert.assertEquals((Object)separator, result.get(3));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(4));
        Assert.assertEquals((Object)separator, result.get(5));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(6));
    }

    @Test
    public void testSepNullSetNullSeparator() {
        List result = this.collectionServices.sep(null, null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testSepNullSet() {
        Object separator = new Object();
        List result = this.collectionServices.sep(null, separator);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testSepEmptySet() {
        Object separator = new Object();
        List result = this.collectionServices.sep((Collection)Sets.newLinkedHashSet(), separator);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testSepSetNullSeparator() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add("a");
        set.add("b");
        set.add("c");
        List result = this.collectionServices.sep((Collection)set, null);
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals((Object)"a", result.get(0));
        Assert.assertEquals(null, result.get(1));
        Assert.assertEquals((Object)"b", result.get(2));
        Assert.assertEquals(null, result.get(3));
        Assert.assertEquals((Object)"c", result.get(4));
    }

    @Test
    public void testSepSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(this);
        set.add("");
        set.add(EcorePackage.eINSTANCE);
        set.add(EcorePackage.eINSTANCE.getEClass());
        Object separator = new Object();
        List result = this.collectionServices.sep((Collection)set, separator);
        Assert.assertEquals((long)7L, (long)result.size());
        Assert.assertEquals((Object)this, result.get(0));
        Assert.assertEquals((Object)separator, result.get(1));
        Assert.assertEquals((Object)"", result.get(2));
        Assert.assertEquals((Object)separator, result.get(3));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(4));
        Assert.assertEquals((Object)separator, result.get(5));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(6));
    }

    @Test
    public void testSepPrefixSuffixNullListNullPrefixNullSeparatorNullSuffix() {
        List result = this.collectionServices.sep(null, null, null, null);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(null);
        expected.add(null);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSepPrefixSuffixNullListNullSeparatorNullSuffix() {
        Object prefix = new Object();
        List result = this.collectionServices.sep(null, prefix, null, null);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(prefix);
        expected.add(null);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSepPrefixSuffixNullListNullSuffix() {
        Object prefix = new Object();
        Object separator = new Object();
        List result = this.collectionServices.sep(null, prefix, separator, null);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(prefix);
        expected.add(null);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSepPrefixSuffixNullListNullSeparator() {
        Object prefix = new Object();
        Object suffix = new Object();
        List result = this.collectionServices.sep(null, prefix, null, suffix);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(prefix);
        expected.add(suffix);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSepPrefixSuffixNullList() {
        Object prefix = new Object();
        Object separator = new Object();
        Object suffix = new Object();
        List result = this.collectionServices.sep(null, prefix, separator, suffix);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(prefix);
        expected.add(suffix);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSepPrefixSuffixNullListNullPrefixNullSuffix() {
        Object separator = new Object();
        List result = this.collectionServices.sep(null, null, separator, null);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(null);
        expected.add(null);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSepPrefixSuffixNullListNullPrefixNullSeparator() {
        Object suffix = new Object();
        List result = this.collectionServices.sep(null, null, null, suffix);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(null);
        expected.add(suffix);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSepPrefixSuffixNullListNullPrefix() {
        Object suffix = new Object();
        Object separator = new Object();
        List result = this.collectionServices.sep(null, null, separator, suffix);
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(null);
        expected.add(suffix);
        Assert.assertEquals(expected, (Object)result);
    }

    @Test
    public void testSepPrefixSuffixNullPrefixNullSeparatorNullSuffix() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        List result = this.collectionServices.sep((Collection)list, null, null, null);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals(null, result.get(0));
        Assert.assertEquals((Object)this, result.get(1));
        Assert.assertEquals(null, result.get(2));
        Assert.assertEquals((Object)"", result.get(3));
        Assert.assertEquals(null, result.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(5));
        Assert.assertEquals(null, result.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(7));
        Assert.assertEquals(null, result.get(8));
    }

    @Test
    public void testSepPrefixSuffixNullSeparatorNullSuffix() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object prefix = new Object();
        List result = this.collectionServices.sep((Collection)list, prefix, null, null);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals((Object)prefix, result.get(0));
        Assert.assertEquals((Object)this, result.get(1));
        Assert.assertEquals(null, result.get(2));
        Assert.assertEquals((Object)"", result.get(3));
        Assert.assertEquals(null, result.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(5));
        Assert.assertEquals(null, result.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(7));
        Assert.assertEquals(null, result.get(8));
    }

    @Test
    public void testSepPrefixSuffixNullSuffix() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object prefix = new Object();
        Object separator = new Object();
        List result = this.collectionServices.sep((Collection)list, prefix, separator, null);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals((Object)prefix, result.get(0));
        Assert.assertEquals((Object)this, result.get(1));
        Assert.assertEquals((Object)separator, result.get(2));
        Assert.assertEquals((Object)"", result.get(3));
        Assert.assertEquals((Object)separator, result.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(5));
        Assert.assertEquals((Object)separator, result.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(7));
        Assert.assertEquals(null, result.get(8));
    }

    @Test
    public void testSepPrefixSuffixNullSeparator() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object prefix = new Object();
        Object suffix = new Object();
        List result = this.collectionServices.sep((Collection)list, prefix, null, suffix);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals((Object)prefix, result.get(0));
        Assert.assertEquals((Object)this, result.get(1));
        Assert.assertEquals(null, result.get(2));
        Assert.assertEquals((Object)"", result.get(3));
        Assert.assertEquals(null, result.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(5));
        Assert.assertEquals(null, result.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(7));
        Assert.assertEquals((Object)suffix, result.get(8));
    }

    @Test
    public void testSepPrefixSuffix() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object prefix = new Object();
        Object separator = new Object();
        Object suffix = new Object();
        List result = this.collectionServices.sep((Collection)list, prefix, separator, suffix);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals((Object)prefix, result.get(0));
        Assert.assertEquals((Object)this, result.get(1));
        Assert.assertEquals((Object)separator, result.get(2));
        Assert.assertEquals((Object)"", result.get(3));
        Assert.assertEquals((Object)separator, result.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(5));
        Assert.assertEquals((Object)separator, result.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(7));
        Assert.assertEquals((Object)suffix, result.get(8));
    }

    @Test
    public void testSepPrefixSuffixNullPrefixNullSuffix() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object separator = new Object();
        List result = this.collectionServices.sep((Collection)list, null, separator, null);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals(null, result.get(0));
        Assert.assertEquals((Object)this, result.get(1));
        Assert.assertEquals((Object)separator, result.get(2));
        Assert.assertEquals((Object)"", result.get(3));
        Assert.assertEquals((Object)separator, result.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(5));
        Assert.assertEquals((Object)separator, result.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(7));
        Assert.assertEquals(null, result.get(8));
    }

    @Test
    public void testSepPrefixSuffixNullPrefixNullSeparator() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object suffix = new Object();
        List result = this.collectionServices.sep((Collection)list, null, null, suffix);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals(null, result.get(0));
        Assert.assertEquals((Object)this, result.get(1));
        Assert.assertEquals(null, result.get(2));
        Assert.assertEquals((Object)"", result.get(3));
        Assert.assertEquals(null, result.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(5));
        Assert.assertEquals(null, result.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(7));
        Assert.assertEquals((Object)suffix, result.get(8));
    }

    @Test
    public void testSepPrefixSuffixNullPrefix() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object separator = new Object();
        Object suffix = new Object();
        List result = this.collectionServices.sep((Collection)list, null, separator, suffix);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals(null, result.get(0));
        Assert.assertEquals((Object)this, result.get(1));
        Assert.assertEquals((Object)separator, result.get(2));
        Assert.assertEquals((Object)"", result.get(3));
        Assert.assertEquals((Object)separator, result.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(5));
        Assert.assertEquals((Object)separator, result.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), result.get(7));
        Assert.assertEquals((Object)suffix, result.get(8));
    }

    @Test(expected=NullPointerException.class)
    public void testLastNullList() {
        Object result = this.collectionServices.last(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLastEmptyList() {
        ArrayList list = Lists.newArrayList();
        Object result = this.collectionServices.last((List)list);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLastList() {
        ArrayList list = Lists.newArrayList();
        list.add(this);
        list.add("");
        list.add(EcorePackage.eINSTANCE);
        list.add(EcorePackage.eINSTANCE.getEClass());
        Object result = this.collectionServices.last((List)list);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testLastNullSet() {
        Object result = this.collectionServices.last(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLastEmptySet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Object result = this.collectionServices.last((Set)set);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLastSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(this);
        set.add("");
        set.add(EcorePackage.eINSTANCE);
        set.add(EcorePackage.eINSTANCE.getEClass());
        Object result = this.collectionServices.last((Set)set);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)result);
    }

    @Test
    public void testExcludesList() {
        ArrayList list = Lists.newArrayList();
        Assert.assertTrue((boolean)this.collectionServices.excludes((Collection)list, (Object)this));
        list.add(this);
        Assert.assertEquals((Object)false, (Object)this.collectionServices.excludes((Collection)list, (Object)this));
    }

    @Test(expected=NullPointerException.class)
    public void testExcludesNullList() {
        this.collectionServices.excludes(null, (Object)this);
    }

    @Test
    public void testExcludesSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertTrue((boolean)this.collectionServices.excludes((Collection)set, (Object)this));
        set.add(this);
        Assert.assertEquals((Object)false, (Object)this.collectionServices.excludes((Collection)set, (Object)this));
    }

    @Test(expected=NullPointerException.class)
    public void testExcludesNullSet() {
        this.collectionServices.excludes(null, (Object)this);
    }

    @Test
    public void testIncludesList() {
        ArrayList list = Lists.newArrayList();
        Assert.assertEquals((Object)false, (Object)this.collectionServices.includes((Collection)list, (Object)this));
        list.add(this);
        Assert.assertTrue((boolean)this.collectionServices.includes((Collection)list, (Object)this));
    }

    @Test(expected=NullPointerException.class)
    public void testIncludesNullList() {
        this.collectionServices.excludes(null, (Object)this);
    }

    @Test
    public void testIncludesSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Assert.assertEquals((Object)false, (Object)this.collectionServices.includes((Collection)set, (Object)this));
        set.add(this);
        Assert.assertTrue((boolean)this.collectionServices.includes((Collection)set, (Object)this));
    }

    @Test(expected=NullPointerException.class)
    public void testIncludesNullSet() {
        this.collectionServices.excludes(null, (Object)this);
    }

    @Test(expected=NullPointerException.class)
    public void testAnyNullCollectionNullLambda() {
        this.collectionServices.any(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testAnyNullList() {
        this.collectionServices.any(null, this.createInstanceOfLambda(Query.class));
    }

    @Test(expected=NullPointerException.class)
    public void testAnyNullSet() {
        this.collectionServices.any(null, this.createInstanceOfLambda(Query.class));
    }

    @Test
    public void testAnySetNullLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Object result = this.collectionServices.any((Collection)list, null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testAnyListNullLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Object result = this.collectionServices.any((Collection)set, null);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testAnySetNotBooleanLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Assert.assertEquals(null, (Object)this.collectionServices.any((Collection)set, this.createSelfLambda()));
    }

    @Test
    public void testAnySetExceptionLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertEquals(null, (Object)this.collectionServices.any((Collection)set, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)4L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(2)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(3)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(3)).getMessage());
    }

    @Test
    public void testAnyListNotBooleanLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Assert.assertEquals(null, (Object)this.collectionServices.any((Collection)list, this.createSelfLambda()));
    }

    @Test
    public void testAnyListExceptionLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertEquals(null, (Object)this.collectionServices.any((Collection)list, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)4L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(2)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(3)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(3)).getMessage());
    }

    @Test
    public void testAnySet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        Object result = this.collectionServices.any((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertNull((Object)result);
        set.add("s");
        result = this.collectionServices.any((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)"s", (Object)result);
    }

    @Test
    public void testAnyList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        Object result = this.collectionServices.any((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertNull((Object)result);
        list.add("s");
        result = this.collectionServices.any((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)"s", (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testCountSetNullNull() {
        this.collectionServices.count(null, null);
    }

    @Test
    public void testCountSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(null);
        Integer result = this.collectionServices.count((Set)set, null);
        Assert.assertEquals((Object)1, (Object)result);
    }

    @Test
    public void testCountSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(null);
        Integer result = this.collectionServices.count((Set)set, (Object)4);
        Assert.assertEquals((Object)0, (Object)result);
        set.add(4);
        result = this.collectionServices.count((Set)set, (Object)4);
        Assert.assertEquals((Object)1, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testCountListNullNull() {
        this.collectionServices.count(null, null);
    }

    @Test
    public void testCountListNull() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(null);
        Integer result = this.collectionServices.count((List)list, null);
        Assert.assertEquals((Object)1, (Object)result);
    }

    @Test
    public void testCountList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(null);
        list.add(1);
        Integer result = this.collectionServices.count((List)list, (Object)1);
        Assert.assertEquals((Object)2, (Object)result);
        result = this.collectionServices.count((List)list, (Object)4);
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void testExistsNullCollection() {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.collectionServices.exists(null, this.createInstanceOfLambda(Integer.class)));
    }

    @Test
    public void testExistsSetNullLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Boolean result = this.collectionServices.exists((Collection)list, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testExistsListNullLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Boolean result = this.collectionServices.exists((Collection)set, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testExistsSetNotBooleanLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Boolean result = this.collectionServices.exists((Collection)set, this.createSelfLambda());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testExistsSetExceptionLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertFalse((boolean)this.collectionServices.exists((Collection)set, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)4L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(2)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(3)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(3)).getMessage());
    }

    @Test
    public void testExistsListNotBooleanLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Boolean result = this.collectionServices.exists((Collection)list, this.createSelfLambda());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testExistsListExceptionLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertFalse((boolean)this.collectionServices.exists((Collection)list, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)4L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(2)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(3)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(3)).getMessage());
    }

    @Test
    public void testExistsSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Boolean result = this.collectionServices.exists((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
        set.add("s");
        result = this.collectionServices.exists((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testExistsList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Boolean result = this.collectionServices.exists((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
        list.add("s");
        result = this.collectionServices.exists((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testForAllNullCollection() {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.collectionServices.forAll(null, this.createSelfLambda()));
    }

    @Test
    public void testForAllListNullLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Boolean result = this.collectionServices.forAll((Collection)list, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testForAllSetNullLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Boolean result = this.collectionServices.forAll((Collection)set, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testForAllSetNotBooleanLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Boolean result = this.collectionServices.forAll((Collection)set, this.createSelfLambda());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testForAllSetExceptionLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertFalse((boolean)this.collectionServices.forAll((Collection)set, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)1L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
    }

    @Test
    public void testForAllListNotBooleanLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Boolean result = this.collectionServices.forAll((Collection)list, this.createSelfLambda());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testForAllListExceptionLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Boolean result = this.collectionServices.forAll((Collection)list, this.createSelfLambda());
        Assert.assertFalse((boolean)result);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertFalse((boolean)this.collectionServices.forAll((Collection)list, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)1L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
    }

    @Test
    public void testForAllSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Boolean result = this.collectionServices.forAll((Collection)set, this.createInstanceOfLambda(Integer.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        set.add("s");
        result = this.collectionServices.forAll((Collection)set, this.createInstanceOfLambda(Integer.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testForAllList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        Boolean result = this.collectionServices.forAll((Collection)list, this.createInstanceOfLambda(Integer.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        list.add("s");
        result = this.collectionServices.forAll((Collection)list, this.createInstanceOfLambda(Integer.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testExcludesAllNullNull() {
        this.collectionServices.excludesAll(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testExcludesAllSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.excludesAll((Collection)set, null);
    }

    @Test(expected=NullPointerException.class)
    public void testExcludesAllListNull() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.excludesAll((Collection)list, null);
    }

    @Test(expected=NullPointerException.class)
    public void testExcludesAllNullSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.excludesAll(null, (Collection)set);
    }

    @Test(expected=NullPointerException.class)
    public void testExcludesAllNullList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.excludesAll(null, (Collection)list);
    }

    @Test
    public void testExcludesAllSetSetFalse() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(5);
        Boolean result = this.collectionServices.excludesAll((Collection)set, (Collection)set1);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testExcludesAllSetSetTrue() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(6);
        set1.add(5);
        Boolean result = this.collectionServices.excludesAll((Collection)set, (Collection)set1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testExcludesAllSetListFalse() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(5);
        Boolean result = this.collectionServices.excludesAll((Collection)set, (Collection)list1);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testExcludesAllSetListTrue() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        ArrayList list1 = Lists.newArrayList();
        list1.add(6);
        list1.add(5);
        Boolean result = this.collectionServices.excludesAll((Collection)set, (Collection)list1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testExcludesAllListSetFalse() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(5);
        Boolean result = this.collectionServices.excludesAll((Collection)list, (Collection)set1);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testExcludesAllListSetTrue() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(6);
        set1.add(5);
        Boolean result = this.collectionServices.excludesAll((Collection)list, (Collection)set1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testExcludesAllListListFalse() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(5);
        Boolean result = this.collectionServices.excludesAll((Collection)list, (Collection)list1);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testExcludesAllListListTrue() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        ArrayList list1 = Lists.newArrayList();
        list1.add(6);
        list1.add(5);
        Boolean result = this.collectionServices.excludesAll((Collection)list, (Collection)list1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testIncludesAllNullNull() {
        this.collectionServices.includesAll(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testIncludesAllSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.includesAll((Collection)set, null);
    }

    @Test(expected=NullPointerException.class)
    public void testIncludesAllListNull() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.includesAll((Collection)list, null);
    }

    @Test(expected=NullPointerException.class)
    public void testIncludesAllNullSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.includesAll(null, (Collection)set);
    }

    @Test(expected=NullPointerException.class)
    public void testIncludesAllNullList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.includesAll(null, (Collection)list);
    }

    @Test
    public void testIncludesAllSetSetFalse() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(5);
        Boolean result = this.collectionServices.includesAll((Collection)set, (Collection)set1);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testIncludesAllSetSetTrue() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(2);
        Boolean result = this.collectionServices.includesAll((Collection)set, (Collection)set1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testIncludesAllSetListFalse() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(5);
        Boolean result = this.collectionServices.includesAll((Collection)set, (Collection)list1);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testIncludesAllSetListTrue() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(2);
        Boolean result = this.collectionServices.includesAll((Collection)set, (Collection)list1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testIncludesAllListSetFalse() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(5);
        Boolean result = this.collectionServices.includesAll((Collection)list, (Collection)set1);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testIncludesAllListSetTrue() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(2);
        Boolean result = this.collectionServices.includesAll((Collection)list, (Collection)set1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test
    public void testIncludesAllListListFalse() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(5);
        Boolean result = this.collectionServices.includesAll((Collection)list, (Collection)list1);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testIncludesAllListListTrue() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(2);
        Boolean result = this.collectionServices.includesAll((Collection)list, (Collection)list1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testIsUniqueNullNull() {
        this.collectionServices.isUnique(null, null);
    }

    @Test
    public void testIsUniqueSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(3);
        Boolean result = this.collectionServices.isUnique((Collection)set, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testIsUniqueListNull() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(3);
        Boolean result = this.collectionServices.isUnique((Collection)list, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testIsUniqueSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        Boolean result = this.collectionServices.isUnique((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        set.add("a");
        result = this.collectionServices.isUnique((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        set.add("b");
        result = this.collectionServices.isUnique((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testIsUniqueList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        Boolean result = this.collectionServices.isUnique((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        list.add("a");
        result = this.collectionServices.isUnique((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        list.add("b");
        result = this.collectionServices.isUnique((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testOneNullNull() {
        this.collectionServices.one(null, null);
    }

    @Test
    public void testOneSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(3);
        Boolean result = this.collectionServices.one((Collection)set, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
        set.add(null);
        result = this.collectionServices.one((Collection)set, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testOneListNull() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(3);
        Boolean result = this.collectionServices.one((Collection)list, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
        list.add(null);
        result = this.collectionServices.one((Collection)list, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testOneSetNotBooleanLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(3);
        Boolean result = this.collectionServices.one((Collection)set, this.createSelfLambda());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testOneSetExceptionLambda() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(3);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertFalse((boolean)this.collectionServices.one((Collection)set, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)2L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
    }

    @Test
    public void testOneListNotBooleanLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(3);
        Boolean result = this.collectionServices.one((Collection)list, this.createSelfLambda());
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testOneListExceptionLambda() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(3);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        Assert.assertFalse((boolean)this.collectionServices.one((Collection)list, this.createExceptionLambda((Diagnostic)diagnostic)));
        Assert.assertEquals((long)2L, (long)diagnostic.getSeverity());
        Assert.assertEquals((long)2L, (long)diagnostic.getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(0)).getMessage());
        Assert.assertEquals((long)2L, (long)((Diagnostic)diagnostic.getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"Test runtime exception lambda.", (Object)((Diagnostic)diagnostic.getChildren().get(1)).getMessage());
    }

    @Test
    public void testOneSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(3);
        Boolean result = this.collectionServices.one((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
        set.add("s");
        result = this.collectionServices.one((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        set.add("a");
        result = this.collectionServices.one((Collection)set, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test
    public void testOneList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(3);
        Boolean result = this.collectionServices.one((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
        list.add("s");
        result = this.collectionServices.one((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result);
        list.add("a");
        result = this.collectionServices.one((Collection)list, this.createInstanceOfLambda(String.class));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testSumNull() {
        this.collectionServices.sum(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSumSetNotNumber() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add("potatoes");
        set.add(3);
        this.collectionServices.sum((Collection)set);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSumListNotNumber() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add("potatoes");
        list.add(3);
        this.collectionServices.sum((Collection)list);
    }

    @Test
    public void testSumSetIntegers() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        Number result = this.collectionServices.sum((Collection)set);
        Assert.assertTrue((boolean)(result instanceof Long));
        Assert.assertEquals((Object)6L, (Object)result);
    }

    @Test
    public void testSumSetTypeMix() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2L);
        set.add(3.0);
        set.add(Float.valueOf(4.0f));
        Number result = this.collectionServices.sum((Collection)set);
        Assert.assertTrue((boolean)(result instanceof Double));
        Assert.assertEquals((Object)10.0, (Object)result);
    }

    @Test
    public void testSumListIntegers() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        Number result = this.collectionServices.sum((Collection)list);
        Assert.assertTrue((boolean)(result instanceof Long));
        Assert.assertEquals((Object)6L, (Object)result);
    }

    @Test
    public void testSumListTypeMix() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2.0);
        list.add(Float.valueOf(3.0f));
        Number result = this.collectionServices.sum((Collection)list);
        Assert.assertTrue((boolean)(result instanceof Double));
        Assert.assertEquals((Object)6.0, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testIndexOfNullListNull() {
        this.collectionServices.indexOf(null, null);
    }

    @Test
    public void testIndexOfListNull() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        Integer result = this.collectionServices.indexOf((List)list, null);
        Assert.assertEquals((Object)0, (Object)result);
        list.add(2, null);
        result = this.collectionServices.indexOf((List)list, null);
        Assert.assertEquals((Object)3, (Object)result);
    }

    @Test
    public void testIndexOfList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        Integer result = this.collectionServices.indexOf((List)list, (Object)7);
        Assert.assertEquals((Object)0, (Object)result);
        result = this.collectionServices.indexOf((List)list, (Object)3);
        Assert.assertEquals((Object)3, (Object)result);
        list.remove((Object)3);
        result = this.collectionServices.indexOf((List)list, (Object)3);
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testIndexOfNullSetNull() {
        this.collectionServices.indexOf(null, null);
    }

    @Test
    public void testIndexOfSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        Integer result = this.collectionServices.indexOf((Set)set, null);
        Assert.assertEquals((Object)0, (Object)result);
        set.add(null);
        result = this.collectionServices.indexOf((Set)set, null);
        Assert.assertEquals((Object)4, (Object)result);
    }

    @Test
    public void testIndexOfSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(null);
        set.add(1);
        set.add(2);
        set.add(3);
        Integer result = this.collectionServices.indexOf((Set)set, (Object)7);
        Assert.assertEquals((Object)0, (Object)result);
        result = this.collectionServices.indexOf((Set)set, (Object)3);
        Assert.assertEquals((Object)4, (Object)result);
        set.remove(3);
        result = this.collectionServices.indexOf((Set)set, (Object)3);
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void testIndexOfSetEquality() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(null);
        set.add(ImmutableSet.of((Object)"s"));
        set.add(1);
        Integer result = this.collectionServices.indexOf((Set)set, (Object)7);
        Assert.assertEquals((Object)0, (Object)result);
        result = this.collectionServices.indexOf((Set)set, (Object)ImmutableSet.of((Object)"s"));
        Assert.assertEquals((Object)2, (Object)result);
        set.remove(ImmutableSet.of((Object)"s"));
        result = this.collectionServices.indexOf((Set)set, (Object)ImmutableSet.of((Object)"s"));
        Assert.assertEquals((Object)0, (Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testInsertAtNullList() {
        this.collectionServices.insertAt(null, Integer.valueOf(1), null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testInsertAtListUnderLowerBound() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        this.collectionServices.insertAt((List)list, Integer.valueOf(0), null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testInsertAtListOverUpperBound() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        this.collectionServices.insertAt((List)list, Integer.valueOf(5), null);
    }

    @Test
    public void testInsertAtList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        List result = this.collectionServices.insertAt((List)list, Integer.valueOf(2), null);
        Assert.assertTrue((list != result ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)1, result.get(0));
        Assert.assertEquals(null, result.get(1));
        Assert.assertEquals((Object)2, result.get(2));
        Assert.assertEquals((Object)3, result.get(3));
    }

    @Test
    public void testInsertAtExtremityList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        List result = this.collectionServices.insertAt((List)list, Integer.valueOf(1), null);
        Assert.assertTrue((list != result ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals(null, result.get(0));
        Assert.assertEquals((Object)1, result.get(1));
        Assert.assertEquals((Object)2, result.get(2));
        Assert.assertEquals((Object)3, result.get(3));
        result = this.collectionServices.insertAt(result, Integer.valueOf(5), (Object)10.0);
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals(null, result.get(0));
        Assert.assertEquals((Object)1, result.get(1));
        Assert.assertEquals((Object)2, result.get(2));
        Assert.assertEquals((Object)3, result.get(3));
        Assert.assertEquals((Object)10.0, result.get(4));
    }

    @Test(expected=NullPointerException.class)
    public void testInsertAtNullSet() {
        this.collectionServices.insertAt(null, Integer.valueOf(1), null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testInsertAtSetUnderLowerBound() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        this.collectionServices.insertAt((Set)set, Integer.valueOf(0), null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testInsertAtSetOverUpperBound() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        this.collectionServices.insertAt((Set)set, Integer.valueOf(5), null);
    }

    @Test
    public void testInsertAtSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        Set result = this.collectionServices.insertAt((Set)set, Integer.valueOf(2), null);
        Assert.assertTrue((set != result ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals(null, itr.next());
        Assert.assertEquals((Object)2, itr.next());
        Assert.assertEquals((Object)3, itr.next());
    }

    @Test
    public void testInsertAtExtremitySet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        Set result = this.collectionServices.insertAt((Set)set, Integer.valueOf(1), null);
        Assert.assertTrue((set != result ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals(null, itr.next());
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals((Object)2, itr.next());
        Assert.assertEquals((Object)3, itr.next());
        result = this.collectionServices.insertAt(result, Integer.valueOf(5), (Object)10);
        Assert.assertEquals((long)5L, (long)result.size());
        itr = result.iterator();
        Assert.assertEquals(null, itr.next());
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals((Object)2, itr.next());
        Assert.assertEquals((Object)3, itr.next());
        Assert.assertEquals((Object)10, itr.next());
    }

    @Test
    public void testInsertAtSetDuplicate() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        Set result = this.collectionServices.insertAt((Set)set, Integer.valueOf(1), (Object)3);
        Assert.assertTrue((set != result ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)3, itr.next());
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals((Object)2, itr.next());
    }

    @Test
    public void testInsertAtSetDuplicateEquality() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(ImmutableSet.of((Object)"s"));
        set.add(2);
        Set result = this.collectionServices.insertAt((Set)set, Integer.valueOf(3), (Object)ImmutableSet.of((Object)"s"));
        Assert.assertTrue((set != result ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals((Object)2, itr.next());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"s"), itr.next());
    }

    @Test(expected=NullPointerException.class)
    public void testPrependNullList() {
        this.collectionServices.prepend(null, null);
    }

    @Test
    public void testPrependList() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        List result = this.collectionServices.prepend((List)list, null);
        Assert.assertTrue((list != result ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals(null, result.get(0));
        Assert.assertEquals((Object)1, result.get(1));
        Assert.assertEquals((Object)2, result.get(2));
        Assert.assertEquals((Object)3, result.get(3));
    }

    @Test
    public void testPrependListDuplicate() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        List result = this.collectionServices.prepend((List)list, (Object)2);
        Assert.assertTrue((list != result ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)2, result.get(0));
        Assert.assertEquals((Object)1, result.get(1));
        Assert.assertEquals((Object)2, result.get(2));
        Assert.assertEquals((Object)3, result.get(3));
    }

    @Test(expected=NullPointerException.class)
    public void testPrependNullSet() {
        this.collectionServices.prepend(null, null);
    }

    @Test
    public void testPrependSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        Set result = this.collectionServices.prepend((Set)set, null);
        Assert.assertTrue((set != result ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals(null, itr.next());
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals((Object)2, itr.next());
        Assert.assertEquals((Object)3, itr.next());
    }

    @Test
    public void testPrependSetDuplicate() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        Set result = this.collectionServices.prepend((Set)set, (Object)2);
        Assert.assertTrue((set != result ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator itr = result.iterator();
        Assert.assertEquals((Object)2, itr.next());
        Assert.assertEquals((Object)1, itr.next());
        Assert.assertEquals((Object)3, itr.next());
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectionSetNullNull() {
        this.collectionServices.intersection(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectionSetSetNull() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        this.collectionServices.intersection((Set)set, null);
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectionSetNullSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        this.collectionServices.intersection(null, (Collection)set);
    }

    @Test
    public void testIntersectionSetSameSize() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(2);
        set1.add(3);
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        set2.add(3);
        set2.add(4);
        set2.add(1);
        Set result = this.collectionServices.intersection((Set)set1, (Collection)set2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)1, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionSetLongestFirst() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(2);
        set1.add(3);
        set1.add(4);
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        set2.add(3);
        set2.add(5);
        set2.add(1);
        Set result = this.collectionServices.intersection((Set)set1, (Collection)set2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)1, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionSetLongestSecond() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(2);
        set1.add(3);
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        set2.add(3);
        set2.add(4);
        set2.add(1);
        set2.add(5);
        Set result = this.collectionServices.intersection((Set)set1, (Collection)set2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)1, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionSetIntegerDouble() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add(1);
        set1.add(2);
        set1.add(3);
        set1.add(4);
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        set2.add(3.0);
        set2.add(5.0);
        set2.add(1.0);
        Set result = this.collectionServices.intersection((Set)set1, (Collection)set2);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testIntersectionSetDifferentClasses() {
        LinkedHashSet set1 = Sets.newLinkedHashSet();
        set1.add("aString");
        set1.add(1);
        set1.add(2);
        set1.add("anotherString");
        set1.add("aThirdString");
        LinkedHashSet set2 = Sets.newLinkedHashSet();
        set2.add("aThirdString");
        set2.add("a");
        set2.add("b");
        set2.add("anotherString");
        set2.add("c");
        Set result = this.collectionServices.intersection((Set)set1, (Collection)set2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)"anotherString", it.next());
        Assert.assertEquals((Object)"aThirdString", it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionSetList() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        ArrayList list = Lists.newArrayList();
        list.add(3);
        list.add(4);
        list.add(1);
        list.add(5);
        list.add(1);
        Set result = this.collectionServices.intersection((Set)set, (Collection)list);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)1, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectionListNullNull() {
        this.collectionServices.intersection(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectionListSetNull() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        this.collectionServices.intersection((List)list, null);
    }

    @Test(expected=NullPointerException.class)
    public void testIntersectionListNullSet() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        this.collectionServices.intersection(null, (Collection)list);
    }

    @Test
    public void testIntersectionListSameSize() {
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(2);
        list1.add(3);
        ArrayList list2 = Lists.newArrayList();
        list2.add(3);
        list2.add(4);
        list2.add(1);
        List result = this.collectionServices.intersection((List)list1, (Collection)list2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)1, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionListLongestFirst() {
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(2);
        list1.add(3);
        list1.add(4);
        ArrayList list2 = Lists.newArrayList();
        list2.add(3);
        list2.add(5);
        list2.add(1);
        List result = this.collectionServices.intersection((List)list1, (Collection)list2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)1, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionListLongestSecond() {
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(2);
        list1.add(3);
        ArrayList list2 = Lists.newArrayList();
        list2.add(3);
        list2.add(4);
        list2.add(1);
        list2.add(5);
        List result = this.collectionServices.intersection((List)list1, (Collection)list2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)1, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionListIntegerDouble() {
        ArrayList list1 = Lists.newArrayList();
        list1.add(1);
        list1.add(2);
        list1.add(3);
        list1.add(4);
        ArrayList list2 = Lists.newArrayList();
        list2.add(3.0);
        list2.add(5.0);
        list2.add(1.0);
        List result = this.collectionServices.intersection((List)list1, (Collection)list2);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testIntersectionListDifferentClasses() {
        ArrayList list1 = Lists.newArrayList();
        list1.add("aString");
        list1.add(1);
        list1.add(2);
        list1.add("anotherString");
        list1.add("aThirdString");
        ArrayList list2 = Lists.newArrayList();
        list2.add("aThirdString");
        list2.add("a");
        list2.add("b");
        list2.add("anotherString");
        list2.add("c");
        List result = this.collectionServices.intersection((List)list1, (Collection)list2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)"anotherString", it.next());
        Assert.assertEquals((Object)"aThirdString", it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionListDuplicatesInFirst() {
        ArrayList list1 = Lists.newArrayList();
        list1.add("a");
        list1.add("b");
        list1.add("a");
        list1.add("c");
        list1.add("b");
        ArrayList list2 = Lists.newArrayList();
        list2.add("b");
        list2.add("d");
        list2.add("c");
        List result = this.collectionServices.intersection((List)list1, (Collection)list2);
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)"b", it.next());
        Assert.assertEquals((Object)"c", it.next());
        Assert.assertEquals((Object)"b", it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionListDuplicatesInSecond() {
        ArrayList list1 = Lists.newArrayList();
        list1.add("b");
        list1.add("d");
        list1.add("c");
        ArrayList list2 = Lists.newArrayList();
        list2.add("a");
        list2.add("b");
        list2.add("a");
        list2.add("c");
        list2.add("b");
        List result = this.collectionServices.intersection((List)list1, (Collection)list2);
        Assert.assertEquals((long)2L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)"b", it.next());
        Assert.assertEquals((Object)"c", it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionListDuplicatesOrder() {
        ArrayList list1 = Lists.newArrayList();
        list1.add("a");
        list1.add("b");
        list1.add("a");
        list1.add("c");
        list1.add("b");
        ArrayList list2 = Lists.newArrayList();
        list2.add("b");
        list2.add("a");
        list2.add("d");
        list2.add("b");
        List result = this.collectionServices.intersection((List)list1, (Collection)list2);
        Assert.assertEquals((long)4L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)"a", it.next());
        Assert.assertEquals((Object)"b", it.next());
        Assert.assertEquals((Object)"a", it.next());
        Assert.assertEquals((Object)"b", it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testIntersectionListSet() {
        ArrayList list = Lists.newArrayList();
        list.add(3);
        list.add(4);
        list.add(1);
        list.add(5);
        list.add(1);
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        List result = this.collectionServices.intersection((List)list, (Collection)set);
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)3, it.next());
        Assert.assertEquals((Object)1, it.next());
        Assert.assertEquals((Object)1, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test(expected=NullPointerException.class)
    public void testSubOrderedSetNull() {
        this.collectionServices.subOrderedSet(null, Integer.valueOf(1), Integer.valueOf(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubOrderedSetStartTooLow() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.subOrderedSet((Set)set, Integer.valueOf(0), Integer.valueOf(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubOrderedSetStartTooHigh() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.subOrderedSet((Set)set, Integer.valueOf(5), Integer.valueOf(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubOrderedSetEndTooLow() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.subOrderedSet((Set)set, Integer.valueOf(1), Integer.valueOf(0));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubOrderedSetEndTooHigh() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.subOrderedSet((Set)set, Integer.valueOf(1), Integer.valueOf(5));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubOrderedSetEndLowerThanStart() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        this.collectionServices.subOrderedSet((Set)set, Integer.valueOf(3), Integer.valueOf(2));
    }

    @Test
    public void testSubOrderedSetStartEqualsEnd() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Set result = this.collectionServices.subOrderedSet((Set)set, Integer.valueOf(3), Integer.valueOf(3));
        Assert.assertEquals((long)1L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)3, it.next());
    }

    @Test
    public void testSubOrderedSet() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(4);
        Set result = this.collectionServices.subOrderedSet((Set)set, Integer.valueOf(2), Integer.valueOf(4));
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)2, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertEquals((Object)4, it.next());
    }

    @Test(expected=NullPointerException.class)
    public void testSubSequenceNull() {
        this.collectionServices.subSequence(null, Integer.valueOf(1), Integer.valueOf(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceStartTooLow() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.subSequence((List)list, Integer.valueOf(0), Integer.valueOf(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceStartTooHigh() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.subSequence((List)list, Integer.valueOf(5), Integer.valueOf(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceEndTooLow() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.subSequence((List)list, Integer.valueOf(1), Integer.valueOf(0));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceEndTooHigh() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.subSequence((List)list, Integer.valueOf(1), Integer.valueOf(5));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceEndLowerThanStart() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        this.collectionServices.subSequence((List)list, Integer.valueOf(3), Integer.valueOf(2));
    }

    @Test
    public void testSubSequenceStartEqualsEnd() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        List result = this.collectionServices.subSequence((List)list, Integer.valueOf(3), Integer.valueOf(3));
        Assert.assertEquals((long)1L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)3, it.next());
    }

    @Test
    public void testSubSequence() {
        ArrayList list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        List result = this.collectionServices.subSequence((List)list, Integer.valueOf(2), Integer.valueOf(4));
        Assert.assertEquals((long)3L, (long)result.size());
        Iterator it = result.iterator();
        Assert.assertEquals((Object)2, it.next());
        Assert.assertEquals((Object)3, it.next());
        Assert.assertEquals((Object)4, it.next());
    }

    private final class SortedByCounter
    extends LambdaValue {
        private int counter;

        private SortedByCounter(Lambda literal, Map<String, Object> variables, AstEvaluator envEvaluator) {
            super(literal, variables, envEvaluator, null);
            this.counter = 0;
        }

        public Object eval(Object[] args) {
            ++this.counter;
            return args[0];
        }
    }

    private static class TestClosure {
        final List<Object> refs = new ArrayList<Object>();

        private TestClosure() {
        }

        public List<Object> getRefs() {
            return this.refs;
        }
    }
}

