/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.parser.tests.ValidationTest;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;

public class CollectionServicesAstValidationTest
extends AbstractServicesValidationTest {
    @Test
    public void testConcatEmptyListEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->concat(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty Sequence defined in extension\n Empty Sequence defined in extension", 10, 30);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty Sequence defined in extension\n Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatIntListRealList() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->concat(Sequence{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testConcatEmptyListEmptySet() {
        IValidationResult validationResult = this.validate("Sequence{}->concat(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty Sequence defined in extension\n Empty OrderedSet defined in extension", 10, 32);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty Sequence defined in extension\n Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatIntListRealSet() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->concat(OrderedSet{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testConcatListNull() {
        IValidationResult validationResult = this.validate("Sequence{}->concat(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty Sequence defined in extension\n concat can only be called on collections, but null was used as its argument.", 10, 24);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty Sequence defined in extension\n concat can only be called on collections, but null was used as its argument.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatListNullAsList() {
        IValidationResult validationResult = this.validate("Sequence{}->concat(null->asSequence())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 23, 37);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 10, 38);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatListNullAsSet() {
        IValidationResult validationResult = this.validate("Sequence{}->concat(null->asSet())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 23, 32);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 10, 33);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatNullList() {
        IValidationResult validationResult = this.validate("null->concat(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty Sequence defined in extension", 4, 24);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatNullSet() {
        IValidationResult validationResult = this.validate("null->concat(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty OrderedSet defined in extension", 4, 26);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatEmptySetEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->concat(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty OrderedSet defined in extension\n Empty OrderedSet defined in extension", 12, 34);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty OrderedSet defined in extension\n Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatIntSetRealSet() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->concat(OrderedSet{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testConcatEmptySetEmptyList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->concat(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty OrderedSet defined in extension\n Empty Sequence defined in extension", 12, 32);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty OrderedSet defined in extension\n Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatIntSetRealList() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->concat(Sequence{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testConcatSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{}->concat(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty OrderedSet defined in extension\n concat can only be called on collections, but null was used as its argument.", 12, 26);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty OrderedSet defined in extension\n concat can only be called on collections, but null was used as its argument.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatSetNullAsList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->concat(null->asSequence())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 25, 39);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 12, 40);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testConcatSetNullAsSet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->concat(null->asSet())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 25, 34);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after concat:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 12, 35);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after concat:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testUnionEmptyListEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->union(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after union:\n Empty Sequence defined in extension\n Empty Sequence defined in extension", 10, 29);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after union:\n Empty Sequence defined in extension\n Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testUnionIntListRealList() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->union(Sequence{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testUnionListNull() {
        IValidationResult validationResult = this.validate("Sequence{}->union(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after union:\n Empty Sequence defined in extension\n union can only be called on collections, but null was used as its argument.", 10, 23);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after union:\n Empty Sequence defined in extension\n union can only be called on collections, but null was used as its argument.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testUnionListNullAsList() {
        IValidationResult validationResult = this.validate("Sequence{}->union(null->asSequence())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 22, 36);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after union:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 10, 37);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after union:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testUnionNullSet() {
        IValidationResult validationResult = this.validate("null->union(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after union:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty OrderedSet defined in extension", 4, 25);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after union:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testUnionEmptySetEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->union(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after union:\n Empty OrderedSet defined in extension\n Empty OrderedSet defined in extension", 12, 33);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after union:\n Empty OrderedSet defined in extension\n Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testUnionIntSetRealSet() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->union(OrderedSet{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testUnionSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{}->union(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after union:\n Empty OrderedSet defined in extension\n union can only be called on collections, but null was used as its argument.", 12, 25);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after union:\n Empty OrderedSet defined in extension\n union can only be called on collections, but null was used as its argument.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testUnionSetNullAsSet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->union(null->asSet())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 24, 33);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after union:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 12, 34);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after union:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testAddImplicitSetNothingStringAsSequence() {
        VariableBuilder variables = new VariableBuilder().addVar("self", new IType[]{this.nothingType("Empty")});
        IValidationResult validationResult = this.validate("self->add('hello'->asSequence())", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Empty", 0, 4);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testAddImplicitSetNothingStringAsSet() {
        VariableBuilder variables = new VariableBuilder().addVar("self", new IType[]{this.nothingType("Empty")});
        IValidationResult validationResult = this.validate("self->add('hello'->asSet())", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Empty", 0, 4);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testAddImplicitSetStringSequenceOfNothing() {
        VariableBuilder variables = new VariableBuilder().addVar("self", new IType[]{this.sequenceType((IType)this.nothingType("Empty"))});
        IValidationResult validationResult = this.validate("'hello'->add(self)", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty", 13, 17);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testAddImplicitSetStringSetOfNothing() {
        VariableBuilder variables = new VariableBuilder().addVar("self", new IType[]{this.setType((IType)this.nothingType("Empty"))});
        IValidationResult validationResult = this.validate("'hello'->add(self)", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty", 13, 17);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testAddImplicitSet() {
        IValidationResult validationResult = this.validate("'hello'->add(Sequence{1,2,3})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testAddSetNothingString() {
        VariableBuilder variables = new VariableBuilder().addVar("self", new IType[]{this.setType((IType)this.nothingType("Empty"))});
        IValidationResult validationResult = this.validate("self->add('hello')", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty", 0, 4);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAddSetStringNothing() {
        VariableBuilder variables = new VariableBuilder().addVar("self", new IType[]{this.nothingType("Empty")});
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->add(self)", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Empty", 25, 29);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testAddSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->add(OrderedSet{1,2,3})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testAddListNothingString() {
        VariableBuilder variables = new VariableBuilder().addVar("self", new IType[]{this.sequenceType((IType)this.nothingType("Empty"))});
        IValidationResult validationResult = this.validate("self->add('hello')", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty", 0, 4);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAddListStringNothing() {
        VariableBuilder variables = new VariableBuilder().addVar("self", new IType[]{this.nothingType("Empty")});
        IValidationResult validationResult = this.validate("Sequence{'hello'}->add(self)", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Empty", 23, 27);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testAddList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->add(Sequence{1,2,3})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testSubEmptyListEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->sub(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty Sequence defined in extension", 0, 27);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubIntListRealList() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->sub(Sequence{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testSubEmptyListEmptySet() {
        IValidationResult validationResult = this.validate("Sequence{}->sub(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty Sequence defined in extension", 0, 29);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubIntListRealSet() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->sub(OrderedSet{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testSubListNull() {
        IValidationResult validationResult = this.validate("Sequence{}->sub(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty Sequence defined in extension", 0, 21);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubListNullAsList() {
        IValidationResult validationResult = this.validate("Sequence{}->sub(null->asSequence())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 20, 34);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Empty Sequence defined in extension", 0, 35);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubListNullAsSet() {
        IValidationResult validationResult = this.validate("Sequence{}->sub(null->asSet())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 20, 29);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Empty Sequence defined in extension", 0, 30);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubNullList() {
        IValidationResult validationResult = this.validate("null->sub(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 0, 21);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubNullSet() {
        IValidationResult validationResult = this.validate("null->sub(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 0, 23);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubEmptySetEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->sub(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty OrderedSet defined in extension", 0, 31);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubIntSetRealSet() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->sub(OrderedSet{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testSubEmptySetEmptyList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->sub(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty OrderedSet defined in extension", 0, 29);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubIntSetRealList() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->sub(Sequence{2.0})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testSubSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{}->sub(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Empty OrderedSet defined in extension", 0, 23);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubSetNullAsList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->sub(null->asSequence())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 22, 36);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Empty OrderedSet defined in extension", 0, 37);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubSetNullAsSet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->sub(null->asSet())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 22, 31);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Empty OrderedSet defined in extension", 0, 32);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIncludingList() {
        IValidationResult validationResult = this.validate("Sequence{1}->including(2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIncludingListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{1}->including('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testIncludingListNull() {
        IValidationResult validationResult = this.validate("Sequence{1}->including(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testIncludingOnNull() {
        IValidationResult validationResult = this.validate("null->including(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testIncludingSet() {
        IValidationResult validationResult = this.validate("OrderedSet{1}->including(2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIncludingSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1}->including('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testIncludingSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{1}->including(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testExcludingList() {
        IValidationResult validationResult = this.validate("Sequence{1}->excluding(2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testExcludingListNull() {
        IValidationResult validationResult = this.validate("Sequence{1}->excluding(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testExcludingOnNull() {
        IValidationResult validationResult = this.validate("null->excluding(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 21);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testExcludingSet() {
        IValidationResult validationResult = this.validate("OrderedSet{1}->excluding(2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testExcludingSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{1}->excluding(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testReverseList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->reverse()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testReverseOnNull() {
        IValidationResult validationResult = this.validate("null->reverse()");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 15);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testReverseSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->reverse()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testIsEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->isEmpty()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsEmptyOnNull() {
        IValidationResult validationResult = this.validate("null->isEmpty()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->isEmpty()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testNotEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->notEmpty()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testNotEmptyOnNull() {
        IValidationResult validationResult = this.validate("null->notEmpty()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testNotEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->notEmpty()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testFirstList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->first()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testFirstEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->first()");
        String message = "Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, message, 10, 19);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testFirstListMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 1}->first()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class), (Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testFirstOnNull() {
        IValidationResult validationResult = this.validate("null->first()");
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, message, 4, 13);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testFirstSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->first()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testFirstSetMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 1}->first()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class), (Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testFirstEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->first()");
        String message = "Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, message, 12, 21);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testAtList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->at(1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAtListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 1}->at(1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class), (Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testAtListOutOfBounds() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->at(3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAtListZero() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->at(0)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAtListNull() {
        IValidationResult validationResult = this.validate("Sequence{1}->at(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testAtOnNull() {
        IValidationResult validationResult = this.validate("null->asSequence()->at(0)");
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 18);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, message, 18, 25);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testSizeList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->size()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testSizeEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->size()");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testSizeOnNull() {
        IValidationResult validationResult = this.validate("Sequence{}->size()");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testSizeSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->size()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testSizeEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->size()");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testAsSetSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->asSet()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testAsSetList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->asSet()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testAsSetSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 1}->asSet()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testAsSetListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 1}->asSet()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testAsOrderedSetSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->asOrderedSet()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testAsOrderedSetList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->asOrderedSet()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testAsOrderedSetSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 1}->asOrderedSet()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testAsOrderedSetListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 1}->asOrderedSet()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testAsSequenceSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->asSequence()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testAsSequenceList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->asSequence()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testAsSequenceSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 1}->asSequence()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testAsSequenceListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 1}->asSequence()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testSortedBySet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->sortedBy(i | i.size())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSortedBySetContainingNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', null, 'world'}->sortedBy(i | i.size())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSortedBySetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 1, 1.5}->sortedBy(i | i)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSortedBySetEObjectName() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        VariableBuilder variables = new VariableBuilder().addVar("eCls1", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())}).addVar("eCls2", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("OrderedSet{eCls1, eCls2}->sortedBy(i | i.name)", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))), (Object)types);
    }

    @Test
    public void testSortedBySetNoComparableLambda() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->sortedBy(i | i->asSequence())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSortedBySetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->sortedBy(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSortedByOnNull() {
        IValidationResult validationResult = this.validate("null->sortedBy(i | i.size())");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 28);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSortedByList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->sortedBy(i | i.size())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSortedByListContainingNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', null, 'world'}->sortedBy(i | i.size())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSortedByListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 1, 1.5}->sortedBy(i | i)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSortedByListEObjectName() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        VariableBuilder variables = new VariableBuilder().addVar("eCls1", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())}).addVar("eCls2", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("Sequence{eCls1, eCls2}->sortedBy(i | i.name)", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))), (Object)types);
    }

    @Test
    public void testSortedByListNoComparableLambda() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->sortedBy(i | i->asSequence())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSortedByListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->sortedBy(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSelectList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->select(i | i.size() = 5)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSelectListAlwaysTrue() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->select(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, message, 30, 51);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSelectListAlwaysFalse() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->select(i | not i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, message, 34, 56);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSelectListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->select(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: expression in a select must return a boolean", 17, 31);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "expression in a select must return a boolean";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSelectListNotBooleanLambda() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->select(i | i.size())");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: expression in a select must return a boolean", 26, 48);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "expression in a select must return a boolean";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSelectOnNull() {
        IValidationResult validationResult = this.validate("null->select(i | i <> null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 27);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSelectSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->select(i | i.size() = 5)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSelectSetAlwaysTrue() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->select(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, message, 32, 53);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSelectSetAlwaysFalse() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->select(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, message, 32, 54);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSelectSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->select(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: expression in a select must return a boolean", 19, 33);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "expression in a select must return a boolean";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSelectSetNotBooleanLambda() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->select(i | i.size())");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: expression in a select must return a boolean", 28, 50);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "expression in a select must return a boolean";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testRejectList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->reject(i | i.size() = 5)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testRejectListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->reject(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: expression in a reject must return a boolean", 17, 31);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "expression in a reject must return a boolean";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testRejectListNotBooleanLambda() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->reject(i | i.size())");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: expression in a reject must return a boolean", 26, 48);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "expression in a reject must return a boolean";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testRejectOnNull() {
        IValidationResult validationResult = this.validate("null->reject(i | i.size() = 5)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 30);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testRejectSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->reject(i | i.size() = 5)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testRejectSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->reject(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: expression in a reject must return a boolean", 19, 33);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "expression in a reject must return a boolean";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testRejectSetNotBooleanLambda() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->reject(i | i.size())");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: expression in a reject must return a boolean", 28, 50);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "expression in a reject must return a boolean";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testCollectList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->collect(i | i.size())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testCollectListImplicitFlatten() {
        IValidationResult validationResult = this.validate("Sequence{Sequence{'hello'}, Sequence{OrderedSet{1}}}->collect(i | i)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testCollectListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->collect(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)types);
    }

    @Test
    public void testCollectListNullPruned() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 1, 3.1}->collect(i | if i.oclIsKindOf(String) then i else null endif)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testCollectListAlwaysTrueBoolean() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->collect(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, message, 40, 61);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Boolean.class))), (Object)types);
    }

    @Test
    public void testCollectListAlwaysFalseBoolean() {
        IValidationResult validationResult = this.validate("Sequence{1, 2}->collect(i | i.oclIsKindOf(String))");
        String message = "Always false:\nNothing inferred when i (java.lang.Integer) is kind of java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, message, 28, 49);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Boolean.class))), (Object)types);
    }

    @Test
    public void testCollectOnNull() {
        IValidationResult validationResult = this.validate("null->collect(i | i.size())");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 27);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testCollectSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->collect(i | i.size())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testCollectSetImplicitFlatten() {
        IValidationResult validationResult = this.validate("OrderedSet{Sequence{'hello'}, Sequence{OrderedSet{1}}}->collect(i | i)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testCollectSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->collect(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)types);
    }

    @Test
    public void testCollectSetNullPruned() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 1, 3.1}->collect(i | if i.oclIsKindOf(String) then i else null endif)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testCollectSetAlwaysTrueBoolean() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->collect(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, message, 42, 63);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Boolean.class))), (Object)types);
    }

    @Test
    public void testCollectSetAlwaysFalseBoolean() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2}->collect(i | i.oclIsKindOf(String))");
        String message = "Always false:\nNothing inferred when i (java.lang.Integer) is kind of java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, message, 30, 51);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Boolean.class))), (Object)types);
    }

    @Test
    public void testClosureList() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("Sequence{pkg}->closure(i | i.eSubpackages)", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))), (Object)types);
    }

    @Test
    public void testClosureListMultipleTypes() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("Sequence{pkg}->closure(i | i.eSubpackages->union(i.eClassifiers))", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), (Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))), (Object)types);
    }

    @Test
    public void testClosureListNull() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("Sequence{pkg}->closure(null)", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testClosureOnNull() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("null->closure(i : ecore::EPackage | i.eSubpackages)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 51);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testClosureSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("OrderedSet{pkg}->closure(i | i.eSubpackages)", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))), (Object)types);
    }

    @Test
    public void testClosureSetMultipleTypes() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("OrderedSet{pkg}->closure(i | i.eSubpackages->union(i.eClassifiers))", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), (Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))), (Object)types);
    }

    @Test
    public void testClosureSetNull() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("OrderedSet{pkg}->closure(null)", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testFilterList() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("Sequence{pkg}.eClassifiers->filter(ecore::EClass)", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))), (Object)types);
    }

    @Test
    public void testFilterListMultipleTypes() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("Sequence{pkg}.eClassifiers->filter({ecore::EClass | ecore::EDataType})", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEDataType()))), (Object)types);
    }

    @Test
    public void testFilterListMultipleTypesSameHierarchy() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("Sequence{pkg}.eClassifiers->filter({ecore::EClass | ecore::EClassifier})", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))), (Object)types);
    }

    @Test
    public void testFilterListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->filter(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling filter:\nEClassifier on filter cannot be null.", 17, 31);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing will be left after calling filter:\nEClassifier on filter cannot be null.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testFilterOnNull() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("null->filter(ecore::EClass)", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling filter:\nThe Collection was empty due to a null value being wrapped as a Collection.", 4, 27);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing will be left after calling filter:\nThe Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testFilterSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("OrderedSet{pkg}.eClassifiers->filter(ecore::EClass)", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))), (Object)types);
    }

    @Test
    public void testFilterSetMultipleTypes() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("OrderedSet{pkg}.eClassifiers->filter({ecore::EClass | ecore::EDataType})", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEDataType()))), (Object)types);
    }

    @Test
    public void testFilterSetMultipleTypesSameHierarchy() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.validate("OrderedSet{pkg}.eClassifiers->filter({ecore::EClass | ecore::EClassifier})", new VariableBuilder().addVar("pkg", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())}).build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))), (Object)types);
    }

    @Test
    public void testFilterSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->filter(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling filter:\nEClassifier on filter cannot be null.", 19, 33);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing will be left after calling filter:\nEClassifier on filter cannot be null.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSepList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(' ')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSepListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepOnNull() {
        IValidationResult validationResult = this.validate("null->sep(' ')");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 14);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)2L, (long)types.size());
        Iterator typeItr = types.iterator();
        IType type = (IType)typeItr.next();
        if (!type.equals(this.sequenceType((IType)this.classType(String.class)))) {
            Assert.assertTrue((boolean)(type instanceof SequenceType));
            Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
            Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
            type = (IType)typeItr.next();
            Assert.assertEquals((Object)this.sequenceType((IType)this.classType(String.class)), (Object)type);
        } else {
            type = (IType)typeItr.next();
            Assert.assertTrue((boolean)(type instanceof SequenceType));
            Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
            Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
        }
    }

    @Test
    public void testSepSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(' ')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSepSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixListNullPrefixNullSeparatorNullSuffix() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(null, null, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixListNullSeparatorNullSuffix() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(1, null, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixListNullSuffix() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(1, 2, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixListNullSeparator() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(1, null, 3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixListNullPrefixNullSuffix() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(null, 2, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixListNullPrefixNullSeparator() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(null, null, 3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixListNullPrefix() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(null, 2, 3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->sep(1, 2, 3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixOnNull() {
        IValidationResult validationResult = this.validate("null->sep(1, 2, 3)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 18);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)2L, (long)types.size());
        Iterator typeItr = types.iterator();
        IType type = (IType)typeItr.next();
        if (!type.equals(this.sequenceType((IType)this.classType(Integer.class)))) {
            Assert.assertTrue((boolean)(type instanceof SequenceType));
            Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
            Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
            type = (IType)typeItr.next();
            Assert.assertEquals((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)type);
        } else {
            type = (IType)typeItr.next();
            Assert.assertTrue((boolean)(type instanceof SequenceType));
            Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
            Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
        }
    }

    @Test
    public void testSepPrefixSuffixSetNullPrefixNullSeparatorNullSuffix() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(null, null, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixSetNullSeparatorNullSuffix() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(1, null, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixSetNullSuffix() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(1, 2, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixSetNullSeparator() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(1, null, 3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixSetNullPrefixNullSuffix() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(null, 2, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixSetNullPrefixNullSeparator() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(null, null, 3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixSetNullPrefix() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(null, 2, 3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testSepPrefixSuffixSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->sep(1, 2, 3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testLastList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->last()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testLastEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->last()");
        String message = "Empty Sequence defined in extension";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, message, 10, 18);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testLastListMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 1}->last()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class), (Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testLastOnNull() {
        IValidationResult validationResult = this.validate("null->last()");
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testLastSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->last()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testLastSetMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 1}->last()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class), (Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testLastEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->last()");
        String message = "Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, message, 12, 20);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testExcludesList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->excludes('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->excludes('hello')");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesListMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 'hello', 2.0}->excludes('world')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->excludes(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesOnNull() {
        IValidationResult validationResult = this.validate("null->excludes('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->excludes('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesSetList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->excludes('hello')");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesSetMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 'hello', 2.0}->excludes('world')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->excludes(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->includes('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->includes('hello')");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesListMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 'hello', 2.0}->includes('world')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->includes(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesOnNull() {
        IValidationResult validationResult = this.validate("null->includes('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->includes('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesSetList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->includes('hello')");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesSetMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 'hello', 2.0}->includes('world')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->includes(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testAnyList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->any(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAnyListAlwaysTrue() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->any(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAnyListAlwaysFalse() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->any(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAnyListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->any(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class), (Object)this.classType(Integer.class), (Object)this.classType(Double.class)), (Object)types);
    }

    @Test
    public void testAnyListDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->any(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAnyListNotBooleanLambda() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->any(i | i.size())");
        String message = "expression in an any must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testAnyListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->any(null)");
        String message = "expression in an any must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testAnyOnNull() {
        IValidationResult validationResult = this.validate("null->any(i | i <> null)");
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testAnySet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->any(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAnySetAlwaysTrue() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->any(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAnySetAlwaysFalse() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->any(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAnySetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->any(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class), (Object)this.classType(Integer.class), (Object)this.classType(Double.class)), (Object)types);
    }

    @Test
    public void testAnySetDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->any(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAnySetNotBooleanLambda() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->any(i | i.size())");
        String message = "expression in an any must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testAnySetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->any(null)");
        String message = "expression in an any must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testCountList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 'map', 'map', 'hello'}->count('map')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testCountListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2, 1, 3}->count(1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testCountListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 'map', 'map', 'hello'}->count(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testCountOnNull() {
        IValidationResult validationResult = this.validate("null->count(1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testCountSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 'map', 'map', 'hello'}->count('map')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testCountSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2, 1, 3}->count(1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testCountSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 'map', 'map', 'hello'}->count(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testExistsList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->exists(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsListAlwaysTrue() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->exists(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsListAlwaysFalse() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->exists(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->exists(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsListDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->exists(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsListNotBooleanLambda() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->exists(i | i.size())");
        String message = "expression in exists must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testExistsListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->exists(null)");
        String message = "expression in exists must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testExistsOnNull() {
        IValidationResult validationResult = this.validate("null->exists(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->exists(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsSetAlwaysTrue() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->exists(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsSetAlwaysFalse() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->exists(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->exists(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsSetDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->exists(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExistsSetNotBooleanLambda() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->exists(i | i.size())");
        String message = "expression in exists must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testExistsSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->exists(null)");
        String message = "expression in exists must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testForAllList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->forAll(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllListAlwaysTrue() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->forAll(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllListAlwaysFalse() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->forAll(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->forAll(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllListDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->forAll(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllListNotBooleanLambda() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->forAll(i | i.size())");
        String message = "expression in forAll must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testForAllListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->forAll(null)");
        String message = "expression in forAll must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testForAllOnNull() {
        IValidationResult validationResult = this.validate("null->forAll(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->forAll(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllSetAlwaysTrue() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->forAll(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllSetAlwaysFalse() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->forAll(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->forAll(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllSetDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->forAll(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testForAllSetNotBooleanLambda() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->forAll(i | i.size())");
        String message = "expression in forAll must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testForAllSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->forAll(null)");
        String message = "expression in forAll must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testExcludesAllListList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->excludesAll(Sequence{'hello', 'world'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllListSet() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->excludesAll(OrderedSet{'hello', 'world'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllEmptyListList() {
        IValidationResult validationResult = this.validate("Sequence{}->excludesAll(Sequence{'hello', 'world'})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllEmptyListSet() {
        IValidationResult validationResult = this.validate("Sequence{}->excludesAll(OrderedSet{'hello', 'world'})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllListEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->excludesAll(Sequence{})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllListEmptySet() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->excludesAll(OrderedSet{})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllListListMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 'hello', 2.0}->excludesAll(Sequence{'world', null})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllListSetMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 'hello', 2.0}->excludesAll(OrderedSet{'world', null})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->excludesAll(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllOnNullList() {
        IValidationResult validationResult = this.validate("null->excludesAll(Sequence{'hello'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllOnNullSet() {
        IValidationResult validationResult = this.validate("null->excludesAll(OrderedSet{'hello'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllSetList() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->excludesAll(Sequence{'hello', 'world'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllSetSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->excludesAll(OrderedSet{'hello', 'world'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllEmptySetList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->excludesAll(Sequence{'hello', 'world'})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllEmptySetSet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->excludesAll(OrderedSet{'hello', 'world'})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllSetEmptyList() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->excludesAll(Sequence{})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllSetEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->excludesAll(OrderedSet{})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllSetListMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 'hello', 2.0}->excludesAll(Sequence{'world', null})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllSetSetMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 'hello', 2.0}->excludesAll(OrderedSet{'world', null})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testExcludesAllSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->excludesAll(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllListList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->includesAll(Sequence{'hello', 'world'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllListSet() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->includesAll(OrderedSet{'hello', 'world'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllEmptyListList() {
        IValidationResult validationResult = this.validate("Sequence{}->includesAll(Sequence{'hello', 'world'})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllEmptyListSet() {
        IValidationResult validationResult = this.validate("Sequence{}->includesAll(OrderedSet{'hello', 'world'})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllListEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->includesAll(Sequence{})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllListEmptySet() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->includesAll(OrderedSet{})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllListListMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 'hello', 2.0}->includesAll(Sequence{'world', null})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllListSetMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 'hello', 2.0}->includesAll(OrderedSet{'world', null})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->includesAll(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllOnNullList() {
        IValidationResult validationResult = this.validate("null->includesAll(Sequence{'hello'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllOnNullSet() {
        IValidationResult validationResult = this.validate("null->includesAll(OrderedSet{'hello'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllSetList() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->includesAll(Sequence{'hello', 'world'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllSetSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->includesAll(OrderedSet{'hello', 'world'})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllEmptySetList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->includesAll(Sequence{'hello', 'world'})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllEmptySetSet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->includesAll(OrderedSet{'hello', 'world'})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllSetEmptyList() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->includesAll(Sequence{})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllSetEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->includesAll(OrderedSet{})");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllSetListMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 'hello', 2.0}->includesAll(Sequence{'world', null})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllSetSetMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 'hello', 2.0}->includesAll(OrderedSet{'world', null})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIncludesAllSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->includesAll(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->isUnique(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueListAlwaysTrue() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->isUnique(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueListAlwaysFalse() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->isUnique(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->isUnique(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueListDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->isUnique(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueListNotBooleanLambda() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->isUnique(i | i.size())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->isUnique(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueOnNull() {
        IValidationResult validationResult = this.validate("null->isUnique(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->isUnique(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueSetAlwaysTrue() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->isUnique(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueSetAlwaysFalse() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->isUnique(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->isUnique(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueSetDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->isUnique(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueSetNotBooleanLambda() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->isUnique(i | i.size())");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testIsUniqueSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->isUnique(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->one(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneListAlwaysTrue() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->one(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneListAlwaysFalse() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->one(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->one(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneListDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world', 1, 2.0}->one(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneListNotBooleanLambda() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->one(i | i.size())");
        String message = "expression in one must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOneListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->one(null)");
        String message = "expression in one must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOneOnNull() {
        IValidationResult validationResult = this.validate("null->one(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->one(i | i.size() > 2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneSetAlwaysTrue() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->one(i | i.oclIsKindOf(String))");
        String message = "Always true:\nNothing inferred when i (java.lang.String) is not kind of java.lang.String";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneSetAlwaysFalse() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->one(i | i.oclIsKindOf(Integer))");
        String message = "Always false:\nNothing inferred when i (java.lang.String) is kind of java.lang.Integer";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.INFO, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->one(i | i <> null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneSetDifferentTypesNarrowing() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world', 1, 2.0}->one(i | i.oclIsKindOf(String))");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOneSetNotBooleanLambda() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->one(i | i.size())");
        String message = "expression in one must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOneSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->one(null)");
        String message = "expression in one must return a boolean";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testSumListIntegers() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->sum()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Long.class)), (Object)types);
    }

    @Test
    public void testSumListTypeMix() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3.0, 4.0}->sum()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Double.class)), (Object)types);
    }

    @Test
    public void testSumListNotNumber() {
        IValidationResult validationResult = this.validate("Sequence{1, 'potatoes', 2.0}->sum()");
        String message = "Sum can only be used on a collection of numbers.";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testSumOnNull() {
        IValidationResult validationResult = this.validate("null->sum()");
        String message = "Sum can only be used on a collection of numbers.";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testSumSetIntegers() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->sum()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Long.class)), (Object)types);
    }

    @Test
    public void testSumSetTypeMix() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3.0, 4.0}->sum()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Double.class)), (Object)types);
    }

    @Test
    public void testSumSetNotNumber() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 'potatoes', 2.0}->sum()");
        String message = "Sum can only be used on a collection of numbers.";
        Assert.assertFalse((boolean)validationResult.getMessages().isEmpty());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        Assert.assertEquals((Object)message, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getMessage());
        Assert.assertEquals((Object)ValidationMessageLevel.ERROR, (Object)((IValidationMessage)validationResult.getMessages().get(0)).getLevel());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testIndexOfList() {
        IValidationResult validationResult = this.validate("Sequence{'hello'}->indexOf('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testIndexOfEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->indexOf('hello')");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testIndexOfListMultipleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 'hello', 2.0}->indexOf('world')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testIndexOfListNull() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->indexOf(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testIndexOfOnNull() {
        IValidationResult validationResult = this.validate("null->indexOf('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testIndexOfSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello'}->indexOf('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testIndexOfSetList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->indexOf('hello')");
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testIndexOfSetMultipleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 'hello', 2.0}->indexOf('world')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testIndexOfSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->indexOf(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Integer.class)), (Object)types);
    }

    @Test
    public void testInsertAtList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->insertAt(1, ' ')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->insertAt(1, 1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testInsertAtListUnderLowerBound() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->insertAt(-1, 'newString')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtListOverUpperBound() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->insertAt(3, 'newString')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtListLowerBound() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->insertAt(0, 'newString')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtListUpperBound() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->insertAt(2, 'newString')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtListNull() {
        IValidationResult validationResult = this.validate("Sequence{1, 2}->insertAt(1, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testInsertAtOnNull() {
        IValidationResult validationResult = this.validate("null->insertAt(0, 'hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->insertAt(1, ' ')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->insertAt(1, 1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testInsertAtSetUnderLowerBound() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->insertAt(-1, 'newString')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtSetOverUpperBound() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->insertAt(3, 'newString')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtSetLowerBound() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->insertAt(0, 'newString')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtSetUpperBound() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->insertAt(2, 'newString')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testInsertAtSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2}->insertAt(1, null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testPrependList() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->prepend(' ')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testPrependListDifferentTypes() {
        IValidationResult validationResult = this.validate("Sequence{'hello', 'world'}->prepend(1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(String.class)), (Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testPrependListNull() {
        IValidationResult validationResult = this.validate("Sequence{1, 2}->prepend(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testPrependOnNull() {
        IValidationResult validationResult = this.validate("null->prepend('hello')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testPrependSet() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->prepend(' ')");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class))), (Object)types);
    }

    @Test
    public void testPrependSetDifferentTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{'hello', 'world'}->prepend(1)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(String.class)), (Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testPrependSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2}->prepend(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(null))), (Object)types);
    }

    @Test
    public void testIntersectionListList() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->intersection(Sequence{2})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIntersectionEmptyListEmptyList() {
        IValidationResult validationResult = this.validate("Sequence{}->intersection(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty Sequence defined in extension\n Empty Sequence defined in extension", 10, 36);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty Sequence defined in extension\n Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionIntListRealList() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->intersection(Sequence{2.0})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Nothing left after intersection of Sequence(java.lang.Integer) and Sequence(java.lang.Double)";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionListListIncompatibleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1.0, 2.0, 3.0}->intersection(Sequence{'hello'})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Nothing left after intersection of Sequence(java.lang.Double) and Sequence(java.lang.String)", 23, 56);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Nothing left after intersection of Sequence(java.lang.Double) and Sequence(java.lang.String)";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionListListMixedTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->intersection(Sequence{'hello', 3})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIntersectionListSet() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->intersection(OrderedSet{2})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIntersectionEmptyListEmptySet() {
        IValidationResult validationResult = this.validate("Sequence{}->intersection(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty Sequence defined in extension\n Empty OrderedSet defined in extension", 10, 38);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty Sequence defined in extension\n Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionIntListRealSet() {
        IValidationResult validationResult = this.validate("Sequence{1, 2, 3}->intersection(OrderedSet{2.0})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Nothing left after intersection of Sequence(java.lang.Integer) and Set(java.lang.Double)";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionListSetIncompatibleTypes() {
        IValidationResult validationResult = this.validate("Sequence{1.0, 2.0, 3.0}->intersection(OrderedSet{'hello'})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Nothing left after intersection of Sequence(java.lang.Double) and Set(java.lang.String)", 23, 58);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Nothing left after intersection of Sequence(java.lang.Double) and Set(java.lang.String)";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionListSetMixedTypes() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->intersection(OrderedSet{'hello', 3})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIntersectionListNull() {
        IValidationResult validationResult = this.validate("Sequence{}->intersection(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty Sequence defined in extension\n intersection can only be called on collections, but null was used as its argument.", 10, 30);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty Sequence defined in extension\n intersection can only be called on collections, but null was used as its argument.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionListNullAsList() {
        IValidationResult validationResult = this.validate("Sequence{}->intersection(null->asSequence())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 29, 43);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 10, 44);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionListNullAsSet() {
        IValidationResult validationResult = this.validate("Sequence{}->intersection(null->asSet())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 29, 38);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 10, 39);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty Sequence defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionNullList() {
        IValidationResult validationResult = this.validate("null->intersection(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty Sequence defined in extension", 4, 30);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionNullSet() {
        IValidationResult validationResult = this.validate("null->intersection(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty OrderedSet defined in extension", 4, 32);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n The Collection was empty due to a null value being wrapped as a Collection.\n Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionSetSet() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->intersection(OrderedSet{2})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIntersectionEmptySetEmptySet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->intersection(OrderedSet{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty OrderedSet defined in extension\n Empty OrderedSet defined in extension", 12, 40);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty OrderedSet defined in extension\n Empty OrderedSet defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionIntSetRealSet() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->intersection(OrderedSet{2.0})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Nothing left after intersection of Set(java.lang.Integer) and Set(java.lang.Double)";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionSetSetIncompatibleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1.0, 2.0, 3.0}->intersection(OrderedSet{'hello'})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Nothing left after intersection of Set(java.lang.Double) and Set(java.lang.String)", 25, 60);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Nothing left after intersection of Set(java.lang.Double) and Set(java.lang.String)";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionSetSetMixedTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->intersection(OrderedSet{'hello', 3})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIntersectionSetList() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->intersection(Sequence{2})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIntersectionEmptySetEmptyList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->intersection(Sequence{})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty OrderedSet defined in extension\n Empty Sequence defined in extension", 12, 38);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty OrderedSet defined in extension\n Empty Sequence defined in extension";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionIntSetRealList() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2, 3}->intersection(Sequence{2.0})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Nothing left after intersection of Set(java.lang.Integer) and Sequence(java.lang.Double)";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionSetListIncompatibleTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1.0, 2.0, 3.0}->intersection(Sequence{'hello'})");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Nothing left after intersection of Set(java.lang.Double) and Sequence(java.lang.String)", 25, 58);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Nothing left after intersection of Set(java.lang.Double) and Sequence(java.lang.String)";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionSetListMixedTypes() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->intersection(Sequence{'hello', 3})");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class))), (Object)types);
    }

    @Test
    public void testIntersectionSetNull() {
        IValidationResult validationResult = this.validate("OrderedSet{}->intersection(null)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty OrderedSet defined in extension\n intersection can only be called on collections, but null was used as its argument.", 12, 32);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty OrderedSet defined in extension\n intersection can only be called on collections, but null was used as its argument.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionSetNullAsList() {
        IValidationResult validationResult = this.validate("OrderedSet{}->intersection(null->asSequence())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 31, 45);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 12, 46);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testIntersectionSetNullAsSet() {
        IValidationResult validationResult = this.validate("OrderedSet{}->intersection(null->asSet())");
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 31, 40);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Empty collection: Nothing left after intersection:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.", 12, 41);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "Nothing left after intersection:\n Empty OrderedSet defined in extension\n The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubOrderedSet() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->subOrderedSet(2,3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubOrderedSetStartUnderLowerBound() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->subOrderedSet(0,2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubOrderedSetStartAboveUpperBound() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->subOrderedSet(4,2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubOrderedSetEndUnderLowerBound() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->subOrderedSet(2,0)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubOrderedSetEndAboveUpperBound() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->subOrderedSet(2,4)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubOrderedSetStartHigherThanEnd() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->subOrderedSet(3,2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubOrderedSetStartEqualsEnd() {
        IValidationResult validationResult = this.validate("OrderedSet{1, 2.0, 3}->subOrderedSet(2,2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.setType((IType)this.classType(Integer.class)), (Object)this.setType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubOrderedSetOnNull() {
        IValidationResult validationResult = this.validate("null->subOrderedSet(1,1)");
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: The Collection was empty due to a null value being wrapped as a Collection.", 4, 24);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        String message = "The Collection was empty due to a null value being wrapped as a Collection.";
        Assert.assertEquals((long)1L, (long)types.size());
        IType type = (IType)types.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)message, (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
    }

    @Test
    public void testSubSequence() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->subSequence(2,3)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubSequenceStartUnderLowerBound() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->subSequence(0,2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubSequenceStartAboveUpperBound() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->subSequence(4,2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubSequenceEndUnderLowerBound() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->subSequence(2,0)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubSequenceEndAboveUpperBound() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->subSequence(2,4)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubSequenceStartHigherThanEnd() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->subSequence(3,2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    @Test
    public void testSubSequenceStartEqualsEnd() {
        IValidationResult validationResult = this.validate("Sequence{1, 2.0, 3}->subSequence(2,2)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.sequenceType((IType)this.classType(Integer.class)), (Object)this.sequenceType((IType)this.classType(Double.class))), (Object)types);
    }

    private static class VariableBuilder {
        private Map<String, Set<IType>> variables = new LinkedHashMap<String, Set<IType>>();

        public VariableBuilder addVar(String name, IType ... types) {
            this.variables.put(name, (Set<IType>)ImmutableSet.copyOf((Object[])types));
            return this;
        }

        public Map<String, Set<IType>> build() {
            return this.variables;
        }
    }
}

