/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.acceleo.query.parser.tests.ValidationTest;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.junit.Assert;
import org.junit.Test;

public class BooleanServicesAstValidationTest
extends AbstractServicesValidationTest {
    @Test
    public void testOrNullNull() {
        IValidationResult validationResult = this.validate("null or null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOrBooleanNull() {
        IValidationResult validationResult = this.validate("false or null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOrNullBoolean() {
        IValidationResult validationResult = this.validate("null or false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOrIntegerInteger() {
        IValidationResult validationResult = this.validate("1 or 1");
        String expectedMessage = "Couldn't find the 'or(java.lang.Integer,java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'or(java.lang.Integer,java.lang.Integer)' service", 0, 6);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'or(java.lang.Integer,java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOrBooleanInteger() {
        IValidationResult validationResult = this.validate("false or 1");
        String expectedMessage = "Couldn't find the 'or(java.lang.Boolean,java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'or(java.lang.Boolean,java.lang.Integer)' service", 0, 10);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'or(java.lang.Boolean,java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOrIntegerBoolean() {
        IValidationResult validationResult = this.validate("1 or false");
        String expectedMessage = "Couldn't find the 'or(java.lang.Integer,java.lang.Boolean)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'or(java.lang.Integer,java.lang.Boolean)' service", 0, 10);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'or(java.lang.Integer,java.lang.Boolean)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOrFalseFalse() {
        IValidationResult validationResult = this.validate("false or false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOrFalseTrue() {
        IValidationResult validationResult = this.validate("false or true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOrTrueFalse() {
        IValidationResult validationResult = this.validate("true or false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOrTrueTrue() {
        IValidationResult validationResult = this.validate("true or true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testAndNullNull() {
        IValidationResult validationResult = this.validate("null and null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testAndBooleanNull() {
        IValidationResult validationResult = this.validate("false and null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testAndNullBoolean() {
        IValidationResult validationResult = this.validate("null and false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testAndIntegerInteger() {
        IValidationResult validationResult = this.validate("1 and 1");
        String expectedMessage = "Couldn't find the 'and(java.lang.Integer,java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'and(java.lang.Integer,java.lang.Integer)' service", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'and(java.lang.Integer,java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testAndBooleanInteger() {
        IValidationResult validationResult = this.validate("false and 1");
        String expectedMessage = "Couldn't find the 'and(java.lang.Boolean,java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'and(java.lang.Boolean,java.lang.Integer)' service", 0, 11);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'and(java.lang.Boolean,java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testAndIntegerBoolean() {
        IValidationResult validationResult = this.validate("1 and false");
        String expectedMessage = "Couldn't find the 'and(java.lang.Integer,java.lang.Boolean)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'and(java.lang.Integer,java.lang.Boolean)' service", 0, 11);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'and(java.lang.Integer,java.lang.Boolean)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testAndFalseFalse() {
        IValidationResult validationResult = this.validate("false and false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testAndFalseTrue() {
        IValidationResult validationResult = this.validate("false and true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testAndTrueFalse() {
        IValidationResult validationResult = this.validate("true and false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testAndTrueTrue() {
        IValidationResult validationResult = this.validate("true and true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testNotNull() {
        IValidationResult validationResult = this.validate("not null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testNotInteger() {
        IValidationResult validationResult = this.validate("not 1");
        String expectedMessage = "Couldn't find the 'not(java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'not(java.lang.Integer)' service", 0, 5);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'not(java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testNotFalse() {
        IValidationResult validationResult = this.validate("not false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testNotTrue() {
        IValidationResult validationResult = this.validate("not true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testImpliesNullNull() {
        IValidationResult validationResult = this.validate("null implies null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testImpliesBooleanNull() {
        IValidationResult validationResult = this.validate("false implies null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testImpliesNullBoolean() {
        IValidationResult validationResult = this.validate("null implies false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testImpliesIntegerInteger() {
        IValidationResult validationResult = this.validate("1 implies 1");
        String expectedMessage = "Couldn't find the 'implies(java.lang.Integer,java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'implies(java.lang.Integer,java.lang.Integer)' service", 0, 11);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'implies(java.lang.Integer,java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testImpliesBooleanInteger() {
        IValidationResult validationResult = this.validate("false implies 1");
        String expectedMessage = "Couldn't find the 'implies(java.lang.Boolean,java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'implies(java.lang.Boolean,java.lang.Integer)' service", 0, 15);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'implies(java.lang.Boolean,java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testImpliesIntegerBoolean() {
        IValidationResult validationResult = this.validate("1 implies false");
        String expectedMessage = "Couldn't find the 'implies(java.lang.Integer,java.lang.Boolean)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'implies(java.lang.Integer,java.lang.Boolean)' service", 0, 15);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'implies(java.lang.Integer,java.lang.Boolean)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testImpliesFalseFalse() {
        IValidationResult validationResult = this.validate("false implies false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testImpliesFalseTrue() {
        IValidationResult validationResult = this.validate("false implies true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testImpliesTrueFalse() {
        IValidationResult validationResult = this.validate("true implies false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testImpliesTrueTrue() {
        IValidationResult validationResult = this.validate("true implies true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testXorNullNull() {
        IValidationResult validationResult = this.validate("null xor null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testXorBooleanNull() {
        IValidationResult validationResult = this.validate("false xor null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testXorNullBoolean() {
        IValidationResult validationResult = this.validate("null xor false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testXorIntegerInteger() {
        IValidationResult validationResult = this.validate("1 xor 1");
        String expectedMessage = "Couldn't find the 'xor(java.lang.Integer,java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'xor(java.lang.Integer,java.lang.Integer)' service", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'xor(java.lang.Integer,java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testXorBooleanInteger() {
        IValidationResult validationResult = this.validate("false xor 1");
        String expectedMessage = "Couldn't find the 'xor(java.lang.Boolean,java.lang.Integer)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'xor(java.lang.Boolean,java.lang.Integer)' service", 0, 11);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'xor(java.lang.Boolean,java.lang.Integer)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testXorIntegerBoolean() {
        IValidationResult validationResult = this.validate("1 xor false");
        String expectedMessage = "Couldn't find the 'xor(java.lang.Integer,java.lang.Boolean)' service";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'xor(java.lang.Integer,java.lang.Boolean)' service", 0, 11);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Couldn't find the 'xor(java.lang.Integer,java.lang.Boolean)' service", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testXorFalseFalse() {
        IValidationResult validationResult = this.validate("false xor false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testXorFalseTrue() {
        IValidationResult validationResult = this.validate("false xor true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testXorTrueFalse() {
        IValidationResult validationResult = this.validate("true xor false");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testXorTrueTrue() {
        IValidationResult validationResult = this.validate("true xor true");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }
}

