/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.acceleo.query.parser.tests.ValidationTest;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;

public class AnyServicesAstValidationTest
extends AbstractServicesValidationTest {
    @Test
    public void testAddNullString() {
        IValidationResult validationResult = this.validate("null + 'string'");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAddStringNull() {
        IValidationResult validationResult = this.validate("'string' + null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAddNothingString() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing + 'string'", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testAddStringNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("'string' + nothing", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 11, 18);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testAddObjectString() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object + 'string'", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAddStringObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("'string' + object", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testDiffersNullNull() {
        IValidationResult validationResult = this.validate("null <> null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testDiffersNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null <> nothing", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testDiffersNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing <> null", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testDiffersNullObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("null <> object", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testDiffersObjectNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object <> null", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testDiffersObjectObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object <> object", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testEqualsNullNull() {
        IValidationResult validationResult = this.validate("null = null");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testEqualsNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null = nothing", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testEqualsNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing = null", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testEqualsNullObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("null = object", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testEqualsObjectNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object = null", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testEqualsObjectObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object = object", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclAsTypeNullNull() {
        IValidationResult validationResult = this.validate("null.oclAsType(null)");
        String expectedMessage = "Nothing will be left after calling oclAsType:\nnull is not compatible with type null";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nnull is not compatible with type null", 4, 20);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nnull is not compatible with type null", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOclAsTypeNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclAsType(null)", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclAsTypeNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null.oclAsType(nothing)", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 15, 22);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclAsTypeNothingNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclAsType(nothing)", variables.build());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "Nothing", 18, 25);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclAsTypeSameType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclAsType(ecore::EClass)", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)types);
    }

    @Test
    public void testOclAsTypeNotCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclAsType(ecore::EPackage)", variables.build());
        String expectedMessage = "Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 4, 31);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOclAsTypeMayBeCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclAsType(ecore::EClass)", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)types);
    }

    @Test
    public void testOclIsKindOfNullNull() {
        IValidationResult validationResult = this.validate("null.oclIsKindOf(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclIsKindOf(null)", variables.build());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when nothing (Nothing(Nothing)) is kind of null", 0, 25);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsKindOfNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null.oclIsKindOf(nothing)", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 17, 24);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsKindOfNothingNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclIsKindOf(nothing)", variables.build());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "Nothing", 20, 27);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsKindOfSameType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsKindOf(ecore::EClass)", variables.build());
        String expectedMessage = "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not kind of EClassifierLiteral=EClass";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not kind of EClassifierLiteral=EClass", 0, 31);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfNotCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsKindOf(ecore::EPackage)", variables.build());
        String expectedMessage = "Always false:\nNothing inferred when eCls (EClassifier=EClass) is kind of EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifier=EClass) is kind of EClassifierLiteral=EPackage", 0, 33);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfMayBeCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclIsKindOf(ecore::EClass)", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNullNull() {
        IValidationResult validationResult = this.validate("null.oclIsTypeOf(null)");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclIsTypeOf(null)", variables.build());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when nothing (Nothing(Nothing)) is type of null", 0, 25);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsTypeOfNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null.oclIsTypeOf(nothing)", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 17, 24);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsTypeOfNothingNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclIsTypeOf(nothing)", variables.build());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "Nothing", 20, 27);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsTypeOfSameType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsTypeOf(ecore::EClass)", variables.build());
        String expectedMessage = "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not type of EClassifierLiteral=EClass";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not type of EClassifierLiteral=EClass", 0, 31);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNotCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsTypeOf(ecore::EPackage)", variables.build());
        String expectedMessage = "Always false:\nNothing inferred when eCls (EClassifier=EClass) is type of EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifier=EClass) is type of EClassifierLiteral=EPackage", 0, 33);
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfMayBeCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclIsTypeOf(ecore::EClass)", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testToStringNull() {
        IValidationResult validationResult = this.validate("null.toString()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testToStringNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.toString()", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
    }

    @Test
    public void testToStringObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object.trace()", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testTraceNull() {
        IValidationResult validationResult = this.validate("null.trace()");
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }

    @Test
    public void testTraceNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.trace()", variables.build());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
    }

    @Test
    public void testTraceObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object.trace()", variables.build());
        Assert.assertTrue((boolean)validationResult.getMessages().isEmpty());
        IQueryBuilderEngine.AstResult ast = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(ast.getAst());
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.classType(String.class)), (Object)types);
    }
}

