/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.services.tests.AbstractServicesTest;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.LambdaType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.junit.Assert;

public abstract class AbstractServicesValidationTest
extends AbstractServicesTest {
    protected void assertNoService(String serviceName, IType[] parameterTypes) {
        IService service = this.serviceLookUp(serviceName, parameterTypes);
        Assert.assertNull((Object)service);
    }

    protected void assertValidation(IType[] expectedReturnTypes, String serviceName, IType[] parameterTypes) {
        this.assertValidation(expectedReturnTypes, expectedReturnTypes, serviceName, parameterTypes);
    }

    protected void assertValidation(IType[] expectedReturnTypes, IType[] expectedAllReturnTypes, String serviceName, IType[] parameterTypes) {
        IService service = this.serviceLookUp(serviceName, parameterTypes);
        this.assertValidation(service, expectedReturnTypes, expectedAllReturnTypes, parameterTypes);
    }

    protected void assertValidation(IService service, IType[] expectedReturnTypes, IType[] expectedAllReturnTypes, IType[] parameterTypes) {
        Assert.assertNotNull((String)"Service not found.", (Object)service);
        Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), Arrays.asList(parameterTypes));
        Assert.assertEquals((long)expectedReturnTypes.length, (long)types.size());
        int i = 0;
        for (IType type : types) {
            this.assertEqualsITypes(expectedReturnTypes[i++], type);
        }
        LinkedHashMap<List<IType>, Set> allTypes = new LinkedHashMap<List<IType>, Set>();
        allTypes.put(Arrays.asList(parameterTypes), types);
        types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
        Assert.assertEquals((long)expectedAllReturnTypes.length, (long)types.size());
        i = 0;
        for (IType type : types) {
            this.assertEqualsITypes(expectedAllReturnTypes[i++], type);
        }
    }

    protected void assertEqualsITypes(IType expected, IType actual) {
        if (expected instanceof SequenceType && actual instanceof SequenceType) {
            this.assertEqualsITypes(((SequenceType)expected).getCollectionType(), ((SequenceType)actual).getCollectionType());
        } else if (expected instanceof SetType && actual instanceof SetType) {
            this.assertEqualsITypes(((SetType)expected).getCollectionType(), ((SetType)actual).getCollectionType());
        } else if (expected instanceof NothingType && actual instanceof NothingType) {
            Assert.assertEquals((Object)((NothingType)expected).getMessage(), (Object)((NothingType)actual).getMessage());
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    protected IService serviceLookUp(String serviceName, IType[] parameterTypes) {
        IType[] argumentClasses = new IType[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            argumentClasses[i] = new ClassType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), this.getClass(parameterTypes[i]));
            ++i;
        }
        return this.getLookupEngine().lookup(serviceName, argumentClasses);
    }

    protected ClassType classType(Class<?> cls) {
        return new ClassType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), cls);
    }

    protected EClassifierType eClassifierType(EClassifier eClassifier) {
        return new EClassifierType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), eClassifier);
    }

    protected EClassifierType eClassifierLiteralType(EClassifier eClassifier) {
        return new EClassifierLiteralType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), eClassifier);
    }

    protected EClassifierSetLiteralType eClassifierSetLiteralType(EClassifier ... eClassifiers) {
        LinkedHashSet<EClassifier> eClss = new LinkedHashSet<EClassifier>(eClassifiers.length);
        EClassifier[] eClassifierArray = eClassifiers;
        int n = eClassifiers.length;
        int n2 = 0;
        while (n2 < n) {
            EClassifier eCls = eClassifierArray[n2];
            eClss.add(eCls);
            ++n2;
        }
        return new EClassifierSetLiteralType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), eClss);
    }

    protected SequenceType sequenceType(IType type) {
        return new SequenceType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), type);
    }

    protected SetType setType(IType type) {
        return new SetType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), type);
    }

    protected NothingType nothingType(String message) {
        return new NothingType(message);
    }

    protected LambdaType lambdaType(String evaluatorName, IType lambdaEvaluatorType, IType lambdaExpressionType) {
        return new LambdaType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), evaluatorName, lambdaEvaluatorType, lambdaExpressionType);
    }

    private Class<?> getClass(IType type) {
        Class result;
        Object t = type.getType();
        if (t instanceof Class) {
            result = (Class)t;
        } else if (type instanceof EClassifierLiteralType) {
            result = EClass.class;
        } else if (t instanceof EClassifier) {
            result = this.getQueryEnvironment().getEPackageProvider().getClass((EClassifier)t);
        } else {
            throw new IllegalStateException("what is the class of " + t);
        }
        return result;
    }

    protected IValidationResult validate(String expression, Map<String, Set<IType>> vars) {
        LinkedHashMap<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();
        if (vars != null) {
            variableTypes.putAll(vars);
        }
        QueryValidationEngine builder = new QueryValidationEngine((IReadOnlyQueryEnvironment)this.getQueryEnvironment());
        return builder.validate(expression, variableTypes);
    }

    protected IValidationResult validate(String expression) {
        return this.validate(expression, null);
    }

    protected static class VariableBuilder {
        private Map<String, Set<IType>> variables = new LinkedHashMap<String, Set<IType>>();

        public VariableBuilder addVar(String name, IType ... types) {
            this.variables.put(name, (Set<IType>)ImmutableSet.copyOf((Object[])types));
            return this;
        }

        public Map<String, Set<IType>> build() {
            return this.variables;
        }
    }
}

