/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.test;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.ILookupEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.test.TestServiceDefinition;
import org.eclipse.acceleo.query.tests.Setup;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EvaluationServicesTest {
    private static final String LOCAL_MODEL_PATH = "ecore/reverse.ecore";
    private Map<String, Object> variables;
    IQueryEnvironment queryEnvironment;
    ILookupEngine engine;
    EvaluationServices services;

    private LinkedHashSet<Object> createSet(Object ... elements) {
        return new LinkedHashSet<Object>(Arrays.asList(elements));
    }

    @Before
    public void setup() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        Set servicesToRegister = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, TestServiceDefinition.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)servicesToRegister);
        this.variables = new HashMap<String, Object>();
        this.variables.put("x", 1);
        this.variables.put("y", 2);
        this.variables.put("z", null);
        this.services = new EvaluationServices((IReadOnlyQueryEnvironment)this.queryEnvironment);
    }

    @Test
    public void getVariableValueNotNull() {
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertEquals((Object)1, (Object)this.services.getVariableValue(this.variables, "x", (Diagnostic)status));
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getChildren().isEmpty());
    }

    @Test
    public void getVariableValueNull() {
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertEquals(null, (Object)this.services.getVariableValue(this.variables, "z", (Diagnostic)status));
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getChildren().isEmpty());
    }

    @Test
    public void getVariableValueNonExisting() {
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertTrue((boolean)(this.services.getVariableValue(this.variables, "xx", (Diagnostic)status) instanceof Nothing));
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((long)4L, (long)child.getSeverity());
        Assert.assertNull((Object)child.getException());
        Assert.assertTrue((boolean)child.getMessage().contains("'xx' variable"));
    }

    @Test
    public void testExistingFeatureAccessOnEObject() {
        EAttribute attribute = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute.setName("attr0");
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertEquals((Object)"attr0", (Object)this.services.callOrApply("aqlFeatureAccess", new Object[]{attribute, "name"}, (Diagnostic)status));
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getChildren().isEmpty());
    }

    @Test
    public void testNonExistingFeatureAccessOnEObject() {
        EAttribute attribute = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute.setName("attr0");
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertTrue((boolean)(this.services.callOrApply("aqlFeatureAccess", new Object[]{attribute, "noname"}, (Diagnostic)status) instanceof Nothing));
        Assert.assertEquals((long)2L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((long)2L, (long)child.getSeverity());
        Assert.assertTrue((boolean)child.getMessage().contains("Feature noname"));
    }

    @Test
    public void testFeatureAccessOnObject() {
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertTrue((boolean)(this.services.callOrApply("aqlFeatureAccess", new Object[]{new Integer(3), "noname"}, (Diagnostic)status) instanceof Nothing));
        Assert.assertEquals((long)2L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((long)2L, (long)child.getSeverity());
        Assert.assertNull((Object)child.getException());
        Assert.assertEquals((Object)"Couldn't find the 'aqlFeatureAccess(java.lang.Integer,java.lang.String)' service", (Object)child.getMessage());
    }

    @Test
    public void testUnsetFeature() {
        EAttribute attribute = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertNull((Object)this.services.callOrApply("aqlFeatureAccess", new Object[]{attribute, "eType"}, (Diagnostic)status));
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getChildren().isEmpty());
    }

    @Test
    public void testFeatureAccessOnList() {
        EAttribute attribute0 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute0.setName("attr0");
        EAttribute attribute1 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute1.setName("attr1");
        ArrayList<EAttribute> list = new ArrayList<EAttribute>();
        list.add(attribute0);
        list.add(attribute1);
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("aqlFeatureAccess", new Object[]{list, "name"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((Object)"attr0", ((List)result).get(0));
        Assert.assertEquals((Object)"attr1", ((List)result).get(1));
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getChildren().isEmpty());
    }

    @Test
    public void testFeatureAccessOnSet() {
        EAttribute attribute0 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute0.setName("attr0");
        EAttribute attribute1 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute1.setName("attr1");
        LinkedHashSet<Object> set = this.createSet(attribute0, attribute1);
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("aqlFeatureAccess", new Object[]{set, "name"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof Set));
        Iterator iterator = ((Set)result).iterator();
        Assert.assertEquals((Object)"attr0", iterator.next());
        Assert.assertEquals((Object)"attr1", iterator.next());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getChildren().isEmpty());
    }

    @Test
    public void testFeatureAccessOnEmptyList() {
        ArrayList list = new ArrayList();
        BasicDiagnostic status = new BasicDiagnostic();
        Object listResult = this.services.callOrApply("aqlFeatureAccess", new Object[]{list, "noname"}, (Diagnostic)status);
        Assert.assertEquals((Object)true, (Object)(listResult instanceof List));
        Assert.assertEquals((long)0L, (long)((List)listResult).size());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getChildren().isEmpty());
    }

    @Test
    public void testFeatureAccessOnEmptySet() {
        LinkedHashSet set = new LinkedHashSet();
        BasicDiagnostic status = new BasicDiagnostic();
        Object setResult = this.services.callOrApply("aqlFeatureAccess", new Object[]{set, "noname"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(setResult instanceof Set));
        Assert.assertEquals((long)0L, (long)((Set)setResult).size());
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertTrue((boolean)status.getChildren().isEmpty());
    }

    public void testFeatureAccessOnListOneObjectOneNonModel() {
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(1));
        EAttribute attribute0 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute0.setName("attr0");
        list.add((Integer)attribute0);
        BasicDiagnostic status = new BasicDiagnostic();
        Object listResult = this.services.callOrApply("aqlFeatureAccess", new Object[]{list, "name"}, (Diagnostic)status);
        Assert.assertEquals((Object)true, (Object)(listResult instanceof List));
        Assert.assertEquals((long)2L, (long)((List)listResult).size());
        Assert.assertTrue((boolean)((List)listResult).contains("attr0"));
        Assert.assertEquals((long)2L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((long)2L, (long)child.getSeverity());
        Assert.assertNull((Object)child.getException());
        Assert.assertTrue((boolean)child.getMessage().contains("feature"));
        Assert.assertTrue((boolean)child.getMessage().contains("name"));
        Assert.assertTrue((boolean)child.getMessage().contains("non ModelObject"));
    }

    public void testFeatureAccessOnListTwoObjectsOneNonModel() {
        ArrayList<Object> list = new ArrayList<Object>();
        EAttribute attribute0 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute0.setName("attr0");
        EAttribute attribute1 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute1.setName("attr1");
        list.add(attribute0);
        list.add(1);
        list.add(attribute1);
        BasicDiagnostic status = new BasicDiagnostic();
        Object listResult = this.services.callOrApply("aqlFeatureAccess", new Object[]{list, "name"}, (Diagnostic)status);
        Assert.assertEquals((Object)true, (Object)(listResult instanceof List));
        Assert.assertEquals((long)3L, (long)((List)listResult).size());
        Assert.assertTrue((boolean)((List)listResult).contains("attr0"));
        Assert.assertTrue((boolean)((List)listResult).contains("attr1"));
        Assert.assertEquals((long)2L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((long)2L, (long)child.getSeverity());
        Assert.assertNull((Object)child.getException());
        Assert.assertTrue((boolean)child.getMessage().contains("feature"));
        Assert.assertTrue((boolean)child.getMessage().contains("name"));
        Assert.assertTrue((boolean)child.getMessage().contains("non ModelObject"));
    }

    @Test
    public void testFeatureAccessOnSetWithOneObject() {
        LinkedHashSet<Object> set = this.createSet(1);
        BasicDiagnostic status = new BasicDiagnostic();
        Object setResult = this.services.callOrApply("aqlFeatureAccess", new Object[]{set, "noname"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(setResult instanceof Set));
        Assert.assertEquals((long)0L, (long)((Set)setResult).size());
    }

    @Test
    public void testFeatureAccessOnListWithOneEObjectMissingFeature() {
        EAttribute attr = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attr.setName("attr0");
        EReference ref = (EReference)EcoreUtil.create((EClass)EcorePackage.Literals.EREFERENCE);
        ref.setContainment(true);
        ArrayList<EStructuralFeature> list = new ArrayList<EStructuralFeature>(Arrays.asList(attr, ref));
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("aqlFeatureAccess", new Object[]{list, "containment"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        Assert.assertEquals((long)1L, (long)((List)result).size());
        Assert.assertTrue((boolean)((Boolean)((List)result).get(0)));
    }

    @Test
    public void testFeatureAccessOnSetWithOneEObjectMissingFeature() {
        EAttribute attr = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attr.setName("attr0");
        EReference ref = (EReference)EcoreUtil.create((EClass)EcorePackage.Literals.EREFERENCE);
        ref.setContainment(true);
        LinkedHashSet<Object> set = this.createSet(attr, ref);
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("aqlFeatureAccess", new Object[]{set, "containment"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof Set));
        Assert.assertEquals((long)1L, (long)((Set)result).size());
        Iterator iterator = ((Set)result).iterator();
        Assert.assertTrue((boolean)((Boolean)iterator.next()));
    }

    @Test
    public void testFeatureAccessOnListWithOneNestedList() {
        EAttribute attribute0 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute0.setName("attr0");
        EAttribute attribute1 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute1.setName("attr1");
        ArrayList<Object> list1 = new ArrayList<Object>(Arrays.asList(attribute1));
        ArrayList<Object> list0 = new ArrayList<Object>(Arrays.asList(attribute0, list1));
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("aqlFeatureAccess", new Object[]{list0, "name"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        List listResult = (List)result;
        Assert.assertEquals((long)2L, (long)listResult.size());
        Assert.assertEquals((Object)"attr0", listResult.get(0));
        Assert.assertEquals((Object)"attr1", listResult.get(1));
    }

    @Test
    public void testFeatureAccessOnListWithOneNestedSet() {
        EAttribute attribute0 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute0.setName("attr0");
        EAttribute attribute1 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute1.setName("attr1");
        LinkedHashSet<Object> list1 = this.createSet(attribute1);
        ArrayList<Object> list0 = new ArrayList<Object>(Arrays.asList(attribute0, list1));
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("aqlFeatureAccess", new Object[]{list0, "name"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        List listResult = (List)result;
        Assert.assertEquals((long)2L, (long)listResult.size());
        Assert.assertEquals((Object)"attr0", listResult.get(0));
        Assert.assertEquals((Object)"attr1", listResult.get(1));
    }

    @Test
    public void testFeatureAccessOnListWithOneNestedListContainingBadObject() {
        EAttribute attribute0 = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute0.setName("attr0");
        ArrayList<Object> list1 = new ArrayList<Object>(Arrays.asList(1));
        ArrayList<Object> list0 = new ArrayList<Object>(Arrays.asList(attribute0, list1));
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("aqlFeatureAccess", new Object[]{list0, "name"}, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        List listResult = (List)result;
        Assert.assertEquals((long)1L, (long)listResult.size());
        Assert.assertEquals((Object)"attr0", listResult.get(0));
    }

    @Test
    public void serviceReturnsNullTest() {
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertNull((Object)this.services.call("serviceReturnsNull", new Object[]{1}, (Diagnostic)status));
    }

    @Test
    public void serviceNotFoundReturnsNothing() {
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertTrue((boolean)(this.services.call("noService", new Object[]{1}, (Diagnostic)status) instanceof Nothing));
    }

    @Test
    public void serviceThrowsException() {
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertTrue((boolean)(this.services.call("serviceThrowsException", new Object[]{1}, (Diagnostic)status) instanceof Nothing));
    }

    @Test
    public void serviceCallTest() {
        Object[] args = new Object[]{new Integer(1), new Integer(2)};
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertEquals((Object)3, (Object)this.services.call("add", args, (Diagnostic)status));
    }

    @Test
    public void callOrApplyOnScalarValueTest() {
        Object[] args = new Object[]{new Integer(1), new Integer(2)};
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertEquals((Object)3, (Object)this.services.callOrApply("add", args, (Diagnostic)status));
    }

    @Test
    public void callOrApplyOnEmptyList() {
        Object[] args = new Object[]{new ArrayList()};
        BasicDiagnostic status = new BasicDiagnostic();
        Object listResult = this.services.callOrApply("add", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(listResult instanceof List));
        Assert.assertEquals((long)0L, (long)((List)listResult).size());
    }

    @Test
    public void callOrApplyOnEmptySet() {
        Object[] args = new Object[]{new LinkedHashSet()};
        BasicDiagnostic status = new BasicDiagnostic();
        Object setResult = this.services.callOrApply("add", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(setResult instanceof Set));
        Assert.assertEquals((long)0L, (long)((Set)setResult).size());
    }

    @Test
    public void callOrApplyOnListTest() {
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(1, 2));
        Object[] args = new Object[]{list};
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("toString", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        List listResult = (List)result;
        Assert.assertEquals((long)2L, (long)listResult.size());
        Assert.assertEquals((Object)"1", listResult.get(0));
        Assert.assertEquals((Object)"2", listResult.get(1));
    }

    @Test
    public void callOrApplyOnSetTest() {
        LinkedHashSet<Object> set = this.createSet(1, 2);
        Object[] args = new Object[]{set};
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("toString", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof Set));
        Set setResult = (Set)result;
        Assert.assertEquals((long)2L, (long)setResult.size());
        Iterator iterator = setResult.iterator();
        Assert.assertEquals((Object)"1", iterator.next());
        Assert.assertEquals((Object)"2", iterator.next());
    }

    @Test
    public void callOrApplyOnNestedList() {
        ArrayList<Integer> list2 = new ArrayList<Integer>(Arrays.asList(3, 4));
        ArrayList<Object> list1 = new ArrayList<Object>(Arrays.asList(1, 2, list2));
        Object[] args = new Object[]{list1};
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("toString", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        List listResult = (List)result;
        Assert.assertEquals((long)4L, (long)listResult.size());
        Assert.assertEquals((Object)"1", listResult.get(0));
        Assert.assertEquals((Object)"2", listResult.get(1));
        Assert.assertEquals((Object)"3", listResult.get(2));
        Assert.assertEquals((Object)"4", listResult.get(3));
    }

    @Test
    public void callOrApplyOnNestedSet() {
        LinkedHashSet<Object> list2 = this.createSet(3, 4);
        ArrayList<Object> list1 = new ArrayList<Object>(Arrays.asList(1, 2, list2));
        Object[] args = new Object[]{list1};
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("toString", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        List listResult = (List)result;
        Assert.assertEquals((long)4L, (long)listResult.size());
        Assert.assertEquals((Object)"1", listResult.get(0));
        Assert.assertEquals((Object)"2", listResult.get(1));
        Assert.assertEquals((Object)"3", listResult.get(2));
        Assert.assertEquals((Object)"4", listResult.get(3));
    }

    @Test
    public void callOrApplySpecialOnNestedList() {
        ArrayList<Integer> list2 = new ArrayList<Integer>(Arrays.asList(3));
        ArrayList<Object> list1 = new ArrayList<Object>(Arrays.asList(1, 2, list2));
        Object[] args = new Object[]{list1};
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("special", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        List listResult = (List)result;
        Assert.assertEquals((long)2L, (long)listResult.size());
        Assert.assertEquals((Object)1, listResult.get(0));
        Assert.assertEquals((Object)2, listResult.get(1));
    }

    @Test
    public void callOrapplySpecialOnList() {
        ArrayList<Integer> list1 = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
        Object[] args = new Object[]{list1};
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("special", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof List));
        List listResult = (List)result;
        Assert.assertEquals((long)2L, (long)listResult.size());
        Assert.assertEquals((Object)1, listResult.get(0));
        Assert.assertEquals((Object)2, listResult.get(1));
    }

    @Test
    public void callOrapplySpecialOnSet() {
        LinkedHashSet<Object> set = this.createSet(1, 2, 3);
        Object[] args = new Object[]{set};
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("special", args, (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof Set));
        Set setResult = (Set)result;
        Assert.assertEquals((long)2L, (long)setResult.size());
        Iterator iterator = setResult.iterator();
        Assert.assertEquals((Object)1, iterator.next());
        Assert.assertEquals((Object)2, iterator.next());
    }

    @Test(expected=AcceleoQueryEvaluationException.class)
    public void testEmptyArgumentCall() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.call("toString", new Object[0], (Diagnostic)status);
    }

    @Test(expected=AcceleoQueryEvaluationException.class)
    public void testEmptyArgumentCallOrApply() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.callOrApply("toString", new Object[0], (Diagnostic)status);
    }

    @Test
    public void testNullArgumentCall() {
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.call("toString", new Object[1], (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof Nothing));
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Assert.assertTrue((boolean)(((Diagnostic)status.getChildren().get(0)).getException() instanceof AcceleoQueryEvaluationException));
        Assert.assertTrue((boolean)(((Diagnostic)status.getChildren().get(0)).getException().getCause() instanceof NullPointerException));
    }

    @Test
    public void testNullArgumentCallOrApply() {
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.callOrApply("toString", new Object[1], (Diagnostic)status);
        Assert.assertTrue((boolean)(result instanceof Nothing));
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Assert.assertTrue((boolean)(((Diagnostic)status.getChildren().get(0)).getException() instanceof AcceleoQueryEvaluationException));
        Assert.assertTrue((boolean)(((Diagnostic)status.getChildren().get(0)).getException().getCause() instanceof NullPointerException));
    }

    @Test
    public void testNullArgumentFeatureAccess() {
        BasicDiagnostic status = new BasicDiagnostic();
        Object[] objectArray = new Object[2];
        objectArray[1] = "name";
        this.services.callOrApply("aqlFeatureAccess", objectArray, (Diagnostic)status);
    }

    @Test(expected=AcceleoQueryEvaluationException.class)
    public void testEmptyArgumentCollectionServiceCall() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.collectionServiceCall("toString", new Object[0], (Diagnostic)status);
    }

    @Test(expected=AcceleoQueryEvaluationException.class)
    public void testNullArgumentCollectionServiceCall() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.collectionServiceCall("toString", null, (Diagnostic)status);
    }

    @Test
    public void testNullLiteralAsArgumentListCollectionServiceCall() {
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.collectionServiceCall("toString", new Object[1], (Diagnostic)status);
        Assert.assertEquals((Object)"[]", (Object)result);
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        result = this.services.collectionServiceCall("size", new Object[1], (Diagnostic)status);
        Assert.assertEquals((Object)0, (Object)result);
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        result = this.services.collectionServiceCall("first", new Object[1], (Diagnostic)status);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertEquals((long)0L, (long)status.getChildren().size());
    }

    @Test
    public void testMapFeatureAccess() throws URISyntaxException, IOException {
        ResourceSet set = new Setup().newConfiguredResourceSet();
        URL url = this.getClass().getClassLoader().getResource(LOCAL_MODEL_PATH);
        URI uri = URI.createURI((String)url.toURI().toString());
        Resource res = set.getResource(uri, true);
        res.load(Collections.EMPTY_MAP);
        EList target = ((EPackage)res.getContents().get(0)).getEClassifier("newDescription4").getEAnnotations();
        Assert.assertTrue((boolean)(target instanceof List));
        EAnnotation annotation = (EAnnotation)((List)target).get(0);
        Map.Entry entry = (Map.Entry)annotation.getDetails().get(0);
        BasicDiagnostic status = new BasicDiagnostic();
        Assert.assertEquals((Object)"archetype", (Object)this.services.callOrApply("aqlFeatureAccess", new Object[]{entry, "key"}, (Diagnostic)status));
    }

    @Test
    public void testEOperationGeneratedClass() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.call("getEClassifier", new Object[]{EcorePackage.eINSTANCE, "EClass"}, (Diagnostic)status);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)result);
    }

    @Test
    public void testEOperationGeneratedClassWithEObjectParameter() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.call("isSuperTypeOf", new Object[]{EcorePackage.eINSTANCE.getEClass(), EcorePackage.eINSTANCE.getEPackage()}, (Diagnostic)status);
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testEOperationDynamicClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("dynamic");
        ePkg.setNsURI("dynamic");
        ePkg.setNsPrefix("dynamic");
        final EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls.setName("DynamicEClass");
        ePkg.getEClassifiers().add((Object)eCls);
        EOperation eOperation = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        eOperation.setName("dynamicEOperation");
        eOperation.setEType((EClassifier)EcorePackage.eINSTANCE.getEcoreFactory().createEClass());
        EParameter eParameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        eParameter.setName("dynamicParameter");
        eParameter.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        eOperation.getEParameters().add((Object)eParameter);
        eCls.getEOperations().add((Object)eOperation);
        ((EOperation.Internal)eOperation).setInvocationDelegate(new EOperation.Internal.InvocationDelegate(){

            public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
                return eCls;
            }
        });
        this.queryEnvironment.registerEPackage(ePkg);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObject receiver = EcoreUtil.create((EClass)eCls);
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.call("dynamicEOperation", new Object[]{receiver, "EClass"}, (Diagnostic)status);
        Assert.assertEquals((Object)eCls, (Object)result);
    }

    @Test
    public void testEOperationDynamicClassWithEObjectParameter() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("dynamic");
        ePkg.setNsURI("dynamic");
        ePkg.setNsPrefix("dynamic");
        final EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls.setName("DynamicEClass");
        ePkg.getEClassifiers().add((Object)eCls);
        EOperation eOperation = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        eOperation.setName("dynamicEOperation");
        eOperation.setEType((EClassifier)EcorePackage.eINSTANCE.getEcoreFactory().createEClass());
        EParameter eParameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
        eParameter.setName("dynamicParameter");
        eParameter.setEType((EClassifier)eCls);
        eOperation.getEParameters().add((Object)eParameter);
        eCls.getEOperations().add((Object)eOperation);
        ((EOperation.Internal)eOperation).setInvocationDelegate(new EOperation.Internal.InvocationDelegate(){

            public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
                return eCls;
            }
        });
        this.queryEnvironment.registerEPackage(ePkg);
        EObject receiver = EcoreUtil.create((EClass)eCls);
        BasicDiagnostic status = new BasicDiagnostic();
        Object result = this.services.call("dynamicEOperation", new Object[]{receiver, receiver}, (Diagnostic)status);
        Assert.assertEquals((Object)eCls, (Object)result);
    }
}

