/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.QueryEnvironment;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.acceleo.query.runtime.test.TestServiceDefinition;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EvaluationServiceStatusTests {
    private static final String NON_EOBJECT_FEATURE_ACCESS = "Couldn't find the 'aqlFeatureAccess(java.lang.Integer,java.lang.String)' service";
    private static final String SERVICE_NOT_FOUND = "Couldn't find the 'noservice(java.lang.Integer)' service";
    private static final String VARIABLE_NOT_FOUND = "Couldn't find the 'novariable' variable";
    private static final String UNKNOWN_FEATURE = "Feature noname not found in EClass EAttribute";
    Map<String, Object> variables;
    BasicLookupEngine engine;
    QueryEnvironment queryEnvironment;
    EvaluationServices services;

    @Before
    public void setup() {
        this.queryEnvironment = (QueryEnvironment)Query.newEnvironmentWithDefaultServices(null);
        this.engine = this.queryEnvironment.getLookupEngine();
        Set servicesToRegister = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, TestServiceDefinition.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)servicesToRegister);
        this.variables = new HashMap<String, Object>();
        this.variables.put("x", 1);
        this.variables.put("y", 2);
        this.services = new EvaluationServices((IReadOnlyQueryEnvironment)this.queryEnvironment);
    }

    @Test
    public void variableNotFoundStatusTest() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.getVariableValue(this.variables, "novariable", (Diagnostic)status);
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((long)4L, (long)child.getSeverity());
        Assert.assertEquals((Object)VARIABLE_NOT_FOUND, (Object)child.getMessage());
        Assert.assertNull((Object)child.getException());
    }

    @Test
    public void featureNotFoundStatusTest() {
        EAttribute attribute = (EAttribute)EcoreUtil.create((EClass)EcorePackage.Literals.EATTRIBUTE);
        attribute.setName("attr0");
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.call("aqlFeatureAccess", new Object[]{attribute, "noname"}, (Diagnostic)status);
        Assert.assertEquals((long)2L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((Object)UNKNOWN_FEATURE, (Object)child.getMessage());
        Assert.assertNull((Object)child.getException());
    }

    @Test
    public void featureAccessOnObjectStatusTest() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.call("aqlFeatureAccess", new Object[]{new Integer(1), "containment"}, (Diagnostic)status);
        Assert.assertEquals((long)2L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((Object)NON_EOBJECT_FEATURE_ACCESS, (Object)child.getMessage());
        Assert.assertNull((Object)child.getException());
    }

    @Test
    public void serviceNotFoundStatusTest() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.call("noservice", new Object[]{1}, (Diagnostic)status);
        Assert.assertEquals((long)2L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((Object)SERVICE_NOT_FOUND, (Object)child.getMessage());
        Assert.assertNull((Object)child.getException());
    }

    @Test
    public void serviceReturnsNullStatusTest() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.call("serviceReturnsNull", new Object[]{1}, (Diagnostic)status);
        Assert.assertEquals((long)0L, (long)status.getSeverity());
        Assert.assertEquals((long)0L, (long)status.getChildren().size());
    }

    @Test
    public void serviceThrowsExceptionStatusTest() {
        BasicDiagnostic status = new BasicDiagnostic();
        this.services.call("serviceThrowsException", new Object[]{1}, (Diagnostic)status);
        Assert.assertEquals((long)4L, (long)status.getSeverity());
        Assert.assertEquals((long)1L, (long)status.getChildren().size());
        Diagnostic child = (Diagnostic)status.getChildren().iterator().next();
        Assert.assertEquals((Object)"serviceThrowsException(java.lang.Object) with arguments [1] failed:\n\tThis is the purpose of this service.", (Object)child.getMessage());
        Assert.assertTrue((boolean)(child.getException() instanceof AcceleoQueryEvaluationException));
        Assert.assertTrue((boolean)(child.getException().getCause() instanceof NullPointerException));
        Assert.assertEquals((Object)"This is the purpose of this service.", (Object)child.getException().getCause().getMessage());
    }
}

