/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.servicelookup;

import java.util.List;
import org.eclipse.acceleo.query.runtime.ILookupEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbtractServiceLookupTest {
    private static final IType[] NO_ARG = new IType[0];

    abstract IQueryEnvironment getQueryEnvironment();

    @Test
    public void emptyEngineTest() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        Assert.assertNull((Object)engine.lookup("method", NO_ARG));
        Assert.assertNull((Object)engine.lookup("method", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Object.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class)}));
    }

    @Test
    public void leafTest() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        Assert.assertEquals((Object)"service0", (Object)engine.lookup("service0", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class)}).getName());
        Assert.assertEquals((Object)"service1", (Object)engine.lookup("service1", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class)}).getName());
        Assert.assertEquals((Object)"service2", (Object)engine.lookup("service2", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class)}).getName());
        Assert.assertNull((Object)engine.lookup("noService", NO_ARG));
    }

    @Test
    public void oneArgSingleMethodSameClassTest() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        Assert.assertEquals((Object)"service3", (Object)engine.lookup("service3", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Object.class)}).getName());
    }

    @Test
    public void nullValueSingleMethodSameClassTest() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        Assert.assertEquals((Object)"service3", (Object)engine.lookup("service3", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, null)}).getName());
    }

    @Test
    public void oneArgSingleMethodSubClassTest() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        Assert.assertEquals((Object)"service3", (Object)engine.lookup("service3", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class)}).getName());
    }

    @Test
    public void oneArgMultiMethodSameClassTest() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        IService service = engine.lookup("service4", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class)});
        Assert.assertEquals((Object)"service4", (Object)service.getName());
        Assert.assertEquals((long)1L, (long)service.getNumberOfParameters());
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
        service = engine.lookup("service4", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Object.class)});
        Assert.assertEquals((Object)"service4", (Object)service.getName());
        Assert.assertEquals((long)1L, (long)service.getNumberOfParameters());
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Object.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
        service = engine.lookup("service4", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class)});
        Assert.assertEquals((Object)"service4", (Object)service.getName());
        Assert.assertEquals((long)1L, (long)service.getNumberOfParameters());
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
    }

    @Test
    public void oneArgMultiMethodSubClassTest() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        IService service = engine.lookup("service4", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class)});
        Assert.assertEquals((Object)"service4", (Object)service.getName());
        Assert.assertEquals((long)1L, (long)service.getNumberOfParameters());
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
        service = engine.lookup("service4", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Double.class)});
        Assert.assertEquals((Object)"service4", (Object)service.getName());
        Assert.assertEquals((long)1L, (long)service.getNumberOfParameters());
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Number.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
        service = engine.lookup("service4", new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, List.class)});
        Assert.assertEquals((Object)"service4", (Object)service.getName());
        Assert.assertEquals((long)1L, (long)service.getNumberOfParameters());
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Object.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
    }

    @Test
    public void threeArgsTest1() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        IType[] args = new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class)};
        IService service = engine.lookup("service5", args);
        Assert.assertNull((Object)service);
    }

    @Test
    public void threeArgsTest2() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        IType[] args = new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Double.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Double.class)};
        IService service = engine.lookup("service5", args);
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Object.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Number.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(1));
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Number.class), service.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(2));
    }

    @Test
    public void threeArgsTest3() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        IType[] args = new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Double.class)};
        IService method = engine.lookup("service5", args);
        Assert.assertNotNull((Object)method);
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(1));
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Number.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(2));
    }

    @Test
    public void threeArgsTest4() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        IType[] args = new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class)};
        IService method = engine.lookup("service5", args);
        Assert.assertNotNull((Object)method);
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(1));
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(2));
    }

    @Test
    public void threeArgsTest5() {
        IQueryEnvironment queryEnvironment = this.getQueryEnvironment();
        ILookupEngine engine = queryEnvironment.getLookupEngine();
        IType[] args = new IType[]{new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class), new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class)};
        IService method = engine.lookup("service5", args);
        Assert.assertNotNull((Object)method);
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(0));
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Number.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(1));
        Assert.assertEquals((Object)new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class), method.getParameterTypes((IReadOnlyQueryEnvironment)queryEnvironment).get(2));
    }
}

