/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nooperationreflection.NooperationreflectionPackage;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.tests.services.EObjectServices;
import org.eclipse.acceleo.query.tests.services.ReceiverServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidationTest {
    QueryValidationEngine engine;
    IQueryEnvironment queryEnvironment;
    Map<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();

    @Before
    public void setup() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)NooperationreflectionPackage.eINSTANCE);
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, EObjectServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        this.engine = new QueryValidationEngine((IReadOnlyQueryEnvironment)this.queryEnvironment);
        this.variableTypes.clear();
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        this.variableTypes.put("self", selfTypes);
        LinkedHashSet<EClassifierType> stuffTypes = new LinkedHashSet<EClassifierType>();
        stuffTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("stuff", stuffTypes);
        LinkedHashSet<EClassifierType> noReflexionTypes = new LinkedHashSet<EClassifierType>();
        noReflexionTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)NooperationreflectionPackage.eINSTANCE.getNoOperationReflection()));
        this.variableTypes.put("noReflexion", noReflexionTypes);
    }

    @Test
    public void nullTest() {
        IValidationResult validationResult = this.engine.validate(null, this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "null or empty string.", -1, -1);
    }

    @Test
    public void emptyTest() {
        IValidationResult validationResult = this.engine.validate("", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "null or empty string.", 0, 0);
    }

    @Test
    public void variableTest() {
        IValidationResult validationResult = this.engine.validate("self", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void variableNotRegisteredEClassifierTest() {
        this.queryEnvironment.removeEPackage((EPackage)EcorePackage.eINSTANCE);
        IValidationResult validationResult = this.engine.validate("self", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "EClassifier=EClass is not registered in the current environment", 0, 4);
    }

    @Test
    public void variableNotExistingTest() {
        IValidationResult validationResult = this.engine.validate("notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notExisting' variable", 0, 11);
    }

    @Test
    public void featureAccessTest() {
        IValidationResult validationResult = this.engine.validate("self.name", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void featureNotExistingAccessTest() {
        IValidationResult validationResult = this.engine.validate("self.notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Feature notExisting not found in EClass EClass", 4, 16);
    }

    @Test
    public void flattenSequenceNothingFeatureNotExistingAccessTest() {
        IValidationResult validationResult = this.engine.validate("self->asSequence().notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Feature notExisting not found in EClass EClass", (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass", 18, 30);
    }

    @Test
    public void flattenSetNothingFeatureNotExistingAccessTest() {
        IValidationResult validationResult = this.engine.validate("self->asSet().notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Feature notExisting not found in EClass EClass", (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass", 13, 25);
    }

    @Test
    public void flattenSequenceNothingOclAsTypeTest() {
        IValidationResult validationResult = this.engine.validate("self->asSequence().oclAsType(ecore::EPackage)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 18, 45);
    }

    @Test
    public void flattenSetNothingOclAsTypeTest() {
        IValidationResult validationResult = this.engine.validate("self->asSequence().oclAsType(ecore::EPackage)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 18, 45);
    }

    @Test
    public void flattenSequenceNothingMultipleTypesNotExistingOnAnyAccessTest() {
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("multiType", selfTypes);
        IValidationResult validationResult = this.engine.validate("multiType->asSequence().notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", 23, 35);
    }

    @Test
    public void flattenSetNothingMultipleTypesNotExistingOnAnyAccessTest() {
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("multiType", selfTypes);
        IValidationResult validationResult = this.engine.validate("multiType->asSet().notExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        IType type = (IType)possibleTypes.iterator().next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature notExisting not found in EClass EClass\nFeature notExisting not found in EClass EPackage", 18, 30);
    }

    @Test
    public void flattenSequenceNothingMultipleTypesNotExistingOnOneAccessTest() {
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("multiType", selfTypes);
        IValidationResult validationResult = this.engine.validate("multiType->asSequence().eClassifiers", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)((EClassifierType)((SequenceType)type).getCollectionType()).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Feature eClassifiers not found in EClass EClass", (Object)((NothingType)((SequenceType)type).getCollectionType()).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature eClassifiers not found in EClass EClass", 23, 36);
    }

    @Test
    public void flattenSetNothingMultipleTypesNotExistingOnOneAccessTest() {
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("multiType", selfTypes);
        IValidationResult validationResult = this.engine.validate("multiType->asSet().eClassifiers", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)((EClassifierType)((SetType)type).getCollectionType()).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)type).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Feature eClassifiers not found in EClass EClass", (Object)((NothingType)((SetType)type).getCollectionType()).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Empty collection: Feature eClassifiers not found in EClass EClass", 18, 31);
    }

    @Test
    public void intliteralTest() {
        IValidationResult validationResult = this.engine.validate("2", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Integer.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void realliteralTest() {
        IValidationResult validationResult = this.engine.validate("1.0", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Double.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void trueliteralTest() {
        IValidationResult validationResult = this.engine.validate("true", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void falseliteralTest() {
        IValidationResult validationResult = this.engine.validate("false", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void stringliteralTest() {
        IValidationResult validationResult = this.engine.validate("'acceleo query is great'", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)possibleType.getType());
    }

    @Test
    public void operatorTest() {
        IValidationResult validationResult = this.engine.validate("1<=2", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void operatorWrongArgumentTypeTest() {
        IValidationResult validationResult = this.engine.validate("1 and '3'", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'and(java.lang.Integer,java.lang.String)' service", 0, 9);
    }

    @Test
    public void operatorNullParameterTypeTest() {
        IValidationResult validationResult = this.engine.validate("true and null", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void serviceTest() {
        IValidationResult validationResult = this.engine.validate("self.someService('a')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Integer.TYPE, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void serviceWrongArgumentTypeTest() {
        IValidationResult validationResult = this.engine.validate("self.someService(true)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'someService(EClassifier=EClass,java.lang.Boolean)' service", 4, 22);
    }

    @Test
    public void serviceNullParameterTypeTest() {
        IValidationResult validationResult = this.engine.validate("self.someService(null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Integer.TYPE, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eOperationTest() {
        IValidationResult validationResult = this.engine.validate("stuff.getEClassifier('EClass')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eOperationWrongArgumentTypeTest() {
        IValidationResult validationResult = this.engine.validate("stuff.getEClassifier(1)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'getEClassifier(EClassifier=EPackage,java.lang.Integer)' service", 5, 23);
    }

    @Test
    public void eOperationNullParameterTypeTest() {
        IValidationResult validationResult = this.engine.validate("stuff.getEClassifier(null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void classifierType() {
        IValidationResult validationResult = this.engine.validate("ecore::EClass", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierLiteralType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void classifierTypeError() {
        IValidationResult validationResult = this.engine.validate("anydsl::EClass", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid type literal anydsl::EClass", 0, 14);
    }

    @Test
    public void classifierTypeErrorMissingOneColon() {
        IValidationResult validationResult = this.engine.validate("anydsl:", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid type literal anydsl:", 0, 7);
    }

    @Test
    public void enumLiteral() {
        IValidationResult validationResult = this.engine.validate("anydsl::Part::Other", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)AnydslPackage.eINSTANCE.getPart(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void enumLiteralError() {
        IValidationResult validationResult = this.engine.validate("anydsl::Part::NotExisting", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid enum literal: no literal registered with this name", 0, 25);
    }

    @Test
    public void enumLiteralErrorMissingOneColon() {
        IValidationResult validationResult = this.engine.validate("anydsl::Part:", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid enum literal: ':' instead of '::'", 0, 13);
    }

    @Test
    public void testNullLiteral() {
        IValidationResult validationResult = this.engine.validate("null", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(null, (Object)((ClassType)possibleType).getType());
    }

    @Test
    public void testSetInExtensionLiteral() {
        IValidationResult validationResult = this.engine.validate("OrderedSet{self, self, true, false}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)((ClassType)((SetType)possibleType).getCollectionType()).getType());
    }

    @Test
    public void setInExtensionLiteralEmpty() {
        IValidationResult validationResult = this.engine.validate("OrderedSet{}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Empty OrderedSet defined in extension", (Object)((NothingType)((SetType)possibleType).getCollectionType()).getMessage());
    }

    @Test
    public void testSequenceInExtensionLiteral() {
        IValidationResult validationResult = this.engine.validate("Sequence{self, self, true, false}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SequenceType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)((ClassType)((SequenceType)possibleType).getCollectionType()).getType());
    }

    @Test
    public void sequenceInExtensionLiteralEmpty() {
        IValidationResult validationResult = this.engine.validate("Sequence{}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof NothingType));
        Assert.assertEquals((Object)"Empty Sequence defined in extension", (Object)((NothingType)((SequenceType)possibleType).getCollectionType()).getMessage());
    }

    @Test
    public void testConditionNothingCondition() {
        LinkedHashSet<NothingType> selectorTypes = new LinkedHashSet<NothingType>();
        selectorTypes.add(new NothingType("nothing"));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "nothing", 3, 11);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "The predicate never evaluates to a boolean type ([]).", 0, 38);
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
    }

    @Test
    public void testConditionNotBooleanCondition() {
        LinkedHashSet<EClassifierType> selectorTypes = new LinkedHashSet<EClassifierType>();
        selectorTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "The predicate never evaluates to a boolean type ([EClassifier=EClass]).", 0, 38);
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
    }

    @Test
    public void testConditionOneBooleanTypeCondition() {
        LinkedHashSet<ClassType> selectorTypes = new LinkedHashSet<ClassType>();
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Boolean.class));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
    }

    @Test
    public void testConditionManyBooleanTypesCondition() {
        LinkedHashSet<ClassType> selectorTypes = new LinkedHashSet<ClassType>();
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Boolean.class));
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Boolean.TYPE));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
    }

    @Test
    public void testConditionNotOnlyBooleanTypesCondition() {
        LinkedHashSet<ClassType> selectorTypes = new LinkedHashSet<ClassType>();
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Boolean.class));
        selectorTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Object.class));
        this.variableTypes.put("selector", selectorTypes);
        IValidationResult validationResult = this.engine.validate("if selector then self else stuff endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)possibleType.getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "The predicate may evaluate to a value that is not a boolean type ([java.lang.Boolean, java.lang.Object]).", 0, 38);
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getTrueBranch()));
        Assert.assertNotNull((Object)validationResult.getPossibleTypes(((Conditional)ast).getFalseBranch()));
    }

    @Test
    public void testLetMaskingVariable() {
        IValidationResult validationResult = this.engine.validate("let stuff = self in stuff", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "Variable stuff overrides an existing value.", 0, 25);
    }

    @Test
    public void testLetMaskingBinding() {
        IValidationResult validationResult = this.engine.validate("let a = 1, a = 2 in self", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertEquals((Object)true, (Object)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "Variable a overrides an existing value.", 0, 24);
    }

    @Test
    public void testLet() {
        IValidationResult validationResult = this.engine.validate("let newVar = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void typeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("{ecore::EClass | ecore::EPackage | ecore::EAttribute}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierSetLiteralType));
        EClassifierSetLiteralType eClassifierSetLiteralType = (EClassifierSetLiteralType)possibleType;
        Assert.assertEquals((long)3L, (long)eClassifierSetLiteralType.getEClassifiers().size());
        Iterator itECls = eClassifierSetLiteralType.getEClassifiers().iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), itECls.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), itECls.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), itECls.next());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void typeSetLiteralDuplicates() {
        IValidationResult validationResult = this.engine.validate("{ecore::EClass | ecore::EPackage | ecore::EAttribute | ecore::EPackage}", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierSetLiteralType));
        EClassifierSetLiteralType eClassifierSetLiteralType = (EClassifierSetLiteralType)possibleType;
        Assert.assertEquals((long)3L, (long)eClassifierSetLiteralType.getEClassifiers().size());
        Iterator itECls = eClassifierSetLiteralType.getEClassifiers().iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), itECls.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), itECls.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), itECls.next());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifierLiteral=EPackage is duplicated in the type set literal.", 0, 71);
    }

    @Test
    public void testLetBindingCompatibleType() {
        IValidationResult validationResult = this.engine.validate("let newVar : ecore::EClass = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void testLetBindingCompatibleTypeTypeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("let newVar : {ecore::EPackage | ecore::EClass} = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void testLetBindingIncompatibleType() {
        IValidationResult validationResult = this.engine.validate("let newVar : ecore::EPackage = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage].", 39, 45);
    }

    @Test
    public void testLetBindingInvalidType() {
        IValidationResult validationResult = this.engine.validate("let newVar : invalid::Type = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid type literal invalid::Type", 13, 26);
    }

    @Test
    public void testLetBindingIncompatibleTypeTypeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("let newVar : {ecore::EPackage | ecore::EReference} = self in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)possibleType).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage, EClassifier=EReference].", 61, 67);
    }

    @Test
    public void testLetExpressionError() {
        IValidationResult validationResult = this.engine.validate("let newVar = 'text' in newVar + notAVariable", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notAVariable' variable", 32, 44);
    }

    @Test
    public void testLetBindingExpressionError() {
        IValidationResult validationResult = this.engine.validate("let newVar = notAVariable in newVar", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'notAVariable' variable", 13, 25);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "The newVar variable has no types", 29, 35);
    }

    @Test
    public void eInverseFeatureNameStringLiteral() {
        IValidationResult validationResult = this.engine.validate("self.eInverse('ePackage')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eInverseFeatureNameExpression() {
        IValidationResult validationResult = this.engine.validate("self.eInverse('ePac'+'kage')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)8L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypedElement(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eInverse() {
        IValidationResult validationResult = this.engine.validate("self.eInverse()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)8L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypedElement(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eInverseFiltered() {
        IValidationResult validationResult = this.engine.validate("self.eInverse(ecore::EStructuralFeature)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)2L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), (Object)((EClassifierType)((SetType)possibleType).getCollectionType()).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void booleanLambdaCheck_484375() {
        IValidationResult validationResult = this.engine.validate("Sequence{'hello'}->any(i | i = 'hello')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)((ClassType)possibleType).getType());
        possibleTypes = validationResult.getPossibleTypes(((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        it = possibleTypes.iterator();
        possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Boolean.class, (Object)((ClassType)possibleType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void variableDefinitionCompatibleType() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : ecore::EClass | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void variableDefinitionCompatibleTypeTypeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : {ecore::EPackage | ecore::EClass} | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void variableDefinitionIncompatibleType() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : ecore::EPackage | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage].", 40, 46);
    }

    @Test
    public void variableDefinitionInvalidType() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : invalid::Type | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "invalid type literal invalid::Type", 22, 35);
    }

    @Test
    public void variableDefinitionIncompatibleTypeTypeSetLiteral() {
        IValidationResult validationResult = this.engine.validate("self->select(newVar : {ecore::EPackage | ecore::EReference} | newVar <> null)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.WARNING, "EClassifier=EClass is incompatible with declaration [EClassifier=EPackage, EClassifier=EReference].", 62, 68);
    }

    @Test
    public void testCollectionCallOnNull_toString() {
        IValidationResult validationResult = this.engine.validate("null->toString()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)possibleType.getType());
    }

    @Test
    public void testCollectionCallOnNull_size() {
        IValidationResult validationResult = this.engine.validate("null->size()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Integer.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void testCollectionCallOnNull_first() {
        IValidationResult validationResult = this.engine.validate("null->first()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "The Collection was empty due to a null value being wrapped as a Collection.", 4, 13);
    }

    @Test
    public void testCollectionCallOnNullFromUnsetReference() {
        LinkedHashSet<EClassifierType> operationTypes = new LinkedHashSet<EClassifierType>();
        operationTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEOperation()));
        this.variableTypes.put("operation", operationTypes);
        IValidationResult validationResult = this.engine.validate("operation.eType->first()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eOperationLookupNoEClassifierForClassType() {
        LinkedHashSet<ClassType> nonEMFTypes = new LinkedHashSet<ClassType>();
        nonEMFTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Query.class));
        this.variableTypes.put("nonEMF", nonEMFTypes);
        IValidationResult validationResult = this.engine.validate("self.triggerEOperationLookUp(nonEMF)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)this.stripNothingTypes(possibleTypes).size());
        Assert.assertEquals((long)0L, (long)possibleTypes.size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Couldn't find the 'triggerEOperationLookUp(EClassifier=EClass,org.eclipse.acceleo.query.runtime.Query)' service", 4, 36);
    }

    @Test
    public void collectionTypeLiteralSequence() {
        IValidationResult validationResult = this.engine.validate("Sequence(String)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SequenceType));
        Assert.assertTrue((boolean)(((SequenceType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(String.class, (Object)((SequenceType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void collectionTypeLiteralOrderedSet() {
        IValidationResult validationResult = this.engine.validate("OrderedSet(String)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof SetType));
        Assert.assertTrue((boolean)(((SetType)possibleType).getCollectionType() instanceof ClassType));
        Assert.assertEquals(String.class, (Object)((SetType)possibleType).getCollectionType().getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void oclAsTypeManyTypesNoneMatching() {
        IValidationResult validationResult = this.engine.validate("self.eContainer().oclAsType(ecore::EInt)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Assert.assertTrue((boolean)(possibleType instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nEClassifier=EPackage is not compatible with type EClassifierLiteral=EInt\nEClassifier=EAnnotation is not compatible with type EClassifierLiteral=EInt", (Object)((NothingType)possibleType).getMessage());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nEClassifier=EPackage is not compatible with type EClassifierLiteral=EInt\nEClassifier=EAnnotation is not compatible with type EClassifierLiteral=EInt", 17, 40);
    }

    @Test
    public void eGetWithStringLiteral() {
        IValidationResult validationResult = this.engine.validate("self.eGet('name')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eGetWithExpression() {
        IValidationResult validationResult = this.engine.validate("self.eGet('na'+'me')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(Object.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eOperationNoReflectionTest() {
        IValidationResult validationResult = this.engine.validate("noReflexion.eOperationNoReflection('text')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eOperationNoReflectionSubParameterTypeTest() {
        IValidationResult validationResult = this.engine.validate("noReflexion.eOperationNoReflectionSubParameterType(ecore::EClass)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void eOperationNoReflectionListParameterTest() {
        IValidationResult validationResult = this.engine.validate("noReflexion.eOperationNoReflectionListParameter(Sequence{ecore::EClass, ecore::EOperation})", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void javaMethodReceiverServiceNoArg() {
        LinkedHashSet<ClassType> selfTypes = new LinkedHashSet<ClassType>();
        selfTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        this.variableTypes.put("self", selfTypes);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)ServiceUtils.getReceiverServices((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        IValidationResult validationResult = this.engine.validate("self.noArg()", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void javaMethodReceiverServiceArg() {
        LinkedHashSet<ClassType> selfTypes = new LinkedHashSet<ClassType>();
        selfTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        this.variableTypes.put("self", selfTypes);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)ServiceUtils.getReceiverServices((IReadOnlyQueryEnvironment)this.queryEnvironment, ReceiverServices.class));
        IValidationResult validationResult = this.engine.validate("self.arg('arg')", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set possibleTypes = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)possibleTypes.size());
        Iterator it = possibleTypes.iterator();
        IType possibleType = (IType)it.next();
        Assert.assertTrue((boolean)(possibleType instanceof ClassType));
        Assert.assertEquals(String.class, (Object)possibleType.getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    public static void assertValidationMessage(IValidationMessage message, ValidationMessageLevel expectedLevel, String expectedMessage, int expectedStartPosition, int expectedEndPosition) {
        Assert.assertEquals((Object)expectedLevel, (Object)message.getLevel());
        Assert.assertEquals((Object)expectedMessage, (Object)message.getMessage());
        Assert.assertEquals((long)expectedStartPosition, (long)message.getStartPosition());
        Assert.assertEquals((long)expectedEndPosition, (long)message.getEndPosition());
    }

    public List<IType> stripNothingTypes(Collection<IType> types) {
        ArrayList<IType> nothings = new ArrayList<IType>();
        Iterator<IType> typeItr = types.iterator();
        while (typeItr.hasNext()) {
            IType type = typeItr.next();
            if (!(type instanceof NothingType)) continue;
            nothings.add(type);
            typeItr.remove();
        }
        return nothings;
    }
}

