/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.tests.ValidationTest;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidationInferrenceTest {
    final EPackage ePackage;
    final EClass o;
    final EClass a;
    final EClass b;
    final EClass c;
    final EClass x;
    final EClass y;
    final EClass z;
    QueryValidationEngine engine;
    IQueryEnvironment queryEnvironment;
    Map<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();

    public ValidationInferrenceTest() {
        this.ePackage = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        this.ePackage.setName("test");
        this.ePackage.setNsURI("test");
        this.ePackage.setNsPrefix("test");
        EDataType bool = EcorePackage.eINSTANCE.getEcoreFactory().createEDataType();
        bool.setName("bool");
        bool.setInstanceClassName(Boolean.class.getCanonicalName());
        this.ePackage.getEClassifiers().add((Object)bool);
        bool.setInstanceClass(Boolean.class);
        this.o = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        this.o.setName("O");
        EAttribute oAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        oAttr.setName("oAttr");
        oAttr.setEType((EClassifier)this.o);
        this.o.getEStructuralFeatures().add((Object)oAttr);
        this.ePackage.getEClassifiers().add((Object)this.o);
        this.a = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        this.a.setName("A");
        EAttribute aAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        aAttr.setName("aAttr");
        aAttr.setEType((EClassifier)this.a);
        this.a.getEStructuralFeatures().add((Object)aAttr);
        this.ePackage.getEClassifiers().add((Object)this.a);
        this.b = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        this.b.setName("B");
        EAttribute bAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        bAttr.setName("bAttr");
        bAttr.setEType((EClassifier)this.b);
        this.b.getEStructuralFeatures().add((Object)bAttr);
        this.b.getESuperTypes().add((Object)this.a);
        this.ePackage.getEClassifiers().add((Object)this.b);
        this.c = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        this.c.setName("C");
        EAttribute cAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        cAttr.setName("cAttr");
        cAttr.setEType((EClassifier)this.c);
        this.c.getEStructuralFeatures().add((Object)cAttr);
        this.c.getESuperTypes().add((Object)this.b);
        this.ePackage.getEClassifiers().add((Object)this.c);
        this.x = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        this.x.setName("X");
        EAttribute xAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        xAttr.setName("xAttr");
        xAttr.setEType((EClassifier)this.x);
        this.x.getEStructuralFeatures().add((Object)xAttr);
        this.ePackage.getEClassifiers().add((Object)this.x);
        this.b.getESuperTypes().add((Object)this.x);
        this.y = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        this.y.setName("Y");
        EAttribute yAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        yAttr.setName("yAttr");
        yAttr.setEType((EClassifier)this.y);
        this.y.getEStructuralFeatures().add((Object)yAttr);
        this.y.getESuperTypes().add((Object)this.b);
        this.ePackage.getEClassifiers().add((Object)this.y);
        this.z = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        this.z.setName("Z");
        EAttribute zAttr = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        zAttr.setName("zAttr");
        zAttr.setEType((EClassifier)this.z);
        this.z.getEStructuralFeatures().add((Object)zAttr);
        this.z.getESuperTypes().add((Object)this.c);
        this.z.getESuperTypes().add((Object)this.y);
        this.ePackage.getEClassifiers().add((Object)this.z);
    }

    @Before
    public void setup() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.queryEnvironment.registerEPackage(this.ePackage);
        this.engine = new QueryValidationEngine((IReadOnlyQueryEnvironment)this.queryEnvironment);
        this.variableTypes.clear();
        LinkedHashSet<EClassifierType> varATypes = new LinkedHashSet<EClassifierType>();
        varATypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.a));
        this.variableTypes.put("varA", varATypes);
        LinkedHashSet<EClassifierType> varBTypes = new LinkedHashSet<EClassifierType>();
        varBTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.b));
        this.variableTypes.put("varB", varBTypes);
        LinkedHashSet<EClassifierType> varCTypes = new LinkedHashSet<EClassifierType>();
        varCTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.c));
        this.variableTypes.put("varC", varCTypes);
        LinkedHashSet<EClassifierType> varZTypes = new LinkedHashSet<EClassifierType>();
        varZTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.z));
        this.variableTypes.put("varZ", varZTypes);
        LinkedHashSet<NothingType> varNothing = new LinkedHashSet<NothingType>();
        varNothing.add(new NothingType("Nothing"));
        this.variableTypes.put("varNothing", varNothing);
    }

    @Test
    public void oclIsKindOf_varNothing_B() {
        String varName = "varNothing";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing", (Object)((NothingType)type).getMessage());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 10);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is kind of EClassifierLiteral=B", 0, 31);
    }

    @Test
    public void oclIsKindOf_varEObject_B() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        String varName = "container";
        LinkedHashMap<String, HashSet<IType>> variableTypes = new LinkedHashMap<String, HashSet<IType>>();
        EClassifierType eObjectType = new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject());
        variableTypes.put(varName, new HashSet<IType>(Arrays.asList(eObjectType)));
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::B)", variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void oclIsKindOf_varA_B() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void oclIsKindOf_varB_B() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varB (EClassifier=B) is not kind of EClassifierLiteral=B", 0, 25);
    }

    @Test
    public void oclIsKindOf_varC_B() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varC (EClassifier=C) is not kind of EClassifierLiteral=B", 0, 25);
    }

    @Test
    public void oclIsKindOf_varC_O() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is kind of EClassifierLiteral=O", 0, 25);
    }

    @Test
    public void oclIsTypeOf_varNothing_B() {
        String varName = "varNothing";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsTypeOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing", (Object)((NothingType)type).getMessage());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 10);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is type of EClassifierLiteral=B", 0, 31);
    }

    @Test
    public void oclIsTypeOf_varEObject_B() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        String varName = "container";
        LinkedHashMap<String, HashSet<IType>> variableTypes = new LinkedHashMap<String, HashSet<IType>>();
        EClassifierType eObjectType = new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject());
        variableTypes.put(varName, new HashSet<IType>(Arrays.asList(eObjectType)));
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsTypeOf(test::B)", variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void oclIsTypeOf_varA_B() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsTypeOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void oclIsTypeOf_varA_X() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsTypeOf(test::X)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varA (EClassifier=A) is type of EClassifierLiteral=X", 0, 25);
    }

    @Test
    public void oclIsTypeOf_varB_B() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsTypeOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)2L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void oclIsTypeOf_varZ_Z() {
        String varName = "varZ";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsTypeOf(test::Z)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZ (EClassifier=Z) is not type of EClassifierLiteral=Z", 0, 25);
    }

    @Test
    public void oclIsTypeOf_varC_B() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsTypeOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=B", 0, 25);
    }

    @Test
    public void oclIsTypeOf_varC_O() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsTypeOf(test::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=O", 0, 25);
    }

    @Test
    public void not_oclIsKindOf_varNothing_B() {
        String varName = "varNothing";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing", (Object)((NothingType)type).getMessage());
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 4, 14);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is kind of EClassifierLiteral=B", 4, 35);
    }

    @Test
    public void not_oclIsKindOf_varA_B() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void oclIsKindOf_varA_X() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::X)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void not_oclIsKindOf_varB_B() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varB (EClassifier=B) is not kind of EClassifierLiteral=B", 4, 29);
    }

    @Test
    public void not_oclIsKindOf_varC_B() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varC (EClassifier=C) is not kind of EClassifierLiteral=B", 4, 29);
    }

    @Test
    public void not_oclIsKindOf_varC_O() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(test::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is kind of EClassifierLiteral=O", 4, 29);
    }

    @Test
    public void not_oclIsTypeOf_varNothing_B() {
        String varName = "varNothing";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing", (Object)((NothingType)type).getMessage());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 4, 14);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is type of EClassifierLiteral=B", 4, 35);
    }

    @Test
    public void not_oclIsTypeOf_varA_B() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void not_oclIsTypeOf_varB_B() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)2L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void not_oclIsTypeOf_varZ_Z() {
        String varName = "varZ";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(test::Z)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZ (EClassifier=Z) is not type of EClassifierLiteral=Z", 4, 29);
    }

    @Test
    public void not_oclIsTypeOf_varC_B() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(test::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=B", 4, 29);
    }

    @Test
    public void not_oclIsTypeOf_varC_O() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(test::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=O", 4, 29);
    }

    @Test
    public void or() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::C) or " + varName + ".oclIsKindOf(test::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)2L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void xor() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::C) xor " + varName + ".oclIsKindOf(test::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void and() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + ".oclIsKindOf(test::C) and " + varName + ".oclIsKindOf(test::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void conditionnalTrueBranch() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate("if " + varName + ".oclIsKindOf(test::C) then " + varName + " else " + varName + " endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertTrue((boolean)(ast instanceof Conditional));
        Conditional conditional = (Conditional)ast;
        Set types = validationResult.getPossibleTypes(conditional.getTrueBranch());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void conditionnalFalseBranch() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate("if not " + varName + ".oclIsKindOf(test::C) then " + varName + " else " + varName + " endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertTrue((boolean)(ast instanceof Conditional));
        Conditional conditional = (Conditional)ast;
        Set types = validationResult.getPossibleTypes(conditional.getFalseBranch());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void any() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + "->any(i | i.oclIsKindOf(test::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void select() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + "->select(i | i.oclIsKindOf(test::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        IType rawType = ((SetType)type).getCollectionType();
        Assert.assertTrue((boolean)(rawType instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)rawType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void reject() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(String.valueOf(varName) + "->reject(i | not i.oclIsKindOf(test::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        IType rawType = ((SetType)type).getCollectionType();
        Assert.assertTrue((boolean)(rawType instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)rawType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void andWithSubTypeAttribute() {
        IValidationResult validationResult = this.engine.validate("varB.oclIsKindOf(test::C) and varB.cAttr = null", this.variableTypes);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    @Test
    public void orWithSubTypeAttribute() {
        IValidationResult validationResult = this.engine.validate("not varB.oclIsKindOf(test::C) or varB.cAttr = null", this.variableTypes);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
    }

    private void assertDisjointTypes(Set<IType> inferredWhenTrue, Set<IType> inferredWhenFalse) {
        for (IType type : inferredWhenTrue) {
            Assert.assertFalse((boolean)inferredWhenFalse.contains(type));
        }
        for (IType type : inferredWhenFalse) {
            Assert.assertFalse((boolean)inferredWhenTrue.contains(type));
        }
    }
}

