/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.BasicFilter;
import org.eclipse.acceleo.query.runtime.impl.QueryCompletionEngine;
import org.eclipse.acceleo.query.runtime.impl.completion.EFeatureCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EOperationServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.JavaMethodServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableDeclarationCompletionProposal;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompletionTest {
    private static final int TOTAL_NUMBER_OF_PROPOSAL = 131;
    QueryCompletionEngine engine;
    IQueryEnvironment queryEnvironment;
    Map<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();

    @Before
    public void setup() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        this.engine = new QueryCompletionEngine((IReadOnlyQueryEnvironment)this.queryEnvironment);
        this.variableTypes.clear();
        LinkedHashSet<EClassifierType> selfTypes = new LinkedHashSet<EClassifierType>();
        selfTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        this.variableTypes.put("self", selfTypes);
        LinkedHashSet<EClassifierType> stuffTypes = new LinkedHashSet<EClassifierType>();
        stuffTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        this.variableTypes.put("stuff", stuffTypes);
    }

    @Test
    public void typeLiteralOneColon() {
        ICompletionResult completionResult = this.engine.getCompletion("ecore:", 6, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 53, "ecore:", "", 0, 6, "ecore::EClass", "ecore::EPackage");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void enumLiteralOneColon() {
        ICompletionResult completionResult = this.engine.getCompletion("anydsl::Color:", 14, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 10, "anydsl::Color:", "", 0, 14, "anydsl::Color::black", "anydsl::Color::red");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void enumLiteral() {
        ICompletionResult completionResult = this.engine.getCompletion("anydsl::Color::", 15, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 10, "anydsl::Color::", "", 0, 15, "anydsl::Color::black", "anydsl::Color::yellow");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void enumLiteralWithinCollectionLiteralOneColon() {
        ICompletionResult completionResult = this.engine.getCompletion("OrderedSet{anydsl::Color:", 25, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 10, "anydsl::Color:", "", 11, 14, "anydsl::Color::white", "anydsl::Color::palPink");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void enumLiteralWithinCollectionLiteral() {
        ICompletionResult completionResult = this.engine.getCompletion("OrderedSet{anydsl::Color::", 26, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 10, "anydsl::Color::", "", 11, 15, "anydsl::Color::white", "anydsl::Color::red");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void nullTest() {
        ICompletionResult completionResult = this.engine.getCompletion(null, 0, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 131, null, null, 0, 0, "self", "ecore::EPackage", "not ");
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeOffsetTest() {
        this.engine.getCompletion("aa", -1, this.variableTypes);
    }

    @Test(expected=IllegalArgumentException.class)
    public void outOffsetTest() {
        this.engine.getCompletion("aa", 10, this.variableTypes);
    }

    @Test
    public void emptyTest() {
        ICompletionResult completionResult = this.engine.getCompletion("", 0, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 0, 0, "anydsl::Group::Fruit", "true");
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void navigationSegmentEmptyTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self.", 5, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 73, "", "", 5, 0, "eAllContents()", "eClass()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertApplyOn(completionResult, (IReadOnlyQueryEnvironment)this.queryEnvironment, EcorePackage.eINSTANCE.getEClass());
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void navigationSegmentPrefixTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self.na", 7, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "na", "", 5, 2, "name");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertApplyOn(completionResult, (IReadOnlyQueryEnvironment)this.queryEnvironment, EcorePackage.eINSTANCE.getEClass());
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void navigationSegmentPrefixRemainingTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self.nam", 7, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "na", "m", 5, 2, "name");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertApplyOn(completionResult, (IReadOnlyQueryEnvironment)this.queryEnvironment, EcorePackage.eINSTANCE.getEClass());
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void navigationSegmentPrefixLongExpressionRemainingTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self.nam.size()", 7, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "na", "m", 5, 2, "name");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertApplyOn(completionResult, (IReadOnlyQueryEnvironment)this.queryEnvironment, EcorePackage.eINSTANCE.getEClass());
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void selfTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self ", 5, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 3, "", "", 5, 0, "= ", "+ ", "<> ");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void someIntTest() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        LinkedHashSet<EClassifierType> someIntTypes = new LinkedHashSet<EClassifierType>();
        someIntTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEInt()));
        this.variableTypes.put("someInt", someIntTypes);
        ICompletionResult completionResult = this.engine.getCompletion("someInt ", 8, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 10, "", "", 8, 0, "= ", "+ ", "- ");
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void alfMultTest() {
        LinkedHashSet<EClassifierType> someIntTypes = new LinkedHashSet<EClassifierType>();
        someIntTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEInt()));
        this.variableTypes.put("someInt", someIntTypes);
        ICompletionResult completionResult = this.engine.getCompletion("someInt * ", 10, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 132, "", "", 10, 0, "someInt", "ecore::EChar", "if ");
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void notTest() {
        ICompletionResult completionResult = this.engine.getCompletion("not ", 4, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 4, 0, "true", "let ", "self", "ecore::EPackage");
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void selfDotTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self.", 5, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 73, "", "", 5, 0, "eClass()", "name");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
        Assert.assertEquals((long)5L, (long)completionResult.getReplacementOffset());
        Assert.assertEquals((long)0L, (long)completionResult.getReplacementLength());
    }

    @Test
    public void selfArrowTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self->", 6, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 6, 0, "size()", "including()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testImplicitCollectProposalsOnDot() {
        ICompletionResult dotCompletionResult = this.engine.getCompletion("Sequence{self}.", 15, this.variableTypes);
        CompletionTest.assertCompletion(dotCompletionResult, 73, "", "", 15, 0, "name", "eContainer()", "oclIsKindOf()");
    }

    @Test
    public void testImplicitCollectProposalsOnArrow() {
        ICompletionResult arrowCompletionResult = this.engine.getCompletion("Sequence{self}->", 16, this.variableTypes);
        CompletionTest.assertCompletion(arrowCompletionResult, 44, "", "", 16, 0, "size()", "select()", "collect()");
    }

    @Test
    public void testImplicitCollectProposalsNoSeparator() {
        ICompletionResult noSeparatorCompletionResult = this.engine.getCompletion("Sequence{self}", 14, this.variableTypes);
        CompletionTest.assertCompletion(noSeparatorCompletionResult, 4, "", "", 14, 0, "+ ", "- ", "= ", "<> ");
    }

    @Test
    public void errorTypeLiteralOneSegmentTest() {
        ICompletionResult completionResult = this.engine.getCompletion("ecore::", 7, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 53, "ecore::", "", 0, 7, "ecore::EObject", "ecore::EInt");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void errorTypeLiteralTwoSegmentsTest() {
        ICompletionResult completionResult = this.engine.getCompletion("ecore::EClass::", 15, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 0, "ecore::EClass::", "", 0, 15, new String[0]);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void selfSelectTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self->select(", 13, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myEClass | ");
        ICompletionProposal proposal = (ICompletionProposal)completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult)).get(0);
        Assert.assertEquals((Object)true, (Object)(proposal instanceof VariableDeclarationCompletionProposal));
        Assert.assertEquals((long)"myEClass | ".length(), (long)proposal.getCursorOffset());
    }

    @Test
    public void selfSelectMissingVariableTypeTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self->select( a : ", 18, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 125, "", "", 18, 0, "Integer", "Boolean", "ecore::EClass", "ecore::EString");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void selfServiceManyArgumentsTest() {
        ICompletionResult completionResult = this.engine.getCompletion("self->service(self, ", 20, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 20, 0, "self", "ecore::EBoolean");
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testLetCompletionFromNothing() {
        ICompletionResult completionResult = this.engine.getCompletion("", 0, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 0, 0, "let ");
    }

    @Test
    public void testLetCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("le", 2, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 2, "le", "", 0, 2, "let ", "anydsl::Kind::Leaf");
    }

    @Test
    public void testLetCompletionNoBinding() {
        ICompletionResult completionResult = this.engine.getCompletion("let ", 4, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 0, "", "", 4, 0, new String[0]);
    }

    @Test
    public void testBindingCompletionNoEquals() {
        ICompletionResult completionResult = this.engine.getCompletion("let a", 5, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 0, "a", "", 4, 1, new String[0]);
    }

    @Test
    public void testBindingCompletionNoEqualsWithSpace() {
        ICompletionResult completionResult = this.engine.getCompletion("let a ", 6, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 2, "", "", 6, 0, ": ", "= ");
    }

    @Test
    public void testBindingCompletionWithErrorType() {
        ICompletionResult completionResult = this.engine.getCompletion("let a : ecore::", 15, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 53, "ecore::", "", 8, 7, "ecore::EPackage", "ecore::EString");
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testBindingCompletionWithTypeNoSpace() {
        ICompletionResult completionResult = this.engine.getCompletion("let a : ecore::EClass", 21, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 2, "ecore::EClass", "", 8, 13, "ecore::EClass", "ecore::EClassifier");
    }

    @Test
    public void testBindingCompletionWithTypeAndSpace() {
        ICompletionResult completionResult = this.engine.getCompletion("let a : ecore::EClass ", 22, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 22, 0, "= ");
    }

    @Test
    public void testBindingCompletionNoType() {
        ICompletionResult completionResult = this.engine.getCompletion("let a = ", 8, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 8, 0, "self", "true");
    }

    @Test
    public void testLetBodyCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("let a=3 in ", 11, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 132, "", "", 11, 0, "a", "self", "ecore::EInt", "not ", "if ");
    }

    @Test
    public void testConditionalIfCompletionFromNothing() {
        ICompletionResult completionResult = this.engine.getCompletion("", 0, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 0, 0, "if ");
    }

    @Test
    public void testConditionalIfCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("i", 1, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 2, "i", "", 0, 1, "if ", "anydsl::Kind::Inflorescence");
    }

    @Test
    public void testConditionAfterIfCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("if ", 3, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 3, 0, "self", "if ", "let ");
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
    }

    @Test
    public void testConditionAfterPredicateCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("if true ", 8, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 12, "", "", 8, 0, "then ");
    }

    @Test
    public void thenVar() {
        LinkedHashSet<EClassifierType> thenVarTypes = new LinkedHashSet<EClassifierType>();
        thenVarTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        this.variableTypes.put("thenVar", thenVarTypes);
        ICompletionResult completionResult = this.engine.getCompletion("then", 4, this.variableTypes);
        Assert.assertEquals((Object)"then", (Object)completionResult.getPrefix());
        Assert.assertEquals((Object)"", (Object)completionResult.getRemaining());
        Assert.assertEquals((long)1L, (long)completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult)).size());
        Assert.assertEquals((Object)"thenVar", (Object)((ICompletionProposal)completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult)).get(0)).getProposal());
        Assert.assertEquals((long)0L, (long)completionResult.getReplacementOffset());
        Assert.assertEquals((long)4L, (long)completionResult.getReplacementLength());
    }

    @Test
    public void testConditionalAfterThenCompletion() {
        LinkedHashSet<EClassifierType> thenVarTypes = new LinkedHashSet<EClassifierType>();
        thenVarTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        this.variableTypes.put("thenVar", thenVarTypes);
        ICompletionResult completionResult = this.engine.getCompletion("if stuff then ", 13, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "then", "", 9, 4, "then ");
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
    }

    @Test
    public void testConditionAfterTrueBranchCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("if true then true ", 18, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 12, "", "", 18, 0, "else ");
    }

    @Test
    public void testConditionWithinTrueBranchCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("if true then tr", 15, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 2, "tr", "", 13, 2, "true", "anydsl::Kind::Tree");
    }

    @Test
    public void testConditionalAfterElseCompletion() {
        LinkedHashSet<EClassifierType> elseVarTypes = new LinkedHashSet<EClassifierType>();
        elseVarTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        this.variableTypes.put("elseVar", elseVarTypes);
        ICompletionResult completionResult = this.engine.getCompletion("if stuff then self else ", 23, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "else", "", 19, 4, "else ");
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
    }

    @Test
    public void testConditionAfterFalseBranchCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("if true then true else false ", 29, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 12, "", "", 29, 0, "endif ");
    }

    @Test
    public void test470195Completion() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eClassifiers->select(p | self.)", 35, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 73, "", "", 35, 0, "name", "eAllContents()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertApplyOn(completionResult, (IReadOnlyQueryEnvironment)this.queryEnvironment, EcorePackage.eINSTANCE.getEClass());
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void test470195ArrowCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eClassifiers->select(p | self->)", 36, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 36, 0, "size()", "first()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void test470195DoubleCallCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eClassifiers->select(w | self.eClassifiers->select(p | self.))", 65, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 73, "", "", 65, 0, "name");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertApplyOn(completionResult, (IReadOnlyQueryEnvironment)this.queryEnvironment, EcorePackage.eINSTANCE.getEClass());
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void test470195ArrowDoubleCallCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eClassifiers->select(w | self.eClassifiers->select(p | self->))", 66, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 66, 0, "size()", "first()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void test472179TypeLiteralCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eContainer(ecore::EP)", 25, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 2, "ecore::EP", "", 16, 9, "ecore::EPackage", "ecore::EParameter");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testTypeLiteralCompletionWithPrefix() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eContainer(ecore::EPack)", 28, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "ecore::EPack", "", 16, 12, "ecore::EPackage");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testTypeLiteralCompletionWithPrefixAndRemaining() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eContainer(ecore::EPack)", 26, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 2, "ecore::EPa", "ck", 16, 10, "ecore::EPackage", "ecore::EParameter");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void test471583TypeLiteralCompletion() {
        ICompletionResult completionResult = this.engine.getCompletion("self->eClassifiers->filter(ecore::)", 34, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 53, "ecore::", "", 27, 7, "ecore::EPackage", "ecore::EClass");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationCollectCompletion_Classifier() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->collect()", 14, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 14, 0, "myEObject | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationCollectCompletion_Class() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<ClassType> selfType = new LinkedHashSet<ClassType>();
        selfType.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, EObject.class));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->collect()", 14, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 14, 0, "myEObject | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationCollectCompletion_Nothing() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<NothingType> selfType = new LinkedHashSet<NothingType>();
        selfType.add(new NothingType("whatever"));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->collect()", 14, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 14, 0, "myNothing | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationCollectCompletion_SequenceOfNothing() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SequenceType> selfType = new LinkedHashSet<SequenceType>();
        selfType.add(new SequenceType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->collect()", 14, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 14, 0, "myNothing | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationSelectCompletion_Classifier() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(", 13, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myEObject | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationSelectCompletion_Class() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<ClassType> selfType = new LinkedHashSet<ClassType>();
        selfType.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, EObject.class));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(", 13, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myEObject | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationSelectCompletion_Nothing() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<NothingType> selfType = new LinkedHashSet<NothingType>();
        selfType.add(new NothingType("whatever"));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(", 13, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myNothing | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationSelectCompletion_SequenceOfNothing() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SequenceType> selfType = new LinkedHashSet<SequenceType>();
        selfType.add(new SequenceType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(", 13, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myNothing | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationRejectCompletion_Classifier() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->reject(", 13, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myEObject | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationRejectCompletion_Class() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<ClassType> selfType = new LinkedHashSet<ClassType>();
        selfType.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, EObject.class));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->reject(", 13, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myEObject | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationRejectCompletion_Nothing() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<NothingType> selfType = new LinkedHashSet<NothingType>();
        selfType.add(new NothingType("whatever"));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->reject(", 13, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myNothing | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test477213VariableDeclarationRejectCompletion_SequenceOfNothing() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SequenceType> selfType = new LinkedHashSet<SequenceType>();
        selfType.add(new SequenceType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->reject(", 13, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 13, 0, "myNothing | ");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test478176MiddleOfEmptyStringLiteralCompletion() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SequenceType> selfType = new LinkedHashSet<SequenceType>();
        selfType.add(new SequenceType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self = ''", 8, types);
        CompletionTest.assertCompletion(completionResult, 0, "", "", 8, 0, new String[0]);
    }

    @Test
    public void test478176MiddleOfStringLiteralCompletion() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SequenceType> selfType = new LinkedHashSet<SequenceType>();
        selfType.add(new SequenceType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self = 'test'", 10, types);
        CompletionTest.assertCompletion(completionResult, 0, "te", "st", 8, 2, new String[0]);
    }

    @Test
    public void test478384NoPipeDeclarationVariable() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(e ", 15, types);
        CompletionTest.assertCompletion(completionResult, 2, "", "", 15, 0, "| ", ": ");
    }

    @Test
    public void test478384NoPipeWithColonDeclarationVariable() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(e :", 16, types);
        CompletionTest.assertCompletion(completionResult, 125, "", "", 16, 0, "String", "Real", "ecore::EPackage", "ecore::EClass");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoServiceCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
    }

    @Test
    public void test478384NoPipeWithTypeDeclarationVariable() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(e : ecore::EClass ", 31, types);
        CompletionTest.assertCompletion(completionResult, 1, "", "", 31, 0, "| ");
    }

    @Test
    public void testOrderedSetMinus() {
        LinkedHashMap types = new LinkedHashMap();
        ICompletionResult completionResult = this.engine.getCompletion("OrderedSet{}-", 13, types);
        CompletionTest.assertCompletion(completionResult, 129, "", "", 13, 0, "OrderedSet{}", "ecore::EPackage");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void test480853EmptyOrderedSetLiteralInExtension() {
        LinkedHashMap types = new LinkedHashMap();
        ICompletionResult completionResult = this.engine.getCompletion("OrderedSet{}->", 14, types);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 14, 0, "size()", "first()");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void test480853EmptySequenceLiteralInExtension() {
        LinkedHashMap types = new LinkedHashMap();
        ICompletionResult completionResult = this.engine.getCompletion("Sequence{}->", 12, types);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 12, 0, "size()", "first()");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testTypeLiteralInTypeSetLiteral() {
        ICompletionResult completionResult = this.engine.getCompletion("{ecore::", 8, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 53, "ecore::", "", 1, 7, "ecore::EClass", "ecore::EInt");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testTypeSetLiteral() {
        ICompletionResult completionResult = this.engine.getCompletion("{", 1, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 118, "", "", 1, 0, "ecore::EPackage");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testTypeLiteralInTypeSetLiteralInServiceCall() {
        ICompletionResult completionResult = this.engine.getCompletion("self->filter({ecore::", 21, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 53, "ecore::", "", 14, 7, "ecore::EClass", "ecore::EInt");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testTypeSetLiteralInServiceCall() {
        ICompletionResult completionResult = this.engine.getCompletion("self->filter({", 14, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 118, "", "", 14, 0, "ecore::EPackage");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
        Assert.assertEquals((long)14L, (long)completionResult.getReplacementOffset());
        Assert.assertEquals((long)0L, (long)completionResult.getReplacementLength());
    }

    @Test
    public void testTypeSetLiteralDot() {
        ICompletionResult completionResult = this.engine.getCompletion("{ecore::EClass}.", 16, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 46, "", "", 16, 0, "name", "eClass()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testTypeSetLiteralArrow() {
        ICompletionResult completionResult = this.engine.getCompletion("{ecore::EClass}->", 17, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 17, 0, "size()", "first()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
    }

    @Test
    public void errorStringLiteralWithEscapeSequence() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("'\\n", 3, types);
        CompletionTest.assertCompletion(completionResult, 0, "n", "", 2, 1, new String[0]);
    }

    @Test
    public void errorStringLiteralInSelectInCall() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(a | a.startsWith('", 31, types);
        CompletionTest.assertCompletion(completionResult, 0, "", "", 31, 0, new String[0]);
    }

    @Test
    public void missingClosingParenthesisCallNoArguments_465037() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self.eAllContents(", 18, types);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 18, 0, "self", "ecore::EClass");
    }

    @Test
    public void missingClosingParenthesisIterationCallNoArguments_465037() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(a | true ", 22, types);
        CompletionTest.assertCompletion(completionResult, 12, "", "", 22, 0, "and ", "or ", "implies ");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
    }

    @Test
    public void missingClosingParenthesisCall_465037() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self.eAllContents(self ", 23, types);
        CompletionTest.assertCompletion(completionResult, 2, "", "", 23, 0, ", ", ")");
    }

    @Test
    public void inSelectVariable() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->select(a | ", 17, types);
        List proposals = completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult));
        boolean variableAFound = false;
        for (ICompletionProposal proposal : proposals) {
            if (!"a".equals(proposal.getProposal())) continue;
            variableAFound = true;
            break;
        }
        Assert.assertTrue((boolean)variableAFound);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 17, 0, "self", "ecore::EClass");
    }

    @Test
    public void inLetVariable() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("let a = self in ", 16, types);
        CompletionTest.assertCompletion(completionResult, 131, "", "", 16, 0, "a", "self");
    }

    @Test
    public void inLetVariableInSecondBinding() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("let a = self, b = ", 18, types);
        List proposals = completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult));
        boolean variableAFound = false;
        for (ICompletionProposal proposal : proposals) {
            if (!"a".equals(proposal.getProposal())) continue;
            variableAFound = true;
            break;
        }
        Assert.assertFalse((boolean)variableAFound);
        CompletionTest.assertCompletion(completionResult, 130, "", "", 18, 0, "self");
    }

    @Test
    public void testCompletionOnNothingDot() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<NothingType> selfType = new LinkedHashSet<NothingType>();
        selfType.add(new NothingType("whatever"));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self.", 5, types);
        CompletionTest.assertCompletion(completionResult, 5, "", "", 5, 0, "toString()", "oclIsKindOf()");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testCompletionOnNothingArrow() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<NothingType> selfType = new LinkedHashSet<NothingType>();
        selfType.add(new NothingType("whatever"));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->", 6, types);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 6, 0, "size()", "first()");
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testCompletionOnSetOfNothingArrow() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SetType> selfType = new LinkedHashSet<SetType>();
        selfType.add(new SetType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->", 6, types);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 6, 0, "size()", "first()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void testCompletionOnSequenceOfNothingArrow() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SequenceType> selfType = new LinkedHashSet<SequenceType>();
        selfType.add(new SequenceType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self->", 6, types);
        CompletionTest.assertCompletion(completionResult, 44, "", "", 6, 0, "size()", "first()");
        this.assertNoVariableCompletionProposal(completionResult);
        CompletionTest.assertNoFeatureCompletionProposal(completionResult);
        CompletionTest.assertNoEOperationCompletionProposal(completionResult);
        CompletionTest.assertNoVariableDeclarationCompletionProposal(completionResult);
    }

    @Test
    public void negativeIndex() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SequenceType> selfType = new LinkedHashSet<SequenceType>();
        selfType.add(new SequenceType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        boolean exception = false;
        try {
            this.engine.getCompletion("self", -1, types);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"offset (-1) must be in the range of the given expression: \"self\"", (Object)e.getMessage());
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void tooHighIndex() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<SequenceType> selfType = new LinkedHashSet<SequenceType>();
        selfType.add(new SequenceType((IReadOnlyQueryEnvironment)this.queryEnvironment, (IType)new NothingType("whatever")));
        types.put("self", selfType);
        boolean exception = false;
        try {
            this.engine.getCompletion("self", 5, types);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"offset (5) must be in the range of the given expression: \"self\"", (Object)e.getMessage());
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void suffixFilter_479632() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eAllContents()", 5, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 73, "", "eAllContents", 5, 0, "eContainer()", "eAttributes");
    }

    @Test
    public void typeInEAllContents_529808() {
        ICompletionResult completionResult = this.engine.getCompletion("self.eAllContents(eco", 21, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 53, "eco", "", 18, 3, "ecore::EInt", "ecore::EClassifier");
    }

    @Test
    public void partialEPackageName() {
        ICompletionResult completionResult = this.engine.getCompletion("eco::", 5, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 53, "eco::", "", 0, 5, "ecore::EClass", "ecore::EClassifier");
    }

    @Test
    public void partialEPackageNameAndEClassName() {
        ICompletionResult completionResult = this.engine.getCompletion("eco::ECl", 8, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 2, "eco::ECl", "", 0, 8, "ecore::EClass", "ecore::EClassifier");
    }

    @Test
    public void partialEPackageNameAndEClassNameAndEnumNameNotEnum() {
        ICompletionResult completionResult = this.engine.getCompletion("eco::ECl::", 8, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 0, "eco::ECl", "", 0, 8, new String[0]);
    }

    @Test
    public void partialEPackageNameAndEClassNameAndEnumName() {
        ICompletionResult completionResult = this.engine.getCompletion("any::Co::whi", 12, this.variableTypes);
        CompletionTest.assertCompletion(completionResult, 1, "any::Co::whi", "", 0, 12, "anydsl::Color::white");
    }

    @Test
    public void eObjectFeatureAccessCompletionOnJavaType() {
        LinkedHashMap types = new LinkedHashMap();
        LinkedHashSet<EClassifierType> selfType = new LinkedHashSet<EClassifierType>();
        selfType.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject()));
        types.put("self", selfType);
        ICompletionResult completionResult = this.engine.getCompletion("self.eClass().nam", 17, types);
        CompletionTest.assertCompletion(completionResult, 1, "nam", "", 14, 3, "name");
    }

    public static void assertCompletion(ICompletionResult completionResult, int size, String prefix, String suffix, int replacementOffset, int replacementLength, String ... proposalStrings) {
        List proposals = completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult));
        if (proposalStrings.length != 0) {
            HashSet<String> actualProposalStrings = new HashSet<String>(proposals.size());
            for (ICompletionProposal proposal : proposals) {
                actualProposalStrings.add(proposal.getProposal());
            }
            String[] stringArray = proposalStrings;
            int n = proposalStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String proposalString = stringArray[n2];
                Assert.assertTrue((String)(String.valueOf(proposalString) + " is missing"), (boolean)actualProposalStrings.contains(proposalString));
                ++n2;
            }
        }
        Assert.assertEquals((long)size, (long)proposals.size());
        Assert.assertEquals((Object)prefix, (Object)completionResult.getPrefix());
        Assert.assertEquals((Object)suffix, (Object)completionResult.getRemaining());
        Assert.assertEquals((long)replacementOffset, (long)completionResult.getReplacementOffset());
        Assert.assertEquals((long)replacementLength, (long)completionResult.getReplacementLength());
    }

    public void assertNoVariableCompletionProposal(ICompletionResult completionResult) {
        for (ICompletionProposal prop : completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult))) {
            Assert.assertEquals((Object)false, (Object)(prop instanceof VariableCompletionProposal));
        }
    }

    public static void assertNoFeatureCompletionProposal(ICompletionResult completionResult) {
        for (ICompletionProposal prop : completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult))) {
            Assert.assertEquals((Object)false, (Object)(prop instanceof EFeatureCompletionProposal));
        }
    }

    public static void assertNoEOperationCompletionProposal(ICompletionResult completionResult) {
        for (ICompletionProposal prop : completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult))) {
            Assert.assertEquals((Object)false, (Object)(prop instanceof EOperationServiceCompletionProposal));
        }
    }

    public static void assertNoVariableDeclarationCompletionProposal(ICompletionResult completionResult) {
        for (ICompletionProposal prop : completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult))) {
            Assert.assertEquals((Object)false, (Object)(prop instanceof VariableDeclarationCompletionProposal));
        }
    }

    public static void assertNoServiceCompletionProposal(ICompletionResult completionResult) {
        for (ICompletionProposal prop : completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult))) {
            Assert.assertEquals((Object)false, (Object)(prop instanceof JavaMethodServiceCompletionProposal));
        }
    }

    public static void assertOnlyVariableCompletionProposal(ICompletionResult completionResult) {
        for (ICompletionProposal prop : completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult))) {
            Assert.assertEquals((Object)true, (Object)(prop instanceof VariableCompletionProposal));
        }
    }

    public static void assertApplyOn(ICompletionResult completionResult, IReadOnlyQueryEnvironment environment, Object ... types) {
        for (ICompletionProposal prop : completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult))) {
            Object[] objectArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Object type = objectArray[n2];
                if (prop instanceof EFeatureCompletionProposal) {
                    if (type instanceof EClass) {
                        Assert.assertEquals((String)(type + " is not compatible with " + ((EFeatureCompletionProposal)prop).getObject().getEContainingClass()), (Object)true, (Object)(((EFeatureCompletionProposal)prop).getObject().getEContainingClass() == type || ((EClass)type).getEAllSuperTypes().contains((Object)((EFeatureCompletionProposal)prop).getObject().getEContainingClass()) ? 1 : 0));
                    } else {
                        Assert.fail((String)"the receiver type must be an EClass for FeatureCompletionProposal");
                    }
                } else if (prop instanceof JavaMethodServiceCompletionProposal) {
                    Object iType = type instanceof EClassifier ? new EClassifierType(environment, (EClassifier)type) : new ClassType(environment, (Class)type);
                    Assert.assertTrue((boolean)((IType)((JavaMethodServiceCompletionProposal)prop).getObject().getParameterTypes(environment).get(0)).isAssignableFrom((IType)iType));
                }
                ++n2;
            }
        }
    }
}

