/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.And;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorBinding;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.ErrorConditional;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorStringLiteral;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Implies;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.Or;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BuildTest {
    QueryBuilderEngine engine;
    IQueryEnvironment queryEnvironment;

    @Before
    public void setup() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        this.engine = new QueryBuilderEngine((IReadOnlyQueryEnvironment)this.queryEnvironment);
    }

    private void assertExpression(IQueryBuilderEngine.AstResult astResult, Class<? extends Expression> expectedClass, int expectedStart, int expectedEnd, Expression actualExpression) {
        Assert.assertTrue((boolean)expectedClass.isAssignableFrom(actualExpression.getClass()));
        if (!Error.class.isAssignableFrom(expectedClass)) {
            Assert.assertFalse((boolean)Error.class.isAssignableFrom(actualExpression.getClass()));
        }
        Assert.assertEquals((long)expectedStart, (long)astResult.getStartPosition(actualExpression));
        Assert.assertEquals((long)expectedEnd, (long)astResult.getEndPosition(actualExpression));
    }

    private void assertVariableDeclaration(IQueryBuilderEngine.AstResult astResult, int expectedStart, int expectedEnd, VariableDeclaration actualVariableDeclaration) {
        Assert.assertEquals((long)expectedStart, (long)astResult.getStartPosition(actualVariableDeclaration));
        Assert.assertEquals((long)expectedEnd, (long)astResult.getEndPosition(actualVariableDeclaration));
    }

    @Test
    public void variableTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("x");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, VarRef.class, 0, 1, ast);
        Assert.assertEquals((Object)"x", (Object)((VarRef)ast).getVariableName());
    }

    @Test
    public void featureAccessTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.name");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 9, ast);
        Assert.assertEquals((Object)"aqlFeatureAccess", (Object)((Call)ast).getServiceName());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        VarRef varRef = (VarRef)((Call)ast).getArguments().get(0);
        Assert.assertEquals((Object)"self", (Object)varRef.getVariableName());
        this.assertExpression(build, StringLiteral.class, 5, 9, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)"name", (Object)((StringLiteral)((Call)ast).getArguments().get(1)).getValue());
    }

    @Test
    public void intliteralTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("2");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, IntegerLiteral.class, 0, 1, ast);
        Assert.assertEquals((long)2L, (long)((IntegerLiteral)ast).getValue());
    }

    @Test
    public void intliteralCallTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("2.toString()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 12, ast);
        Assert.assertEquals((Object)"toString", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        Assert.assertEquals((long)2L, (long)((IntegerLiteral)((Call)ast).getArguments().get(0)).getValue());
    }

    @Test
    public void realliteralTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("1.0");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, RealLiteral.class, 0, 3, ast);
        Assert.assertEquals((double)1.0, (double)((RealLiteral)ast).getValue(), (double)0.1);
    }

    @Test
    public void realliteralCallTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("1.0.toString()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 14, ast);
        Assert.assertEquals((Object)"toString", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, RealLiteral.class, 0, 3, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((double)1.0, (double)((RealLiteral)((Call)ast).getArguments().get(0)).getValue(), (double)0.1);
    }

    @Test
    public void trueliteralTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("true");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, BooleanLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)true, (Object)((BooleanLiteral)ast).isValue());
    }

    @Test
    public void trueliteralCallTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("true.toString()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 15, ast);
        Assert.assertEquals((Object)"toString", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, BooleanLiteral.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)true, (Object)((BooleanLiteral)((Call)ast).getArguments().get(0)).isValue());
    }

    @Test
    public void falseliteralTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("false");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, BooleanLiteral.class, 0, 5, ast);
        Assert.assertEquals((Object)false, (Object)((BooleanLiteral)ast).isValue());
    }

    @Test
    public void falseliteralCallTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("false.toString()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 16, ast);
        Assert.assertEquals((Object)"toString", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, BooleanLiteral.class, 0, 5, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)false, (Object)((BooleanLiteral)((Call)ast).getArguments().get(0)).isValue());
    }

    @Test
    public void stringliteralTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("'acceleo query is great'");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, StringLiteral.class, 0, 24, ast);
        Assert.assertEquals((Object)"acceleo query is great", (Object)((StringLiteral)ast).getValue());
    }

    @Test
    public void stringliteralEscapeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("'\\b'");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)"\b", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\b'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 5, ast);
        Assert.assertEquals((Object)"\\b", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\t'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)"\t", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\t'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 5, ast);
        Assert.assertEquals((Object)"\\t", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\n'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)"\n", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\n'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 5, ast);
        Assert.assertEquals((Object)"\\n", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\f'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)"\f", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\f'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 5, ast);
        Assert.assertEquals((Object)"\\f", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\r'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)"\r", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\r'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 5, ast);
        Assert.assertEquals((Object)"\\r", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\"'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)"\"", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\\"'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 5, ast);
        Assert.assertEquals((Object)"\\\"", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\''");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)"'", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 4, ast);
        Assert.assertEquals((Object)"\\", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\x09'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 6, ast);
        Assert.assertEquals((Object)"\t", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\x09'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 7, ast);
        Assert.assertEquals((Object)"\\x09", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\u0041'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 8, ast);
        Assert.assertEquals((Object)"A", (Object)((StringLiteral)ast).getValue());
        build = this.engine.build("'\\\\u0041'");
        ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        this.assertExpression(build, StringLiteral.class, 0, 9, ast);
        Assert.assertEquals((Object)"\\u0041", (Object)((StringLiteral)ast).getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidStringliteralEscapeTest() {
        this.engine.build("'\\w'");
    }

    @Test(expected=IllegalArgumentException.class)
    public void incompletStringliteralEscapeTest() {
        this.engine.build("'\\'");
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidXStringliteralEscapeTest() {
        this.engine.build("'\\xZZ'");
    }

    @Test(expected=IllegalArgumentException.class)
    public void incompletXStringliteralEscapeTest() {
        this.engine.build("'\\x0'");
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidUStringliteralEscapeTest() {
        this.engine.build("'\\uZZZZ'");
    }

    @Test(expected=IllegalArgumentException.class)
    public void incompletUStringliteralEscapeTest() {
        this.engine.build("'\\u0'");
    }

    @Test
    public void stringliteralCallTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("'acceleo query is great'.toString()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 35, ast);
        Assert.assertEquals((Object)"toString", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, StringLiteral.class, 0, 24, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"acceleo query is great", (Object)((StringLiteral)((Call)ast).getArguments().get(0)).getValue());
    }

    @Test
    public void nullliteralTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("null");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, NullLiteral.class, 0, 4, ast);
    }

    @Test
    public void nullliteralTestCall() {
        IQueryBuilderEngine.AstResult build = this.engine.build("null.toString()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 15, ast);
        Assert.assertEquals((Object)"toString", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, NullLiteral.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
    }

    @Test
    public void lowerEqualTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("1<=2");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 4, ast);
        Assert.assertEquals((Object)"lessThanEqual", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, IntegerLiteral.class, 0, 1, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)1L, (long)((IntegerLiteral)((Call)ast).getArguments().get(0)).getValue());
        this.assertExpression(build, IntegerLiteral.class, 3, 4, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)2L, (long)((IntegerLiteral)((Call)ast).getArguments().get(1)).getValue());
    }

    @Test
    public void lowerTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("1<2");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 3, ast);
        Assert.assertEquals((Object)"lessThan", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, IntegerLiteral.class, 0, 1, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)1L, (long)((IntegerLiteral)((Call)ast).getArguments().get(0)).getValue());
        this.assertExpression(build, IntegerLiteral.class, 2, 3, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)2L, (long)((IntegerLiteral)((Call)ast).getArguments().get(1)).getValue());
    }

    @Test
    public void greaterEqualTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("1>=2");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 4, ast);
        Assert.assertEquals((Object)"greaterThanEqual", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, IntegerLiteral.class, 0, 1, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)1L, (long)((IntegerLiteral)((Call)ast).getArguments().get(0)).getValue());
        this.assertExpression(build, IntegerLiteral.class, 3, 4, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)2L, (long)((IntegerLiteral)((Call)ast).getArguments().get(1)).getValue());
    }

    @Test
    public void greaterTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("1>2");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 3, ast);
        Assert.assertEquals((Object)"greaterThan", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, IntegerLiteral.class, 0, 1, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)1L, (long)((IntegerLiteral)((Call)ast).getArguments().get(0)).getValue());
        this.assertExpression(build, IntegerLiteral.class, 2, 3, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)2L, (long)((IntegerLiteral)((Call)ast).getArguments().get(1)).getValue());
    }

    @Test
    public void addTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("'a' + 'b'");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 9, ast);
        Assert.assertEquals((Object)"add", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, StringLiteral.class, 0, 3, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"a", (Object)((StringLiteral)((Call)ast).getArguments().get(0)).getValue());
        this.assertExpression(build, StringLiteral.class, 6, 9, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)"b", (Object)((StringLiteral)((Call)ast).getArguments().get(1)).getValue());
    }

    @Test
    public void orTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("true or false");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Or.class, 0, 13, ast);
        Assert.assertEquals((Object)"or", (Object)((Or)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Or)ast).getType());
        Assert.assertEquals((long)2L, (long)((Or)ast).getArguments().size());
        this.assertExpression(build, BooleanLiteral.class, 0, 4, (Expression)((Or)ast).getArguments().get(0));
        Assert.assertEquals((Object)true, (Object)((BooleanLiteral)((Or)ast).getArguments().get(0)).isValue());
        this.assertExpression(build, BooleanLiteral.class, 8, 13, (Expression)((Or)ast).getArguments().get(1));
        Assert.assertEquals((Object)false, (Object)((BooleanLiteral)((Or)ast).getArguments().get(1)).isValue());
    }

    @Test
    public void xorTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("true xor false");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 14, ast);
        Assert.assertEquals((Object)"xor", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, BooleanLiteral.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)true, (Object)((BooleanLiteral)((Call)ast).getArguments().get(0)).isValue());
        this.assertExpression(build, BooleanLiteral.class, 9, 14, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)false, (Object)((BooleanLiteral)((Call)ast).getArguments().get(1)).isValue());
    }

    @Test
    public void impliesTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("true implies false");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Implies.class, 0, 18, ast);
        Assert.assertEquals((Object)"implies", (Object)((Implies)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Implies)ast).getType());
        Assert.assertEquals((long)2L, (long)((Implies)ast).getArguments().size());
        this.assertExpression(build, BooleanLiteral.class, 0, 4, (Expression)((Implies)ast).getArguments().get(0));
        Assert.assertEquals((Object)true, (Object)((BooleanLiteral)((Implies)ast).getArguments().get(0)).isValue());
        this.assertExpression(build, BooleanLiteral.class, 13, 18, (Expression)((Implies)ast).getArguments().get(1));
        Assert.assertEquals((Object)false, (Object)((BooleanLiteral)((Implies)ast).getArguments().get(1)).isValue());
    }

    @Test
    public void andTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("true and false");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, And.class, 0, 14, ast);
        Assert.assertEquals((Object)"and", (Object)((And)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((And)ast).getType());
        Assert.assertEquals((long)2L, (long)((And)ast).getArguments().size());
        this.assertExpression(build, BooleanLiteral.class, 0, 4, (Expression)((And)ast).getArguments().get(0));
        Assert.assertEquals((Object)true, (Object)((BooleanLiteral)((And)ast).getArguments().get(0)).isValue());
        this.assertExpression(build, BooleanLiteral.class, 9, 14, (Expression)((And)ast).getArguments().get(1));
        Assert.assertEquals((Object)false, (Object)((BooleanLiteral)((And)ast).getArguments().get(1)).isValue());
    }

    @Test
    public void notTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("not true");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 8, ast);
        Assert.assertEquals((Object)"not", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, BooleanLiteral.class, 4, 8, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)true, (Object)((BooleanLiteral)((Call)ast).getArguments().get(0)).isValue());
    }

    @Test
    public void multTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("1*2");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 3, ast);
        Assert.assertEquals((Object)"mult", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, IntegerLiteral.class, 0, 1, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)1L, (long)((IntegerLiteral)((Call)ast).getArguments().get(0)).getValue());
        this.assertExpression(build, IntegerLiteral.class, 2, 3, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)2L, (long)((IntegerLiteral)((Call)ast).getArguments().get(1)).getValue());
    }

    @Test
    public void sizeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->size()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 12, ast);
        Assert.assertEquals((Object)"size", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"self", (Object)((VarRef)((Call)ast).getArguments().get(0)).getVariableName());
    }

    @Test
    public void selectTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select(e | true)");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 22, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"self", (Object)((VarRef)((Call)ast).getArguments().get(0)).getVariableName());
        this.assertExpression(build, Lambda.class, 17, 21, (Expression)((Call)ast).getArguments().get(1));
        this.assertVariableDeclaration(build, 13, 14, (VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0));
        Assert.assertEquals((Object)"e", (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getName());
        Assert.assertEquals(null, (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType());
        this.assertExpression(build, BooleanLiteral.class, 17, 21, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
    }

    @Test
    public void selectWithVariableNameTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select(var | true)");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 24, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"self", (Object)((VarRef)((Call)ast).getArguments().get(0)).getVariableName());
        this.assertExpression(build, Lambda.class, 19, 23, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)"var", (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getName());
        Assert.assertEquals(null, (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType());
        this.assertExpression(build, BooleanLiteral.class, 19, 23, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
    }

    @Test
    public void selectWithVariableNameAndTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select(var : ecore::EClass | true)");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 40, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"self", (Object)((VarRef)((Call)ast).getArguments().get(0)).getVariableName());
        this.assertExpression(build, Lambda.class, 35, 39, (Expression)((Call)ast).getArguments().get(1));
        this.assertVariableDeclaration(build, 13, 32, (VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0));
        Assert.assertEquals((Object)"var", (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getName());
        this.assertExpression(build, TypeLiteral.class, 19, 32, (Expression)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType());
        Assert.assertEquals((Object)true, (Object)(((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType().getValue() == EcorePackage.Literals.ECLASS ? 1 : 0));
        this.assertExpression(build, BooleanLiteral.class, 35, 39, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
    }

    @Test
    public void explicitSeqLitEmptyTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Sequence{}");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, SequenceInExtensionLiteral.class, 0, 10, ast);
        Assert.assertEquals((long)0L, (long)((SequenceInExtensionLiteral)ast).getValues().size());
    }

    @Test
    public void explicitSeqLitWithValueTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Sequence{ self }");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, SequenceInExtensionLiteral.class, 0, 16, ast);
        Assert.assertEquals((long)1L, (long)((SequenceInExtensionLiteral)ast).getValues().size());
        this.assertExpression(build, VarRef.class, 10, 14, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(0));
    }

    @Test
    public void explicitSeqLitWithValuesTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Sequence{ self, true }");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, SequenceInExtensionLiteral.class, 0, 22, ast);
        Assert.assertEquals((long)2L, (long)((SequenceInExtensionLiteral)ast).getValues().size());
        this.assertExpression(build, VarRef.class, 10, 14, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(0));
        this.assertExpression(build, BooleanLiteral.class, 16, 20, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(1));
    }

    @Test
    public void explicitSeqLitWithValuesCallTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Sequence{ self, true }.toString()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 33, ast);
        Assert.assertEquals((Object)"toString", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, SequenceInExtensionLiteral.class, 0, 22, (Expression)((Call)ast).getArguments().get(0));
    }

    @Test
    public void explicitSetLitEmptyTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("OrderedSet{}");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, SetInExtensionLiteral.class, 0, 12, ast);
        Assert.assertEquals((long)0L, (long)((SetInExtensionLiteral)ast).getValues().size());
    }

    @Test
    public void explicitSetLitWithValueTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("OrderedSet{ self }");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, SetInExtensionLiteral.class, 0, 18, ast);
        Assert.assertEquals((long)1L, (long)((SetInExtensionLiteral)ast).getValues().size());
        this.assertExpression(build, VarRef.class, 12, 16, (Expression)((SetInExtensionLiteral)ast).getValues().get(0));
    }

    @Test
    public void explicitSetLitWithValuesTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("OrderedSet{ self, true }");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, SetInExtensionLiteral.class, 0, 24, ast);
        Assert.assertEquals((long)2L, (long)((SetInExtensionLiteral)ast).getValues().size());
        this.assertExpression(build, VarRef.class, 12, 16, (Expression)((SetInExtensionLiteral)ast).getValues().get(0));
        this.assertExpression(build, BooleanLiteral.class, 18, 22, (Expression)((SetInExtensionLiteral)ast).getValues().get(1));
    }

    @Test
    public void explicitSetLitWithValuesCallTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("OrderedSet{ self, true }.toString()");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
        this.assertExpression(build, Call.class, 0, 35, ast);
        Assert.assertEquals((Object)"toString", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, SetInExtensionLiteral.class, 0, 24, (Expression)((Call)ast).getArguments().get(0));
    }

    @Test
    public void seqTypeWithTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.filter(Sequence(String))");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 29, ast);
        Assert.assertEquals((Object)"filter", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, CollectionTypeLiteral.class, 12, 28, (Expression)((Call)ast).getArguments().get(1));
        this.assertExpression(build, TypeLiteral.class, 21, 27, (Expression)((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType());
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getValue() == List.class ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType().getValue() == String.class ? 1 : 0));
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void setTypeWithTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.filter(OrderedSet(String))");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 31, ast);
        Assert.assertEquals((Object)"filter", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, CollectionTypeLiteral.class, 12, 30, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getValue() == Set.class ? 1 : 0));
        this.assertExpression(build, TypeLiteral.class, 23, 29, (Expression)((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType());
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType().getValue() == String.class ? 1 : 0));
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void typeLiteral() {
        IQueryBuilderEngine.AstResult build = this.engine.build("ecore::EClass");
        Expression ast = build.getAst();
        this.assertExpression(build, TypeLiteral.class, 0, 13, ast);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)((TypeLiteral)ast).getValue());
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void integerTypeLiteral() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Integer");
        Expression ast = build.getAst();
        this.assertExpression(build, TypeLiteral.class, 0, 7, ast);
        Assert.assertEquals(Integer.class, (Object)((TypeLiteral)ast).getValue());
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void realTypeLiteral() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Real");
        Expression ast = build.getAst();
        this.assertExpression(build, TypeLiteral.class, 0, 4, ast);
        Assert.assertEquals(Double.class, (Object)((TypeLiteral)ast).getValue());
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void classifierError() {
        IQueryBuilderEngine.AstResult build = this.engine.build("anydsl::EClass");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorTypeLiteral.class, 0, 14, ast);
        Assert.assertFalse((boolean)((ErrorTypeLiteral)ast).isMissingColon());
        Assert.assertEquals((Object)"anydsl", (Object)((ErrorTypeLiteral)ast).getSegments().get(0));
        Assert.assertEquals((Object)"EClass", (Object)((ErrorTypeLiteral)ast).getSegments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal anydsl::EClass", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void enumLiteral() {
        IQueryBuilderEngine.AstResult build = this.engine.build("anydsl::Part::Other");
        Expression ast = build.getAst();
        this.assertExpression(build, EnumLiteral.class, 0, 19, ast);
        Assert.assertEquals((Object)AnydslPackage.eINSTANCE.getPart().getEEnumLiteral("Other"), (Object)((EnumLiteral)ast).getLiteral());
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void enumLiteralError() {
        IQueryBuilderEngine.AstResult build = this.engine.build("anydsl::Part::NotExisting");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorEnumLiteral.class, 0, 25, ast);
        Assert.assertFalse((boolean)((ErrorEnumLiteral)ast).isMissingColon());
        Assert.assertEquals((Object)"anydsl", (Object)((ErrorEnumLiteral)ast).getSegments().get(0));
        Assert.assertEquals((Object)"Part", (Object)((ErrorEnumLiteral)ast).getSegments().get(1));
        Assert.assertEquals((Object)"NotExisting", (Object)((ErrorEnumLiteral)ast).getSegments().get(2));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid enum literal: no literal registered with this name", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void precedingSiblings() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.precedingSiblings()");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 24, ast);
        Assert.assertEquals((Object)"precedingSiblings", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void precedingSiblingsType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.precedingSiblings(ecore::EClass)");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 37, ast);
        Assert.assertEquals((Object)"precedingSiblings", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, TypeLiteral.class, 23, 36, (Expression)((Call)ast).getArguments().get(1));
        TypeLiteral typeLiteral = (TypeLiteral)((Call)ast).getArguments().get(1);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)typeLiteral.getValue());
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void followingSiblingsType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.followingSiblings(ecore::EClass)");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 37, ast);
        Assert.assertEquals((Object)"followingSiblings", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, TypeLiteral.class, 23, 36, (Expression)((Call)ast).getArguments().get(1));
        TypeLiteral typeLiteral = (TypeLiteral)((Call)ast).getArguments().get(1);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)typeLiteral.getValue());
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void followingSiblings() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.followingSiblings()");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 24, ast);
        Assert.assertEquals((Object)"followingSiblings", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void eInverse() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.eInverse()");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 15, ast);
        Assert.assertEquals((Object)"eInverse", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void eInverseType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.eInverse(ecore::EClass)");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 28, ast);
        Assert.assertEquals((Object)"eInverse", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, TypeLiteral.class, 14, 27, (Expression)((Call)ast).getArguments().get(1));
        TypeLiteral typeLiteral = (TypeLiteral)((Call)ast).getArguments().get(1);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), (Object)typeLiteral.getValue());
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void eInverseString() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.eInverse('name')");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 21, ast);
        Assert.assertEquals((Object)"eInverse", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, StringLiteral.class, 14, 20, (Expression)((Call)ast).getArguments().get(1));
        StringLiteral stringLiteral = (StringLiteral)((Call)ast).getArguments().get(1);
        Assert.assertEquals((Object)"name", (Object)stringLiteral.getValue());
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void letOneBinding() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a = 'a' in a");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 16, ast);
        Assert.assertEquals((long)1L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertEquals(null, (Object)((Binding)((Let)ast).getBindings().get(0)).getType());
        this.assertExpression(build, StringLiteral.class, 8, 11, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        this.assertExpression(build, VarRef.class, 15, 16, ((Let)ast).getBody());
    }

    @Test
    public void letTwoBindings() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a = 'a', b = 'b' in a + b");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 29, ast);
        Assert.assertEquals((long)2L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertEquals(null, (Object)((Binding)((Let)ast).getBindings().get(0)).getType());
        this.assertExpression(build, StringLiteral.class, 8, 11, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        Assert.assertEquals((Object)"b", (Object)((Binding)((Let)ast).getBindings().get(1)).getName());
        Assert.assertEquals(null, (Object)((Binding)((Let)ast).getBindings().get(1)).getType());
        this.assertExpression(build, StringLiteral.class, 17, 20, ((Binding)((Let)ast).getBindings().get(1)).getValue());
        this.assertExpression(build, Call.class, 24, 29, ((Let)ast).getBody());
    }

    @Test
    public void letOneBindingWithType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a : ecore::EString = 'a' in a");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 33, ast);
        Assert.assertEquals((long)1L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertTrue((boolean)(((Binding)((Let)ast).getBindings().get(0)).getType() instanceof TypeLiteral));
        this.assertExpression(build, StringLiteral.class, 25, 28, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        this.assertExpression(build, VarRef.class, 32, 33, ((Let)ast).getBody());
    }

    @Test
    public void letTwoBindingsWithType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a : ecore::EString = 'a', b : ecore::EString = 'b' in a + b");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 63, ast);
        Assert.assertEquals((long)2L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertTrue((boolean)(((Binding)((Let)ast).getBindings().get(0)).getType() instanceof TypeLiteral));
        this.assertExpression(build, StringLiteral.class, 25, 28, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        Assert.assertEquals((Object)"b", (Object)((Binding)((Let)ast).getBindings().get(1)).getName());
        Assert.assertTrue((boolean)(((Binding)((Let)ast).getBindings().get(1)).getType() instanceof TypeLiteral));
        this.assertExpression(build, StringLiteral.class, 51, 54, ((Binding)((Let)ast).getBindings().get(1)).getValue());
        this.assertExpression(build, Call.class, 58, 63, ((Let)ast).getBody());
    }

    @Test
    public void LetNoIn() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let v = self.name");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 17, ast);
        Assert.assertEquals((long)1L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"v", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        this.assertExpression(build, ErrorExpression.class, 17, 17, ((Let)ast).getBody());
    }

    @Test
    public void nullTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build(null);
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorExpression.class, -1, -1, ast);
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((Object)"null or empty string.", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void emtpyTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorExpression.class, 0, 0, ast);
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((Object)"null or empty string.", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletNotTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("not");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 3, ast);
        Assert.assertEquals((Object)"not", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, ErrorExpression.class, 3, 3, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletMinTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("-");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 1, ast);
        Assert.assertEquals((Object)"unaryMin", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)build.getAst()).getType());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, ErrorExpression.class, 1, 1, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletMultTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self *");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 6, ast);
        Assert.assertEquals((Object)"mult", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 6, 6, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompleteDivTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self /");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 6, ast);
        Assert.assertEquals((Object)"divOp", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 6, 6, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletAddTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self +");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 6, ast);
        Assert.assertEquals((Object)"add", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 6, 6, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletSubTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self -");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 6, ast);
        Assert.assertEquals((Object)"sub", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 6, 6, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        build = this.engine.build("self - ");
        ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 7, ast);
        Assert.assertEquals((Object)"sub", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 7, 7, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletLessTanTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self <");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 6, ast);
        Assert.assertEquals((Object)"lessThan", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 6, 6, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletLessThanEqualTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self <=");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 7, ast);
        Assert.assertEquals((Object)"lessThanEqual", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 7, 7, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletGreaterThanTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self >");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 6, ast);
        Assert.assertEquals((Object)"greaterThan", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 6, 6, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletGreaterThanEqualTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self >=");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 7, ast);
        Assert.assertEquals((Object)"greaterThanEqual", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 7, 7, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletEqualsTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self =");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 6, ast);
        Assert.assertEquals((Object)"equals", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 6, 6, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletEqualsJavaStyleTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self ==");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 7, ast);
        Assert.assertEquals((Object)"equals", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 7, 7, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletDiffersTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self <>");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 7, ast);
        Assert.assertEquals((Object)"differs", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 7, 7, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletDiffersJavaStyleTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self !=");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 7, ast);
        Assert.assertEquals((Object)"differs", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 7, 7, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletAndTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self and");
        Expression ast = build.getAst();
        this.assertExpression(build, And.class, 0, 8, ast);
        Assert.assertEquals((Object)"and", (Object)((And)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((And)build.getAst()).getType());
        Assert.assertEquals((long)2L, (long)((And)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((And)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 8, 8, (Expression)((And)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletOrTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self or");
        Expression ast = build.getAst();
        this.assertExpression(build, Or.class, 0, 7, ast);
        Assert.assertEquals((Object)"or", (Object)((Or)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Or)ast).getType());
        Assert.assertEquals((long)2L, (long)((Or)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Or)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 7, 7, (Expression)((Or)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletXorTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self xor");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 8, ast);
        Assert.assertEquals((Object)"xor", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 8, 8, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletImpliesTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self implies");
        Expression ast = build.getAst();
        this.assertExpression(build, Implies.class, 0, 12, ast);
        Assert.assertEquals((Object)"implies", (Object)((Implies)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Implies)ast).getType());
        Assert.assertEquals((long)2L, (long)((Implies)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Implies)ast).getArguments().get(0));
        this.assertExpression(build, ErrorExpression.class, 12, 12, (Expression)((Implies)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletNavigationSegmentDotTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 5, ast);
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"self", (Object)((VarRef)((Call)ast).getArguments().get(0)).getVariableName());
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing feature access or service call", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletNavigationSegmentArrowTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorCall.class, 0, 6, ast);
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((ErrorCall)ast).getArguments().get(0));
        Assert.assertEquals((Object)"self", (Object)((VarRef)((ErrorCall)ast).getArguments().get(0)).getVariableName());
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing collection service call", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletStringLitTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("'str");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorStringLiteral.class, 0, 4, ast);
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"String literal is not properly closed by a simple-quote: 'str", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletStringLitTestInExpression() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self = 'str");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 11, ast);
        Assert.assertEquals((Object)"equals", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLSERVICE, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, ErrorStringLiteral.class, 7, 11, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"String literal is not properly closed by a simple-quote: 'str", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletRealLitTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("3.");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 2, ast);
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((Object)ast, build.getErrors().get(0));
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing feature access or service call", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletExplicitSeqLitTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Sequence{");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((Object)"missing '}' at ''", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        this.assertExpression(build, SequenceInExtensionLiteral.class, 0, 9, ast);
        Assert.assertEquals((long)0L, (long)((SequenceInExtensionLiteral)ast).getValues().size());
    }

    @Test
    public void incompletExplicitSeqLitWithValueTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Sequence{ self");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing '}' at ''", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        this.assertExpression(build, SequenceInExtensionLiteral.class, 0, 14, ast);
        Assert.assertEquals((long)1L, (long)((SequenceInExtensionLiteral)ast).getValues().size());
        this.assertExpression(build, VarRef.class, 10, 14, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(0));
    }

    @Test
    public void incompletExplicitSeqLitWithValueAndCommaTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Sequence{ self,");
        Expression ast = build.getAst();
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        this.assertExpression(build, SequenceInExtensionLiteral.class, 0, 15, ast);
        Assert.assertEquals((long)2L, (long)((SequenceInExtensionLiteral)ast).getValues().size());
        this.assertExpression(build, VarRef.class, 10, 14, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(0));
        this.assertExpression(build, ErrorExpression.class, 15, 15, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(1));
        Assert.assertEquals(build.getErrors().get(0), (Object)((SequenceInExtensionLiteral)ast).getValues().get(1));
    }

    @Test
    public void incompletExplicitSetLitTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("OrderedSet{");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing '}' at ''", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        this.assertExpression(build, SetInExtensionLiteral.class, 0, 11, ast);
        Assert.assertEquals((long)0L, (long)((SetInExtensionLiteral)ast).getValues().size());
    }

    @Test
    public void incompletExplicitSetLitWithValueTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("OrderedSet{ self");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing '}' at ''", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        this.assertExpression(build, SetInExtensionLiteral.class, 0, 16, ast);
        Assert.assertEquals((long)1L, (long)((SetInExtensionLiteral)ast).getValues().size());
        this.assertExpression(build, VarRef.class, 12, 16, (Expression)((SetInExtensionLiteral)ast).getValues().get(0));
    }

    @Test
    public void incompletExplicitSetLitWithValueAndCommaTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("OrderedSet{ self,");
        Expression ast = build.getAst();
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        this.assertExpression(build, SetInExtensionLiteral.class, 0, 17, ast);
        Assert.assertEquals((long)2L, (long)((SetInExtensionLiteral)ast).getValues().size());
        this.assertExpression(build, VarRef.class, 12, 16, (Expression)((SetInExtensionLiteral)ast).getValues().get(0));
        this.assertExpression(build, ErrorExpression.class, 17, 17, (Expression)((SetInExtensionLiteral)ast).getValues().get(1));
        Assert.assertEquals(build.getErrors().get(0), (Object)((SetInExtensionLiteral)ast).getValues().get(1));
    }

    @Test
    public void incompletClassifierTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("toto::");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorTypeLiteral.class, 0, 6, ast);
        Assert.assertFalse((boolean)((ErrorTypeLiteral)ast).isMissingColon());
        Assert.assertEquals((long)1L, (long)((ErrorTypeLiteral)ast).getSegments().size());
        Assert.assertEquals((Object)"toto", (Object)((ErrorTypeLiteral)ast).getSegments().get(0));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal no viable alternative at input 'toto::'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletEnumLitWithPackageTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("toto::tata::");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorEnumLiteral.class, 0, 12, ast);
        Assert.assertFalse((boolean)((ErrorEnumLiteral)ast).isMissingColon());
        Assert.assertEquals((long)2L, (long)((ErrorEnumLiteral)ast).getSegments().size());
        Assert.assertEquals((Object)"toto", (Object)((ErrorEnumLiteral)ast).getSegments().get(0));
        Assert.assertEquals((Object)"tata", (Object)((ErrorEnumLiteral)ast).getSegments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid enum literal: missing literal name", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)2L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing Ident at ''", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void incompletIterationCallTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select(");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 13, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 13, 13, (Expression)((Call)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((Call)ast).getArguments().get(1);
        this.assertExpression(build, ErrorExpression.class, 13, 13, lambda.getExpression());
        Assert.assertEquals((long)1L, (long)lambda.getParameters().size());
        Assert.assertEquals((long)1L, (long)lambda.getParameters().size());
        this.assertVariableDeclaration(build, 13, 13, (VariableDeclaration)lambda.getParameters().get(0));
        Assert.assertEquals((long)3L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)3L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing variable declaration", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals(build.getErrors().get(2), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
    }

    @Test
    public void incompletIterationCallWithExpressionTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select(e | true");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 21, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 17, 21, (Expression)((Call)ast).getArguments().get(1));
        this.assertExpression(build, BooleanLiteral.class, 17, 21, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletIterationCallWithVariableNameTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select( a |");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 17, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 17, 17, (Expression)((Call)ast).getArguments().get(1));
        this.assertExpression(build, ErrorExpression.class, 17, 17, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)2L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void incompletIterationCallWithVariableNameAndExpressionTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select( a | true");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 22, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 18, 22, (Expression)((Call)ast).getArguments().get(1));
        this.assertExpression(build, BooleanLiteral.class, 18, 22, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletIterationCallWithMissingTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select( a :");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 17, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 17, 17, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)"a", (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getName());
        this.assertExpression(build, ErrorTypeLiteral.class, 17, 17, (Expression)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType());
        Assert.assertFalse((boolean)((ErrorTypeLiteral)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).isMissingColon());
        Assert.assertEquals((long)0L, (long)((ErrorTypeLiteral)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).getSegments().size());
        this.assertExpression(build, ErrorExpression.class, 17, 17, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)3L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)3L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal no viable alternative at input '<EOF>'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals(build.getErrors().get(2), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
    }

    @Test
    public void incompletIterationCallWithErrorTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select( a : ecore:: |");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 27, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 27, 27, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)"a", (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getName());
        this.assertExpression(build, ErrorTypeLiteral.class, 18, 25, (Expression)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType());
        Assert.assertFalse((boolean)((ErrorTypeLiteral)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).isMissingColon());
        Assert.assertEquals((long)1L, (long)((ErrorTypeLiteral)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).getSegments().size());
        Assert.assertEquals((Object)"ecore", (Object)((ErrorTypeLiteral)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType()).getSegments().get(0));
        this.assertExpression(build, ErrorExpression.class, 27, 27, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)3L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)3L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal ecore::<missing Ident>", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals(build.getErrors().get(2), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
    }

    @Test
    public void incompletIterationCallWithVariableDeclarationNoPipeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select( a : ecore::EClass");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 31, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 31, 31, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)"a", (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getName());
        this.assertExpression(build, TypeLiteral.class, 18, 31, (Expression)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType());
        Assert.assertEquals((Object)true, (Object)(((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType().getValue() == EcorePackage.Literals.ECLASS ? 1 : 0));
        this.assertExpression(build, ErrorExpression.class, 31, 31, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)3L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)3L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"incomplete variable definition", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals(build.getErrors().get(2), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
    }

    @Test
    public void incompletIterationCallWithVariableDeclarationWithPipeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select( a : ecore::EClass |");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 33, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 33, 33, (Expression)((Call)ast).getArguments().get(1));
        this.assertExpression(build, ErrorExpression.class, 33, 33, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)2L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void incompletIterationCallWithVariableDeclarationAndExpressionTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select( a : ecore::EClass | true");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 38, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 34, 38, (Expression)((Call)ast).getArguments().get(1));
        this.assertExpression(build, BooleanLiteral.class, 34, 38, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletServiceCallNoParameterTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.service(");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 13, ast);
        Assert.assertEquals((Object)"service", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)1L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletServiceCallOneParameterTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.service( true");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 18, ast);
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((Object)"service", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, BooleanLiteral.class, 14, 18, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void incompletServiceCallOneParameterAndComaTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.service( true,");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 19, ast);
        Assert.assertEquals((Object)"service", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)3L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, BooleanLiteral.class, 14, 18, (Expression)((Call)ast).getArguments().get(1));
        this.assertExpression(build, ErrorExpression.class, 19, 19, (Expression)((Call)ast).getArguments().get(2));
        Assert.assertEquals((long)2L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void incompletSeqTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.filter(Sequence(");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 21, ast);
        Assert.assertEquals((Object)"filter", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, CollectionTypeLiteral.class, 12, 21, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getValue() == List.class ? 1 : 0));
        this.assertExpression(build, ErrorTypeLiteral.class, 21, 21, (Expression)((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType());
        Assert.assertFalse((boolean)((ErrorTypeLiteral)((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType()).isMissingColon());
        Assert.assertEquals((long)2L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal no viable alternative at input '<EOF>'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void incompletSeqTypeWithTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.filter(Sequence(String");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 27, ast);
        Assert.assertEquals((Object)"filter", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, CollectionTypeLiteral.class, 12, 27, (Expression)((Call)ast).getArguments().get(1));
        this.assertExpression(build, TypeLiteral.class, 21, 27, (Expression)((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType());
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getValue() == List.class ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType().getValue() == String.class ? 1 : 0));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"mismatched input '' expecting ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((Object)((Call)ast).getArguments().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void incompletSetTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.filter(OrderedSet(");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 23, ast);
        Assert.assertEquals((Object)"filter", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, CollectionTypeLiteral.class, 12, 23, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getValue() == Set.class ? 1 : 0));
        this.assertExpression(build, ErrorTypeLiteral.class, 23, 23, (Expression)((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType());
        Assert.assertFalse((boolean)((ErrorTypeLiteral)((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType()).isMissingColon());
        Assert.assertEquals((long)2L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal no viable alternative at input '<EOF>'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void incompletSetTypeWithTypeTest() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.filter(OrderedSet(String");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 29, ast);
        Assert.assertEquals((Object)"filter", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, CollectionTypeLiteral.class, 12, 29, (Expression)((Call)ast).getArguments().get(1));
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getValue() == Set.class ? 1 : 0));
        this.assertExpression(build, TypeLiteral.class, 23, 29, (Expression)((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType());
        Assert.assertEquals((Object)true, (Object)(((CollectionTypeLiteral)((Call)ast).getArguments().get(1)).getElementType().getValue() == String.class ? 1 : 0));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"mismatched input '' expecting ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((Object)((Call)ast).getArguments().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void errorStringLiteralInSelectInCall() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select(a | a.startsWith('");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 31, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 17, 31, (Expression)((Call)ast).getArguments().get(1));
        this.assertVariableDeclaration(build, 13, 14, (VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0));
        Assert.assertEquals((Object)"a", (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getName());
        Assert.assertEquals(null, (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType());
        this.assertExpression(build, ErrorCall.class, 17, 31, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        ErrorCall call = (ErrorCall)((Lambda)((Call)ast).getArguments().get(1)).getExpression();
        Assert.assertEquals((Object)"startsWith", (Object)call.getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)call.getType());
        Assert.assertEquals((long)2L, (long)call.getArguments().size());
        this.assertExpression(build, VarRef.class, 17, 18, (Expression)call.getArguments().get(0));
        this.assertExpression(build, ErrorStringLiteral.class, 30, 31, (Expression)call.getArguments().get(1));
    }

    @Test
    public void errorStringLiteralAndCommaInSelectInCall() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self->select(a | a.startsWith(a, '");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 34, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 4, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 17, 34, (Expression)((Call)ast).getArguments().get(1));
        this.assertVariableDeclaration(build, 13, 14, (VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0));
        Assert.assertEquals((Object)"a", (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getName());
        Assert.assertEquals(null, (Object)((VariableDeclaration)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).getType());
        this.assertExpression(build, ErrorCall.class, 17, 34, ((Lambda)((Call)ast).getArguments().get(1)).getExpression());
        ErrorCall call = (ErrorCall)((Lambda)((Call)ast).getArguments().get(1)).getExpression();
        Assert.assertEquals((Object)"startsWith", (Object)call.getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)call.getType());
        Assert.assertEquals((long)3L, (long)call.getArguments().size());
        this.assertExpression(build, VarRef.class, 17, 18, (Expression)call.getArguments().get(0));
        this.assertExpression(build, VarRef.class, 30, 31, (Expression)call.getArguments().get(1));
        this.assertExpression(build, ErrorStringLiteral.class, 33, 34, (Expression)call.getArguments().get(2));
    }

    @Test
    public void incompleteLetNoExpression() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a=2 in");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 10, ast);
        Assert.assertEquals((long)1L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertEquals(null, (Object)((Binding)((Let)ast).getBindings().get(0)).getType());
        this.assertExpression(build, IntegerLiteral.class, 6, 7, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        this.assertExpression(build, ErrorExpression.class, 10, 10, ((Let)ast).getBody());
    }

    @Test
    public void incompleteLetNoBindingNoExpression() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 3, ast);
        Assert.assertEquals((long)1L, (long)((Let)ast).getBindings().size());
        this.assertExpression(build, ErrorExpression.class, 3, 3, ((Let)ast).getBody());
    }

    @Test
    public void incompleteLetNoBinding() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let in a");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 8, ast);
        Assert.assertEquals((long)1L, (long)((Let)ast).getBindings().size());
        Assert.assertTrue((boolean)(((Let)ast).getBindings().get(0) instanceof ErrorBinding));
        Assert.assertEquals(null, (Object)((ErrorBinding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertEquals(null, (Object)((ErrorBinding)((Let)ast).getBindings().get(0)).getType());
        this.assertExpression(build, ErrorExpression.class, 8, 8, ((Let)ast).getBody());
    }

    @Test
    public void incompleteLetIncompleteFirstBinding() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a= in a + b");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 15, ast);
        Assert.assertEquals((long)1L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertEquals(null, (Object)((Binding)((Let)ast).getBindings().get(0)).getType());
        this.assertExpression(build, ErrorExpression.class, 7, 7, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        this.assertExpression(build, Call.class, 10, 15, ((Let)ast).getBody());
    }

    @Test
    public void incompleteLetIncompleteFirstBindingErrorType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a : ecore:: = in a");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 22, ast);
        Assert.assertEquals((long)1L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        this.assertExpression(build, ErrorTypeLiteral.class, 8, 15, (Expression)((Binding)((Let)ast).getBindings().get(0)).getType());
        Assert.assertFalse((boolean)((ErrorTypeLiteral)((Binding)((Let)ast).getBindings().get(0)).getType()).isMissingColon());
        this.assertExpression(build, ErrorExpression.class, 18, 18, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        this.assertExpression(build, VarRef.class, 21, 22, ((Let)ast).getBody());
    }

    @Test
    public void incompleteLetIncompleteSecondBinding() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a=2 ,b= in a + b");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 20, ast);
        Assert.assertEquals((long)2L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertEquals(null, (Object)((Binding)((Let)ast).getBindings().get(0)).getType());
        this.assertExpression(build, IntegerLiteral.class, 6, 7, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        Assert.assertEquals((Object)"b", (Object)((Binding)((Let)ast).getBindings().get(1)).getName());
        Assert.assertEquals(null, (Object)((Binding)((Let)ast).getBindings().get(1)).getType());
        this.assertExpression(build, ErrorExpression.class, 12, 12, ((Binding)((Let)ast).getBindings().get(1)).getValue());
        this.assertExpression(build, Call.class, 15, 20, ((Let)ast).getBody());
    }

    @Test
    public void incompleteLetIncompleteSecondBindingErrorType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("let a=2 ,b : ecore:: = in a + b");
        Expression ast = build.getAst();
        this.assertExpression(build, Let.class, 0, 31, ast);
        Assert.assertEquals((long)2L, (long)((Let)ast).getBindings().size());
        Assert.assertEquals((Object)"a", (Object)((Binding)((Let)ast).getBindings().get(0)).getName());
        Assert.assertEquals(null, (Object)((Binding)((Let)ast).getBindings().get(0)).getType());
        this.assertExpression(build, IntegerLiteral.class, 6, 7, ((Binding)((Let)ast).getBindings().get(0)).getValue());
        Assert.assertEquals((Object)"b", (Object)((Binding)((Let)ast).getBindings().get(1)).getName());
        Assert.assertTrue((boolean)(((Binding)((Let)ast).getBindings().get(1)).getType() instanceof ErrorTypeLiteral));
        this.assertExpression(build, ErrorExpression.class, 23, 23, ((Binding)((Let)ast).getBindings().get(1)).getValue());
        this.assertExpression(build, Call.class, 26, 31, ((Let)ast).getBody());
    }

    @Test
    public void testConditional() {
        IQueryBuilderEngine.AstResult build = this.engine.build("if true then 5 else 'string' endif");
        Expression ast = build.getAst();
        Assert.assertFalse((boolean)(ast instanceof ErrorConditional));
        this.assertExpression(build, Conditional.class, 0, 34, ast);
        this.assertExpression(build, BooleanLiteral.class, 3, 7, ((Conditional)ast).getPredicate());
        this.assertExpression(build, IntegerLiteral.class, 13, 14, ((Conditional)ast).getTrueBranch());
        this.assertExpression(build, StringLiteral.class, 20, 28, ((Conditional)ast).getFalseBranch());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void testIncompleteConditionIf() {
        IQueryBuilderEngine.AstResult build = this.engine.build("if");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorConditional.class, 0, 2, ast);
        this.assertExpression(build, ErrorExpression.class, 2, 2, ((ErrorConditional)ast).getPredicate());
        Assert.assertEquals(null, (Object)((ErrorConditional)ast).getTrueBranch());
        Assert.assertEquals(null, (Object)((ErrorConditional)ast).getFalseBranch());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((Object)((ErrorConditional)ast).getPredicate(), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((Object)"incomplet conditional", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
    }

    @Test
    public void testIncompleteConditionIfThen() {
        IQueryBuilderEngine.AstResult build = this.engine.build("if then");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorConditional.class, 0, 7, ast);
        this.assertExpression(build, ErrorExpression.class, 3, 3, ((ErrorConditional)ast).getPredicate());
        this.assertExpression(build, ErrorExpression.class, 7, 7, ((ErrorConditional)ast).getTrueBranch());
        Assert.assertEquals(null, (Object)((ErrorConditional)ast).getFalseBranch());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)3L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((Object)((ErrorConditional)ast).getPredicate(), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals((Object)((ErrorConditional)ast).getTrueBranch(), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
        Assert.assertEquals((Object)"incomplet conditional", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
    }

    @Test
    public void testIncompleteConditionIfThenElse() {
        IQueryBuilderEngine.AstResult build = this.engine.build("if then else");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorConditional.class, 0, 12, ast);
        this.assertExpression(build, ErrorExpression.class, 3, 3, ((ErrorConditional)ast).getPredicate());
        this.assertExpression(build, ErrorExpression.class, 8, 8, ((ErrorConditional)ast).getTrueBranch());
        this.assertExpression(build, ErrorExpression.class, 12, 12, ((ErrorConditional)ast).getFalseBranch());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((Object)((ErrorConditional)ast).getPredicate(), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals((Object)((ErrorConditional)ast).getTrueBranch(), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals((Object)((ErrorConditional)ast).getFalseBranch(), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(3)).getData().get(0));
        Assert.assertEquals((Object)"incomplet conditional", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(3)).getMessage());
    }

    @Test
    public void testIncompleteConditionNoExpressions() {
        IQueryBuilderEngine.AstResult build = this.engine.build("if then else endif");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorConditional.class, 0, 18, ast);
        this.assertExpression(build, ErrorExpression.class, 3, 3, ((ErrorConditional)ast).getPredicate());
        this.assertExpression(build, ErrorExpression.class, 8, 8, ((ErrorConditional)ast).getTrueBranch());
        this.assertExpression(build, ErrorExpression.class, 13, 13, ((ErrorConditional)ast).getFalseBranch());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((Object)((ErrorConditional)ast).getPredicate(), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((Object)((ErrorConditional)ast).getTrueBranch(), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals((Object)((ErrorConditional)ast).getFalseBranch(), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(3)).getData().get(0));
        Assert.assertEquals((Object)"incomplet conditional", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(3)).getMessage());
    }

    @Test
    public void testNotPrecedenceEqual() {
        IQueryBuilderEngine.AstResult build = this.engine.build("not self.name = 'self'");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 22, ast);
        Assert.assertEquals((Object)"equals", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, Call.class, 0, 13, (Expression)((Call)ast).getArguments().get(0));
        Call not = (Call)((Call)ast).getArguments().get(0);
        Assert.assertEquals((Object)"not", (Object)not.getServiceName());
        Assert.assertEquals((long)1L, (long)not.getArguments().size());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void testBooleanOperatorsPrecedence1() {
        IQueryBuilderEngine.AstResult build = this.engine.build("not a.abstract and b.abstract or c.abstract");
        Expression ast = build.getAst();
        this.assertExpression(build, Or.class, 0, 43, ast);
        Assert.assertEquals((Object)"or", (Object)((Or)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Or)ast).getArguments().size());
        this.assertExpression(build, And.class, 0, 29, (Expression)((Or)ast).getArguments().get(0));
        And and = (And)((Or)ast).getArguments().get(0);
        Assert.assertEquals((Object)"and", (Object)and.getServiceName());
        Assert.assertEquals((long)2L, (long)and.getArguments().size());
        this.assertExpression(build, Call.class, 0, 14, (Expression)and.getArguments().get(0));
        Call not = (Call)and.getArguments().get(0);
        Assert.assertEquals((Object)"not", (Object)not.getServiceName());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void testBooleanOperatorsPrecedence2() {
        IQueryBuilderEngine.AstResult build = this.engine.build("a.abstract or not b.abstract and c.abstract");
        Expression ast = build.getAst();
        this.assertExpression(build, Or.class, 0, 43, ast);
        Assert.assertEquals((Object)"or", (Object)((Or)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Or)ast).getArguments().size());
        this.assertExpression(build, And.class, 14, 43, (Expression)((Or)ast).getArguments().get(1));
        And and = (And)((Or)ast).getArguments().get(1);
        Assert.assertEquals((Object)"and", (Object)and.getServiceName());
        Assert.assertEquals((long)2L, (long)and.getArguments().size());
        this.assertExpression(build, Call.class, 14, 28, (Expression)and.getArguments().get(0));
        Call not = (Call)and.getArguments().get(0);
        Assert.assertEquals((Object)"not", (Object)not.getServiceName());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void testClassifierSetType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("{ecore::EClass | ecore::EPackage | ecore::EAttribute}");
        Expression ast = build.getAst();
        this.assertExpression(build, TypeSetLiteral.class, 0, 53, ast);
        Assert.assertEquals((long)3L, (long)((TypeSetLiteral)ast).getTypes().size());
        this.assertExpression(build, TypeLiteral.class, 1, 14, (Expression)((TypeLiteral)((TypeSetLiteral)ast).getTypes().get(0)));
        this.assertExpression(build, TypeLiteral.class, 17, 32, (Expression)((TypeLiteral)((TypeSetLiteral)ast).getTypes().get(1)));
        this.assertExpression(build, TypeLiteral.class, 35, 52, (Expression)((TypeLiteral)((TypeSetLiteral)ast).getTypes().get(2)));
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)0L, (long)build.getDiagnostic().getChildren().size());
    }

    @Test
    public void incompletClassifierSetType() {
        IQueryBuilderEngine.AstResult build = this.engine.build("{");
        Expression ast = build.getAst();
        this.assertExpression(build, TypeSetLiteral.class, 0, 1, ast);
        Assert.assertEquals((long)1L, (long)((TypeSetLiteral)ast).getTypes().size());
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)((TypeSetLiteral)ast).getTypes().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((Object)"missing classifier literal", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        this.assertExpression(build, TypeSetLiteral.class, 0, 1, ast);
    }

    @Test
    public void incompletClassifierSetTypeEmpty() {
        IQueryBuilderEngine.AstResult build = this.engine.build("{}");
        Expression ast = build.getAst();
        this.assertExpression(build, TypeSetLiteral.class, 0, 2, ast);
        Assert.assertEquals((long)1L, (long)((TypeSetLiteral)ast).getTypes().size());
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)((TypeSetLiteral)ast).getTypes().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((Object)"missing classifier literal", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
    }

    @Test
    public void incompletClassifierSetTypeWithValue() {
        IQueryBuilderEngine.AstResult build = this.engine.build("{ecore::EClass");
        Expression ast = build.getAst();
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)2L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing '}' at ''", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals((Object)ast, ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        this.assertExpression(build, TypeSetLiteral.class, 0, 14, ast);
        Assert.assertEquals((long)1L, (long)((TypeSetLiteral)ast).getTypes().size());
        this.assertExpression(build, TypeLiteral.class, 1, 14, (Expression)((TypeSetLiteral)ast).getTypes().get(0));
    }

    @Test
    public void incompletClassifierSetTypeWithValueAndPipe() {
        IQueryBuilderEngine.AstResult build = this.engine.build("{ecore::EClass |");
        Expression ast = build.getAst();
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing classifier literal", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        this.assertExpression(build, TypeSetLiteral.class, 0, 16, ast);
        Assert.assertEquals((long)2L, (long)((TypeSetLiteral)ast).getTypes().size());
        this.assertExpression(build, TypeLiteral.class, 1, 14, (Expression)((TypeSetLiteral)ast).getTypes().get(0));
        this.assertExpression(build, ErrorTypeLiteral.class, 16, 16, (Expression)((TypeSetLiteral)ast).getTypes().get(1));
        Assert.assertFalse((boolean)((ErrorTypeLiteral)((TypeSetLiteral)ast).getTypes().get(1)).isMissingColon());
        Assert.assertEquals(build.getErrors().get(0), (Object)((TypeSetLiteral)ast).getTypes().get(1));
    }

    @Test
    public void incompletTypeSeparatorInSelect() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.packagedElement->select(e | e.oclIsTypeOf(uml:");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 51, ast);
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, Call.class, 0, 20, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"aqlFeatureAccess", (Object)((Call)((Call)ast).getArguments().get(0)).getServiceName());
        this.assertExpression(build, StringLiteral.class, 5, 20, (Expression)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1));
        StringLiteral featureName = (StringLiteral)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1);
        Assert.assertEquals((Object)"packagedElement", (Object)featureName.getValue());
        this.assertExpression(build, Lambda.class, 33, 51, (Expression)((Call)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((Call)ast).getArguments().get(1);
        this.assertExpression(build, ErrorCall.class, 33, 51, lambda.getExpression());
        ErrorCall call = (ErrorCall)lambda.getExpression();
        Assert.assertEquals((long)2L, (long)call.getArguments().size());
        this.assertExpression(build, VarRef.class, 33, 34, (Expression)call.getArguments().get(0));
        this.assertExpression(build, ErrorTypeLiteral.class, 47, 51, (Expression)call.getArguments().get(1));
        Assert.assertTrue((boolean)((ErrorTypeLiteral)call.getArguments().get(1)).isMissingColon());
        Assert.assertEquals((long)3L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)3L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal uml:", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing collection service call", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals(build.getErrors().get(2), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
    }

    @Test
    public void incompletEnumLiteralSeparatorInSelect() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.packagedElement->select(e | e.oclIsTypeOf(anydsl::Color:");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 61, ast);
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        Assert.assertEquals((Object)"aqlFeatureAccess", (Object)((Call)((Call)ast).getArguments().get(0)).getServiceName());
        this.assertExpression(build, StringLiteral.class, 5, 20, (Expression)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1));
        StringLiteral featureName = (StringLiteral)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1);
        Assert.assertEquals((Object)"packagedElement", (Object)featureName.getValue());
        this.assertExpression(build, Lambda.class, 33, 61, (Expression)((Call)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((Call)ast).getArguments().get(1);
        this.assertExpression(build, ErrorCall.class, 33, 61, lambda.getExpression());
        ErrorCall call = (ErrorCall)lambda.getExpression();
        Assert.assertEquals((long)2L, (long)call.getArguments().size());
        this.assertExpression(build, VarRef.class, 33, 34, (Expression)call.getArguments().get(0));
        this.assertExpression(build, ErrorEnumLiteral.class, 47, 61, (Expression)call.getArguments().get(1));
        Assert.assertEquals((long)2L, (long)((ErrorEnumLiteral)call.getArguments().get(1)).getSegments().size());
        Assert.assertTrue((boolean)((ErrorEnumLiteral)call.getArguments().get(1)).isMissingColon());
        Assert.assertEquals((long)3L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)3L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid enum literal: ':' instead of '::'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing collection service call", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals(build.getErrors().get(2), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
    }

    @Test
    public void incompletTypeLiteralInSelect() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.eAllContents(ecore::EClass)->select(a: ecore::");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 51, ast);
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, Call.class, 0, 32, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 51, 51, (Expression)((Call)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((Call)ast).getArguments().get(1);
        this.assertExpression(build, ErrorExpression.class, 51, 51, lambda.getExpression());
        this.assertExpression(build, ErrorTypeLiteral.class, 44, 51, (Expression)((VariableDeclaration)lambda.getParameters().get(0)).getType());
        Assert.assertEquals((long)3L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)3L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal ecore::", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"missing ')'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals(build.getErrors().get(2), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
    }

    @Test
    public void incompletTypeLiteralInSelectWithExpression() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.eAllContents(ecore::EClass)->select(a: ecore:: | a)");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 56, ast);
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, Call.class, 0, 32, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 55, 55, (Expression)((Call)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((Call)ast).getArguments().get(1);
        this.assertExpression(build, ErrorExpression.class, 55, 55, lambda.getExpression());
        this.assertExpression(build, ErrorTypeLiteral.class, 44, 56, (Expression)((VariableDeclaration)lambda.getParameters().get(0)).getType());
        Assert.assertEquals((long)4L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal ecore::|a", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"incomplete variable definition", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getSeverity());
        Assert.assertEquals((Object)"missing expression", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(2)).getMessage());
        Assert.assertEquals(build.getErrors().get(2), ((Diagnostic)build.getDiagnostic().getChildren().get(2)).getData().get(0));
    }

    @Test
    public void incompletTypeLiteralInSelectWithExpression_500204() {
        IQueryBuilderEngine.AstResult build = this.engine.build("aPackage->reject(aPackage: Package | aPackage.eContainer() != null)");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 67, ast);
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 8, (Expression)((Call)ast).getArguments().get(0));
        Assert.assertEquals((Object)"aPackage", (Object)((VarRef)((Call)ast).getArguments().get(0)).getVariableName());
        this.assertExpression(build, Lambda.class, 37, 66, (Expression)((Call)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((Call)ast).getArguments().get(1);
        this.assertExpression(build, ErrorTypeLiteral.class, 27, 36, (Expression)((VariableDeclaration)lambda.getParameters().get(0)).getType());
        Assert.assertEquals((long)0L, (long)((ErrorTypeLiteral)((VariableDeclaration)lambda.getParameters().get(0)).getType()).getSegments().size());
        Assert.assertEquals((Object)"", (Object)((VariableDeclaration)lambda.getParameters().get(0)).getName());
        this.assertExpression(build, Call.class, 37, 66, lambda.getExpression());
        Assert.assertEquals((Object)"differs", (Object)((Call)lambda.getExpression()).getServiceName());
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal ", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
    }

    @Test
    public void incompletParentExpressionInSelect() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self.value->select(value | not (value.owner.oclAsType(uml::Slot)");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 64, ast);
        Assert.assertEquals((Object)"select", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        Assert.assertEquals((Object)"aqlFeatureAccess", (Object)((Call)((Call)ast).getArguments().get(0)).getServiceName());
        this.assertExpression(build, StringLiteral.class, 5, 10, (Expression)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1));
        StringLiteral featureName = (StringLiteral)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1);
        Assert.assertEquals((Object)"value", (Object)featureName.getValue());
        this.assertExpression(build, Lambda.class, 27, 64, (Expression)((Call)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((Call)ast).getArguments().get(1);
        this.assertExpression(build, Call.class, 27, 64, lambda.getExpression());
        Assert.assertEquals((Object)"not", (Object)((Call)lambda.getExpression()).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)lambda.getExpression()).getArguments().size());
        Assert.assertEquals((long)2L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"invalid type literal uml::Slot", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getSeverity());
        Assert.assertEquals((Object)"invalid iteration call", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(1)).getMessage());
        Assert.assertEquals(build.getErrors().get(1), ((Diagnostic)build.getDiagnostic().getChildren().get(1)).getData().get(0));
    }

    @Test
    public void invalidLambda_484323() {
        IQueryBuilderEngine.AstResult build = this.engine.build("OrderedSet{'hello'}->any(1)");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 27, ast);
        Assert.assertEquals((Object)"any", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, SetInExtensionLiteral.class, 0, 19, (Expression)((Call)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 25, 26, (Expression)((Call)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((Call)ast).getArguments().get(1);
        this.assertExpression(build, IntegerLiteral.class, 25, 26, lambda.getExpression());
        Assert.assertEquals((long)1L, (long)((IntegerLiteral)lambda.getExpression()).getValue());
        Assert.assertEquals((long)1L, (long)lambda.getParameters().size());
        Assert.assertTrue((boolean)(lambda.getParameters().get(0) instanceof ErrorVariableDeclaration));
        Assert.assertEquals((long)1L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertEquals((Object)"missing variable declaration", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertEquals(build.getErrors().get(0), ((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().get(0));
    }

    @Test
    public void invalidToken() {
        IQueryBuilderEngine.AstResult build = this.engine.build("self \u00b5= null");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 12, ast);
        Assert.assertEquals((long)0L, (long)build.getErrors().size());
        Assert.assertEquals((long)4L, (long)build.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)build.getDiagnostic().getChildren().size());
        Assert.assertEquals((Object)"token recognition error at: '\u00b5'", (Object)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getMessage());
        Assert.assertTrue((String)"token recognition error at: '\u00b5'", (boolean)((Diagnostic)build.getDiagnostic().getChildren().get(0)).getData().isEmpty());
    }

    @Test
    public void emoji() {
        IQueryBuilderEngine.AstResult build = this.engine.build("Sequence{'\u1f61C','\u1f62D','\u1f63D','\u1f1eB\u1f1f7'}");
        Expression ast = build.getAst();
        this.assertExpression(build, SequenceInExtensionLiteral.class, 0, 31, ast);
        this.assertExpression(build, StringLiteral.class, 9, 13, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(0));
        Assert.assertEquals((Object)"\u1f61C", (Object)((StringLiteral)((SequenceInExtensionLiteral)ast).getValues().get(0)).getValue());
        this.assertExpression(build, StringLiteral.class, 14, 18, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(1));
        Assert.assertEquals((Object)"\u1f62D", (Object)((StringLiteral)((SequenceInExtensionLiteral)ast).getValues().get(1)).getValue());
        this.assertExpression(build, StringLiteral.class, 19, 23, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(2));
        Assert.assertEquals((Object)"\u1f63D", (Object)((StringLiteral)((SequenceInExtensionLiteral)ast).getValues().get(2)).getValue());
        this.assertExpression(build, StringLiteral.class, 24, 30, (Expression)((SequenceInExtensionLiteral)ast).getValues().get(3));
        Assert.assertEquals((Object)"\u1f1eB\u1f1f7", (Object)((StringLiteral)((SequenceInExtensionLiteral)ast).getValues().get(3)).getValue());
    }

    @Test
    public void incompleteSelect_494432() {
        IQueryBuilderEngine.AstResult build = this.engine.build("var->select(oclIsKindOf(String) or oclIsKindOf(Integer))");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorCall.class, 0, 56, ast);
        Assert.assertEquals((Object)"select", (Object)((ErrorCall)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((ErrorCall)ast).getType());
        Assert.assertFalse((boolean)((ErrorCall)ast).isMissingEndParenthesis());
    }

    @Test
    public void emptySelect() {
        IQueryBuilderEngine.AstResult build = this.engine.build("var->select()");
        Expression ast = build.getAst();
        this.assertExpression(build, ErrorCall.class, 0, 13, ast);
        Assert.assertEquals((Object)"select", (Object)((ErrorCall)ast).getServiceName());
        Assert.assertEquals((Object)CallType.COLLECTIONCALL, (Object)((ErrorCall)ast).getType());
        Assert.assertFalse((boolean)((ErrorCall)ast).isMissingEndParenthesis());
        Assert.assertEquals((long)2L, (long)((ErrorCall)ast).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 3, (Expression)((ErrorCall)ast).getArguments().get(0));
        this.assertExpression(build, Lambda.class, 12, 12, (Expression)((ErrorCall)ast).getArguments().get(1));
        Lambda lambda = (Lambda)((ErrorCall)ast).getArguments().get(1);
        Assert.assertEquals((long)1L, (long)lambda.getParameters().size());
        Assert.assertTrue((boolean)(lambda.getParameters().get(0) instanceof ErrorVariableDeclaration));
        Assert.assertEquals(null, (Object)((ErrorVariableDeclaration)lambda.getParameters().get(0)).getName());
        this.assertExpression(build, ErrorExpression.class, 12, 12, lambda.getExpression());
    }

    @Test
    public void doubleDot() {
        IQueryBuilderEngine.AstResult build = this.engine.build("fke.primaryKeyColumn()..name");
        Expression ast = build.getAst();
        this.assertExpression(build, Call.class, 0, 28, ast);
        Assert.assertEquals((Object)"aqlFeatureAccess", (Object)((Call)ast).getServiceName());
        Assert.assertEquals((Object)CallType.CALLORAPPLY, (Object)((Call)ast).getType());
        Assert.assertEquals((long)2L, (long)((Call)ast).getArguments().size());
        this.assertExpression(build, ErrorCall.class, 0, 24, (Expression)((Call)ast).getArguments().get(0));
        ErrorCall arg0 = (ErrorCall)((Call)ast).getArguments().get(0);
        Assert.assertEquals((Object)false, (Object)arg0.isMissingEndParenthesis());
        Assert.assertEquals((Object)"aqlFeatureAccess", (Object)arg0.getServiceName());
        Assert.assertEquals((long)1L, (long)arg0.getArguments().size());
        this.assertExpression(build, Call.class, 0, 22, (Expression)arg0.getArguments().get(0));
        Assert.assertEquals((Object)"primaryKeyColumn", (Object)((Call)arg0.getArguments().get(0)).getServiceName());
        Assert.assertEquals((long)1L, (long)((Call)arg0.getArguments().get(0)).getArguments().size());
        this.assertExpression(build, VarRef.class, 0, 3, (Expression)((Call)arg0.getArguments().get(0)).getArguments().get(0));
        this.assertExpression(build, StringLiteral.class, 24, 28, (Expression)((Call)ast).getArguments().get(1));
        StringLiteral arg1 = (StringLiteral)((Call)ast).getArguments().get(1);
        Assert.assertEquals((Object)"name", (Object)arg1.getValue());
    }
}

