/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ast.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.parser.AstEvaluator;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.CrossReferencerToAQL;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.LambdaValue;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AstEvaluatorTest
extends AstBuilder {
    private AstEvaluator evaluator;

    private CrossReferenceProvider createEInverseCrossreferencer(EObject target) {
        EcoreUtil.CrossReferencer crossReferencer;
        Resource res = null;
        ResourceSet rs = null;
        if (target.eResource() != null) {
            res = target.eResource();
        }
        if (res != null && res.getResourceSet() != null) {
            rs = res.getResourceSet();
        }
        if (rs != null) {
            Resource ecoreResource = EcorePackage.eINSTANCE.getEClass().eResource();
            ArrayList<Resource> notifiers = new ArrayList<Resource>();
            for (Resource crossReferenceResource : rs.getResources()) {
                if ("emtl".equals(crossReferenceResource.getURI().fileExtension())) continue;
                notifiers.add(crossReferenceResource);
            }
            notifiers.add(ecoreResource);
            crossReferencer = new EcoreUtil.CrossReferencer(notifiers){
                private static final long serialVersionUID = 1L;
                {
                    this.crossReference();
                    this.done();
                }
            };
        } else if (res != null) {
            crossReferencer = new EcoreUtil.CrossReferencer(res){
                private static final long serialVersionUID = 1L;
                {
                    this.crossReference();
                    this.done();
                }
            };
        } else {
            EObject targetObject = EcoreUtil.getRootContainer((EObject)target);
            crossReferencer = new EcoreUtil.CrossReferencer(targetObject){
                private static final long serialVersionUID = 1L;
                {
                    this.crossReference();
                    this.done();
                }
            };
        }
        return new CrossReferencerToAQL(crossReferencer);
    }

    @Before
    public void setup() {
        IQueryEnvironment environment = Query.newEnvironmentWithDefaultServices((CrossReferenceProvider)this.createEInverseCrossreferencer((EObject)EcorePackage.eINSTANCE));
        this.evaluator = new AstEvaluator(new EvaluationServices((IReadOnlyQueryEnvironment)environment));
    }

    @Test
    public void testIntLiteral() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals(1, this.evaluator.eval(varDefinitions, (Expression)this.integerLiteral(1)));
    }

    @Test
    public void testRealLiteral() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals(1.0, this.evaluator.eval(varDefinitions, (Expression)this.realLiteral(1.0)));
    }

    @Test
    public void testBoolLiteral() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals(Boolean.TRUE, this.evaluator.eval(varDefinitions, (Expression)this.booleanLiteral(true)));
        this.assertOKResultEquals(Boolean.FALSE, this.evaluator.eval(varDefinitions, (Expression)this.booleanLiteral(false)));
    }

    @Test
    public void testStringLiteral() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals("john doe", this.evaluator.eval(varDefinitions, (Expression)this.stringLiteral("john doe")));
    }

    @Test
    public void testTypeLiteral() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals(EcorePackage.Literals.ECLASS, this.evaluator.eval(varDefinitions, (Expression)this.typeLiteral(EcorePackage.Literals.ECLASS)));
        this.assertOKResultEquals(Integer.class, this.evaluator.eval(varDefinitions, (Expression)this.typeLiteral(Integer.class)));
    }

    @Test
    public void testFeatureAccess() {
        HashMap<String, EClass> varDefinitions = new HashMap<String, EClass>();
        varDefinitions.put("self", EcorePackage.Literals.ECLASS);
        this.assertOKResultEquals("EClass", this.evaluator.eval(varDefinitions, (Expression)this.callService("aqlFeatureAccess", new Expression[]{this.varRef("self"), this.stringLiteral("name")})));
        EvaluationResult result = this.evaluator.eval(varDefinitions, (Expression)this.callService("aqlFeatureAccess", new Expression[]{this.varRef("self"), this.stringLiteral("eAllSuperTypes")}));
        Assert.assertTrue((boolean)(result.getResult() instanceof List));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        List listResult = (List)result.getResult();
        Assert.assertEquals((long)3L, (long)listResult.size());
        Assert.assertTrue((boolean)listResult.contains(EcorePackage.Literals.EMODEL_ELEMENT));
        Assert.assertTrue((boolean)listResult.contains(EcorePackage.Literals.ENAMED_ELEMENT));
        Assert.assertTrue((boolean)listResult.contains(EcorePackage.Literals.ECLASSIFIER));
    }

    @Test
    public void testVarRef() {
        HashMap<String, EClass> varDefinitions = new HashMap<String, EClass>();
        varDefinitions.put("self", EcorePackage.Literals.ECLASS);
        this.assertOKResultEquals(EcorePackage.Literals.ECLASS, this.evaluator.eval(varDefinitions, (Expression)this.varRef("self")));
    }

    @Test
    public void testCall() {
        HashMap<String, EClass> varDefinitions = new HashMap<String, EClass>();
        varDefinitions.put("self", EcorePackage.Literals.ECLASS);
        Call callService = this.callService("size", new Expression[]{this.callService("aqlFeatureAccess", new Expression[]{this.varRef("self"), this.stringLiteral("eAllSuperTypes")})});
        callService.setType(CallType.COLLECTIONCALL);
        EvaluationResult result = this.evaluator.eval(varDefinitions, (Expression)callService);
        this.assertOKResultEquals(3, result);
    }

    @Test
    public void testLambda() {
        HashMap<String, Integer> varDefinitions = new HashMap<String, Integer>();
        varDefinitions.put("x", new Integer(1));
        Lambda lambda = this.lambda((Expression)this.varRef("x"), new VariableDeclaration[0]);
        EvaluationResult value = this.evaluator.eval(varDefinitions, (Expression)lambda);
        Assert.assertTrue((boolean)(value.getResult() instanceof LambdaValue));
        Assert.assertEquals((long)0L, (long)value.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)value.getDiagnostic().getChildren().isEmpty());
        Assert.assertEquals((Object)1, (Object)((LambdaValue)value.getResult()).eval(new Object[0]));
    }

    @Test
    public void testNullLiteral() {
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals(null, this.evaluator.eval(varDefinitions, (Expression)this.nullLiteral()));
    }

    @Test
    public void testSetInExtensionLiteral() {
        HashMap<String, EClass> varDefinitions = new HashMap<String, EClass>();
        varDefinitions.put("self", EcorePackage.Literals.ECLASS);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(this.varRef("self"));
        values.add(this.varRef("self"));
        values.add(this.booleanLiteral(true));
        values.add(this.booleanLiteral(false));
        EvaluationResult result = this.evaluator.eval(varDefinitions, (Expression)this.setInExtension(values));
        Assert.assertTrue((boolean)(result.getResult() instanceof Set));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        Set setResult = (Set)result.getResult();
        Assert.assertEquals((long)3L, (long)setResult.size());
        Iterator it = setResult.iterator();
        Assert.assertEquals((Object)EcorePackage.Literals.ECLASS, it.next());
        Assert.assertEquals((Object)Boolean.TRUE, it.next());
        Assert.assertEquals((Object)Boolean.FALSE, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSequenceInExtensionLiteral() {
        HashMap<String, EClass> varDefinitions = new HashMap<String, EClass>();
        varDefinitions.put("self", EcorePackage.Literals.ECLASS);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(this.varRef("self"));
        values.add(this.varRef("self"));
        values.add(this.booleanLiteral(true));
        values.add(this.booleanLiteral(false));
        EvaluationResult result = this.evaluator.eval(varDefinitions, (Expression)this.sequenceInExtension(values));
        Assert.assertTrue((boolean)(result.getResult() instanceof List));
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
        List listResult = (List)result.getResult();
        Assert.assertEquals((long)4L, (long)listResult.size());
        Iterator it = listResult.iterator();
        Assert.assertEquals((Object)EcorePackage.Literals.ECLASS, it.next());
        Assert.assertEquals((Object)EcorePackage.Literals.ECLASS, it.next());
        Assert.assertEquals((Object)Boolean.TRUE, it.next());
        Assert.assertEquals((Object)Boolean.FALSE, it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testConditionnalTrueBranch() {
        HashMap varDefinitions = new HashMap();
        Conditional conditional = this.conditional((Expression)this.booleanLiteral(true), (Expression)this.stringLiteral("trueBranch"), (Expression)this.stringLiteral("falseBranch"));
        this.assertOKResultEquals("trueBranch", this.evaluator.eval(varDefinitions, (Expression)conditional));
    }

    @Test
    public void testConditionnalFalseBranch() {
        HashMap varDefinitions = new HashMap();
        Conditional conditional = this.conditional((Expression)this.booleanLiteral(false), (Expression)this.stringLiteral("trueBranch"), (Expression)this.stringLiteral("falseBranch"));
        this.assertOKResultEquals("falseBranch", this.evaluator.eval(varDefinitions, (Expression)conditional));
    }

    @Test
    public void testConditionnalBadPredicate() {
        HashMap varDefinitions = new HashMap();
        Conditional conditional = this.conditional((Expression)this.stringLiteral("Hey, what's this?!"), (Expression)this.stringLiteral("trueBranch"), (Expression)this.stringLiteral("falseBranch"));
        EvaluationResult result = this.evaluator.eval(varDefinitions, (Expression)conditional);
        Assert.assertTrue((boolean)(result.getResult() instanceof Nothing));
        Assert.assertEquals((long)2L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)1L, (long)result.getDiagnostic().getChildren().size());
        String message = ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage();
        Assert.assertTrue((boolean)message.contains("Conditional"));
        Assert.assertTrue((boolean)message.contains("boolean"));
    }

    @Test
    public void testLetBasic() {
        Let let = this.let((Expression)this.callService("concat", new Expression[]{this.varRef("x"), this.varRef("y")}), new Binding[]{this.binding("x", null, (Expression)this.stringLiteral("prefix")), this.binding("y", null, (Expression)this.stringLiteral("suffix"))});
        HashMap varDefinitions = new HashMap();
        this.assertOKResultEquals("prefixsuffix", this.evaluator.eval(varDefinitions, (Expression)let));
    }

    @Test
    public void testLetArenotRecursive() {
        Let let = this.let((Expression)this.callService("concat", new Expression[]{this.varRef("x"), this.varRef("y")}), new Binding[]{this.binding("x", null, (Expression)this.stringLiteral("prefix")), this.binding("y", null, (Expression)this.callService("concat", new Expression[]{this.varRef("x"), this.stringLiteral("end")}))});
        HashMap<String, String> varDefinitions = new HashMap<String, String>();
        varDefinitions.put("x", "firstx");
        this.assertOKResultEquals("prefixfirstxend", this.evaluator.eval(varDefinitions, (Expression)let));
    }

    @Test
    public void testLetWithNothingBound() {
        Let let = this.let((Expression)this.callService("concat", new Expression[]{this.varRef("x"), this.varRef("y")}), new Binding[]{this.binding("x", null, (Expression)this.varRef("prefix")), this.binding("y", null, (Expression)this.stringLiteral("suffix"))});
        HashMap varDefinitions = new HashMap();
        EvaluationResult result = this.evaluator.eval(varDefinitions, (Expression)let);
        Assert.assertTrue((boolean)(result.getResult() instanceof Nothing));
        Assert.assertEquals((long)4L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)result.getDiagnostic().getChildren().size());
        String message1 = ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage();
        Assert.assertEquals((long)4L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(0)).getSeverity());
        Assert.assertTrue((boolean)message1.contains("Couldn't find the 'prefix' variable"));
        Assert.assertEquals((long)2L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(1)).getSeverity());
        String message2 = ((Diagnostic)result.getDiagnostic().getChildren().get(1)).getMessage();
        Assert.assertTrue((boolean)message2.contains("Couldn't find the 'concat"));
    }

    @Test
    public void testLetWithNothingBody() {
        Let let = this.let((Expression)this.callService("concat", new Expression[]{this.varRef("novar"), this.varRef("y")}), new Binding[]{this.binding("x", null, (Expression)this.stringLiteral("prefix")), this.binding("y", null, (Expression)this.stringLiteral("suffix"))});
        HashMap varDefinitions = new HashMap();
        EvaluationResult result = this.evaluator.eval(varDefinitions, (Expression)let);
        Assert.assertTrue((boolean)(result.getResult() instanceof Nothing));
        Assert.assertEquals((long)4L, (long)result.getDiagnostic().getSeverity());
        Assert.assertEquals((long)2L, (long)result.getDiagnostic().getChildren().size());
        Assert.assertEquals((long)4L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(0)).getSeverity());
        String message1 = ((Diagnostic)result.getDiagnostic().getChildren().get(0)).getMessage();
        Assert.assertTrue((boolean)message1.contains("Couldn't find the 'novar' variable"));
        Assert.assertEquals((long)2L, (long)((Diagnostic)result.getDiagnostic().getChildren().get(1)).getSeverity());
        String message2 = ((Diagnostic)result.getDiagnostic().getChildren().get(1)).getMessage();
        Assert.assertTrue((boolean)message2.contains("Couldn't find the 'concat"));
    }

    @Test
    public void testTypeSetLiteral() {
        ArrayList<TypeLiteral> types = new ArrayList<TypeLiteral>();
        types.add((TypeLiteral)this.typeLiteral(EcorePackage.eINSTANCE.getEClass()));
        types.add((TypeLiteral)this.typeLiteral(EcorePackage.eINSTANCE.getEPackage()));
        types.add((TypeLiteral)this.typeLiteral(EcorePackage.eINSTANCE.getEAttribute()));
        HashMap varDefinitions = new HashMap();
        EvaluationResult result = this.evaluator.eval(varDefinitions, (Expression)this.typeSetLiteral(types));
        Assert.assertTrue((boolean)(result.getResult() instanceof Set));
        Assert.assertEquals((long)3L, (long)((Set)result.getResult()).size());
        Iterator it = ((Set)result.getResult()).iterator();
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), it.next());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), it.next());
    }

    @Test
    public void testLetOverwriteVariable() {
        Let let = this.let((Expression)this.varRef("self"), new Binding[]{this.binding("self", null, (Expression)this.stringLiteral("selfOverritten"))});
        HashMap<String, String> varDefinitions = new HashMap<String, String>();
        varDefinitions.put("self", "self");
        this.assertOKResultEquals("selfOverritten", this.evaluator.eval(varDefinitions, (Expression)let));
    }

    @Test
    public void testLetOverwriteBinding() {
        Let let = this.let((Expression)this.varRef("a"), new Binding[]{this.binding("a", null, (Expression)this.stringLiteral("a")), this.binding("a", null, (Expression)this.stringLiteral("aOverritten"))});
        HashMap<String, String> varDefinitions = new HashMap<String, String>();
        varDefinitions.put("self", "self");
        this.assertOKResultEquals("aOverritten", this.evaluator.eval(varDefinitions, (Expression)let));
    }

    private void assertOKResultEquals(Object expected, EvaluationResult result) {
        Assert.assertEquals((Object)expected, (Object)result.getResult());
        Assert.assertEquals((long)0L, (long)result.getDiagnostic().getSeverity());
        Assert.assertTrue((boolean)result.getDiagnostic().getChildren().isEmpty());
    }
}

