/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.unit;

import junit.framework.TestCase;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.Comment;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.CstPackage;
import org.eclipse.acceleo.parser.cst.FileBlock;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.InitSection;
import org.eclipse.acceleo.parser.cst.LetBlock;
import org.eclipse.acceleo.parser.cst.Macro;
import org.eclipse.acceleo.parser.cst.ModelExpression;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.ModuleExtendsValue;
import org.eclipse.acceleo.parser.cst.ModuleImportsValue;
import org.eclipse.acceleo.parser.cst.OpenModeKind;
import org.eclipse.acceleo.parser.cst.ProtectedAreaBlock;
import org.eclipse.acceleo.parser.cst.Query;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TemplateExpression;
import org.eclipse.acceleo.parser.cst.TemplateOverridesValue;
import org.eclipse.acceleo.parser.cst.TextExpression;
import org.eclipse.acceleo.parser.cst.TraceBlock;
import org.eclipse.acceleo.parser.cst.TypedModel;
import org.eclipse.acceleo.parser.cst.Variable;
import org.eclipse.acceleo.parser.cst.VisibilityKind;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EClassifierImpl;

public class CstFactoryTest
extends TestCase {
    public void testCreateModule() {
        Module result = CstFactory.eINSTANCE.createModule();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Module));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.MODULE);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Module));
    }

    public void testCreateModuleExtendsValue() {
        ModuleExtendsValue result = CstFactory.eINSTANCE.createModuleExtendsValue();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ModuleExtendsValue));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.MODULE_EXTENDS_VALUE);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ModuleExtendsValue));
    }

    public void testCreateModuleImportsValue() {
        ModuleImportsValue result = CstFactory.eINSTANCE.createModuleImportsValue();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ModuleImportsValue));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.MODULE_IMPORTS_VALUE);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ModuleImportsValue));
    }

    public void testCreateTypedModel() {
        TypedModel result = CstFactory.eINSTANCE.createTypedModel();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TypedModel));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.TYPED_MODEL);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TypedModel));
    }

    public void testCreateComment() {
        Comment result = CstFactory.eINSTANCE.createComment();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Comment));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.COMMENT);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Comment));
    }

    public void testCreateTemplate() {
        Template result = CstFactory.eINSTANCE.createTemplate();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Template));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.TEMPLATE);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Template));
    }

    public void testCreateTemplateOverridesValue() {
        TemplateOverridesValue result = CstFactory.eINSTANCE.createTemplateOverridesValue();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TemplateOverridesValue));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.TEMPLATE_OVERRIDES_VALUE);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TemplateOverridesValue));
    }

    public void testCreateVariable() {
        Variable result = CstFactory.eINSTANCE.createVariable();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Variable));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.VARIABLE);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Variable));
    }

    public void testCreateTemplateExpression() {
        TemplateExpression result = CstFactory.eINSTANCE.createTemplateExpression();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TemplateExpression));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.TEMPLATE_EXPRESSION);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TemplateExpression));
    }

    public void testCreateModelExpression() {
        ModelExpression result = CstFactory.eINSTANCE.createModelExpression();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ModelExpression));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.MODEL_EXPRESSION);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ModelExpression));
    }

    public void testCreateTextExpression() {
        TextExpression result = CstFactory.eINSTANCE.createTextExpression();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TextExpression));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.TEXT_EXPRESSION);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TextExpression));
    }

    public void testCreateBlock() {
        Block result = CstFactory.eINSTANCE.createBlock();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Block));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.BLOCK);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Block));
    }

    public void testCreateInitSection() {
        InitSection result = CstFactory.eINSTANCE.createInitSection();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof InitSection));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.INIT_SECTION);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof InitSection));
    }

    public void testCreateProtectedAreaBlock() {
        ProtectedAreaBlock result = CstFactory.eINSTANCE.createProtectedAreaBlock();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ProtectedAreaBlock));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.PROTECTED_AREA_BLOCK);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ProtectedAreaBlock));
    }

    public void testCreateForBlock() {
        ForBlock result = CstFactory.eINSTANCE.createForBlock();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ForBlock));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.FOR_BLOCK);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof ForBlock));
    }

    public void testCreateIfBlock() {
        IfBlock result = CstFactory.eINSTANCE.createIfBlock();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof IfBlock));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.IF_BLOCK);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof IfBlock));
    }

    public void testCreateLetBlock() {
        LetBlock result = CstFactory.eINSTANCE.createLetBlock();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof LetBlock));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.LET_BLOCK);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof LetBlock));
    }

    public void testCreateFileBlock() {
        FileBlock result = CstFactory.eINSTANCE.createFileBlock();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof FileBlock));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.FILE_BLOCK);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof FileBlock));
    }

    public void testCreateTraceBlock() {
        TraceBlock result = CstFactory.eINSTANCE.createTraceBlock();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TraceBlock));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.TRACE_BLOCK);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof TraceBlock));
    }

    public void testCreateMacro() {
        Macro result = CstFactory.eINSTANCE.createMacro();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Macro));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.MACRO);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Macro));
    }

    public void testCreateQuery() {
        Query result = CstFactory.eINSTANCE.createQuery();
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Query));
        result = CstFactory.eINSTANCE.create(CstPackage.Literals.QUERY);
        CstFactoryTest.assertNotNull((Object)result);
        CstFactoryTest.assertTrue((boolean)(result instanceof Query));
    }

    public void testCreateUnknownEClass() {
        try {
            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
            ((EClassifierImpl)eClass).setClassifierID(-1);
            CstFactory.eINSTANCE.create(eClass);
            CstFactoryTest.fail((String)"Expected IllegalArgumentException hasn't been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConvertVisibilityKindToString() {
        for (VisibilityKind value : VisibilityKind.VALUES) {
            String result = CstFactory.eINSTANCE.convertToString((EDataType)CstPackage.Literals.VISIBILITY_KIND, (Object)value);
            CstFactoryTest.assertNotNull((Object)result);
            CstFactoryTest.assertEquals((Object)value.toString(), (Object)result);
        }
    }

    public void testConvertOpenModeKindToString() {
        for (OpenModeKind value : OpenModeKind.VALUES) {
            String result = CstFactory.eINSTANCE.convertToString((EDataType)CstPackage.Literals.OPEN_MODE_KIND, (Object)value);
            CstFactoryTest.assertNotNull((Object)result);
            CstFactoryTest.assertEquals((Object)value.toString(), (Object)result);
        }
    }

    public void testConvertUnknownEEnumToString() {
        try {
            EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
            ((EClassifierImpl)eEnum).setClassifierID(-1);
            CstFactory.eINSTANCE.convertToString((EDataType)eEnum, (Object)eEnum);
            CstFactoryTest.fail((String)"Expected IllegalArgumentException hasn't been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateVisibilityKindFromString() {
        for (VisibilityKind value : VisibilityKind.VALUES) {
            Object result = CstFactory.eINSTANCE.createFromString((EDataType)CstPackage.Literals.VISIBILITY_KIND, value.getLiteral());
            CstFactoryTest.assertNotNull((Object)result);
            CstFactoryTest.assertSame((Object)value, (Object)result);
            try {
                CstFactory.eINSTANCE.createFromString((EDataType)CstPackage.Literals.VISIBILITY_KIND, "ThisShouldntBeAKnownEEnumLiteral");
                CstFactoryTest.fail((String)"Expected IllegalArgumentException hasn't been thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void testCreateOpenModeKindFromString() {
        for (OpenModeKind value : OpenModeKind.VALUES) {
            Object result = CstFactory.eINSTANCE.createFromString((EDataType)CstPackage.Literals.OPEN_MODE_KIND, value.getLiteral());
            CstFactoryTest.assertNotNull((Object)result);
            CstFactoryTest.assertSame((Object)value, (Object)result);
            try {
                CstFactory.eINSTANCE.createFromString((EDataType)CstPackage.Literals.OPEN_MODE_KIND, "ThisShouldntBeAKnownEEnumLiteral");
                CstFactoryTest.fail((String)"Expected IllegalArgumentException hasn't been thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void testCreateUnknownEEnumFromString() {
        try {
            EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
            ((EClassifierImpl)eEnum).setClassifierID(-1);
            CstFactory.eINSTANCE.createFromString((EDataType)eEnum, "ThisShouldntBeAKnownEEnumLiteral");
            CstFactoryTest.fail((String)"Expected IllegalArgumentException hasn't been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

