/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.cst;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.eclipse.acceleo.parser.tests.cst.AbstractCSTParserTests;
import org.eclipse.core.runtime.Platform;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class CSTParserPerformanceTests
extends AbstractCSTParserTests {
    private static Bundle bundle;
    private StringBuffer result;
    private int numberOfTests = 100;
    private long parsingTime = 120L;

    @BeforeClass
    public static void setUp() throws Exception {
        bundle = Platform.getBundle((String)"org.eclipse.emf.eef.codegen");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        bundle = null;
    }

    @Test
    public void testEEFParsing() {
        this.result = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        this.result.append("###############################################\n");
        this.result.append("# CST Parsing test on EEF - " + dateFormat.format(date) + '\n');
        this.result.append("###############################################\n");
        Enumeration entries = bundle.findEntries("/", "*.mtl", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                Object element = entries.nextElement();
                if (!(element instanceof URL)) continue;
                URL url = (URL)element;
                try {
                    this.result.append("#File: " + url.getPath() + '\n');
                    InputStream stream = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                    String line = "";
                    StringBuffer sb = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    this.testParsingPerformance(sb);
                }
                catch (IOException e) {
                    Assert.fail();
                }
            }
            System.err.println(this.result.toString());
        } else {
            Assert.fail((String)"No entries found");
        }
    }

    private void testParsingPerformance(StringBuffer file) {
        long endTime = 0L;
        int i = 0;
        while (i < this.numberOfTests) {
            long beginTime = System.currentTimeMillis();
            this.checkCSTParsing(file, 0, 0, 0);
            endTime += System.currentTimeMillis() - beginTime;
            ++i;
        }
        this.result.append(String.valueOf(file.length()) + " " + (float)endTime / (float)this.numberOfTests + '\n');
        Assert.assertTrue((String)("The parsing is not fast enough: " + (float)endTime / (float)this.numberOfTests + "ms (it should be lower than " + this.parsingTime + "ms)"), ((float)endTime / (float)this.numberOfTests <= (float)this.parsingTime ? 1 : 0) != 0);
    }
}

