/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.cst;

import org.eclipse.acceleo.internal.parser.cst.CSTParser;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.tests.cst.AbstractCSTParserTests;
import org.junit.Test;

public class CSTParserModuleTests
extends AbstractCSTParserTests {
    @Test
    public void testParseModuleHeaderUML() {
        StringBuffer buffer = new StringBuffer("mymodule(http://www.eclipse.org/uml2/2.1.0/UML)");
        this.testParseModuleHeader(buffer, 0, 0, 0);
    }

    @Test
    public void testParseModuleHeaderUMLExtendsOneModule() {
        StringBuffer buffer = new StringBuffer("mymodule(http://www.eclipse.org/uml2/2.1.0/UML) extends mymodule1");
        this.testParseModuleHeader(buffer, 0, 1, 0);
    }

    @Test
    public void testParseModuleHeaderUMLExtendsTwoModules() {
        StringBuffer buffer = new StringBuffer("mymodule(http://www.eclipse.org/uml2/2.1.0/UML) extends mymodule1, mymodule2");
        this.testParseModuleHeader(buffer, 0, 2, 0);
    }

    @Test
    public void testParseModuleIsMissing() {
        StringBuffer buffer = new StringBuffer("[template name()][/template]");
        this.checkCSTInvalidParsing(buffer, 0, 0, 1);
    }

    @Test
    public void testParseModuleIsNotTerminated() {
        StringBuffer buffer = new StringBuffer("[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 0, 0, 0);
        buffer = new StringBuffer("[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)");
        this.checkCSTInvalidParsing(buffer, 0, 0, 1);
    }

    @Test
    public void testParseModuleTextBeforeHeader() {
        StringBuffer buffer = new StringBuffer("[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 0, 0, 0);
        buffer = new StringBuffer("blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 0, 1, 0);
        buffer = new StringBuffer("[comment @TODO do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 1, 1, 0);
        buffer = new StringBuffer("[comment encoding=UTF-8/]blablablablabla[comment @TODO do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 1, 2, 0);
        buffer = new StringBuffer("[** @TODO do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 1, 1, 0);
        buffer = new StringBuffer("[comment @FIXME do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 1, 1, 0);
        buffer = new StringBuffer("[** @FIXME do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 1, 1, 0);
        buffer = new StringBuffer("blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)");
        this.checkCSTInvalidParsing(buffer, 0, 0, 1);
        buffer = new StringBuffer("[comment @TODO do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)");
        this.checkCSTInvalidParsing(buffer, 0, 0, 1);
        buffer = new StringBuffer("[comment encoding=UTF-8/]blablablablabla[comment @TODO do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)");
        this.checkCSTInvalidParsing(buffer, 0, 0, 1);
        buffer = new StringBuffer("[** @TODO do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)");
        this.checkCSTInvalidParsing(buffer, 0, 0, 1);
        buffer = new StringBuffer("[comment @FIXME do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)");
        this.checkCSTInvalidParsing(buffer, 0, 0, 1);
        buffer = new StringBuffer("[** @FIXME do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)");
        this.checkCSTInvalidParsing(buffer, 0, 0, 1);
    }

    @Test
    public void testParseInvalidCommentBeforeModule() {
        StringBuffer buffer = new StringBuffer("[comment encoding=UTF-8]blablablablabla[comment @TODO do something later/]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 1, 1, 1);
    }

    @Test
    public void testParseInvalidDocumentationBlockBeforeModule() {
        StringBuffer buffer = new StringBuffer("[comment encoding=UTF-8/]blablablablabla[** @TODO do something later]blablablablabla[module library2text(http:///org/eclipse/emf/examples/library/extlibrary.ecore/1.0.0)/]");
        this.checkCSTParsing(buffer, 0, 0, 1);
    }

    private void testParseModuleHeader(StringBuffer buffer, int infos, int warnings, int problems) {
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(buffer);
        CSTParser parser = new CSTParser(source);
        Module eModule = CstFactory.eINSTANCE.createModule();
        parser.parseModuleHeader(0, buffer.length(), eModule);
        this.checkProblems(source, problems);
        this.checkWarnings(source, warnings);
        this.checkInfos(source, infos);
    }
}

