/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.cst;

import org.eclipse.acceleo.internal.parser.cst.CSTParser;
import org.eclipse.acceleo.internal.parser.cst.CSTParserBlock;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.cst.Block;
import org.eclipse.acceleo.parser.cst.CstFactory;
import org.eclipse.acceleo.parser.cst.FileBlock;
import org.eclipse.acceleo.parser.cst.ForBlock;
import org.eclipse.acceleo.parser.cst.IfBlock;
import org.eclipse.acceleo.parser.cst.LetBlock;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.acceleo.parser.cst.TraceBlock;
import org.junit.Assert;
import org.junit.Test;

public class CSTParserBlockTests {
    @Test
    public void testParseIf() {
        StringBuffer buffer = new StringBuffer("[if(true)] [/if]");
        this.testParseIf(buffer, 0);
    }

    @Test
    public void testParseIfElse() {
        StringBuffer buffer = new StringBuffer("[if(true)] [else] [/if]");
        this.testParseIf(buffer, 0);
    }

    @Test
    public void testParseIfElseIf() {
        StringBuffer buffer = new StringBuffer("[if(true)] [elseif(true)] [else] [/if]");
        this.testParseIf(buffer, 0);
    }

    @Test
    public void testParseIfWithOwnedIf() {
        StringBuffer buffer = new StringBuffer("[if(true)] [if(true)] [elseif(true)] [else] [/if] [/if]");
        this.testParseIf(buffer, 0);
    }

    @Test
    public void testParseIfBadSyntaxValidateQuotes() {
        StringBuffer buffer = new StringBuffer("[if(true)] \" [if(true)] \" [elseif(true)] [/if]");
        this.testParseIf(buffer, 1);
    }

    @Test
    public void testParseIfValidateQuotes() {
        StringBuffer buffer = new StringBuffer("[if(true)] \" [elseif(true)] [else] [/if]");
        this.testParseIf(buffer, 0);
    }

    private void testParseIf(StringBuffer buffer, int problemsCount) {
        StringBuffer moduleBuffer = new StringBuffer("mymodule(http://www.eclipse.org/uml2/2.1.0/UML)");
        AcceleoSourceBuffer moduleSource = new AcceleoSourceBuffer(moduleBuffer);
        CSTParser pAcceleomodule = new CSTParser(moduleSource);
        Module eModule = CstFactory.eINSTANCE.createModule();
        pAcceleomodule.parseModuleHeader(0, moduleBuffer.length(), eModule);
        Template eTemplate = CstFactory.eINSTANCE.createTemplate();
        eModule.getOwnedModuleElement().add((Object)eTemplate);
        IfBlock eIf = CstFactory.eINSTANCE.createIfBlock();
        eTemplate.getBody().add((Object)eIf);
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(buffer);
        CSTParser pAcceleo = new CSTParser(source);
        CSTParserBlock parser = new CSTParserBlock(pAcceleo);
        parser.parse(0, buffer.length(), (Block)eIf);
        if (source.getProblems().getList().size() != problemsCount) {
            Assert.fail((String)("You must have " + problemsCount + " syntax errors : " + source.getProblems().getMessage()));
        }
    }

    @Test
    public void testParseFor() {
        StringBuffer buffer = new StringBuffer("[for (c : Class | null)] [/for]");
        this.testParseFor(buffer, 0);
    }

    @Test
    public void testParseForWithOwnedFor() {
        StringBuffer buffer = new StringBuffer("[for (c : Class | null)] [for(a : Property | null)] [/for] [/for]");
        this.testParseFor(buffer, 0);
    }

    @Test
    public void testParseForWithBefore() {
        StringBuffer buffer = new StringBuffer("[for (c : Class | null) before (null)] [/for]");
        this.testParseFor(buffer, 0);
    }

    @Test
    public void testParseForWithBeforeSeparator() {
        StringBuffer buffer = new StringBuffer("[for (c : Class | null) before (null) separator (',')] [/for]");
        this.testParseFor(buffer, 0);
    }

    @Test
    public void testParseForWithBeforeAfter() {
        StringBuffer buffer = new StringBuffer("[for (c : Class | null) before (null)] after (null)] [/for]");
        this.testParseFor(buffer, 0);
    }

    @Test
    public void testParseForWithBeforeGuard() {
        StringBuffer buffer = new StringBuffer("[for (c : Class | null) before (null) ? (null)] [/for]");
        this.testParseFor(buffer, 0);
    }

    @Test
    public void testParseForWithBeforeGuardInitSection() {
        StringBuffer buffer = new StringBuffer("[for (c1 : Class | null) before (null) ? (null) {c2:Class;} ] [/for]");
        this.testParseFor(buffer, 0);
    }

    private void testParseFor(StringBuffer buffer, int problemsCount) {
        StringBuffer moduleBuffer = new StringBuffer("mymodule(http://www.eclipse.org/uml2/2.1.0/UML)");
        AcceleoSourceBuffer moduleSource = new AcceleoSourceBuffer(moduleBuffer);
        Module eModule = CstFactory.eINSTANCE.createModule();
        CSTParser pAcceleomodule = new CSTParser(moduleSource);
        pAcceleomodule.parseModuleHeader(0, moduleBuffer.length(), eModule);
        Template eTemplate = CstFactory.eINSTANCE.createTemplate();
        eModule.getOwnedModuleElement().add((Object)eTemplate);
        ForBlock eFor = CstFactory.eINSTANCE.createForBlock();
        eTemplate.getBody().add((Object)eFor);
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(buffer);
        CSTParser pAcceleo = new CSTParser(source);
        CSTParserBlock parser = new CSTParserBlock(pAcceleo);
        parser.parse(0, buffer.length(), (Block)eFor);
        if (source.getProblems().getList().size() != problemsCount) {
            Assert.fail((String)("You must have " + problemsCount + " syntax errors : " + source.getProblems().getMessage()));
        }
    }

    @Test
    public void testParseLetWithVariable() {
        StringBuffer buffer = new StringBuffer("[let c1 : Class = null] [/let]");
        this.testParseLet(buffer, 0);
    }

    @Test
    public void testParseLetWithoutVariable() {
        StringBuffer buffer = new StringBuffer("[let ] [/let]");
        this.testParseLet(buffer, 1);
    }

    @Test
    public void testParseLetElse() {
        StringBuffer buffer = new StringBuffer("[let c:Class = null] [else] [/let]");
        this.testParseLet(buffer, 0);
    }

    @Test
    public void testParseLetElseLet() {
        StringBuffer buffer = new StringBuffer("[let c1:Class = null] [elselet c2:Class = null] [else] [/let]");
        this.testParseLet(buffer, 0);
    }

    @Test
    public void testParseLetWithOwnedLet() {
        StringBuffer buffer = new StringBuffer("[let c1:Class = null] [let c2:Class = null] [elselet c3:Class = null] [else] [/let] [/let]");
        this.testParseLet(buffer, 0);
    }

    private void testParseLet(StringBuffer buffer, int problemsCount) {
        StringBuffer moduleBuffer = new StringBuffer("mymodule(http://www.eclipse.org/uml2/2.1.0/UML)");
        AcceleoSourceBuffer moduleSource = new AcceleoSourceBuffer(moduleBuffer);
        Module eModule = CstFactory.eINSTANCE.createModule();
        CSTParser pAcceleomodule = new CSTParser(moduleSource);
        pAcceleomodule.parseModuleHeader(0, moduleBuffer.length(), eModule);
        Template eTemplate = CstFactory.eINSTANCE.createTemplate();
        eModule.getOwnedModuleElement().add((Object)eTemplate);
        LetBlock eLet = CstFactory.eINSTANCE.createLetBlock();
        eTemplate.getBody().add((Object)eLet);
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(buffer);
        CSTParser pAcceleo = new CSTParser(source);
        CSTParserBlock parser = new CSTParserBlock(pAcceleo);
        parser.parse(0, buffer.length(), (Block)eLet);
        if (source.getProblems().getList().size() != problemsCount) {
            Assert.fail((String)("You must have " + problemsCount + " syntax errors : " + source.getProblems().getMessage()));
        }
    }

    @Test
    public void testParseTrace() {
        StringBuffer buffer = new StringBuffer("[trace ('')] [/trace]");
        this.testParseTrace(buffer, 0);
    }

    @Test
    public void testParseTraceWithOwnedTrace() {
        StringBuffer buffer = new StringBuffer("[trace ('1')] [trace ('2')] [/trace] [/trace]");
        this.testParseTrace(buffer, 0);
    }

    private void testParseTrace(StringBuffer buffer, int problemsCount) {
        StringBuffer moduleBuffer = new StringBuffer("mymodule(http://www.eclipse.org/uml2/2.1.0/UML)");
        AcceleoSourceBuffer moduleSource = new AcceleoSourceBuffer(moduleBuffer);
        Module eModule = CstFactory.eINSTANCE.createModule();
        CSTParser pAcceleomodule = new CSTParser(moduleSource);
        pAcceleomodule.parseModuleHeader(0, moduleBuffer.length(), eModule);
        Template eTemplate = CstFactory.eINSTANCE.createTemplate();
        eModule.getOwnedModuleElement().add((Object)eTemplate);
        TraceBlock eTrace = CstFactory.eINSTANCE.createTraceBlock();
        eTemplate.getBody().add((Object)eTrace);
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(buffer);
        CSTParser pAcceleo = new CSTParser(source);
        CSTParserBlock parser = new CSTParserBlock(pAcceleo);
        parser.parse(0, buffer.length(), (Block)eTrace);
        if (source.getProblems().getList().size() != problemsCount) {
            Assert.fail((String)("You must have " + problemsCount + " syntax errors : " + source.getProblems().getMessage()));
        }
    }

    @Test
    public void testParseFileWithOverwriteMode() {
        StringBuffer buffer = new StringBuffer("[file ('file.txt', false)] [/file]");
        this.testParseFile(buffer, 0);
    }

    @Test
    public void testParseFileWithAppendMode() {
        StringBuffer buffer = new StringBuffer("[file ('file.txt', true)] [/file]");
        this.testParseFile(buffer, 0);
    }

    @Test
    public void testParseFileWithBadOpenMode() {
        StringBuffer buffer = new StringBuffer("[file ('file.txt', badmode)] [/file]");
        this.testParseFile(buffer, 1);
    }

    @Test
    public void testParseFileWithOpenModeAndUniqueId() {
        StringBuffer buffer = new StringBuffer("[file ('file.txt', true, 'ID')] [/file]");
        this.testParseFile(buffer, 0);
    }

    @Test
    public void testParseFileWithOwnedFile() {
        StringBuffer buffer = new StringBuffer("[file ('file.txt', false)] [file ('file.txt', false)] [/file] [/file]");
        this.testParseFile(buffer, 0);
    }

    private void testParseFile(StringBuffer buffer, int problemsCount) {
        StringBuffer moduleBuffer = new StringBuffer("mymodule(http://www.eclipse.org/uml2/2.1.0/UML)");
        AcceleoSourceBuffer moduleSource = new AcceleoSourceBuffer(moduleBuffer);
        Module eModule = CstFactory.eINSTANCE.createModule();
        CSTParser pAcceleomodule = new CSTParser(moduleSource);
        pAcceleomodule.parseModuleHeader(0, moduleBuffer.length(), eModule);
        Template eTemplate = CstFactory.eINSTANCE.createTemplate();
        eModule.getOwnedModuleElement().add((Object)eTemplate);
        FileBlock eFile = CstFactory.eINSTANCE.createFileBlock();
        eTemplate.getBody().add((Object)eFile);
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(buffer);
        CSTParser pAcceleo = new CSTParser(source);
        CSTParserBlock parser = new CSTParserBlock(pAcceleo);
        parser.parse(0, buffer.length(), (Block)eFile);
        if (source.getProblems().getList().size() != problemsCount) {
            Assert.fail((String)("You must have " + problemsCount + " syntax errors : " + source.getProblems().getMessage()));
        }
    }
}

