/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.cst;

import java.io.File;
import org.eclipse.acceleo.internal.parser.cst.CSTParser;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.junit.Assert;

public abstract class AbstractCSTParserTests {
    protected void checkCSTParsing(StringBuffer buffer, int infoCount, int warningCount, int problemCount) {
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(buffer);
        this.checkCSTParsing(source, infoCount, warningCount, problemCount);
    }

    protected void checkCSTParsing(File file, int infoCount, int warningCount, int problemCount) {
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(file);
        this.checkCSTParsing(source, infoCount, warningCount, problemCount);
    }

    private void checkCSTParsing(AcceleoSourceBuffer source, int infoCount, int warningCount, int problemCount) {
        CSTParser parser = new CSTParser(source);
        Assert.assertNotNull((Object)parser.parse());
        this.checkProblems(source, problemCount);
        this.checkWarnings(source, warningCount);
        this.checkInfos(source, infoCount);
    }

    protected void checkCSTInvalidParsing(StringBuffer buffer, int infoCount, int warningCount, int problemCount) {
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(buffer);
        this.checkCSTInvalidParsing(source, infoCount, warningCount, problemCount);
    }

    protected void checkCSTInvalidParsing(File file, int infoCount, int warningCount, int problemCount) {
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(file);
        this.checkCSTInvalidParsing(source, infoCount, warningCount, problemCount);
    }

    private void checkCSTInvalidParsing(AcceleoSourceBuffer source, int infoCount, int warningCount, int problemCount) {
        CSTParser parser = new CSTParser(source);
        Assert.assertNull((Object)parser.parse());
        this.checkProblems(source, problemCount);
        this.checkWarnings(source, warningCount);
        this.checkInfos(source, infoCount);
    }

    protected void checkProblems(AcceleoSourceBuffer source, int problemsCount) {
        if (source.getProblems().getList().size() != problemsCount) {
            Assert.fail((String)("You must have " + problemsCount + " syntax errors : " + source.getProblems().getList().size()));
        }
    }

    protected void checkWarnings(AcceleoSourceBuffer source, int warningsCount) {
        if (source.getWarnings().getList().size() != warningsCount) {
            Assert.fail((String)("You must have " + warningsCount + " syntax warnings : " + source.getWarnings().getList().size()));
        }
    }

    protected void checkInfos(AcceleoSourceBuffer source, int infosCount) {
        if (source.getInfos().getList().size() != infosCount) {
            Assert.fail((String)("You must have " + infosCount + " syntax infos : " + source.getInfos().getList().size()));
        }
    }
}

