/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParserInfo;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserWarning;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public abstract class AbstractASTParserTests {
    protected static IProject project;
    protected static Bundle bundle;
    private static final String DEFAULT_EMTL_URI = "http://acceleo.eclipse.org/default.emtl";
    protected static final ResourceSet oResourceSet;
    private static final List<URI> resourceSetURIs;
    private AcceleoProject acceleoProject;
    private IFile mtlFile;
    protected AcceleoSourceBuffer sourceBuffer;

    static {
        oResourceSet = new ResourceSetImpl();
        resourceSetURIs = new ArrayList<URI>();
    }

    protected static IProject createAcceleoProject(String name) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject proj = root.getProject(name);
        try {
            proj.create((IProgressMonitor)monitor);
            proj.open((IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            Assert.fail((String)"Project creation error");
        }
        new AcceleoProject(proj);
        String eol = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer("Manifest-Version: 1.0" + eol + "Bundle-ManifestVersion: 2" + eol + "Bundle-Name: Acceleo Sample Module Runtime Plug-in" + eol + "Bundle-SymbolicName: " + proj.getName() + eol + "Bundle-Version: 1.0.0.qualifier" + eol + "Bundle-Vendor: Eclipse Modeling Project" + eol + "Require-Bundle: org.eclipse.core.runtime, " + eol + " org.eclipse.emf.ecore," + eol + " org.eclipse.emf.ecore," + eol + " org.eclipse.emf.ecore.xmi," + eol + " org.eclipse.ocl," + eol + " org.eclipse.ocl.ecore," + eol + " org.eclipse.acceleo.model," + eol + " org.eclipse.acceleo.engine" + eol + "Bundle-RequiredExecutionEnvironment: J2SE-1.5" + eol + "Bundle-ActivationPolicy: lazy" + eol + "Eclipse-LazyStart: true" + eol + "Export-Package: " + proj.getName() + ".files");
        AbstractASTParserTests.createFile(buffer.toString(), (IPath)new Path("/META-INF"), proj, "MANIFEST.MF");
        try {
            boolean hasNature = proj.hasNature("org.eclipse.acceleo.ide.ui.acceleoNature");
            if (!hasNature) {
                IProjectDescription description = proj.getDescription();
                String[] natureIds = description.getNatureIds();
                String[] newNaturesIds = new String[natureIds.length + 3];
                System.arraycopy(natureIds, 0, newNaturesIds, 0, natureIds.length);
                newNaturesIds[natureIds.length] = "org.eclipse.acceleo.ide.ui.acceleoNature";
                newNaturesIds[natureIds.length + 1] = "org.eclipse.pde.PluginNature";
                newNaturesIds[natureIds.length + 2] = "org.eclipse.jdt.core.javanature";
                description.setNatureIds(newNaturesIds);
                proj.setDescription(description, 1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Assert.fail();
        }
        buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + eol + "<classpath>" + eol + "<classpathentry kind=\"con\" path=\"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5\"/>" + eol + "<classpathentry kind=\"con\" path=\"org.eclipse.pde.core.requiredPlugins\"/>" + eol + "<classpathentry kind=\"src\" path=\"src\"/>" + eol + "<classpathentry kind=\"output\" path=\"bin\"/>" + eol + "</classpath>");
        AbstractASTParserTests.createFile(buffer.toString(), (IPath)new Path("/"), proj, ".classpath");
        buffer = new StringBuffer("eclipse.preferences.version=1" + eol + "org.eclipse.jdt.core.compiler.codegen.targetPlatform=1.5" + eol + "org.eclipse.jdt.core.compiler.compliance=1.5" + eol + "org.eclipse.jdt.core.compiler.problem.assertIdentifier=error" + eol + "org.eclipse.jdt.core.compiler.problem.enumIdentifier=error" + eol + "org.eclipse.jdt.core.compiler.source=1.5");
        AbstractASTParserTests.createFile(buffer.toString(), (IPath)new Path("/.settings"), proj, "org.eclipse.jdt.core.prefs");
        return proj;
    }

    protected static IFile createFile(String content, IPath path, IProject proj, String name) {
        String[] segments = path.segments();
        IProject currentContainer = proj;
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            IFolder folder = currentContainer.getFolder((IPath)new Path(string));
            if (!folder.exists()) {
                try {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Assert.fail((String)e.getMessage());
                    return null;
                }
            }
            currentContainer = folder;
            ++n2;
        }
        IFile file = currentContainer.getFile((IPath)new Path(name));
        if (!file.exists()) {
            try {
                ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes("UTF8"));
                file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (UnsupportedEncodingException e) {
                Assert.fail((String)e.getMessage());
                return null;
            }
            catch (CoreException e) {
                Assert.fail((String)e.getMessage());
                return null;
            }
        }
        return file;
    }

    protected void parseAndLoadModule(IFile file) {
        AcceleoFile acceleoFile = new AcceleoFile(file.getLocation().toFile(), AcceleoFile.relativePathToFullModuleName((String)file.getProjectRelativePath().toString()));
        AcceleoSourceBuffer aSourceBuffer = new AcceleoSourceBuffer(acceleoFile);
        aSourceBuffer.createCST();
        AcceleoProject anAcceleoProject = new AcceleoProject(file.getProject());
        IFile aMtlFile = file;
        URI fileURI = null;
        IPath outputPath = anAcceleoProject.getOutputFilePath(aMtlFile);
        fileURI = outputPath != null ? URI.createPlatformResourceURI((String)outputPath.toString(), (boolean)false) : URI.createPlatformResourceURI((String)aMtlFile.getFullPath().removeFileExtension().addFileExtension("emtl").toString(), (boolean)false);
        Resource resource = ModelUtils.createResource((URI)fileURI, (ResourceSet)oResourceSet);
        System.out.println(resource.getURI());
        resourceSetURIs.add(fileURI);
    }

    protected void checkCSTParsing(IFile file, int infosCount, int warningsCount, int problemsCount) {
        AcceleoFile acceleoFile = new AcceleoFile(file.getLocation().toFile(), AcceleoFile.relativePathToFullModuleName((String)file.getProjectRelativePath().toString()));
        this.sourceBuffer = new AcceleoSourceBuffer(acceleoFile);
        this.sourceBuffer.getProblems().clear();
        this.sourceBuffer.getWarnings().clear();
        this.sourceBuffer.getInfos().clear();
        this.sourceBuffer.createCST();
        this.checkInfos(this.sourceBuffer, infosCount);
        this.checkWarnings(this.sourceBuffer, warningsCount);
        this.checkProblems(this.sourceBuffer, problemsCount);
        this.acceleoProject = new AcceleoProject(file.getProject());
        this.mtlFile = file;
    }

    protected void checkCST2ASTConvertion(int infosCount, int warningsCount, int problemsCount) {
        if (this.sourceBuffer != null) {
            IPath outputPath;
            URI fileURI = this.mtlFile != null ? ((outputPath = this.acceleoProject.getOutputFilePath(this.mtlFile)) != null ? URI.createPlatformResourceURI((String)outputPath.toString(), (boolean)false) : URI.createPlatformResourceURI((String)this.mtlFile.getFullPath().removeFileExtension().addFileExtension("emtl").toString(), (boolean)false)) : URI.createURI((String)DEFAULT_EMTL_URI);
            Resource oResource = ModelUtils.createResource((URI)fileURI, (ResourceSet)oResourceSet);
            resourceSetURIs.add(fileURI);
            this.sourceBuffer.createAST(oResource);
            this.checkProblems(this.sourceBuffer, problemsCount);
            this.checkWarnings(this.sourceBuffer, warningsCount);
            this.checkInfos(this.sourceBuffer, infosCount);
        }
    }

    protected void checkASTResolution(int infosCount, int warningsCount, int problemsCount) {
        if (this.sourceBuffer != null) {
            this.sourceBuffer.resolveAST();
            this.checkProblems(this.sourceBuffer, problemsCount);
            this.checkWarnings(this.sourceBuffer, warningsCount);
            this.checkInfos(this.sourceBuffer, infosCount);
        } else {
            Assert.fail((String)"The source buffer is null");
        }
    }

    protected void checkASTDocumentationResolution(int infosCount, int warningsCount, int problemsCount) {
        if (this.sourceBuffer != null) {
            this.sourceBuffer.resolveASTDocumentation();
            this.checkProblems(this.sourceBuffer, problemsCount);
            this.checkWarnings(this.sourceBuffer, warningsCount);
            this.checkInfos(this.sourceBuffer, infosCount);
        } else {
            Assert.fail((String)"The source buffer is null");
        }
    }

    protected void checkProblems(AcceleoSourceBuffer source, int problemsCount) {
        if (source.getProblems().getList().size() != problemsCount) {
            StringBuffer message = new StringBuffer();
            List list = source.getProblems().getList();
            for (AcceleoParserProblem acceleoParserProblem : list) {
                message.append(String.valueOf(acceleoParserProblem.getMessage()) + '\n');
            }
            Assert.fail((String)("You must have " + problemsCount + " syntax errors : " + source.getProblems().getList().size() + " error : " + message.toString()));
        }
    }

    protected void checkWarnings(AcceleoSourceBuffer source, int warningsCount) {
        if (source.getWarnings().getList().size() != warningsCount) {
            StringBuffer message = new StringBuffer();
            List list = source.getWarnings().getList();
            for (AcceleoParserWarning acceleoParserWarning : list) {
                message.append(String.valueOf(acceleoParserWarning.getMessage()) + '\n');
            }
            Assert.fail((String)("You must have " + warningsCount + " syntax warnings : " + source.getWarnings().getList().size() + " warning : " + message.toString()));
        }
    }

    protected void checkInfos(AcceleoSourceBuffer source, int infosCount) {
        if (source.getInfos().getList().size() != infosCount) {
            StringBuffer message = new StringBuffer();
            List list = source.getInfos().getList();
            for (AcceleoParserInfo acceleoParserInfo : list) {
                message.append(String.valueOf(acceleoParserInfo.getMessage()) + '\n');
            }
            Assert.fail((String)("You must have " + infosCount + " syntax infos : " + source.getInfos().getList().size() + " info : " + message.toString()));
        }
    }

    protected String getContentFromPath(String pathName) {
        try {
            URL url = FileLocator.resolve((URL)bundle.getEntry(pathName));
            return this.readFileFromURL(url);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private String readFileFromURL(URL url) {
        String result = "";
        InputStream openStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            openStream = url.openStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (openStream != null) {
            StringBuilder stringBuilder;
            block42: {
                inputStreamReader = new InputStreamReader(openStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                stringBuilder = new StringBuilder();
                String line = null;
                try {
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                                try {
                                    openStream.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                                break block42;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                openStream.close();
                            }
                            catch (IOException e4) {
                                e4.printStackTrace();
                            }
                            throw throwable;
                        }
                        try {
                            openStream.close();
                        }
                        catch (IOException e5) {
                            e5.printStackTrace();
                        }
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    block44: {
                        try {
                            try {
                                inputStreamReader.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                try {
                                    openStream.close();
                                }
                                catch (IOException e6) {
                                    e6.printStackTrace();
                                }
                                break block44;
                            }
                        }
                        catch (Throwable throwable2) {
                            try {
                                openStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            throw throwable2;
                        }
                        try {
                            openStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            openStream.close();
                        }
                        catch (IOException e7) {
                            e7.printStackTrace();
                        }
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        openStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    openStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            result = stringBuilder.toString();
        }
        return result;
    }
}

