/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.model.mtl.Documentation;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.parser.tests.ast.AbstractASTParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ASTParserModuleTests
extends AbstractASTParserTests {
    @BeforeClass
    public static void setUp() {
        if (EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore") == null) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        }
        if (EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/GenModel") == null) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
        }
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
        project = ASTParserModuleTests.createAcceleoProject("org.eclipse.acceleo.parser.tests.module");
    }

    @AfterClass
    public static void tearDown() {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            bundle = null;
            EList resources = oResourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseModuleValid() {
        String content = this.getContentFromPath("/data/ast/module/moduleValid.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleValid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidHeader() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidHeader.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidHeader.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleDocumentation1() {
        String content = this.getContentFromPath("/data/ast/module/moduleDocumentation1.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleDocumentation1.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
            Module ast = this.sourceBuffer.getAST();
            Assert.assertNotNull((Object)ast);
            Documentation documentation = ast.getDocumentation();
            Assert.assertNotNull((Object)documentation);
            Assert.assertNotNull((Object)documentation.getBody());
            Assert.assertNotNull((Object)documentation.getBody().getValue());
            Assert.assertTrue((boolean)documentation.getBody().getValue().contains("this is my documentation"));
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleDocumentation2() {
        String content = this.getContentFromPath("/data/ast/module/moduleDocumentation2.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleDocumentation2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
            Module ast = this.sourceBuffer.getAST();
            Assert.assertNotNull((Object)ast);
            Documentation documentation = ast.getDocumentation();
            Assert.assertNotNull((Object)documentation);
            Assert.assertNotNull((Object)documentation.getBody());
            Assert.assertNotNull((Object)documentation.getBody().getValue());
            Assert.assertTrue((boolean)documentation.getBody().getValue().contains("this is my documentation"));
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleDocumentation3() {
        String content = this.getContentFromPath("/data/ast/module/moduleDocumentation3.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleDocumentation3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleDocumentationDeprecated() {
        String content = this.getContentFromPath("/data/ast/module/moduleDocumentationDeprecated.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleDocumentationDeprecated.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
            Module ast = this.sourceBuffer.getAST();
            Assert.assertNotNull((Object)ast);
            Assert.assertTrue((boolean)ast.isDeprecated());
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleExtendsOtherModule() {
        String content = this.getContentFromPath("/data/ast/module/moduleValid.mtl");
        IFile moduleValidIFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/module/moduleExtendsOtherModule.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleExtendsOtherModule.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleExtendsSelf() {
        String content = this.getContentFromPath("/data/ast/module/moduleExtendsSelf.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleExtendsSelf.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleExtendsInvalidModule() {
        String content = this.getContentFromPath("/data/ast/module/moduleExtendsInvalidModule.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleExtendsInvalidModule.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleMultipleExtends() {
        String content = this.getContentFromPath("/data/ast/module/moduleValid.mtl");
        IFile moduleValidIFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/module/moduleMultipleExtends.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleMultipleExtends.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 2, 0);
            this.checkCST2ASTConvertion(0, 3, 0);
            this.checkASTResolution(0, 3, 0);
            this.checkASTDocumentationResolution(0, 3, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleMultipleMetaModel() {
        String content = this.getContentFromPath("/data/ast/module/moduleMultipleMetaModel.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleMultipleMetaModel.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleMultipleSameMetaModel() {
        String content = this.getContentFromPath("/data/ast/module/moduleMultipleSameMetaModel.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleMultipleSameMetaModel.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidMetaModel() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidMetaModel.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidMetaModel.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleExtendsIncompatibleMetaModel() {
        String content = this.getContentFromPath("/data/ast/module/moduleValid.mtl");
        IFile moduleValidIFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/module/moduleExtendsIncompatibleMetaModel.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleExtendsIncompatibleMetaModel.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 2, 0);
            this.checkASTDocumentationResolution(0, 2, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleExtendsMultipleSameModule() {
        String content = this.getContentFromPath("/data/ast/module/moduleExtendsMultipleSameModule.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleExtendsMultipleSameModule.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 3, 0);
            this.checkCST2ASTConvertion(0, 4, 0);
            this.checkASTResolution(0, 4, 0);
            this.checkASTDocumentationResolution(0, 4, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleExtendsDeprecatedModule() {
        String content = this.getContentFromPath("/data/ast/module/moduleExtendsDeprecatedModule.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleExtendsDeprecatedModule.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 2, 0);
            this.checkASTDocumentationResolution(0, 2, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleNamedModule() {
        String content = this.getContentFromPath("/data/ast/module/module.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "module.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleNamedKeyword() {
        String content = this.getContentFromPath("/data/ast/module/protected.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "protected.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleImport() {
        String content = this.getContentFromPath("/data/ast/module/moduleValid.mtl");
        IFile moduleValidIFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/module/moduleImport.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleImport.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleMultipleImport() {
        String content = this.getContentFromPath("/data/ast/module/moduleValid.mtl");
        IFile moduleValidIFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/module/moduleMultipleImport.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleMultipleImport.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 3, 0);
            this.checkCST2ASTConvertion(0, 3, 0);
            this.checkASTResolution(0, 3, 0);
            this.checkASTDocumentationResolution(0, 3, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleDeprecatedImport() {
        String content = this.getContentFromPath("/data/ast/module/moduleDeprecatedImport.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleDeprecatedImport.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 2, 0);
            this.checkASTDocumentationResolution(0, 2, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidImport() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidImport.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidImport.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleDuplicatedImport() {
        String content = this.getContentFromPath("/data/ast/module/moduleDuplicatedImport.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleDuplicatedImport.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 3, 0);
            this.checkCST2ASTConvertion(0, 3, 0);
            this.checkASTResolution(0, 3, 0);
            this.checkASTDocumentationResolution(0, 3, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleImportSelf() {
        String content = this.getContentFromPath("/data/ast/module/moduleImportSelf.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleImportSelf.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleQualifiedNameExtends() {
        String content = this.getContentFromPath("/data/ast/module/moduleQualifiedNameExtends.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleQualifiedNameExtends.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleQualifiedNameImports() {
        String content = this.getContentFromPath("/data/ast/module/moduleQualifiedNameImports.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleQualifiedNameImports.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleMissingMetaModel() {
        String content = this.getContentFromPath("/data/ast/module/moduleMissingMetaModel.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleMissingMetaModel.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleEmptyMetaModel() {
        String content = this.getContentFromPath("/data/ast/module/moduleEmptyMetaModel.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleEmptyMetaModel.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleMissingParenthesis() {
        String content = this.getContentFromPath("/data/ast/module/moduleMissingParenthesis.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleMissingParenthesis.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidFile() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidFile.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidFile.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidFile2() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidFile2.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidFile2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 2);
            this.checkCST2ASTConvertion(0, 0, 2);
            this.checkASTResolution(0, 0, 2);
            this.checkASTDocumentationResolution(0, 0, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidDefinition() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidDefinition.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidDefinition.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidForm() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidForm.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidForm.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidImportForm() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidImportForm.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidImportForm.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidDocumentation() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidDocumentation.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidDocumentation.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidDocumentation2() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidDocumentation2.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidDocumentation2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleAlternateComment() {
        String content = this.getContentFromPath("/data/ast/module/moduleAlternateComment.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleAlternateComment.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleWithoutEncoding() {
        String content = this.getContentFromPath("/data/ast/module/moduleWithoutEncoding.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleWithoutEncoding.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleWithoutEncodingDocumentation() {
        String content = this.getContentFromPath("/data/ast/module/moduleWithoutEncodingDocumentation.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleWithoutEncodingDocumentation.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidComment() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidComment.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidComment.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidComment2() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidComment2.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidComment2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidComment3() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidComment3.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidComment3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidComment4() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidComment4.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidComment4.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidAlternateComment() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidAlternateComment.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidAlternateComment.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidModel() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidModel.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidModel.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseModuleInvalidModuleElement() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidModuleElement.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidModuleElement.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseModuleInvalidExtends() {
        String content = this.getContentFromPath("/data/ast/module/moduleInvalidExtends.mtl");
        IFile moduleFile = ASTParserModuleTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/module/files"), project, "moduleInvalidextends.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }
}

