/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.parser.tests.ast.AbstractASTParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ASTOperationTests
extends AbstractASTParserTests {
    @BeforeClass
    public static void setUp() {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
        project = ASTOperationTests.createAcceleoProject("org.eclipse.acceleo.parser.tests.operations");
    }

    @AfterClass
    public static void tearDown() {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            bundle = null;
            EList resources = oResourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseAcceleoStandardOperation() {
        String content = this.getContentFromPath("/data/ast/operations/acceleoStandardOperation.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "acceleoStandardOperation.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseAcceleoNonStandardOperation() {
        String content = this.getContentFromPath("/data/ast/operations/acceleoNonStandardOperation.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "acceleoNonStandardOperation.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(1, 1, 0);
            this.checkASTDocumentationResolution(1, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseAcceleoOperationReturnType() {
        String content = this.getContentFromPath("/data/ast/operations/acceleoOperationReturnType.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "acceleoOperationReturnType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseOCLStandardOperation() {
        String content = this.getContentFromPath("/data/ast/operations/oclStandardOperation.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "oclStandardOperation.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseOCLComparison() {
        String content = this.getContentFromPath("/data/ast/operations/oclComparison.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "oclComparison.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 4, 0);
            this.checkASTDocumentationResolution(0, 4, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryCallResolution() {
        String content = this.getContentFromPath("/data/ast/operations/queryCallResolution.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "queryCallResolution.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseQueryCallQualifiedNameResolution() {
        String content = this.getContentFromPath("/data/ast/operations/queryCallQualifiedNameResolution.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "queryCallQualifiedNameResolution.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateCallResolution() {
        String content = this.getContentFromPath("/data/ast/operations/templateCallResolution.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "templateCallResolution.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateCallQualifiedNameResolution() {
        String content = this.getContentFromPath("/data/ast/operations/templateCallQualifiedNameResolution.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "templateCallQualifiedNameResolution.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseRecursiveQuery() {
        String content = this.getContentFromPath("/data/ast/operations/recursiveQuery.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "recursiveQuery.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseAcceleoEscapeCharacter() {
        String content = this.getContentFromPath("/data/ast/operations/acceleoEscapeCharacter.mtl");
        IFile moduleFile = ASTOperationTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/operations/files"), project, "acceleoEscapeCharacter.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }
}

