/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.parser.tests.ast.AbstractASTParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ASTContextLetTests
extends AbstractASTParserTests {
    @BeforeClass
    public static void setUp() {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
        project = ASTContextLetTests.createAcceleoProject("org.eclipse.acceleo.parser.tests.context.let");
    }

    @AfterClass
    public static void tearDown() {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            bundle = null;
            EList resources = oResourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParserScopeLetValid() {
        String content = this.getContentFromPath("/data/ast/context/letContextValid.mtl");
        IFile moduleFile = ASTContextLetTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/let/files"), project, "letContextValid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserScopeLetValid2() {
        String content = this.getContentFromPath("/data/ast/context/letContextValid2.mtl");
        IFile moduleFile = ASTContextLetTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/let/files"), project, "letContextValid2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextLetInvalid() {
        String content = this.getContentFromPath("/data/ast/context/letContextInvalid.mtl");
        IFile moduleFile = ASTContextLetTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/let/files"), project, "letContextInvalid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserContextLetInvalid2() {
        String content = this.getContentFromPath("/data/ast/context/letContextInvalid2.mtl");
        IFile moduleFile = ASTContextLetTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/context/let/files"), project, "letContextInvalid2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }
}

