/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.internal.utils.compatibility.AcceleoCompatibilityEclipseHelper;
import org.eclipse.acceleo.common.internal.utils.compatibility.OCLVersion;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class AcceleoParserTests {
    private static Bundle bundle;

    @BeforeClass
    public static void setUp() throws Exception {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        bundle = null;
    }

    private File createFile(String pathName) {
        try {
            String fileLocation = FileLocator.resolve((URL)bundle.getEntry(pathName)).getPath();
            return new File(fileLocation);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NullPointerException e) {
            Assert.fail((String)e.getMessage());
        }
        return null;
    }

    private URI createFileURI(String pathName) {
        try {
            String fileLocation = FileLocator.resolve((URL)bundle.getEntry(pathName)).getPath();
            if (fileLocation.startsWith("file:")) {
                fileLocation = fileLocation.substring("file:".length());
            }
            return URI.createFileURI((String)fileLocation);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    @Test
    @Ignore
    public void testCompileSourceBufferEcoreAcceleoWithImport() {
        File file = this.createFile("/data/template/mtlParserEcore.mtl");
        if (file == null) {
            return;
        }
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(file);
        AcceleoParser parser = new AcceleoParser();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = ModelUtils.createResource((URI)URI.createURI((String)"http://acceleo.eclipse.org/default.emtl"), (ResourceSet)resourceSet);
        ArrayList<URI> dependencies = new ArrayList<URI>();
        dependencies.add(this.createFileURI("/data/template/mtlParserEcoreCommon.emtl"));
        parser.parse(source, resource, dependencies);
        Assert.assertNotNull((Object)source.getAST());
        if (source.getProblems().getList().size() > 0 && AcceleoCompatibilityEclipseHelper.getCurrentOCLVersion() != OCLVersion.GANYMEDE) {
            Assert.fail((String)source.getProblems().getMessage());
        }
    }

    public void testCompileRecursiveModuleExtend() {
        ArrayList<File> files = new ArrayList<File>();
        files.add(this.createFile("/data/template/RecursiveModule1.mtl"));
        files.add(this.createFile("/data/template/RecursiveModule2.mtl"));
        File problemFile = this.createFile("/data/template/RecursiveModule3.mtl");
        files.add(problemFile);
        ArrayList<URI> resources = new ArrayList<URI>();
        resources.add(this.createFileURI("/data/template/RecursiveModule1.emtl"));
        resources.add(this.createFileURI("/data/template/RecursiveModule2.emtl"));
        resources.add(this.createFileURI("/data/template/RecursiveModule3.emtl"));
        AcceleoParser parser = new AcceleoParser();
        ArrayList dependencies = new ArrayList();
        ArrayList<AcceleoFile> acceleoFiles = new ArrayList<AcceleoFile>();
        for (File inputFile : files) {
            acceleoFiles.add(new AcceleoFile(inputFile, AcceleoFile.simpleModuleName((File)inputFile)));
        }
        parser.parse(acceleoFiles, resources, dependencies, null, (Monitor)new BasicMonitor());
        for (File file : files) {
            List problems = parser.getProblems(file).getList();
            if (file != problemFile) {
                Assert.assertEquals((long)0L, (long)problems.size());
                continue;
            }
            Assert.assertEquals((long)1L, (long)problems.size());
        }
    }

    @Test
    @Ignore
    public void testCompileSourceBufferLibrary2textAcceleo() {
        File file = this.createFile("/data/template/mtlParserLibrary2text.mtl");
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(file);
        AcceleoParser parser = new AcceleoParser();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = ModelUtils.createResource((URI)URI.createURI((String)"http://acceleo.eclipse.org/default.emtl"), (ResourceSet)resourceSet);
        parser.parse(source, resource, new ArrayList());
        Assert.assertNotNull((Object)source.getAST());
        if (source.getProblems().getList().size() > 0) {
            Assert.fail((String)source.getProblems().getMessage());
        }
    }

    @Test
    @Ignore
    public void testCompileFileLibrary2textAcceleo() {
        File iFile = this.createFile("/data/template/mtlParserLibrary2text.mtl");
        URI oURI = this.createFileURI("/data/template/mtlParserLibrary2text.emtl");
        this.testCompileFile(iFile, oURI, 0);
    }

    @Test
    @Ignore
    public void testCompileFileLibrary2textAcceleoWithBadOutputURI() {
        File iFile = this.createFile("/data/template/mtlParserLibrary2text.mtl");
        URI oURI = URI.createURI((String)"http://acceleo.eclipse.org");
        this.testCompileFile(iFile, oURI, 1);
    }

    private void testCompileFile(File iFile, URI oURI, int problemsCount) {
        ArrayList<File> iFiles = new ArrayList<File>();
        iFiles.add(iFile);
        AcceleoParser parser = new AcceleoParser();
        ArrayList<URI> oURIs = new ArrayList<URI>();
        oURIs.add(oURI);
        Assert.assertNull((Object)parser.getProblems(iFile));
        ArrayList<AcceleoFile> acceleoFiles = new ArrayList<AcceleoFile>();
        for (File inputFile : iFiles) {
            acceleoFiles.add(new AcceleoFile(inputFile, AcceleoFile.simpleModuleName((File)inputFile)));
        }
        parser.parse(acceleoFiles, oURIs, new ArrayList(), null, (Monitor)new BasicMonitor());
        if (parser.getProblems(iFile).getList().size() != problemsCount) {
            Assert.fail((String)("You must have " + problemsCount + " syntax errors : " + parser.getProblems(iFile).getMessage()));
        }
        if (problemsCount == 0) {
            Assert.assertEquals((Object)parser.getProblems(iFile).getMessage(), (Object)"");
            Assert.assertEquals((Object)parser.getProblems(iFile).toString(), (Object)"");
        } else {
            Assert.assertTrue((parser.getProblems(iFile).getMessage() != null ? 1 : 0) != 0);
            for (AcceleoParserProblem parserProblem : parser.getProblems(iFile).getList()) {
                Assert.assertTrue((parserProblem.getMessage() != null ? 1 : 0) != 0);
                Assert.assertTrue((parserProblem.getLine() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((parserProblem.getPosBegin() > -1 ? 1 : 0) != 0);
                Assert.assertTrue((parserProblem.getPosEnd() > -1 ? 1 : 0) != 0);
                Assert.assertTrue((parserProblem.toString().length() > 0 ? 1 : 0) != 0);
            }
        }
        parser.getProblems(iFile).clear();
    }

    @Test
    @Ignore
    public void testIndentStrategy() {
        File file = this.createFile("/data/template/mtlIndentStrategy.mtl");
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(file);
        AcceleoParser parser = new AcceleoParser();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = ModelUtils.createResource((URI)URI.createURI((String)"http://acceleo.eclipse.org/default.emtl"), (ResourceSet)resourceSet);
        ArrayList dependencies = new ArrayList();
        parser.parse(source, resource, dependencies);
        Assert.assertNotNull((Object)source.getAST());
        if (source.getProblems().getList().size() > 0) {
            Assert.fail((String)source.getProblems().getMessage());
        }
        String[] results = new String[]{"\n", "\n", "\t\t", "\n", "\t\t", "\n", "\n", "\t", "\n", "\t\t", "\n", "\t\t\t", "\n", "\t\t\t", "\n", "\n", "\n\t\t", "\n", "\n"};
        int i = -1;
        StringBuffer report = new StringBuffer();
        TreeIterator it = ((EObject)resource.getContents().get(0)).eAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof StringLiteralExp) || eObject.eContainer() != null && eObject.eContainer().eContainingFeature() == MtlPackage.eINSTANCE.getIfBlock_IfExpr()) continue;
            StringLiteralExp literal = (StringLiteralExp)eObject;
            String symbol = literal.getStringSymbol().replaceAll("\r", "");
            if (++i < results.length && results[i].equals(symbol)) continue;
            int line = FileContent.lineNumber((StringBuffer)source.getBuffer(), (int)literal.getStartPosition());
            report.append("New value at line " + line + " [" + i + "] = '" + symbol + "'\n");
        }
        if (report.length() > 0) {
            System.out.print(report);
            Assert.fail((String)report.toString());
        }
    }
}

