/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.cst.utils;

import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.internal.parser.cst.utils.SequenceBlock;
import org.junit.Assert;
import org.junit.Test;

public class SequenceTests {
    @Test
    public void testSequence() {
        StringBuffer buffer = new StringBuffer("g.abcde");
        Assert.assertEquals((long)new Sequence("a").search(buffer).b(), (long)2L);
        Assert.assertEquals((long)new Sequence("abcde").search(buffer).b(), (long)2L);
        Assert.assertEquals((long)new Sequence("f").search(buffer).b(), (long)-1L);
        Sequence seq = new Sequence("g");
        Assert.assertEquals((Object)seq.search(buffer), (Object)new Region(0, 1, seq));
        Assert.assertEquals((Object)seq.search(buffer).toString(), (Object)"[0,1]");
        seq = new Sequence("f");
        Assert.assertEquals((Object)seq.search(buffer), (Object)Region.NOT_FOUND);
    }

    @Test
    public void testSequenceBlock() {
        StringBuffer buffer = new StringBuffer("a((h)g)h");
        SequenceBlock parenthesis = new SequenceBlock(new Sequence("("), new Sequence(")"), null, true, null);
        Assert.assertEquals((long)new Sequence("g").search(buffer, 0, buffer.length(), null, new SequenceBlock[]{parenthesis}).b(), (long)-1L);
        Assert.assertEquals((long)new Sequence("h").search(buffer, 0, buffer.length(), null, new SequenceBlock[]{parenthesis}).b(), (long)7L);
    }
}

