/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.cst.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import junit.framework.AssertionFailedError;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class FileContentTests {
    private static Bundle bundle;

    @BeforeClass
    public static void setUp() throws Exception {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        bundle = null;
    }

    @Test
    public void testLineNumber() {
        StringBuffer buffer = new StringBuffer("1\n2\n3\n4\n5");
        Assert.assertEquals((long)FileContent.lineNumber((StringBuffer)buffer, (int)0), (long)1L);
        Assert.assertEquals((long)FileContent.lineNumber((StringBuffer)buffer, (int)1), (long)1L);
        Assert.assertEquals((long)FileContent.lineNumber((StringBuffer)buffer, (int)2), (long)2L);
        Assert.assertEquals((long)FileContent.lineNumber((StringBuffer)buffer, (int)3), (long)2L);
        Assert.assertEquals((long)FileContent.lineNumber((StringBuffer)buffer, (int)4), (long)3L);
        Assert.assertEquals((long)FileContent.lineNumber((StringBuffer)buffer, (int)5), (long)3L);
        Assert.assertEquals((long)FileContent.lineNumber((StringBuffer)buffer, (int)6), (long)4L);
    }

    @Test
    public void testColumnNumber() {
        StringBuffer buffer = new StringBuffer("1\n2\n3\n4\n5");
        Assert.assertEquals((long)FileContent.columnNumber((StringBuffer)buffer, (int)0), (long)1L);
        Assert.assertEquals((long)FileContent.columnNumber((StringBuffer)buffer, (int)1), (long)2L);
        Assert.assertEquals((long)FileContent.columnNumber((StringBuffer)buffer, (int)2), (long)1L);
        Assert.assertEquals((long)FileContent.columnNumber((StringBuffer)buffer, (int)3), (long)2L);
        Assert.assertEquals((long)FileContent.columnNumber((StringBuffer)buffer, (int)4), (long)1L);
        Assert.assertEquals((long)FileContent.columnNumber((StringBuffer)buffer, (int)5), (long)2L);
        Assert.assertEquals((long)FileContent.columnNumber((StringBuffer)buffer, (int)6), (long)1L);
    }

    @Test
    @Ignore
    public void testencodingISO() {
        StringBuffer bufferISO = FileContent.getFileContent((File)this.createFile("data/template/FileContentEncodingISO_8859_1.mtl"));
        try {
            String refISO = new String("[comment encoding=ISO-8859-1 /]\n\n[module FileContentEncoding(http://www.eclipse.org/emf/2002/Ecore) /]\n\n[comment]\n\t\u00eatre, o\u00f9, ha\u00efr, \u00e9t\u00e9\n[/comment]\n".getBytes("UTF-8"), "UTF-8");
            Assert.assertEquals((Object)refISO, (Object)bufferISO.toString());
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testencodingUTF() {
        StringBuffer bufferUTF = FileContent.getFileContent((File)this.createFile("data/template/FileContentEncodingUTF_8.mtl"));
        try {
            String refUTF = new String("[comment encoding=UTF-8 /]\n\n[module FileContentEncodingUTF_8(http://www.eclipse.org/emf/2002/Ecore) /]\n\n[comment]\n\t\u0434\u043e\u0431\u044a\u0440 \u0434\u0435\u043d\n[/comment]\n".getBytes("UTF-8"), "UTF-8");
            Assert.assertEquals((Object)refUTF, (Object)bufferUTF.toString());
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private File createFile(String pathName) {
        try {
            String fileLocation = FileLocator.resolve((URL)bundle.getEntry(pathName)).getPath();
            return new File(fileLocation);
        }
        catch (IOException e) {
            throw new AssertionFailedError(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new AssertionFailedError(e.getMessage());
        }
    }
}

