/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoTypeResolver;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.junit.Test;

public class AcceleoTypeResolverTests {
    @Test
    public void testShadowedClassifierNull() {
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual(null, (EClassifier)type);
    }

    @Test
    public void testTypeClassifierNull() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.getEClassifiers().add((Object)eClassifier);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, null);
    }

    @Test
    public void testShadowedClassifierAndTypeClassifierNull() {
        AcceleoTypeResolver.classifierEqual(null, null);
    }

    @Test
    public void testShadowedClassifierEmptyContainer() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testTypeClassifierEmptyContainer() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testShadowedClassifierAndTypeClassifierEmptyContainer() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        container.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testShadowedClassifierContainerNullName() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.getEClassifiers().add((Object)eClassifier);
        EPackage container2 = EcoreFactory.eINSTANCE.createEPackage();
        container2.setName("container2");
        container2.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testTypeClassifierContainerNullName() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        EPackage container2 = EcoreFactory.eINSTANCE.createEPackage();
        container2.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testShadowedClassifierAndTypeClassifierContainerNullName() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.getEClassifiers().add((Object)eClassifier);
        EPackage container2 = EcoreFactory.eINSTANCE.createEPackage();
        container2.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testShadowedClassifierContainerInvalidURI() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier\ufffd&)\ufffd\"&)\ufffd\"\ufffd&)_'");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        container.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testTypeClassifierContainerInvalidURI() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type\"\ufffd_'\ufffd\ufffd\ufffd\ufffd\ufffd(\ufffd\ufffd()");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        container.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testShadowedClassifierAndTypeClassifierContainerInvalidURI() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("eClassifier\ufffd&)\ufffd\"&)\ufffd\"\ufffd&)_'");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type\"\ufffd_'\ufffd\ufffd\ufffd\ufffd\ufffd(\ufffd\ufffd()");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        container.getEClassifiers().add((Object)type);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testShadowedClassifierAndTypeDifferentAttributeNumbers() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("type");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        container.getEClassifiers().add((Object)type);
        EAttribute attribute0 = EcoreFactory.eINSTANCE.createEAttribute();
        EAttribute attribute1 = EcoreFactory.eINSTANCE.createEAttribute();
        EAttribute attribute2 = EcoreFactory.eINSTANCE.createEAttribute();
        eClassifier.getEStructuralFeatures().add((Object)attribute0);
        eClassifier.getEStructuralFeatures().add((Object)attribute1);
        type.getEStructuralFeatures().add((Object)attribute2);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testShadowedClassifierAndTypeDifferentAttributesNoName() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("type");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        container.getEClassifiers().add((Object)type);
        EAttribute attribute0 = EcoreFactory.eINSTANCE.createEAttribute();
        EAttribute attribute1 = EcoreFactory.eINSTANCE.createEAttribute();
        EAttribute attribute2 = EcoreFactory.eINSTANCE.createEAttribute();
        EAttribute attribute3 = EcoreFactory.eINSTANCE.createEAttribute();
        eClassifier.getEStructuralFeatures().add((Object)attribute0);
        eClassifier.getEStructuralFeatures().add((Object)attribute1);
        type.getEStructuralFeatures().add((Object)attribute2);
        type.getEStructuralFeatures().add((Object)attribute3);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }

    @Test
    public void testShadowedClassifierAndTypeDifferentAttributeBounds() {
        EClass eClassifier = EcoreFactory.eINSTANCE.createEClass();
        eClassifier.setName("type");
        EClass type = EcoreFactory.eINSTANCE.createEClass();
        type.setName("type");
        EPackage container = EcoreFactory.eINSTANCE.createEPackage();
        container.setName("container");
        container.getEClassifiers().add((Object)eClassifier);
        container.getEClassifiers().add((Object)type);
        EAttribute attribute0 = EcoreFactory.eINSTANCE.createEAttribute();
        attribute0.setName("a");
        attribute0.setLowerBound(1);
        attribute0.setUpperBound(1);
        EAttribute attribute1 = EcoreFactory.eINSTANCE.createEAttribute();
        attribute1.setName("a");
        attribute1.setLowerBound(1);
        attribute1.setUpperBound(1);
        EAttribute attribute2 = EcoreFactory.eINSTANCE.createEAttribute();
        attribute2.setName("a");
        attribute2.setLowerBound(1);
        attribute2.setUpperBound(1);
        EAttribute attribute3 = EcoreFactory.eINSTANCE.createEAttribute();
        attribute3.setName("a");
        attribute3.setLowerBound(1);
        attribute3.setUpperBound(0);
        eClassifier.getEStructuralFeatures().add((Object)attribute0);
        eClassifier.getEStructuralFeatures().add((Object)attribute1);
        type.getEStructuralFeatures().add((Object)attribute2);
        type.getEStructuralFeatures().add((Object)attribute3);
        AcceleoTypeResolver.classifierEqual((EClassifier)eClassifier, (EClassifier)type);
    }
}

