/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.parser.tests.ast.AbstractASTParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ASTScopeQueryTests
extends AbstractASTParserTests {
    @BeforeClass
    public static void setUp() {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
        project = ASTScopeQueryTests.createAcceleoProject("org.eclipse.acceleo.parser.tests.scope.query");
    }

    @AfterClass
    public static void tearDown() {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            bundle = null;
            EList resources = oResourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParserScopeQueryValid() {
        String content = this.getContentFromPath("/data/ast/scope/queryScopeValid.mtl");
        IFile moduleFile = ASTScopeQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/scope/query/files"), project, "queryScopeValid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserScopeQueryValid2() {
        String content = this.getContentFromPath("/data/ast/scope/queryScopeValid2.mtl");
        IFile moduleFile = ASTScopeQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/scope/query/files"), project, "queryScopeValid2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserScopeQueryValid3() {
        String content = this.getContentFromPath("/data/ast/scope/queryScopeValid3.mtl");
        IFile moduleFile = ASTScopeQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/scope/query/files"), project, "queryScopeValid3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParserScopeQueryInvalid() {
        String content = this.getContentFromPath("/data/ast/scope/queryScopeInvalid.mtl");
        IFile moduleFile = ASTScopeQueryTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/scope/query/files"), project, "queryScopeInvalid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }
}

