/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.tests.ast;

import org.eclipse.acceleo.parser.tests.ast.AbstractASTParserTests;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ASTParserTemplateTests
extends AbstractASTParserTests {
    @BeforeClass
    public static void setUp() {
        bundle = Platform.getBundle((String)"org.eclipse.acceleo.parser.tests");
        project = ASTParserTemplateTests.createAcceleoProject("org.eclipse.acceleo.parser.tests.template");
    }

    @AfterClass
    public static void tearDown() {
        try {
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            bundle = null;
            EList resources = oResourceSet.getResources();
            for (Resource resource : resources) {
                resource.unload();
            }
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testParseTemplateValid() {
        String content = this.getContentFromPath("/data/ast/template/templateValid.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateValid.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateDocumentation() {
        String content = this.getContentFromPath("/data/ast/template/templateDocumentation.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateDocumentation.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateOverride() {
        String content = this.getContentFromPath("/data/ast/template/templateOverride.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateOverride.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(1, 1, 0);
            this.checkASTResolution(1, 1, 0);
            this.checkASTDocumentationResolution(1, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateOverrideQualifiedName() {
        String content = this.getContentFromPath("/data/ast/template/templateOverrideQualifiedName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateOverrideQualifiedName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(1, 0, 0);
            this.checkASTResolution(1, 0, 0);
            this.checkASTDocumentationResolution(1, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateOverrideInSameModule() {
        String content = this.getContentFromPath("/data/ast/template/templateOverrideInSameModule.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateOverrideInSameModule.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(1, 1, 0);
            this.checkASTResolution(1, 1, 1);
            this.checkASTDocumentationResolution(1, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateOverrideInSameModuleQualifiedName() {
        String content = this.getContentFromPath("/data/ast/template/templateOverrideInSameModuleQualifiedName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateOverrideInSameModuleQualifiedName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(1, 1, 0);
            this.checkASTResolution(1, 1, 1);
            this.checkASTDocumentationResolution(1, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateOverrideMissingTemplate() {
        String content = this.getContentFromPath("/data/ast/template/templateOverrideMissingTemplate.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateOverrideMissingTemplate.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(1, 0, 0);
            this.checkASTResolution(1, 0, 1);
            this.checkASTDocumentationResolution(1, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateMultipleOverride() {
        String content = this.getContentFromPath("/data/ast/module/templateValid.mtl");
        IFile moduleValidIFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/template/templateMultipleOverride.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleOverride.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 2, 0);
            this.checkCST2ASTConvertion(1, 4, 0);
            this.checkASTResolution(1, 4, 0);
            this.checkASTDocumentationResolution(1, 4, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateMultipleOverrideQualifiedName() {
        String content = this.getContentFromPath("/data/ast/module/templateValid.mtl");
        IFile moduleValidIFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/template/templateMultipleOverrideQualifiedName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleOverrideQualifiedName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 2, 0);
            this.checkCST2ASTConvertion(1, 4, 0);
            this.checkASTResolution(1, 4, 0);
            this.checkASTDocumentationResolution(1, 4, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateMultipleOverrideSameValue() {
        String content = this.getContentFromPath("/data/ast/module/templateValid.mtl");
        IFile moduleValidIFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/template/templateMultipleOverrideSameValue.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleOverrideSameValue.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 2, 0);
            this.checkCST2ASTConvertion(1, 4, 0);
            this.checkASTResolution(1, 5, 0);
            this.checkASTDocumentationResolution(1, 5, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateMultipleOverrideSameValueQualifiedName() {
        String content = this.getContentFromPath("/data/ast/module/templateValid.mtl");
        IFile moduleValidIFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/template/templateMultipleOverrideSameValueQualifiedName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleOverrideSameValueQualifiedName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 2, 0);
            this.checkCST2ASTConvertion(1, 4, 0);
            this.checkASTResolution(1, 5, 0);
            this.checkASTDocumentationResolution(1, 5, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateMultipleOverrideInSameModule() {
        String content = this.getContentFromPath("/data/ast/module/templateValid.mtl");
        IFile moduleValidIFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/template/templateMultipleOverrideInSameModule.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleOverrideInSameModule.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 2, 0);
            this.checkCST2ASTConvertion(1, 4, 0);
            this.checkASTResolution(1, 4, 1);
            this.checkASTDocumentationResolution(1, 4, 1);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplateMultipleOverrideInSameModuleQualifiedName() {
        String content = this.getContentFromPath("/data/ast/module/templateValid.mtl");
        IFile moduleValidIFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/template/templateMultipleOverrideInSameModuleQualifiedName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleOverrideInSameModuleQualifiedName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 2, 0);
            this.checkCST2ASTConvertion(1, 4, 0);
            this.checkASTResolution(1, 4, 1);
            this.checkASTDocumentationResolution(1, 4, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplatePost() {
        String content = this.getContentFromPath("/data/ast/template/templatePost.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templatePost.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateGuard() {
        String content = this.getContentFromPath("/data/ast/template/templateGuard.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateGuard.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateVariableInit() {
        String content = this.getContentFromPath("/data/ast/template/templateVariableInit.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateVariableInit.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplatePostAndGuard() {
        String content = this.getContentFromPath("/data/ast/template/templatePostAndGuard.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templatePostAndGuard.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Ignore
    @Test
    public void testParseTemplatePostGuardVariableInitOverridesQualifiedName() {
        String content = this.getContentFromPath("/data/ast/module/templateValid.mtl");
        IFile moduleValidIFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateValid.mtl");
        this.parseAndLoadModule(moduleValidIFile);
        content = this.getContentFromPath("/data/ast/template/templatePostGuardVariableInitOverridesQualifiedName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templatePostGuardVariableInitOverridesQualifiedName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(1, 0, 0);
            this.checkASTResolution(1, 0, 0);
            this.checkASTDocumentationResolution(1, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateDocumentationDeprecated() {
        String content = this.getContentFromPath("/data/ast/template/templateDocumentationDeprecated.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateDocumentationDeprecated.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateDocumentationTODO() {
        String content = this.getContentFromPath("/data/ast/template/templateDocumentationTODO.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateDocumentationTODO.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 1, 0, 0);
            this.checkCST2ASTConvertion(1, 0, 0);
            this.checkASTResolution(1, 0, 0);
            this.checkASTDocumentationResolution(1, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateDocumentationFIXME() {
        String content = this.getContentFromPath("/data/ast/template/templateDocumentationFIXME.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateDocumentationFIXME.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 1, 0, 0);
            this.checkCST2ASTConvertion(1, 0, 0);
            this.checkASTResolution(1, 0, 0);
            this.checkASTDocumentationResolution(1, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateDocumentationTODOFIXME() {
        String content = this.getContentFromPath("/data/ast/template/templateDocumentationTODOFIXME.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateDocumentationTODOFIXME.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 2, 0, 0);
            this.checkCST2ASTConvertion(2, 0, 0);
            this.checkASTResolution(2, 0, 0);
            this.checkASTDocumentationResolution(2, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateOverrideDeprecated() {
        String content = this.getContentFromPath("/data/ast/template/templateOverrideDeprecated.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateOverrideDeprecated.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(1, 1, 0);
            this.checkASTResolution(1, 2, 0);
            this.checkASTDocumentationResolution(1, 2, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateParamNameKeyword() {
        String content = this.getContentFromPath("/data/ast/template/templateParamNameKeyword.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateParamNameKeyword.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateNameKeyword() {
        String content = this.getContentFromPath("/data/ast/template/templateNameKeyword.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateNameKeyword.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateOtherForm() {
        String content = this.getContentFromPath("/data/ast/template/templateOtherForm.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateOtherForm.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateInvalidHeader() {
        String content = this.getContentFromPath("/data/ast/template/templateInvalidHeader.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateInvalidHeader.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateInvalidName() {
        String content = this.getContentFromPath("/data/ast/template/templateInvalidName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateInvalidName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateInvalidParamName() {
        String content = this.getContentFromPath("/data/ast/template/templateInvalidParamName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateInvalidParamName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateInvalidVisibility() {
        String content = this.getContentFromPath("/data/ast/template/templateInvalidVisibility.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateInvalidVisibility.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateInvalidVarInit() {
        String content = this.getContentFromPath("/data/ast/template/templateInvalidVarInit.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateInvalidVarInit.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 2);
            this.checkCST2ASTConvertion(0, 0, 2);
            this.checkASTResolution(0, 0, 2);
            this.checkASTDocumentationResolution(0, 0, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateInvalidPost() {
        String content = this.getContentFromPath("/data/ast/template/templateInvalidPost.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateInvalidPost.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateInvalidGuard() {
        String content = this.getContentFromPath("/data/ast/template/templateInvalidGuard.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateInvalidGuard.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateInvalidParamType() {
        String content = this.getContentFromPath("/data/ast/template/templateInvalidParamType.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateInvalidParamType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingVisibility() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingVisibility.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingVisibility.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingName() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingParameterName() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingParameterName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingParameterName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingParenthesis() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingParenthesis.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingParenthesis.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingParenthesis2() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingParenthesis2.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingParenthesis2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingParenthesis3() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingParenthesis3.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingParenthesis3.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingParenthesis4() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingParenthesis4.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingParenthesis4.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 2);
            this.checkCST2ASTConvertion(0, 0, 2);
            this.checkASTResolution(0, 0, 2);
            this.checkASTDocumentationResolution(0, 0, 2);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingGuardParenthesis() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingGuardParenthesis.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingGuardParenthesis.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingPostParenthesis() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingPostParenthesis.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingPostParenthesis.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingPostParenthesis2() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingPostParenthesis2.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingPostParenthesis2.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingColon() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingColon.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingColon.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 1, 1);
            this.checkCST2ASTConvertion(0, 1, 1);
            this.checkASTResolution(0, 1, 1);
            this.checkASTDocumentationResolution(0, 1, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingCurlyBrace() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingCurlyBrace.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingCurlyBrace.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingSemiColon() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingSemiColon.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingSemiColon.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingQuestionMark() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingQuestionMark.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingQuestionMark.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMissingParameterType() {
        String content = this.getContentFromPath("/data/ast/template/templateMissingParameterType.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMissingParameterType.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMultipleSameNameAndParam() {
        String content = this.getContentFromPath("/data/ast/template/templateMultipleSameNameAndParam.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleSameNameAndParam.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMultipleSameName() {
        String content = this.getContentFromPath("/data/ast/template/templateMultipleSameName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleSameName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMultipleParamSameName() {
        String content = this.getContentFromPath("/data/ast/template/templateMultipleParamSameName.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleParamSameName.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 1);
            this.checkCST2ASTConvertion(0, 0, 1);
            this.checkASTResolution(0, 0, 1);
            this.checkASTDocumentationResolution(0, 0, 1);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMultipleVarInit() {
        String content = this.getContentFromPath("/data/ast/template/templateMultipleVarInit.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleVarInit.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateMultipleVariable() {
        String content = this.getContentFromPath("/data/ast/template/templateMultipleVariable.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateMultipleVariable.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplatePublicMain() {
        String content = this.getContentFromPath("/data/ast/template/templatePublicMain.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templatePublicMain.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 0, 0);
            this.checkASTResolution(0, 0, 0);
            this.checkASTDocumentationResolution(0, 0, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplateProtectedMain() {
        String content = this.getContentFromPath("/data/ast/template/templateProtectedMain.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templateProtectedMain.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }

    @Test
    public void testParseTemplatePrivateMain() {
        String content = this.getContentFromPath("/data/ast/template/templatePrivateMain.mtl");
        IFile moduleFile = ASTParserTemplateTests.createFile(content, (IPath)new Path("/org/eclipse/acceleo/parser/tests/template/files"), project, "templatePrivateMain.mtl");
        if (moduleFile.exists() && content.length() > 0) {
            this.checkCSTParsing(moduleFile, 0, 0, 0);
            this.checkCST2ASTConvertion(0, 1, 0);
            this.checkASTResolution(0, 1, 0);
            this.checkASTDocumentationResolution(0, 1, 0);
        } else {
            Assert.fail();
        }
    }
}

